/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.row;

import java.math.BigDecimal;
import java.util.Date;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.xml.XMLHandler;
import org.w3c.dom.Node;

public class ValueMetaAndData {
    public static final String XML_TAG = "value";
    private ValueMetaInterface valueMeta;
    private Object valueData;
    public static final String VALUE_REPOSITORY_NUMBER_CONVERSION_MASK = "#.#";
    public static final String VALUE_REPOSITORY_INTEGER_CONVERSION_MASK = "#";
    public static final String VALUE_REPOSITORY_DATE_CONVERSION_MASK = "yyyy/MM/dd HH:mm:ss.SSS";
    public static final String VALUE_REPOSITORY_DECIMAL_SYMBOL = ".";
    public static final String VALUE_REPOSITORY_GROUPING_SYMBOL = ",";

    public ValueMetaAndData() {
    }

    public ValueMetaAndData(ValueMetaInterface valueMeta, Object valueData) {
        this.valueMeta = valueMeta;
        this.valueData = valueData;
    }

    public ValueMetaAndData(String valueName, Object valueData) throws KettleValueException {
        this.valueData = valueData;
        this.valueMeta = valueData instanceof String ? new ValueMeta(valueName, 2) : (valueData instanceof Double ? new ValueMeta(valueName, 1) : (valueData instanceof Long ? new ValueMeta(valueName, 5) : (valueData instanceof Date ? new ValueMeta(valueName, 3) : (valueData instanceof BigDecimal ? new ValueMeta(valueName, 6) : (valueData instanceof Boolean ? new ValueMeta(valueName, 4) : (valueData instanceof byte[] ? new ValueMeta(valueName, 8) : new ValueMeta(valueName, 7)))))));
    }

    public Object clone() {
        ValueMetaAndData vmad = new ValueMetaAndData();
        try {
            vmad.valueData = this.valueMeta.cloneValueData(this.valueData);
        }
        catch (KettleValueException e) {
            vmad.valueData = null;
        }
        vmad.valueMeta = this.valueMeta.clone();
        return vmad;
    }

    public String toString() {
        try {
            return this.valueMeta.getString(this.valueData);
        }
        catch (KettleValueException e) {
            return "<![" + e.getMessage() + "]!>";
        }
    }

    public String getXML() throws KettleValueException {
        ValueMetaInterface meta = this.valueMeta.clone();
        meta.setDecimalSymbol(VALUE_REPOSITORY_DECIMAL_SYMBOL);
        meta.setGroupingSymbol(null);
        meta.setCurrencySymbol(null);
        StringBuffer retval = new StringBuffer(128);
        retval.append("<value>");
        retval.append(XMLHandler.addTagValue("name", meta.getName(), false, new String[0]));
        retval.append(XMLHandler.addTagValue("type", meta.getTypeDesc(), false, new String[0]));
        try {
            retval.append(XMLHandler.addTagValue("text", meta.getCompatibleString(this.valueData), false, new String[0]));
        }
        catch (KettleValueException e) {
            LogWriter.getInstance().logError(this.toString(), Const.getStackTracker(e), new Object[0]);
            retval.append(XMLHandler.addTagValue("text", "", false, new String[0]));
        }
        retval.append(XMLHandler.addTagValue("length", meta.getLength(), false));
        retval.append(XMLHandler.addTagValue("precision", meta.getPrecision(), false));
        retval.append(XMLHandler.addTagValue("isnull", meta.isNull(this.valueData), false));
        retval.append(XMLHandler.addTagValue("mask", meta.getConversionMask(), false, new String[0]));
        retval.append("</value>");
        return retval.toString();
    }

    public ValueMetaAndData(Node valnode) {
        this();
        this.loadXML(valnode);
    }

    public boolean loadXML(Node valnode) {
        this.valueMeta = null;
        try {
            String valname = XMLHandler.getTagValue(valnode, "name");
            int valtype = ValueMeta.getType(XMLHandler.getTagValue(valnode, "type"));
            String text = XMLHandler.getTagValue(valnode, "text");
            boolean isnull = "Y".equalsIgnoreCase(XMLHandler.getTagValue(valnode, "isnull"));
            int len = Const.toInt(XMLHandler.getTagValue(valnode, "length"), -1);
            int prec = Const.toInt(XMLHandler.getTagValue(valnode, "precision"), -1);
            String mask = XMLHandler.getTagValue(valnode, "mask");
            this.valueMeta = new ValueMeta(valname, valtype);
            this.valueData = text;
            this.valueMeta.setLength(len);
            this.valueMeta.setPrecision(prec);
            if (mask != null) {
                this.valueMeta.setConversionMask(mask);
            }
            if (valtype != 2) {
                ValueMeta originMeta = new ValueMeta(valname, 2);
                if (this.valueMeta.isNumeric()) {
                    originMeta.setDecimalSymbol(VALUE_REPOSITORY_DECIMAL_SYMBOL);
                    originMeta.setGroupingSymbol(null);
                    originMeta.setCurrencySymbol(null);
                }
                this.valueData = Const.trim(text);
                this.valueData = this.valueMeta.convertData(originMeta, this.valueData);
            }
            if (isnull) {
                this.valueData = null;
            }
        }
        catch (Exception e) {
            this.valueData = null;
            return false;
        }
        return true;
    }

    public String toStringMeta() {
        return this.valueMeta.toStringMeta();
    }

    public Object getValueData() {
        return this.valueData;
    }

    public void setValueData(Object valueData) {
        this.valueData = valueData;
    }

    public ValueMetaInterface getValueMeta() {
        return this.valueMeta;
    }

    public void setValueMeta(ValueMetaInterface valueMeta) {
        this.valueMeta = valueMeta;
    }
}

