/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.ArchitectProject;
import ca.sqlpower.architect.ArchitectSession;
import ca.sqlpower.architect.ArchitectSessionContext;
import ca.sqlpower.architect.ArchitectStatusInformation;
import ca.sqlpower.architect.ProjectLoader;
import ca.sqlpower.architect.ddl.DDLGenerator;
import ca.sqlpower.architect.ddl.GenericDDLGenerator;
import ca.sqlpower.architect.ddl.LiquibaseSettings;
import ca.sqlpower.architect.profile.ProfileManager;
import ca.sqlpower.architect.profile.ProfileManagerImpl;
import ca.sqlpower.object.SPObjectSnapshot;
import ca.sqlpower.sql.DataSourceCollection;
import ca.sqlpower.sql.JDBCDataSource;
import ca.sqlpower.sql.SPDataSource;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLObjectRoot;
import ca.sqlpower.sqlobject.UserDefinedSQLType;
import ca.sqlpower.swingui.event.SessionLifecycleEvent;
import ca.sqlpower.swingui.event.SessionLifecycleListener;
import ca.sqlpower.util.DefaultUserPrompterFactory;
import ca.sqlpower.util.UserPrompter;
import ca.sqlpower.util.UserPrompterFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ArchitectSessionImpl
implements ArchitectSession {
    private final ArchitectSessionContext context;
    private final ArchitectProject project;
    private String name;
    private final List<SessionLifecycleListener<ArchitectSession>> lifecycleListeners = new ArrayList<SessionLifecycleListener<ArchitectSession>>();
    private UserPrompterFactory userPrompterFactory = new DefaultUserPrompterFactory();
    private ProjectLoader projectLoader;
    private DDLGenerator ddlGenerator;
    private LiquibaseSettings liquibaseSettings;
    protected boolean isEnterpriseSession;
    private ArchitectStatusInformation statusInfo;

    public ArchitectSessionImpl(ArchitectSessionContext context, String name) throws SQLObjectException {
        this(context, name, new ArchitectProject());
    }

    public ArchitectSessionImpl(ArchitectSessionContext context, String name, ArchitectProject project) throws SQLObjectException {
        this.context = context;
        this.project = project;
        project.setSession(this);
        ProfileManagerImpl manager = new ProfileManagerImpl();
        this.project.setProfileManager(manager);
        this.name = name;
        this.projectLoader = new ProjectLoader(this);
        this.isEnterpriseSession = false;
        this.liquibaseSettings = new LiquibaseSettings();
        try {
            this.ddlGenerator = new GenericDDLGenerator();
        }
        catch (SQLException e) {
            throw new SQLObjectException("SQL Error in ddlGenerator", (Throwable)e);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String argName) {
        this.name = argName;
    }

    @Override
    public ProfileManager getProfileManager() {
        return this.project.getProfileManager();
    }

    @Override
    public SQLDatabase getTargetDatabase() {
        return this.project.getTargetDatabase();
    }

    @Override
    public ProjectLoader getProjectLoader() {
        return this.projectLoader;
    }

    @Override
    public void setProjectLoader(ProjectLoader project) {
        this.projectLoader = project;
    }

    @Override
    public SQLObjectRoot getRootObject() {
        return this.project.getRootObject();
    }

    @Override
    public ArchitectSessionContext getContext() {
        return this.context;
    }

    public void setProfileManager(ProfileManagerImpl manager) {
        this.project.setProfileManager(manager);
    }

    public UserPrompter createUserPrompter(String question, UserPrompterFactory.UserPromptType responseType, UserPrompter.UserPromptOptions optionType, UserPrompter.UserPromptResponse defaultResponseType, Object defaultResponse, String ... buttonNames) {
        return this.userPrompterFactory.createUserPrompter(question, responseType, optionType, defaultResponseType, defaultResponse, buttonNames);
    }

    public void setUserPrompterFactory(UserPrompterFactory upFactory) {
        if (upFactory == null) {
            throw new NullPointerException("Null user prompter factory is not allowed!");
        }
        this.userPrompterFactory = upFactory;
    }

    public SQLDatabase getDatabase(JDBCDataSource ds) {
        return this.project.getDatabase(ds);
    }

    @Override
    public DDLGenerator getDDLGenerator() {
        return this.ddlGenerator;
    }

    @Override
    public void setDDLGenerator(DDLGenerator generator) {
        this.ddlGenerator = generator;
    }

    @Override
    public void setSourceDatabaseList(List<SQLDatabase> databases) throws SQLObjectException {
        this.project.setSourceDatabaseList(databases);
    }

    public UserPrompter createDatabaseUserPrompter(String question, List<Class<? extends SPDataSource>> dsTypes, UserPrompter.UserPromptOptions optionType, UserPrompter.UserPromptResponse defaultResponseType, Object defaultResponse, DataSourceCollection<SPDataSource> dsCollection, String ... buttonNames) {
        return this.userPrompterFactory.createDatabaseUserPrompter(question, dsTypes, optionType, defaultResponseType, defaultResponse, dsCollection, buttonNames);
    }

    @Override
    public ArchitectProject getWorkspace() {
        return this.project;
    }

    public boolean isForegroundThread() {
        return true;
    }

    public void runInBackground(Runnable runner) {
        runner.run();
    }

    public void runInForeground(Runnable runner) {
        runner.run();
    }

    @Override
    public boolean close() {
        SessionLifecycleEvent lifecycleEvent = new SessionLifecycleEvent((Object)this);
        for (int i = this.lifecycleListeners.size() - 1; i >= 0; --i) {
            this.lifecycleListeners.get(i).sessionClosing(lifecycleEvent);
        }
        return true;
    }

    @Override
    public void addSessionLifecycleListener(SessionLifecycleListener<ArchitectSession> l) {
        this.lifecycleListeners.add(l);
    }

    @Override
    public void removeSessionLifecycleListener(SessionLifecycleListener<ArchitectSession> l) {
        this.lifecycleListeners.remove(l);
    }

    @Override
    public boolean isEnterpriseSession() {
        return this.isEnterpriseSession;
    }

    @Override
    public DataSourceCollection<JDBCDataSource> getDataSources() {
        return this.context.getPlDotIni();
    }

    @Override
    public List<UserDefinedSQLType> getSQLTypes() {
        return this.getDataSources().getSQLTypes();
    }

    @Override
    public UserDefinedSQLType findSQLTypeByUUID(String uuid) {
        List<UserDefinedSQLType> types = this.getSQLTypes();
        for (UserDefinedSQLType type : types) {
            if (!type.getUUID().equals(uuid)) continue;
            return type;
        }
        return null;
    }

    @Override
    public UserDefinedSQLType findSQLTypeByJDBCType(int jdbcType) {
        List<UserDefinedSQLType> types = this.getSQLTypes();
        for (UserDefinedSQLType type : types) {
            if (type.getType() != jdbcType) continue;
            return type;
        }
        return null;
    }

    public <T> UserPrompter createListUserPrompter(String question, List<T> responses, T defaultResponse) {
        return this.userPrompterFactory.createListUserPrompter(question, responses, defaultResponse);
    }

    @Override
    public List<UserDefinedSQLType> getDomains() {
        return Collections.emptyList();
    }

    @Override
    public LiquibaseSettings getLiquibaseSettings() {
        return this.liquibaseSettings;
    }

    @Override
    public void setLiquibaseSettings(LiquibaseSettings settings) {
        this.liquibaseSettings = settings;
    }

    @Override
    public ArchitectStatusInformation getStatusInformation() {
        return this.statusInfo;
    }

    public void setStatusInfo(ArchitectStatusInformation statusInfo) {
        this.statusInfo = statusInfo;
    }

    @Override
    public Runnable createUpdateSnapshotRunnable(SPObjectSnapshot<?> snapshot) {
        return new Runnable(){

            @Override
            public void run() {
                ArchitectSessionImpl.this.createUserPrompter("Cannot update a snapshot from this session", UserPrompterFactory.UserPromptType.MESSAGE, UserPrompter.UserPromptOptions.OK, UserPrompter.UserPromptResponse.OK, null, new String[0]);
            }
        };
    }
}

