/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.ArchitectSession;
import ca.sqlpower.architect.ArchitectVersion;
import ca.sqlpower.architect.AscendDescendConverter;
import ca.sqlpower.architect.DeferrabilityConverter;
import ca.sqlpower.architect.DigesterCancelledException;
import ca.sqlpower.architect.UnclosableInputStream;
import ca.sqlpower.architect.UpdateDeleteRuleConverter;
import ca.sqlpower.architect.ddl.GenericDDLGenerator;
import ca.sqlpower.architect.profile.ColumnProfileResult;
import ca.sqlpower.architect.profile.ColumnValueCount;
import ca.sqlpower.architect.profile.TableProfileResult;
import ca.sqlpower.sql.DataSourceCollection;
import ca.sqlpower.sql.JDBCDataSource;
import ca.sqlpower.sql.JDBCDataSourceType;
import ca.sqlpower.sql.SPDataSource;
import ca.sqlpower.sqlobject.SQLCatalog;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLIndex;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLObjectRoot;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.sqlobject.SQLSchema;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.sqlobject.UserDefinedSQLType;
import ca.sqlpower.util.BrowserUtil;
import ca.sqlpower.util.DefaultUserPrompterFactory;
import ca.sqlpower.util.UserPrompter;
import ca.sqlpower.util.UserPrompterFactory;
import ca.sqlpower.xml.UnescapingSaxParser;
import com.google.common.collect.ArrayListMultimap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.digester.AbstractObjectCreationFactory;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.ObjectCreationFactory;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.SetPropertiesRule;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ProjectLoader {
    protected File file;
    private static final Logger logger;
    protected boolean modified;
    protected boolean saveInProgress;
    protected PrintWriter out;
    protected Map<String, SQLObject> sqlObjectLoadIdMap;
    protected Map<SQLObject, String> sqlObjectSaveIdMap;
    protected Map<String, JDBCDataSource> dbcsLoadIdMap;
    protected Map<SPDataSource, String> dbcsSaveIdMap;
    protected int progress = 0;
    protected ArchitectSession session;
    protected ArchitectSession siblingSession;
    protected String fileVersion;
    private SQLTable currentTable;

    private static void LoadSQLObjectAttributes(SQLObject obj, Attributes attr) {
        String message = attr.getValue("sql-exception");
        if (message != null) {
            try {
                obj.setChildrenInaccessibleReason((Throwable)new SQLObjectException(message), SQLObject.class, false);
            }
            catch (SQLObjectException e) {
                throw new AssertionError((Object)"Unreachable code");
            }
        }
    }

    public boolean isSaveInProgress() {
        return this.saveInProgress;
    }

    public void setSaveInProgress(boolean saveInProgress) {
        this.saveInProgress = saveInProgress;
    }

    public ProjectLoader(ArchitectSession session) {
        this.session = session;
    }

    public void load(InputStream in, DataSourceCollection<? extends SPDataSource> dataSources) throws IOException, SQLObjectException {
        this.load(in, dataSources, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(InputStream in, DataSourceCollection<? extends SPDataSource> dataSources, ArchitectSession messageDelegate) throws IOException, SQLObjectException {
        UnclosableInputStream uin = new UnclosableInputStream(in);
        this.siblingSession = messageDelegate;
        try {
            this.dbcsLoadIdMap = new HashMap<String, JDBCDataSource>();
            this.sqlObjectLoadIdMap = new HashMap<String, SQLObject>();
            Digester digester = null;
            try {
                digester = this.setupDigester();
                digester.parse((InputStream)uin);
            }
            catch (SAXException ex) {
                if (ex.getException() instanceof DigesterCancelledException) {
                    throw new RuntimeException(new InterruptedIOException("progress"));
                }
                logger.error((Object)"SAX Exception in project file parse!", (Throwable)ex);
                String message = digester == null ? "Couldn't create an XML parser" : "There is an XML parsing error in project file at Line:" + digester.getDocumentLocator().getLineNumber() + " Column:" + digester.getDocumentLocator().getColumnNumber();
                throw new SQLObjectException(message, (Throwable)ex);
            }
            catch (IOException ex) {
                logger.error((Object)"IO Exception in project file parse!", (Throwable)ex);
                throw new SQLObjectException("There was an I/O error while reading the file", (Throwable)ex);
            }
            catch (Exception ex) {
                logger.error((Object)"General Exception in project file parse!", (Throwable)ex);
                throw new SQLObjectException("Unexpected Exception", (Throwable)ex);
            }
            SQLObjectRoot dbConnectionContainer = this.getSession().getRootObject();
            for (SQLDatabase db : dbConnectionContainer.getChildren(SQLDatabase.class)) {
                JDBCDataSource ds = db.getDataSource();
                String parentTypeId = (String)ds.getPropertiesMap().get("Connection Type");
                if (parentTypeId == null) continue;
                for (JDBCDataSourceType dstype : dataSources.getDataSourceTypes()) {
                    if (!dstype.getName().equals(parentTypeId)) continue;
                    ds.setParentType(dstype);
                }
                if (ds.getParentType() != null) continue;
                logger.error((Object)("Data Source \"" + ds.getName() + "\" has type \"" + parentTypeId + "\", which is not configured in the user prefs."));
            }
            for (SQLTable table : this.getSession().getTargetDatabase().getTables()) {
                if (logger.isDebugEnabled()) {
                    if (!table.isPopulated()) {
                        logger.debug((Object)("Table [" + table.getName() + "] not populated"));
                    } else {
                        logger.debug((Object)("Table [" + table.getName() + "] index folder contents: " + table.getIndices()));
                    }
                }
                if (table.getPrimaryKeyIndex() == null) {
                    logger.debug((Object)("primary key index is null in table: " + table));
                    logger.debug((Object)("number of children found in indices folder: " + table.getIndices().size()));
                    for (SQLIndex index : table.getIndices()) {
                        if (this.sqlObjectLoadIdMap.get(table.getName() + "." + index.getName()) == null) continue;
                        table.getPrimaryKeyIndex().updateToMatch((SQLObject)index);
                        break;
                    }
                }
                logger.debug((Object)("Table [" + table.getName() + "]2 index folder contents: " + table.getIndices()));
                logger.debug((Object)("Table [" + table.getName() + "]3 index folder contents: " + table.getIndices()));
                if (!logger.isDebugEnabled()) continue;
                if (!table.isPopulated()) {
                    logger.debug((Object)("Table [" + table.getName() + "] not populated"));
                    continue;
                }
                logger.debug((Object)("Table [" + table.getName() + "] index folder contents: " + table.getIndices().size()));
            }
            ArrayListMultimap columns = ArrayListMultimap.create();
            for (SQLTable table : this.getSession().getTargetDatabase().getTables()) {
                for (SQLColumn column : table.getChildren(SQLColumn.class)) {
                    SQLColumn sourceColumn = column.getSourceColumn();
                    if (sourceColumn != null && sourceColumn.getPlatform() != null) {
                        columns.put((Object)column.getSourceColumn().getPlatform(), (Object)column);
                        continue;
                    }
                    columns.put((Object)"GENERIC", (Object)column);
                }
            }
            for (String platform : columns.keySet()) {
                SQLColumn.assignTypes((List)columns.get((Object)platform), dataSources, (String)platform, (UserPrompterFactory)new DefaultUserPrompterFactory());
            }
            this.setModified(false);
        }
        finally {
            uin.forceClose();
        }
    }

    protected Digester setupDigester() throws ParserConfigurationException, SAXException {
        Digester d = new Digester((SAXParser)new UnescapingSaxParser());
        final ArchitectSession messageOwner = this.siblingSession == null ? this.session : this.siblingSession;
        d.setValidating(false);
        d.push((Object)this.session);
        d.addRule("architect-enterprise-project", new Rule(){

            public void begin(String namespace, String name, Attributes attributes) throws Exception {
                UserPrompter loadingWarningPrompt = messageOwner.createUserPrompter("This file contains an Enterprise project and can only\nbe opened in the Architect Enterprise Edition.", UserPrompterFactory.UserPromptType.BOOLEAN, UserPrompter.UserPromptOptions.OK_CANCEL, UserPrompter.UserPromptResponse.CANCEL, UserPrompter.UserPromptResponse.CANCEL, new String[]{"Get Enterprise", "Cancel"});
                UserPrompter.UserPromptResponse upr = loadingWarningPrompt.promptUser(new Object[0]);
                if (upr == UserPrompter.UserPromptResponse.OK) {
                    try {
                        BrowserUtil.launch((String)"http://www.sqlpower.ca/page/architect-e");
                    }
                    catch (IOException e) {
                        throw new DigesterCancelledException();
                    }
                }
                throw new DigesterCancelledException();
            }
        });
        d.addRule("architect-project", new Rule(){

            public void begin(String namespace, String name, Attributes attributes) throws Exception {
                String loadingMessage;
                block7: {
                    ProjectLoader.this.fileVersion = attributes.getValue("appversion");
                    try {
                        if (ProjectLoader.this.fileVersion == null) {
                            loadingMessage = "The version of the file cannot be found.";
                            ProjectLoader.this.fileVersion = "0";
                            break block7;
                        }
                        if (ArchitectVersion.APP_FULL_VERSION.compareTo(new ArchitectVersion(ProjectLoader.this.fileVersion)) < 0) {
                            loadingMessage = "This file was last saved with a newer version.\nLoading with an older version may cause data loss.";
                            break block7;
                        }
                        return;
                    }
                    catch (Exception e) {
                        loadingMessage = "The version of the file cannot be understood.";
                    }
                }
                UserPrompter loadingWarningPrompt = messageOwner.createUserPrompter(loadingMessage + "\nDo you wish to try and open the file?", UserPrompterFactory.UserPromptType.BOOLEAN, UserPrompter.UserPromptOptions.OK_NOTOK_CANCEL, UserPrompter.UserPromptResponse.OK, UserPrompter.UserPromptResponse.OK, new String[]{"Try loading", "Upgrade...", "Cancel"});
                UserPrompter.UserPromptResponse response = loadingWarningPrompt.promptUser(new Object[0]);
                if (response != UserPrompter.UserPromptResponse.OK) {
                    if (response == UserPrompter.UserPromptResponse.NOT_OK) {
                        BrowserUtil.launch((String)"http://www.sqlpower.ca/page/architect");
                        throw new DigesterCancelledException();
                    }
                    if (response == UserPrompter.UserPromptResponse.CANCEL) {
                        throw new DigesterCancelledException();
                    }
                }
            }
        });
        d.addCallMethod("architect-project/project-name", "setName", 0);
        DBCSFactory dbcsFactory = new DBCSFactory();
        d.addFactoryCreate("architect-project/project-connection-specs/dbcs", (ObjectCreationFactory)dbcsFactory);
        d.addSetProperties("architect-project/project-connection-specs/dbcs", new String[]{"connection-name", "driver-class", "jdbc-url", "user-name", "user-pass", "sequence-number", "single-login"}, new String[]{"displayName", "driverClass", "url", "user", "pass", "seqNo", "singleLogin"});
        d.addCallMethod("architect-project/project-connection-specs/dbcs", "setName", 0);
        d.addFactoryCreate("architect-project/project-data-sources/data-source", (ObjectCreationFactory)dbcsFactory);
        d.addCallMethod("architect-project/project-data-sources/data-source/property", "put", 2);
        d.addCallParam("architect-project/project-data-sources/data-source/property", 0, "key");
        d.addCallParam("architect-project/project-data-sources/data-source/property", 1, "value");
        d.addObjectCreate("architect-project/source-databases", LinkedList.class);
        d.addSetNext("architect-project/source-databases", "setSourceDatabaseList");
        SQLDatabaseFactory dbFactory = new SQLDatabaseFactory();
        d.addFactoryCreate("architect-project/source-databases/database", (ObjectCreationFactory)dbFactory);
        d.addSetProperties("architect-project/source-databases/database");
        d.addSetNext("architect-project/source-databases/database", "add");
        d.addObjectCreate("architect-project/source-databases/database/catalog", SQLCatalog.class);
        d.addSetProperties("architect-project/source-databases/database/catalog");
        d.addSetNext("architect-project/source-databases/database/catalog", "addChild");
        SQLSchemaFactory schemaFactory = new SQLSchemaFactory();
        d.addFactoryCreate("*/schema", (ObjectCreationFactory)schemaFactory);
        d.addSetProperties("*/schema");
        d.addSetNext("*/schema", "addChild");
        SQLTableFactory tableFactory = new SQLTableFactory();
        d.addFactoryCreate("*/table", (ObjectCreationFactory)tableFactory);
        d.addSetProperties("*/table");
        d.addCallMethod("*/remarks", "setRemarks", 0);
        d.addSetNext("*/table", "addChild");
        d.addFactoryCreate("*/folder", (ObjectCreationFactory)new SQLFolderFactory());
        SQLColumnFactory columnFactory = new SQLColumnFactory();
        d.addFactoryCreate("*/column", (ObjectCreationFactory)columnFactory);
        d.addSetProperties("*/column");
        d.addCallMethod("*/remarks", "setRemarks", 0);
        d.addCallMethod("*/column", "setSourceDataTypeName", 1);
        d.addCallParam("*/column", 0, "sourceDBTypeName");
        d.addCallMethod("*/column", "setSourceDataTypeName", 1);
        d.addCallParam("*/column", 0, "sourceDataTypeName");
        d.addSetNext("*/column", "addChild");
        SQLRelationshipFactory relationshipFactory = new SQLRelationshipFactory();
        d.addFactoryCreate("*/relationship", (ObjectCreationFactory)relationshipFactory);
        d.addSetProperties("*/relationship");
        ColumnMappingFactory columnMappingFactory = new ColumnMappingFactory();
        d.addFactoryCreate("*/column-mapping", (ObjectCreationFactory)columnMappingFactory);
        d.addSetProperties("*/column-mapping");
        d.addSetNext("*/column-mapping", "addChild");
        SQLIndexFactory indexFactory = new SQLIndexFactory();
        d.addFactoryCreate("*/index", (ObjectCreationFactory)indexFactory);
        d.addSetProperties("*/index");
        d.addSetNext("*/index", "addChild");
        SQLIndexColumnFactory indexColumnFactory = new SQLIndexColumnFactory();
        d.addFactoryCreate("*/index-column", (ObjectCreationFactory)indexColumnFactory);
        d.addSetProperties("*/index-column");
        d.addSetNext("*/index-column", "addChild");
        SQLExceptionFactory exceptionFactory = new SQLExceptionFactory();
        d.addFactoryCreate("*/sql-exception", (ObjectCreationFactory)exceptionFactory);
        d.addSetProperties("*/sql-exception");
        d.addSetNext("*/sql-exception", "setChildrenInaccessibleReason");
        TargetDBFactory targetDBFactory = new TargetDBFactory();
        d.addFactoryCreate("architect-project/target-database", (ObjectCreationFactory)targetDBFactory);
        d.addSetProperties("architect-project/target-database");
        DDLGeneratorFactory ddlgFactory = new DDLGeneratorFactory();
        d.addFactoryCreate("architect-project/ddl-generator", (ObjectCreationFactory)ddlgFactory);
        d.addSetProperties("architect-project/ddl-generator");
        d.addSetNext("architect-project/ddl-generator", "setDDLGenerator");
        LiquibaseSettingsFactory lbFactory = new LiquibaseSettingsFactory();
        d.addFactoryCreate("architect-project/liquibase-settings", (ObjectCreationFactory)lbFactory);
        d.addSetProperties("architect-project/liquibase-settings");
        d.addSetNext("architect-project/liquibase-settings", "setLiquibaseSettings");
        ProfileManagerFactory profileManagerFactory = new ProfileManagerFactory();
        d.addFactoryCreate("*/profiles", (ObjectCreationFactory)profileManagerFactory);
        d.addSetProperties("*/profiles");
        ProfileResultFactory profileResultFactory = new ProfileResultFactory();
        d.addFactoryCreate("*/profiles/profile-result", (ObjectCreationFactory)profileResultFactory);
        d.addRule("*/profiles/profile-result", (Rule)new SetPropertiesRule(new String[]{"exception"}, new String[0]));
        d.addSetNext("*/profiles/profile-result", "loadResult");
        d.addFactoryCreate("*/profiles/table-profile-result", (ObjectCreationFactory)new TableProfileResultFactory());
        d.addRule("*/profiles/table-profile-result", (Rule)new SetPropertiesRule(new String[]{"exception"}, new String[0]));
        d.addSetNext("*/profiles/table-profile-result", "addTableProfileResult");
        d.addFactoryCreate("*/profiles/table-profile-result/column-profile-result", (ObjectCreationFactory)new ColumnProfileResultFactory());
        d.addRule("*/profiles/table-profile-result/column-profile-result", (Rule)new SetPropertiesRule(new String[]{"exception"}, new String[0]));
        d.addSetNext("*/profiles/table-profile-result/column-profile-result", "addColumnProfileResult");
        ProfileResultValueFactory profileResultValueFactory = new ProfileResultValueFactory();
        d.addFactoryCreate("*/profiles/table-profile-result/column-profile-result/avgValue", (ObjectCreationFactory)profileResultValueFactory);
        d.addSetNext("*/profiles/table-profile-result/column-profile-result/avgValue", "setAvgValue");
        d.addFactoryCreate("*/profiles/table-profile-result/column-profile-result/minValue", (ObjectCreationFactory)profileResultValueFactory);
        d.addSetNext("*/profiles/table-profile-result/column-profile-result/minValue", "setMinValue");
        d.addFactoryCreate("*/profiles/table-profile-result/column-profile-result/maxValue", (ObjectCreationFactory)profileResultValueFactory);
        d.addSetNext("*/profiles/table-profile-result/column-profile-result/maxValue", "setMaxValue");
        ProfileResultTopNValueFactory topNValueFactory = new ProfileResultTopNValueFactory();
        d.addFactoryCreate("*/profiles/table-profile-result/column-profile-result/topNvalue", (ObjectCreationFactory)topNValueFactory);
        d.addSetNext("*/profiles/table-profile-result/column-profile-result/topNvalue", "addValueCount");
        FileFactory fileFactory = new FileFactory();
        d.addFactoryCreate("*/file", (ObjectCreationFactory)fileFactory);
        d.addSetNext("*/file", "setFile");
        return d;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Project modified: " + modified));
        }
        this.modified = modified;
    }

    protected ArchitectSession getSession() {
        return this.session;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File argFile) {
        this.file = argFile;
    }

    public void clearFileVersion() {
        this.fileVersion = null;
    }

    public void addAllTablesFrom(SQLDatabase db) throws SQLObjectException {
        SQLDatabase ppdb = this.getSession().getTargetDatabase();
        for (SQLTable table : db.getChildren(SQLTable.class)) {
            ppdb.addChild((SQLObject)table);
        }
    }

    static {
        ConvertUtils.register((Converter)new DeferrabilityConverter(), SQLRelationship.Deferrability.class);
        ConvertUtils.register((Converter)new UpdateDeleteRuleConverter(), SQLRelationship.UpdateDeleteRule.class);
        ConvertUtils.register((Converter)new AscendDescendConverter(), SQLIndex.AscendDescend.class);
        logger = Logger.getLogger(ProjectLoader.class);
    }

    private class ProfileResultTopNValueFactory
    extends AbstractObjectCreationFactory {
        private ProfileResultTopNValueFactory() {
        }

        public Object createObject(Attributes attributes) throws SQLObjectException, ClassNotFoundException, InstantiationException, IllegalAccessException {
            String className = attributes.getValue("type");
            int count = Integer.valueOf(attributes.getValue("count"));
            String per = attributes.getValue("percent");
            double percent = -1.0;
            if (per != null) {
                percent = Double.valueOf(per);
            }
            String value = attributes.getValue("value");
            String otherValuesString = attributes.getValue("otherValues");
            if (otherValuesString == null) {
                otherValuesString = "false";
            }
            Boolean otherValues = Boolean.parseBoolean(otherValuesString);
            if (className == null || className.length() == 0) {
                return new ColumnValueCount(null, count, percent, otherValues);
            }
            if (className.equals(BigDecimal.class.getName())) {
                return new ColumnValueCount(new BigDecimal(value), count, percent, otherValues);
            }
            if (className.equals(Timestamp.class.getName())) {
                return new ColumnValueCount(new Timestamp(Timestamp.valueOf(value).getTime()), count, percent, otherValues);
            }
            if (className.equals(String.class.getName())) {
                return new ColumnValueCount(new String(value), count, percent, otherValues);
            }
            return new ColumnValueCount(new String(value), count, percent, otherValues);
        }
    }

    private class ProfileResultValueFactory
    extends AbstractObjectCreationFactory {
        private ProfileResultValueFactory() {
        }

        public Object createObject(Attributes attributes) throws SQLObjectException, ClassNotFoundException, InstantiationException, IllegalAccessException {
            String className = attributes.getValue("type");
            if (className == null) {
                throw new SQLObjectException("Missing mandatory attribute \"type\" in <avgValue> or <minValue> or <maxValue> element");
            }
            if (className.equals(BigDecimal.class.getName())) {
                return new BigDecimal(attributes.getValue("value"));
            }
            if (className.equals(Timestamp.class.getName())) {
                return new Timestamp(Timestamp.valueOf(attributes.getValue("value")).getTime());
            }
            if (className.equals(String.class.getName())) {
                return new String(attributes.getValue("value"));
            }
            return new String(attributes.getValue("value"));
        }
    }

    private class ColumnProfileResultFactory
    extends AbstractObjectCreationFactory {
        private ColumnProfileResultFactory() {
        }

        public Object createObject(Attributes attributes) throws SQLObjectException {
            String refid = attributes.getValue("ref-id");
            if (refid == null) {
                throw new SQLObjectException("Missing mandatory attribute \"ref-id\" id <column-profile-result> element");
            }
            SQLColumn c = (SQLColumn)ProjectLoader.this.sqlObjectLoadIdMap.get(refid);
            return new ColumnProfileResult(c);
        }
    }

    private class TableProfileResultFactory
    extends AbstractObjectCreationFactory {
        private TableProfileResultFactory() {
        }

        public Object createObject(Attributes attributes) throws SQLObjectException {
            String refid = attributes.getValue("ref-id");
            if (refid == null) {
                throw new SQLObjectException("Missing mandatory attribute \"ref-id\" in <table-profile-result> element");
            }
            SQLTable t = (SQLTable)ProjectLoader.this.sqlObjectLoadIdMap.get(refid);
            return new TableProfileResult(t, ProjectLoader.this.session.getProfileManager().getDefaultProfileSettings());
        }
    }

    private class ProfileResultFactory
    extends AbstractObjectCreationFactory {
        TableProfileResult tableProfileResult;

        private ProfileResultFactory() {
        }

        public Object createObject(Attributes attributes) throws SQLObjectException, ClassNotFoundException, InstantiationException, IllegalAccessException {
            String refid = attributes.getValue("ref-id");
            String className = attributes.getValue("type");
            if (refid == null) {
                throw new SQLObjectException("Missing mandatory attribute \"ref-id\" in <profile-result> element");
            }
            if (className == null) {
                throw new SQLObjectException("Missing mandatory attribute \"type\" in <profile-result> element");
            }
            if (className.equals(TableProfileResult.class.getName())) {
                SQLTable t = (SQLTable)ProjectLoader.this.sqlObjectLoadIdMap.get(refid);
                this.tableProfileResult = new TableProfileResult(t, ProjectLoader.this.session.getProfileManager().getDefaultProfileSettings());
                return this.tableProfileResult;
            }
            if (className.equals(ColumnProfileResult.class.getName())) {
                SQLColumn c = (SQLColumn)ProjectLoader.this.sqlObjectLoadIdMap.get(refid);
                if (this.tableProfileResult == null) {
                    throw new IllegalArgumentException("Column result does not have a parent");
                }
                ColumnProfileResult cpr = new ColumnProfileResult(c);
                this.tableProfileResult.addColumnProfileResult(cpr);
                return cpr;
            }
            throw new SQLObjectException("Profile result type \"" + className + "\" not recognised");
        }
    }

    private class ProfileManagerFactory
    extends AbstractObjectCreationFactory {
        private ProfileManagerFactory() {
        }

        public Object createObject(Attributes attributes) throws SQLObjectException {
            return ProjectLoader.this.session.getProfileManager();
        }
    }

    private class FileFactory
    extends AbstractObjectCreationFactory {
        private FileFactory() {
        }

        public Object createObject(Attributes attributes) {
            return new File(attributes.getValue("path"));
        }
    }

    private class DDLGeneratorFactory
    extends AbstractObjectCreationFactory {
        private DDLGeneratorFactory() {
        }

        public Object createObject(Attributes attributes) throws SQLException {
            try {
                GenericDDLGenerator ddlg = (GenericDDLGenerator)Class.forName(attributes.getValue("type"), true, ProjectLoader.class.getClassLoader()).newInstance();
                ddlg.setTargetCatalog(attributes.getValue("target-catalog"));
                ddlg.setTargetSchema(attributes.getValue("target-schema"));
                return ddlg;
            }
            catch (Exception e) {
                logger.debug((Object)"Couldn't create DDL Generator instance. Returning generic instance.", (Throwable)e);
                return new GenericDDLGenerator();
            }
        }
    }

    private class LiquibaseSettingsFactory
    extends AbstractObjectCreationFactory {
        private LiquibaseSettingsFactory() {
        }

        public Object createObject(Attributes attributes) {
            return ProjectLoader.this.session.getLiquibaseSettings();
        }
    }

    private class SQLIndexColumnFactory
    extends AbstractObjectCreationFactory {
        private SQLIndexColumnFactory() {
        }

        public Object createObject(Attributes attributes) {
            SQLIndex.Column col = new SQLIndex.Column();
            String id = attributes.getValue("id");
            if (id != null) {
                ProjectLoader.this.sqlObjectLoadIdMap.put(id, (SQLObject)col);
            } else {
                logger.warn((Object)"No ID found in index-column element while loading project!");
            }
            String referencedColId = attributes.getValue("column-ref");
            if (referencedColId != null) {
                SQLColumn column = (SQLColumn)ProjectLoader.this.sqlObjectLoadIdMap.get(referencedColId);
                col.setColumn(column);
            }
            for (int i = 0; i < attributes.getLength(); ++i) {
                logger.debug((Object)("Attribute: \"" + attributes.getQName(i) + "\" Value:" + attributes.getValue(i)));
            }
            if (attributes.getValue("ascendingOrDescending") != null) {
                col.setAscendingOrDescending(SQLIndex.AscendDescend.valueOf((String)attributes.getValue("ascendingOrDescending")));
            }
            ProjectLoader.LoadSQLObjectAttributes((SQLObject)col, attributes);
            return col;
        }
    }

    private class SQLIndexFactory
    extends AbstractObjectCreationFactory {
        private SQLIndexFactory() {
        }

        public Object createObject(Attributes attributes) {
            String id;
            SQLIndex index = new SQLIndex();
            logger.debug((Object)("Loading index: " + attributes.getValue("name")));
            String pkIndex = attributes.getValue("primaryKeyIndex");
            if (Boolean.valueOf(pkIndex).booleanValue()) {
                index = ProjectLoader.this.currentTable.getPrimaryKeyIndex();
            }
            if ((id = attributes.getValue("id")) != null) {
                ProjectLoader.this.sqlObjectLoadIdMap.put(id, (SQLObject)index);
            } else {
                logger.warn((Object)"No ID found in index element while loading project!");
            }
            for (int i = 0; i < attributes.getLength(); ++i) {
                logger.debug((Object)("Attribute: \"" + attributes.getQName(i) + "\" Value:" + attributes.getValue(i)));
            }
            index.setType(attributes.getValue("index-type"));
            ProjectLoader.LoadSQLObjectAttributes((SQLObject)index, attributes);
            return index;
        }
    }

    private class ColumnMappingFactory
    extends AbstractObjectCreationFactory {
        private ColumnMappingFactory() {
        }

        public Object createObject(Attributes attributes) {
            String fkColName;
            String fkTableId;
            String pkColumnId;
            SQLRelationship.ColumnMapping cmap = new SQLRelationship.ColumnMapping();
            String id = attributes.getValue("id");
            if (id != null) {
                ProjectLoader.this.sqlObjectLoadIdMap.put(id, (SQLObject)cmap);
            } else {
                logger.warn((Object)"No ID found in column-mapping element while loading project!");
            }
            String fkColumnId = attributes.getValue("fk-column-ref");
            if (fkColumnId != null) {
                cmap.setFkColumn((SQLColumn)ProjectLoader.this.sqlObjectLoadIdMap.get(fkColumnId));
            }
            if ((pkColumnId = attributes.getValue("pk-column-ref")) != null) {
                cmap.setPkColumn((SQLColumn)ProjectLoader.this.sqlObjectLoadIdMap.get(pkColumnId));
            }
            if ((fkTableId = attributes.getValue("fk-table")) != null) {
                cmap.setFkTable((SQLTable)ProjectLoader.this.sqlObjectLoadIdMap.get(fkTableId));
            }
            if ((fkColName = attributes.getValue("fk-col-name")) != null) {
                cmap.setFkColName(fkColName);
            }
            return cmap;
        }
    }

    private class SQLRelationshipFactory
    extends AbstractObjectCreationFactory {
        private SQLRelationshipFactory() {
        }

        public Object createObject(Attributes attributes) {
            SQLRelationship rel = new SQLRelationship();
            String id = attributes.getValue("id");
            if (id != null) {
                ProjectLoader.this.sqlObjectLoadIdMap.put(id, (SQLObject)rel);
            } else {
                logger.warn((Object)"No ID found in relationship element while loading project!");
            }
            String fkTableId = attributes.getValue("fk-table-ref");
            String pkTableId = attributes.getValue("pk-table-ref");
            if (fkTableId != null && pkTableId != null) {
                SQLTable fkTable = (SQLTable)ProjectLoader.this.sqlObjectLoadIdMap.get(fkTableId);
                SQLTable pkTable = (SQLTable)ProjectLoader.this.sqlObjectLoadIdMap.get(pkTableId);
                try {
                    rel.attachRelationship(pkTable, fkTable, false);
                }
                catch (SQLObjectException e) {
                    logger.error((Object)("Couldn't attach relationship to pktable \"" + pkTable.getName() + "\" and fktable \"" + fkTable.getName() + "\""), (Throwable)e);
                    JOptionPane.showMessageDialog(null, "Failed to attach relationship to pktable \"" + pkTable.getName() + "\" and fktable \"" + fkTable.getName() + "\":\n" + e.getMessage());
                }
            } else {
                JOptionPane.showMessageDialog(null, "Missing pktable or fktable references for relationship id \"" + id + "\"");
            }
            ProjectLoader.LoadSQLObjectAttributes((SQLObject)rel, attributes);
            return rel;
        }
    }

    private class SQLExceptionFactory
    extends AbstractObjectCreationFactory {
        private SQLExceptionFactory() {
        }

        public Object createObject(Attributes attributes) {
            return new Exception(attributes.getValue("message"));
        }
    }

    private class SQLColumnFactory
    extends AbstractObjectCreationFactory {
        private SQLColumnFactory() {
        }

        public Object createObject(Attributes attributes) {
            SQLColumn col = new SQLColumn();
            String id = attributes.getValue("id");
            if (id != null) {
                ProjectLoader.this.sqlObjectLoadIdMap.put(id, (SQLObject)col);
            } else {
                logger.warn((Object)"No ID found in column element while loading project!");
            }
            String sourceId = attributes.getValue("source-column-ref");
            if (sourceId != null) {
                col.setSourceColumn((SQLColumn)ProjectLoader.this.sqlObjectLoadIdMap.get(sourceId));
            }
            String sqlTypeUUID = attributes.getValue("userDefinedTypeUUID");
            UserDefinedSQLType sqlType = null;
            if (sqlTypeUUID != null) {
                sqlType = ProjectLoader.this.session.findSQLTypeByUUID(sqlTypeUUID);
            }
            col.getUserDefinedSQLType().setUpstreamType(sqlType);
            ProjectLoader.LoadSQLObjectAttributes((SQLObject)col, attributes);
            return col;
        }
    }

    private class SQLFolderFactory
    extends AbstractObjectCreationFactory {
        private SQLFolderFactory() {
        }

        public Object createObject(Attributes attributes) throws Exception {
            String type = attributes.getValue("type");
            boolean isPopulated = Boolean.valueOf(attributes.getValue("populated"));
            String message = attributes.getValue("sql-exception");
            if (type.equals("1")) {
                ProjectLoader.this.currentTable.setColumnsPopulated(isPopulated);
                if (message != null) {
                    try {
                        ProjectLoader.this.currentTable.setChildrenInaccessibleReason((Throwable)new SQLObjectException(message), SQLColumn.class, false);
                    }
                    catch (SQLObjectException e) {
                        throw new AssertionError((Object)"Unreachable code");
                    }
                }
            } else if (type.equals("2")) {
                ProjectLoader.this.currentTable.setImportedKeysPopulated(isPopulated);
                if (message != null) {
                    try {
                        ProjectLoader.this.currentTable.setChildrenInaccessibleReason((Throwable)new SQLObjectException(message), SQLRelationship.SQLImportedKey.class, false);
                    }
                    catch (SQLObjectException e) {
                        throw new AssertionError((Object)"Unreachable code");
                    }
                }
            } else if (type.equals("3")) {
                ProjectLoader.this.currentTable.setExportedKeysPopulated(isPopulated);
                if (message != null) {
                    try {
                        ProjectLoader.this.currentTable.setChildrenInaccessibleReason((Throwable)new SQLObjectException(message), SQLRelationship.class, false);
                    }
                    catch (SQLObjectException e) {
                        throw new AssertionError((Object)"Unreachable code");
                    }
                }
            } else if (type.equals("4")) {
                ProjectLoader.this.currentTable.setIndicesPopulated(isPopulated);
                if (message != null) {
                    try {
                        ProjectLoader.this.currentTable.setChildrenInaccessibleReason((Throwable)new SQLObjectException(message), SQLIndex.class, false);
                    }
                    catch (SQLObjectException e) {
                        throw new AssertionError((Object)"Unreachable code");
                    }
                }
            }
            return ProjectLoader.this.currentTable;
        }
    }

    private class SQLTableFactory
    extends AbstractObjectCreationFactory {
        private SQLTableFactory() {
        }

        public Object createObject(Attributes attributes) throws SQLObjectException {
            SQLTable tab = new SQLTable();
            String id = attributes.getValue("id");
            String pkName = attributes.getValue("primaryKeyName");
            if (id != null) {
                ProjectLoader.this.sqlObjectLoadIdMap.put(id, (SQLObject)tab);
                ProjectLoader.this.sqlObjectLoadIdMap.put(id + "." + pkName, (SQLObject)tab);
            } else {
                logger.warn((Object)"No ID found in table element while loading project!");
            }
            String populated = attributes.getValue("populated");
            if (populated != null && populated.equals("false")) {
                tab.initFolders(false);
            }
            ProjectLoader.this.currentTable = tab;
            ProjectLoader.LoadSQLObjectAttributes((SQLObject)tab, attributes);
            return tab;
        }
    }

    private class SQLSchemaFactory
    extends AbstractObjectCreationFactory {
        private SQLSchemaFactory() {
        }

        public Object createObject(Attributes attributes) {
            String populated = attributes.getValue("populated");
            boolean startPopulated = populated != null && populated.equals("true");
            SQLSchema schema = new SQLSchema(startPopulated);
            String id = attributes.getValue("id");
            if (id != null) {
                ProjectLoader.this.sqlObjectLoadIdMap.put(id, (SQLObject)schema);
            } else {
                logger.warn((Object)"No ID found in database element while loading project!");
            }
            ProjectLoader.LoadSQLObjectAttributes((SQLObject)schema, attributes);
            return schema;
        }
    }

    private class SQLDatabaseFactory
    extends AbstractObjectCreationFactory {
        private SQLDatabaseFactory() {
        }

        public Object createObject(Attributes attributes) {
            String populated;
            SQLDatabase db = new SQLDatabase();
            String id = attributes.getValue("id");
            if (id != null) {
                ProjectLoader.this.sqlObjectLoadIdMap.put(id, (SQLObject)db);
            } else {
                logger.warn((Object)"No ID found in database element while loading project!");
            }
            String dbcsid = attributes.getValue("dbcs-ref");
            if (dbcsid != null) {
                db.setDataSource(ProjectLoader.this.dbcsLoadIdMap.get(dbcsid));
            }
            if ((populated = attributes.getValue("populated")) != null && populated.equals("false")) {
                db.setPopulated(false);
            }
            ProjectLoader.LoadSQLObjectAttributes((SQLObject)db, attributes);
            return db;
        }
    }

    private class TargetDBFactory
    extends AbstractObjectCreationFactory {
        private TargetDBFactory() {
        }

        public Object createObject(Attributes attributes) throws Exception {
            SQLDatabase ppdb = ProjectLoader.this.getSession().getTargetDatabase();
            String id = attributes.getValue("id");
            if (id != null) {
                ProjectLoader.this.sqlObjectLoadIdMap.put(id, (SQLObject)ppdb);
            } else {
                logger.warn((Object)"No ID found in database element while loading project!");
            }
            String dbcsid = attributes.getValue("dbcs-ref");
            if (dbcsid != null) {
                ppdb.setDataSource(ProjectLoader.this.dbcsLoadIdMap.get(dbcsid));
            }
            ProjectLoader.this.sqlObjectLoadIdMap.put(id, (SQLObject)ppdb);
            return ppdb;
        }
    }

    private class DBCSFactory
    extends AbstractObjectCreationFactory {
        private DBCSFactory() {
        }

        public Object createObject(Attributes attributes) {
            JDBCDataSource dbcs = new JDBCDataSource(ProjectLoader.this.getSession().getDataSources());
            String id = attributes.getValue("id");
            if (id != null) {
                ProjectLoader.this.dbcsLoadIdMap.put(id, dbcs);
            } else {
                logger.info((Object)"No ID found in dbcs element while loading project! (this is normal for playpen db, but bad for other data sources!");
            }
            return dbcs;
        }
    }
}

