/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectProject;
import ca.sqlpower.architect.ProjectSettings;
import ca.sqlpower.architect.SnapshotCollection;
import ca.sqlpower.architect.ddl.critic.CriticManager;
import ca.sqlpower.architect.enterprise.BusinessDefinition;
import ca.sqlpower.architect.enterprise.DomainCategory;
import ca.sqlpower.architect.enterprise.FormulaMetricCalculation;
import ca.sqlpower.architect.etl.kettle.KettleSettings;
import ca.sqlpower.architect.olap.OLAPRootObject;
import ca.sqlpower.architect.olap.OLAPSession;
import ca.sqlpower.architect.profile.ProfileManager;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenContentPane;
import ca.sqlpower.enterprise.client.Group;
import ca.sqlpower.enterprise.client.User;
import ca.sqlpower.object.MappedSPTree;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.object.annotation.Constructor;
import ca.sqlpower.object.annotation.ConstructorParameter;
import ca.sqlpower.object.annotation.NonBound;
import ca.sqlpower.object.annotation.NonProperty;
import ca.sqlpower.object.annotation.Transient;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLObjectRoot;
import ca.sqlpower.sqlobject.UserDefinedSQLType;
import ca.sqlpower.util.RunnableDispatcher;
import ca.sqlpower.util.SQLPowerUtils;
import ca.sqlpower.util.WorkspaceContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ArchitectSwingProject
extends ArchitectProject
implements MappedSPTree {
    public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.unmodifiableList(new ArrayList<Class>(Arrays.asList(UserDefinedSQLType.class, DomainCategory.class, SnapshotCollection.class, SQLObjectRoot.class, OLAPRootObject.class, PlayPenContentPane.class, ProfileManager.class, ProjectSettings.class, CriticManager.class, KettleSettings.class, User.class, Group.class, BusinessDefinition.class, FormulaMetricCalculation.class)));
    private PlayPenContentPane playPenContentPane;
    private final OLAPRootObject olapRootObject;
    private final List<PlayPenContentPane> olapContentPaneList = new ArrayList<PlayPenContentPane>();
    private final List<BusinessDefinition> businessDefinitions = new ArrayList<BusinessDefinition>();
    private final List<FormulaMetricCalculation> formulas = new ArrayList<FormulaMetricCalculation>();
    private final List<DomainCategory> domainCategories = new ArrayList<DomainCategory>();
    private final SnapshotCollection snapshotCollection;
    private final Map<OLAPSession, PlayPenContentPane> olapContentPaneMap = new HashMap<OLAPSession, PlayPenContentPane>();
    private final KettleSettings kettleSettings;
    private final CriticManager criticManager;

    public ArchitectSwingProject() throws SQLObjectException {
        this.snapshotCollection = new SnapshotCollection();
        this.snapshotCollection.setParent((SPObject)this);
        this.olapRootObject = new OLAPRootObject();
        this.olapRootObject.setParent((SPObject)this);
        this.kettleSettings = new KettleSettings();
        this.kettleSettings.setParent((SPObject)this);
        this.setName("Architect Project");
        this.criticManager = new CriticManager();
        this.criticManager.setParent((SPObject)this);
    }

    @Constructor
    public ArchitectSwingProject(@ConstructorParameter(parameterType=ConstructorParameter.ParameterType.CHILD, propertyName="rootObject") SQLObjectRoot rootObject, @ConstructorParameter(parameterType=ConstructorParameter.ParameterType.CHILD, propertyName="olapRootObject") OLAPRootObject olapRootObject, @ConstructorParameter(parameterType=ConstructorParameter.ParameterType.CHILD, propertyName="kettleSettings") KettleSettings kettleSettings, @ConstructorParameter(parameterType=ConstructorParameter.ParameterType.CHILD, propertyName="profileManager") ProfileManager profileManager, @ConstructorParameter(parameterType=ConstructorParameter.ParameterType.CHILD, propertyName="criticManager") CriticManager criticManager, @ConstructorParameter(parameterType=ConstructorParameter.ParameterType.CHILD, propertyName="snapshotCollection") SnapshotCollection snapshotCollection) throws SQLObjectException {
        super(rootObject, profileManager);
        this.snapshotCollection = new SnapshotCollection();
        snapshotCollection.setParent((SPObject)this);
        this.olapRootObject = olapRootObject;
        olapRootObject.setParent((SPObject)this);
        this.kettleSettings = kettleSettings;
        kettleSettings.setParent((SPObject)this);
        this.criticManager = criticManager;
        criticManager.setParent((SPObject)this);
        this.setName("Architect Project");
    }

    @Override
    protected boolean removeChildImpl(SPObject child) {
        if (child instanceof PlayPenContentPane) {
            return this.removeOLAPContentPane((PlayPenContentPane)child);
        }
        if (child instanceof BusinessDefinition) {
            return this.removeBusinessDefinition((BusinessDefinition)child);
        }
        if (child instanceof FormulaMetricCalculation) {
            return this.removeFormulaMetricCalculation((FormulaMetricCalculation)child);
        }
        if (child instanceof DomainCategory) {
            return this.removeDomainCategory((DomainCategory)child);
        }
        return super.removeChildImpl(child);
    }

    @Override
    @Transient
    @Accessor
    public WorkspaceContainer getWorkspaceContainer() {
        return this.getSession();
    }

    @Override
    @Transient
    @Accessor
    public RunnableDispatcher getRunnableDispatcher() {
        return this.getSession();
    }

    @Override
    @Transient
    @Accessor
    public List<Class<? extends SPObject>> getAllowedChildTypes() {
        return allowedChildTypes;
    }

    @Override
    @NonProperty
    public List<SPObject> getChildren() {
        ArrayList<Object> allChildren = new ArrayList<Object>();
        allChildren.addAll(this.getSqlTypes());
        allChildren.addAll(this.getDomainCategories());
        allChildren.add((Object)this.getSnapshotCollection());
        allChildren.add(this.getRootObject());
        allChildren.add((Object)this.olapRootObject);
        if (this.playPenContentPane != null) {
            allChildren.add((Object)this.playPenContentPane);
        }
        allChildren.addAll(this.olapContentPaneList);
        if (this.getProfileManager() != null) {
            allChildren.add(this.getProfileManager());
        }
        allChildren.add((Object)this.getProjectSettings());
        allChildren.add((Object)this.criticManager);
        allChildren.add((Object)this.kettleSettings);
        allChildren.addAll(this.getUsers());
        allChildren.addAll(this.getGroups());
        allChildren.addAll(this.getBusinessDefinitions());
        allChildren.addAll(this.getFormulas());
        return Collections.unmodifiableList(allChildren);
    }

    @Override
    @NonBound
    public List<? extends SPObject> getDependencies() {
        return Collections.emptyList();
    }

    @Override
    public void removeDependency(SPObject dependency) {
        super.removeDependency(dependency);
        this.getOlapRootObject().removeDependency(dependency);
        this.getCriticManager().removeDependency(dependency);
        this.getKettleSettings().removeDependency(dependency);
        this.getPlayPenContentPane().removeDependency(dependency);
        for (PlayPenContentPane ppcp : this.getOlapContentPanes()) {
            ppcp.removeDependency(dependency);
        }
    }

    @Override
    protected void addChildImpl(SPObject child, int index) {
        if (child instanceof PlayPenContentPane) {
            PlayPenContentPane pane = (PlayPenContentPane)child;
            if (index == 0) {
                this.setPlayPenContentPane(pane);
            } else {
                this.addOLAPContentPane(pane);
            }
        } else if (child instanceof BusinessDefinition) {
            this.addBusinessDefinition((BusinessDefinition)child, index);
        } else if (child instanceof FormulaMetricCalculation) {
            this.addFormulaMetricCalculation((FormulaMetricCalculation)child, index);
        } else if (child instanceof DomainCategory) {
            this.addDomainCategory((DomainCategory)child, index);
        } else {
            super.addChildImpl(child, index);
        }
    }

    @NonProperty
    public void setPlayPenContentPane(PlayPenContentPane pane) {
        PlayPenContentPane oldPane = this.playPenContentPane;
        this.playPenContentPane = pane;
        if (oldPane != null) {
            if (pane.getPlayPen() == null) {
                PlayPen pp = oldPane.getPlayPen();
                pp.setContentPane(pane);
            }
            pane.setComponentListeners(oldPane.getComponentListeners());
            this.fireChildRemoved(((Object)((Object)oldPane)).getClass(), (SPObject)oldPane, 0);
        }
        this.fireChildAdded(((Object)((Object)pane)).getClass(), (SPObject)this.playPenContentPane, 0);
        pane.setParent((SPObject)this);
    }

    @NonProperty
    public PlayPenContentPane getPlayPenContentPane() {
        return this.playPenContentPane;
    }

    @NonProperty
    public OLAPRootObject getOlapRootObject() {
        return this.olapRootObject;
    }

    @NonProperty
    public KettleSettings getKettleSettings() {
        return this.kettleSettings;
    }

    @NonProperty
    public List<PlayPenContentPane> getOlapContentPanes() {
        return Collections.unmodifiableList(this.olapContentPaneList);
    }

    @NonBound
    public PlayPenContentPane getOlapContentPane(OLAPSession session) {
        return this.olapContentPaneMap.get((Object)session);
    }

    public void addOLAPContentPane(PlayPenContentPane olapContentPane) {
        if (!(olapContentPane.getModelContainer() instanceof OLAPSession)) {
            throw new IllegalArgumentException("PlayPenContentPane is not modelling an OLAPSession");
        }
        this.olapContentPaneList.add(olapContentPane);
        this.olapContentPaneMap.put((OLAPSession)olapContentPane.getModelContainer(), olapContentPane);
        int index = this.olapContentPaneList.indexOf((Object)olapContentPane);
        if (this.playPenContentPane != null) {
            ++index;
        }
        olapContentPane.setParent((SPObject)this);
        this.fireChildAdded(PlayPenContentPane.class, (SPObject)olapContentPane, index);
    }

    public boolean removeOLAPContentPane(PlayPenContentPane olapContentPane) {
        int index = this.olapContentPaneList.indexOf((Object)olapContentPane);
        if (!this.olapContentPaneList.remove((Object)olapContentPane)) {
            return false;
        }
        if (this.olapContentPaneMap.remove(olapContentPane.getModelContainer()) == null) {
            throw new IllegalStateException("Tried removing OLAP PlayPenContentPane from  project mapping but could not find it from its OLAPSession");
        }
        if (this.playPenContentPane != null) {
            ++index;
        }
        this.fireChildRemoved(PlayPenContentPane.class, (SPObject)olapContentPane, index);
        olapContentPane.setParent(null);
        return true;
    }

    @NonBound
    public SPObject getObjectInTree(String uuid) {
        return SQLPowerUtils.findByUuid((SPObject)this, (String)uuid, SPObject.class);
    }

    @NonBound
    public <T extends SPObject> T getObjectInTree(String uuid, Class<T> expectedType) {
        return (T)SQLPowerUtils.findByUuid((SPObject)this, (String)uuid, expectedType);
    }

    @NonProperty
    public CriticManager getCriticManager() {
        return this.criticManager;
    }

    @NonProperty
    protected List<BusinessDefinition> getBusinessDefinitions() {
        return Collections.unmodifiableList(this.businessDefinitions);
    }

    @NonProperty
    protected List<FormulaMetricCalculation> getFormulas() {
        return Collections.unmodifiableList(this.formulas);
    }

    public void addBusinessDefinition(BusinessDefinition businessDefinition, int index) {
        this.businessDefinitions.add(index, businessDefinition);
        businessDefinition.setParent((SPObject)this);
        this.fireChildAdded(BusinessDefinition.class, (SPObject)businessDefinition, index);
    }

    public void addFormulaMetricCalculation(FormulaMetricCalculation formula, int index) {
        this.formulas.add(index, formula);
        formula.setParent((SPObject)this);
        this.fireChildAdded(FormulaMetricCalculation.class, (SPObject)formula, index);
    }

    public boolean removeBusinessDefinition(BusinessDefinition child) {
        int index = this.businessDefinitions.indexOf((Object)child);
        boolean removed = this.businessDefinitions.remove((Object)child);
        if (removed) {
            this.fireChildRemoved(BusinessDefinition.class, (SPObject)child, index);
            child.setParent(null);
        }
        return removed;
    }

    public boolean removeFormulaMetricCalculation(FormulaMetricCalculation child) {
        int index = this.formulas.indexOf((Object)child);
        boolean removed = this.formulas.remove((Object)child);
        if (removed) {
            this.fireChildRemoved(FormulaMetricCalculation.class, (SPObject)child, index);
            child.setParent(null);
        }
        return removed;
    }

    public boolean removeDomainCategory(DomainCategory child) {
        int index = this.domainCategories.indexOf((Object)child);
        boolean removed = this.domainCategories.remove((Object)child);
        if (removed) {
            this.fireChildRemoved(DomainCategory.class, (SPObject)child, index);
            child.setParent(null);
        }
        return removed;
    }

    @NonProperty
    public List<DomainCategory> getDomainCategories() {
        return Collections.unmodifiableList(this.domainCategories);
    }

    public void addDomainCategory(DomainCategory domainCategory, int index) {
        this.domainCategories.add(index, domainCategory);
        domainCategory.setParent((SPObject)this);
        this.fireChildAdded(DomainCategory.class, (SPObject)domainCategory, index);
    }

    @NonProperty
    public SnapshotCollection getSnapshotCollection() {
        return this.snapshotCollection;
    }
}

