/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.FormLayout;
import ca.sqlpower.architect.swingui.Messages;
import ca.sqlpower.architect.swingui.TablePane;
import ca.sqlpower.sqlobject.SQLIndex;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.swingui.ChangeListeningDataEntryPanel;
import ca.sqlpower.swingui.ColorCellRenderer;
import ca.sqlpower.swingui.ColourScheme;
import ca.sqlpower.util.WebColour;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class TableEditPanel
extends ChangeListeningDataEntryPanel {
    private static final Logger logger = Logger.getLogger(TableEditPanel.class);
    private JPanel panel;
    private SQLTable table;
    private JTextField logicalName;
    private JTextField physicalName;
    private JTextField pkName;
    private JTextArea remarks;
    private JComboBox bgColor;
    private JComboBox fgColor;
    private JCheckBox rounded;
    private JCheckBox dashed;
    private TablePane tablePane;
    final HashMap<String, PropertyChangeEvent> propertyConflicts = new HashMap();
    final HashMap<String, JComponent> propertyFields = new HashMap();

    public TableEditPanel(ArchitectSwingSession session, TablePane tp) {
        this(session, (SQLTable)tp.getModel());
        this.tablePane = tp;
    }

    public TableEditPanel(ArchitectSwingSession session, SQLTable t) {
        this.panel = new JPanel(new FormLayout());
        this.tablePane = session.getPlayPen().findTablePane(t);
        this.panel.add(new JLabel(Messages.getString("TableEditPanel.tableLogicalNameLabel")));
        this.logicalName = new JTextField("", 30);
        this.panel.add(this.logicalName);
        this.panel.add(new JLabel(Messages.getString("TableEditPanel.tablePhysicalNameLabel")));
        this.physicalName = new JTextField("", 30);
        this.panel.add(this.physicalName);
        this.panel.add(new JLabel(Messages.getString("TableEditPanel.primaryKeyNameLabel")));
        this.pkName = new JTextField("", 30);
        this.panel.add(this.pkName);
        this.panel.add(new JLabel(Messages.getString("TableEditPanel.remarksLabel")));
        this.remarks = new JTextArea(4, 30);
        this.panel.add(new JScrollPane(this.remarks));
        this.remarks.setLineWrap(true);
        this.remarks.setWrapStyleWord(true);
        this.panel.add(new JLabel(Messages.getString("TableEditPanel.tableColourLabel")));
        ColorCellRenderer renderer = new ColorCellRenderer(40, 20);
        this.bgColor = new JComboBox<WebColour>(ColourScheme.BACKGROUND_COLOURS);
        this.bgColor.setRenderer(renderer);
        this.bgColor.addItem(new Color(240, 240, 240));
        this.panel.add(this.bgColor);
        this.panel.add(new JLabel(Messages.getString("TableEditPanel.textColourLabel")));
        this.fgColor = new JComboBox<WebColour>(ColourScheme.FOREGROUND_COLOURS);
        this.fgColor.setRenderer(renderer);
        this.fgColor.addItem(Color.BLACK);
        this.panel.add(this.fgColor);
        this.panel.add(new JLabel(Messages.getString("TableEditPanel.dashedLinesLabel")));
        this.dashed = new JCheckBox();
        this.panel.add(this.dashed);
        this.panel.add(new JLabel(Messages.getString("TableEditPanel.roundedCornersLabel")));
        this.rounded = new JCheckBox();
        this.panel.add(this.rounded);
        this.editTable(t);
    }

    private void editTable(SQLTable t) {
        this.table = t;
        this.logicalName.setText(t.getName());
        this.physicalName.setText(t.getPhysicalName());
        SQLIndex primaryKeyIndex = t.getPrimaryKeyIndex();
        if (primaryKeyIndex == null) {
            this.pkName.setEnabled(false);
        } else {
            this.pkName.setText(primaryKeyIndex.getName());
            this.pkName.setEnabled(true);
        }
        this.remarks.setText(t.getRemarks());
        this.logicalName.selectAll();
        if (this.tablePane != null) {
            this.bgColor.setSelectedItem(this.tablePane.getBackgroundColor());
            this.fgColor.setSelectedItem(this.tablePane.getForegroundColor());
            this.dashed.setSelected(this.tablePane.isDashed());
            this.rounded.setSelected(this.tablePane.isRounded());
        }
    }

    public boolean applyChanges() {
        String warnings = this.generateWarnings();
        if (warnings.length() == 0) {
            this.table.begin(Messages.getString("TableEditPanel.compoundEditName"));
            if (this.pkName.isEnabled() && this.table.getPrimaryKeyIndex() != null) {
                this.table.getPrimaryKeyIndex().setName(this.pkName.getText());
            }
            this.table.setPhysicalName(this.physicalName.getText());
            this.table.setName(this.logicalName.getText());
            this.table.setRemarks(this.remarks.getText());
            if (this.tablePane != null) {
                this.tablePane.begin("TableEditPanel.compoundEditName");
                if (!this.tablePane.getBackgroundColor().equals((Color)this.bgColor.getSelectedItem())) {
                    this.tablePane.setBackgroundColor((Color)this.bgColor.getSelectedItem());
                }
                if (!this.tablePane.getForegroundColor().equals((Color)this.fgColor.getSelectedItem())) {
                    this.tablePane.setForegroundColor((Color)this.fgColor.getSelectedItem());
                }
                if (this.tablePane.isDashed() != this.dashed.isSelected()) {
                    this.tablePane.setDashed(this.dashed.isSelected());
                }
                if (this.tablePane.isRounded() != this.rounded.isSelected()) {
                    this.tablePane.setRounded(this.rounded.isSelected());
                }
                this.tablePane.commit();
            }
            this.table.commit();
            return true;
        }
        JOptionPane.showMessageDialog(this.panel, warnings);
        return false;
    }

    protected String generateWarnings() {
        StringBuffer warnings = new StringBuffer();
        if (this.logicalName.getText().trim().length() == 0) {
            warnings.append(Messages.getString("TableEditPanel.blankTableNameWarning"));
        }
        if (this.pkName.isEnabled() && this.pkName.getText().trim().length() == 0) {
            warnings.append(Messages.getString("TableEditPanel.blankPkNameWarning"));
        }
        return warnings.toString();
    }

    public void discardChanges() {
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void setNameText(String newName) {
        this.logicalName.setText(newName);
    }

    public void setPkNameText(String newPkName) {
        this.pkName.setText(newPkName);
    }

    public void setPhysicalNameText(String newPhysicalName) {
        this.physicalName.setText(newPhysicalName);
    }

    public boolean hasUnsavedChanges() {
        return true;
    }

    public SQLTable getTable() {
        return this.table;
    }

    public TablePane getTablePane() {
        return this.tablePane;
    }

    public JComboBox getBgColor() {
        return this.bgColor;
    }

    public JCheckBox getDashed() {
        return this.dashed;
    }

    public JComboBox getFgColor() {
        return this.fgColor;
    }

    public JTextField getLogicalName() {
        return this.logicalName;
    }

    public JTextField getPhysicalName() {
        return this.physicalName;
    }

    public JTextField getPkName() {
        return this.pkName;
    }

    public JTextArea getRemarks() {
        return this.remarks;
    }

    public JCheckBox getRounded() {
        return this.rounded;
    }
}

