/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.layout.ArchitectLayout;
import ca.sqlpower.architect.layout.LayoutEdge;
import ca.sqlpower.architect.layout.LayoutNode;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.ContainerPane;
import ca.sqlpower.architect.swingui.LayoutAnimator;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.action.AbstractArchitectAction;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class AutoLayoutAction
extends AbstractArchitectAction {
    private static final Logger logger = Logger.getLogger(AutoLayoutAction.class);
    private boolean animationEnabled = true;
    private ArchitectLayout layout;
    private int framesPerSecond = 25;

    public AutoLayoutAction(ArchitectSwingSession session, PlayPen pp, String name, String description, String iconResourceName) {
        super(session, pp, name, description, iconResourceName);
    }

    public AutoLayoutAction(ArchitectFrame frame, String name, String description, String iconResourceName) {
        super(frame, name, description, iconResourceName);
    }

    public AutoLayoutAction(ArchitectSwingSession session, PlayPen playPen, String name, String description, Icon icon) {
        super(session, playPen, name, description, icon);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        logger.debug((Object)"Auto layout action starting...");
        try {
            this.layout = (ArchitectLayout)this.layout.getClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        logger.debug((Object)("Created new Layout instance: " + this.layout));
        List<Object> nodes = new ArrayList();
        for (ContainerPane<?, ?> cp : this.getPlayPen().getSelectedContainers()) {
            if (!(cp instanceof LayoutNode)) continue;
            nodes.add(cp);
        }
        List<LayoutNode> notLaidOut = AutoLayoutAction.extractLayoutNodes(this.getPlaypen());
        notLaidOut.removeAll(nodes);
        Point layoutAreaOffset = new Point();
        if (nodes.size() == 0 || nodes.size() == 1) {
            nodes = AutoLayoutAction.extractLayoutNodes(this.getPlaypen());
        } else if (nodes.size() != AutoLayoutAction.extractLayoutNodes(this.getPlaypen()).size()) {
            int maxWidth = 0;
            for (LayoutNode tp : notLaidOut) {
                int width = tp.getWidth() + tp.getX();
                if (width <= maxWidth) continue;
                maxWidth = width;
            }
            layoutAreaOffset = new Point(maxWidth, 0);
        }
        List<LayoutEdge> edges = AutoLayoutAction.extractLayoutEdges(this.getPlaypen());
        logger.debug((Object)("About to do layout. nodes=" + nodes));
        logger.debug((Object)("About to do layout. edges=" + edges));
        Rectangle layoutArea = new Rectangle(layoutAreaOffset, this.layout.getNewArea(nodes));
        this.layout.setup(nodes, edges, layoutArea);
        LayoutAnimator anim = new LayoutAnimator(this.getPlaypen(), this.layout);
        anim.setAnimationEnabled(this.animationEnabled);
        anim.setFramesPerSecond(this.framesPerSecond);
        anim.startAnimation();
        try {
            if ((evt.getModifiers() & 1) != 0) {
                Clip clip = AudioSystem.getClip();
                clip.open(AudioSystem.getAudioInputStream(this.getClass().getResource("/sounds/boingoingoingoingoing.wav")));
                clip.start();
            }
        }
        catch (Exception ex) {
            logger.debug((Object)"Couldn't play sound. Sigh.", (Throwable)ex);
        }
    }

    private static List<LayoutNode> extractLayoutNodes(PlayPen pp) {
        ArrayList<LayoutNode> nodes = new ArrayList<LayoutNode>();
        for (PlayPenComponent playPenComponent : pp.getContentPane().getChildren()) {
            if (!(playPenComponent instanceof LayoutNode)) continue;
            nodes.add((LayoutNode)((Object)playPenComponent));
        }
        return nodes;
    }

    private static List<LayoutEdge> extractLayoutEdges(PlayPen pp) {
        ArrayList<LayoutEdge> edges = new ArrayList<LayoutEdge>();
        for (PlayPenComponent playPenComponent : pp.getContentPane().getChildren()) {
            if (!(playPenComponent instanceof LayoutEdge)) continue;
            edges.add((LayoutEdge)((Object)playPenComponent));
        }
        return edges;
    }

    public boolean isAnimationEnabled() {
        return this.animationEnabled;
    }

    public void setAnimationEnabled(boolean animationEnabled) {
        this.animationEnabled = animationEnabled;
    }

    public ArchitectLayout getLayout() {
        return this.layout;
    }

    public void setLayout(ArchitectLayout layout) {
        this.layout = layout;
    }

    public PlayPen getPlayPen() {
        return this.getPlaypen();
    }
}

