/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.Messages;
import ca.sqlpower.sqlobject.SQLDatabase;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.tree.TreePath;

public class DataSourcePropertiesAction
extends AbstractAction {
    private final ArchitectSwingSession session;
    private final ArchitectFrame frame;

    public DataSourcePropertiesAction(ArchitectSwingSession session) {
        super(Messages.getString("DBTree.dbcsPropertiesActionName"));
        this.session = session;
        this.frame = null;
    }

    public DataSourcePropertiesAction(ArchitectFrame frame) {
        super(Messages.getString("DBTree.dbcsPropertiesActionName"));
        this.frame = frame;
        this.session = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TreePath p = this.getSession().getDBTree().getSelectionPath();
        if (p == null) {
            return;
        }
        Object[] pathArray = p.getPath();
        SQLDatabase sd = null;
        for (int ii = 0; ii < pathArray.length && sd == null; ++ii) {
            if (!(pathArray[ii] instanceof SQLDatabase)) continue;
            sd = (SQLDatabase)pathArray[ii];
        }
        if (sd != null) {
            ASUtils.showDbcsDialog(this.getSession().getArchitectFrame(), sd.getDataSource(), null);
        }
    }

    public ArchitectSwingSession getSession() {
        return this.session == null ? this.frame.getCurrentSession() : this.session;
    }
}

