/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.TableEditPanel;
import ca.sqlpower.architect.swingui.TablePane;
import ca.sqlpower.architect.swingui.action.AbstractArchitectAction;
import ca.sqlpower.architect.swingui.action.Messages;
import ca.sqlpower.object.AbstractSPListener;
import ca.sqlpower.object.SPChildEvent;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.swingui.DataEntryPanel;
import ca.sqlpower.swingui.DataEntryPanelBuilder;
import ca.sqlpower.swingui.DataEntryPanelChangeUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class EditTableAction
extends AbstractArchitectAction {
    private static final Logger logger = Logger.getLogger(EditTableAction.class);
    private final SPListener sqlTableListener = new AbstractSPListener(){

        public void childRemoved(SPChildEvent evt) {
            logger.debug((Object)("SQLObject children got removed: " + evt));
            if (EditTableAction.this.tableEditPanel.getTable() == evt.getChild()) {
                evt.getChild().removeSPListener((SPListener)this);
                EditTableAction.this.tableEditPanel.getTablePane().removeSPListener(EditTableAction.this.tablePaneListener);
                EditTableAction.this.tableEditPanel = null;
                if (EditTableAction.this.editDialog != null) {
                    EditTableAction.this.editDialog.dispose();
                    EditTableAction.this.editDialog = null;
                }
            }
        }

        public void propertyChanged(PropertyChangeEvent evt) {
            String property = evt.getPropertyName();
            boolean foundError = false;
            if (evt.getSource() == EditTableAction.this.tableEditPanel.getTable()) {
                if (property.equals("name")) {
                    foundError = DataEntryPanelChangeUtil.incomingChange((JTextComponent)EditTableAction.this.tableEditPanel.getLogicalName(), (PropertyChangeEvent)evt);
                } else if (property.equals("physicalName")) {
                    foundError = DataEntryPanelChangeUtil.incomingChange((JTextComponent)EditTableAction.this.tableEditPanel.getPhysicalName(), (PropertyChangeEvent)evt);
                } else if (property.equals("pkName")) {
                    foundError = DataEntryPanelChangeUtil.incomingChange((JTextComponent)EditTableAction.this.tableEditPanel.getPkName(), (PropertyChangeEvent)evt);
                } else if (property.equals("remarks")) {
                    foundError = DataEntryPanelChangeUtil.incomingChange((JTextComponent)EditTableAction.this.tableEditPanel.getRemarks(), (PropertyChangeEvent)evt);
                }
            }
            if (foundError) {
                EditTableAction.this.tableEditPanel.setErrorText("<html>This object has been changed by another user.<br>You must re-open this window before making changes.</html>");
            }
        }
    };
    private SPListener tablePaneListener = new AbstractSPListener(){

        public void propertyChanged(PropertyChangeEvent evt) {
            String property = evt.getPropertyName();
            boolean foundError = false;
            if (evt.getSource() == EditTableAction.this.tableEditPanel.getTablePane()) {
                if (property.equals("backgroundColor")) {
                    foundError = DataEntryPanelChangeUtil.incomingChange((JComboBox)EditTableAction.this.tableEditPanel.getBgColor(), (PropertyChangeEvent)evt);
                } else if (property.equals("foregroundColor")) {
                    foundError = DataEntryPanelChangeUtil.incomingChange((JComboBox)EditTableAction.this.tableEditPanel.getFgColor(), (PropertyChangeEvent)evt);
                } else if (property.equals("rounded")) {
                    foundError = DataEntryPanelChangeUtil.incomingChange((JCheckBox)EditTableAction.this.tableEditPanel.getRounded(), (PropertyChangeEvent)evt);
                } else if (property.equals("dashed")) {
                    foundError = DataEntryPanelChangeUtil.incomingChange((JCheckBox)EditTableAction.this.tableEditPanel.getDashed(), (PropertyChangeEvent)evt);
                }
            }
            if (foundError) {
                EditTableAction.this.tableEditPanel.setErrorText("<html>This object has been changed by another user.<br>You must re-open this window before making changes.</html>");
            }
        }
    };
    protected JDialog editDialog;
    private TableEditPanel tableEditPanel;

    public EditTableAction(ArchitectFrame frame) {
        super(frame, Messages.getString("EditTableAction.name"), Messages.getString("EditTableAction.description"), "edit_table");
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equals("PlayPen")) {
            List<PlayPenComponent> selection = this.getPlaypen().getSelectedItems();
            if (selection.size() < 1) {
                JOptionPane.showMessageDialog(this.getPlaypen(), Messages.getString("EditTableAction.noTablesSelected"));
            } else if (selection.size() > 1) {
                JOptionPane.showMessageDialog(this.getPlaypen(), Messages.getString("EditTableAction.multipleTablesSelected"));
            } else if (selection.get(0) instanceof TablePane) {
                TablePane tp = (TablePane)selection.get(0);
                this.makeDialog((SQLTable)tp.getModel());
            } else {
                JOptionPane.showMessageDialog(this.getPlaypen(), Messages.getString("EditTableAction.cannotRecognizeItem"));
            }
        } else if (evt.getActionCommand().equals("DBTree")) {
            TreePath[] selections = this.getSession().getDBTree().getSelectionPaths();
            logger.debug((Object)("selections length is: " + selections.length));
            if (selections.length == 1 || selections.length == 2) {
                SQLObject so = (SQLObject)selections[0].getLastPathComponent();
                SQLTable st = null;
                if (so instanceof SQLColumn && selections.length == 2) {
                    so = (SQLObject)selections[1].getLastPathComponent();
                }
                if (so instanceof SQLTable) {
                    logger.debug((Object)"user clicked on table, so we shall try to edit the table properties.");
                    st = (SQLTable)so;
                    this.makeDialog(st);
                } else {
                    JOptionPane.showMessageDialog(this.frame, Messages.getString("EditTableAction.instructions"));
                }
            } else {
                JOptionPane.showMessageDialog(this.frame, Messages.getString("EditTableAction.instructions"));
            }
        }
    }

    protected void makeDialog(SQLTable table) {
        DataEntryPanel panel = this.makeDataEntryPanel(table);
        this.editDialog = DataEntryPanelBuilder.createDataEntryPanelDialog((DataEntryPanel)panel, (Component)this.frame, (String)Messages.getString("EditTableAction.dialogTitle"), (String)DataEntryPanelBuilder.OK_BUTTON_LABEL);
        this.editDialog.pack();
        this.editDialog.setLocationRelativeTo(this.frame);
        this.editDialog.setVisible(true);
    }

    protected DataEntryPanel makeDataEntryPanel(SQLTable table) {
        return this.makeTableEditPanel(table);
    }

    protected TableEditPanel makeTableEditPanel(SQLTable table) {
        this.tableEditPanel = new TableEditPanel(this.getSession(), table);
        table.addSPListener(this.sqlTableListener);
        this.tableEditPanel.getTablePane().addSPListener(this.tablePaneListener);
        return this.tableEditPanel;
    }
}

