/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.transformation;

import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.transformation.ReportTransformer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XsltTransformation
implements ReportTransformer,
URIResolver {
    private File baseDir;
    private File projectDir;
    private Map<String, Object> parameters = new HashMap<String, Object>();

    @Override
    public void transform(String builtInXsltName, File result, ArchitectSwingSession session) throws Exception {
        InputStream xsltStylesheet = this.getClass().getResourceAsStream(builtInXsltName);
        this.transform(xsltStylesheet, result, session);
    }

    @Override
    public void transform(File xsltStylesheet, File output, ArchitectSwingSession session) throws Exception {
        FileInputStream xslt = new FileInputStream(xsltStylesheet);
        this.baseDir = xsltStylesheet.getParentFile();
        this.transform(xslt, output, session);
    }

    public void transform(InputStream xsltStylesheet, File output, ArchitectSwingSession session) throws Exception {
        ByteArrayOutputStream sessionAsStream = new ByteArrayOutputStream();
        session.getSaveBehaviour().saveToStream(session, sessionAsStream);
        StreamSource xmlSource = new StreamSource(new ByteArrayInputStream(sessionAsStream.toByteArray()));
        StreamSource xsltSource = new StreamSource(xsltStylesheet);
        FileOutputStream result = new FileOutputStream(output);
        TransformerFactory transFact = TransformerFactory.newInstance();
        transFact.setURIResolver(this);
        Transformer trans = transFact.newTransformer(xsltSource);
        for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
            trans.setParameter(entry.getKey(), entry.getValue());
        }
        trans.transform(xmlSource, new StreamResult(result));
        result.flush();
        result.close();
        xsltStylesheet.close();
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        File referenced = null;
        referenced = base == null ? new File(href) : new File(base, href);
        try {
            if (referenced.exists()) {
                return new StreamSource(new FileInputStream(referenced));
            }
            File toUse = null;
            if (this.baseDir != null) {
                toUse = new File(this.baseDir, href);
            } else {
                InputStream in = this.getClass().getResourceAsStream(href);
                if (in != null) {
                    return new StreamSource(in);
                }
            }
            if (toUse.exists()) {
                return new StreamSource(new FileInputStream(toUse));
            }
            if (this.projectDir != null) {
                toUse = new File(this.projectDir, href);
            }
            if (toUse.exists()) {
                return new StreamSource(new FileInputStream(toUse));
            }
            return null;
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    @Override
    public void setParameter(String name, Object value) {
        this.parameters.put(name, value);
    }
}

