/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authoritymapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.authoritymapping.Attributes2GrantedAuthoritiesMapper;
import org.springframework.security.authoritymapping.MappableAttributesRetriever;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class MapBasedAttributes2GrantedAuthoritiesMapper
implements Attributes2GrantedAuthoritiesMapper,
MappableAttributesRetriever,
InitializingBean {
    private Map attributes2grantedAuthoritiesMap = null;
    private String stringSeparator = ",";
    private String[] mappableAttributes = null;

    public void afterPropertiesSet() {
        Assert.notEmpty((Map)this.attributes2grantedAuthoritiesMap, (String)"A non-empty attributes2grantedAuthoritiesMap must be supplied");
        this.attributes2grantedAuthoritiesMap = this.preProcessMap(this.attributes2grantedAuthoritiesMap);
        try {
            this.mappableAttributes = this.attributes2grantedAuthoritiesMap.keySet().toArray(new String[0]);
        }
        catch (ArrayStoreException ase) {
            throw new IllegalArgumentException("attributes2grantedAuthoritiesMap contains non-String objects as keys");
        }
    }

    private Map preProcessMap(Map orgMap) {
        HashMap result = new HashMap(orgMap.size());
        Iterator it = orgMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            result.put(entry.getKey(), this.getGrantedAuthorityCollection(entry.getValue()));
        }
        return result;
    }

    private Collection getGrantedAuthorityCollection(Object value) {
        ArrayList result = new ArrayList();
        this.addGrantedAuthorityCollection(result, value);
        return result;
    }

    private void addGrantedAuthorityCollection(Collection result, Object value) {
        if (value != null) {
            if (value instanceof Collection) {
                this.addGrantedAuthorityCollection(result, (Collection)value);
            } else if (value instanceof Object[]) {
                this.addGrantedAuthorityCollection(result, (Object[])value);
            } else if (value instanceof String) {
                this.addGrantedAuthorityCollection(result, (String)value);
            } else if (value instanceof GrantedAuthority) {
                result.add(value);
            } else {
                throw new IllegalArgumentException("Invalid object type: " + value.getClass().getName());
            }
        }
    }

    private void addGrantedAuthorityCollection(Collection result, Collection value) {
        Iterator it = value.iterator();
        while (it.hasNext()) {
            this.addGrantedAuthorityCollection(result, it.next());
        }
    }

    private void addGrantedAuthorityCollection(Collection result, Object[] value) {
        for (int i = 0; i < value.length; ++i) {
            this.addGrantedAuthorityCollection(result, value[i]);
        }
    }

    private void addGrantedAuthorityCollection(Collection result, String value) {
        StringTokenizer st = new StringTokenizer(value, this.stringSeparator, false);
        while (st.hasMoreTokens()) {
            String nextToken = st.nextToken();
            if (!StringUtils.hasText((String)nextToken)) continue;
            result.add(new GrantedAuthorityImpl(nextToken));
        }
    }

    public GrantedAuthority[] getGrantedAuthorities(String[] attributes) {
        ArrayList gaList = new ArrayList();
        for (int i = 0; i < attributes.length; ++i) {
            Collection c = (Collection)this.attributes2grantedAuthoritiesMap.get(attributes[i]);
            if (c == null) continue;
            gaList.addAll(c);
        }
        GrantedAuthority[] result = new GrantedAuthority[gaList.size()];
        result = gaList.toArray(result);
        return result;
    }

    public Map getAttributes2grantedAuthoritiesMap() {
        return this.attributes2grantedAuthoritiesMap;
    }

    public void setAttributes2grantedAuthoritiesMap(Map attributes2grantedAuthoritiesMap) {
        this.attributes2grantedAuthoritiesMap = attributes2grantedAuthoritiesMap;
    }

    public String[] getMappableAttributes() {
        return this.mappableAttributes;
    }

    public String getStringSeparator() {
        return this.stringSeparator;
    }

    public void setStringSeparator(String stringSeparator) {
        this.stringSeparator = stringSeparator;
    }
}

