/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.gui.GUIPositionInterface;
import org.pentaho.di.core.gui.GUISizeInterface;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.core.xml.XMLInterface;
import org.pentaho.di.repository.Repository;
import org.w3c.dom.Node;

public class NotePadMeta
implements Cloneable,
XMLInterface,
GUIPositionInterface,
GUISizeInterface {
    public static final String XML_TAG = "notepad";
    private String note;
    private Point location;
    public int width;
    public int height;
    private boolean selected;
    private boolean changed;
    private long id;

    public NotePadMeta() {
        this.note = null;
        this.location = new Point(-1, -1);
        this.width = -1;
        this.height = -1;
        this.selected = false;
    }

    public NotePadMeta(String n, int xl, int yl, int w, int h) {
        this.note = n;
        this.location = new Point(xl, yl);
        this.width = w;
        this.height = h;
        this.selected = false;
    }

    public NotePadMeta(Node notepadnode) throws KettleXMLException {
        try {
            this.note = XMLHandler.getTagValue((Node)notepadnode, (String)"note");
            String sxloc = XMLHandler.getTagValue((Node)notepadnode, (String)"xloc");
            String syloc = XMLHandler.getTagValue((Node)notepadnode, (String)"yloc");
            String swidth = XMLHandler.getTagValue((Node)notepadnode, (String)"width");
            String sheight = XMLHandler.getTagValue((Node)notepadnode, (String)"heigth");
            int x = Const.toInt((String)sxloc, (int)0);
            int y = Const.toInt((String)syloc, (int)0);
            this.location = new Point(x, y);
            this.width = Const.toInt((String)swidth, (int)0);
            this.height = Const.toInt((String)sheight, (int)0);
            this.selected = false;
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to read Notepad info from XML", (Throwable)e);
        }
    }

    public NotePadMeta(LogWriter log, Repository rep, long id_note) throws KettleException {
        this.readRep(log, rep, id_note);
    }

    private void readRep(LogWriter log, Repository rep, long id_note) throws KettleException {
        try {
            this.setID(id_note);
            RowMetaAndData r = rep.getNote(id_note);
            if (r == null) {
                this.setID(-1L);
                throw new KettleException("I couldn't find Notepad with id_note=" + id_note + " in the repository.");
            }
            this.note = r.getString("VALUE_STR", "");
            int x = (int)r.getInteger("GUI_LOCATION_X", 0L);
            int y = (int)r.getInteger("GUI_LOCATION_Y", 0L);
            this.location = new Point(x, y);
            this.width = (int)r.getInteger("GUI_LOCATION_WIDTH", 0L);
            this.height = (int)r.getInteger("GUI_LOCATION_HEIGHT", 0L);
            this.selected = false;
        }
        catch (KettleDatabaseException dbe) {
            this.setID(-1L);
            throw new KettleException("Unable to load Notepad from repository (id_note=" + id_note + ")", (Throwable)dbe);
        }
    }

    public void saveRep(Repository rep, long id_transformation) throws KettleException {
        try {
            int x = this.location == null ? -1 : this.location.x;
            int y = this.location == null ? -1 : this.location.y;
            this.setID(rep.insertNote(this.note, x, y, this.width, this.height));
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save notepad in repository (id_transformation=" + id_transformation + ")", (Throwable)dbe);
        }
    }

    public long getID() {
        return this.id;
    }

    public void setID(long id) {
        this.id = id;
    }

    public void setLocation(int x, int y) {
        if (x != this.location.x || y != this.location.y) {
            this.setChanged();
        }
        this.location.x = x;
        this.location.y = y;
    }

    public void setLocation(Point p) {
        this.setLocation(p.x, p.y);
    }

    public Point getLocation() {
        return this.location;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void flipSelected() {
        this.selected = !this.selected;
    }

    public Object clone() {
        try {
            Object retval = super.clone();
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void setChanged() {
        this.setChanged(true);
    }

    public void setChanged(boolean ch) {
        this.changed = ch;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public String toString() {
        return this.note;
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer(100);
        retval.append("    <notepad>").append(Const.CR);
        retval.append("      ").append(XMLHandler.addTagValue((String)"note", (String)this.note));
        retval.append("      ").append(XMLHandler.addTagValue((String)"xloc", (int)this.location.x));
        retval.append("      ").append(XMLHandler.addTagValue((String)"yloc", (int)this.location.y));
        retval.append("      ").append(XMLHandler.addTagValue((String)"width", (int)this.width));
        retval.append("      ").append(XMLHandler.addTagValue((String)"heigth", (int)this.height));
        retval.append("    </notepad>").append(Const.CR);
        return retval.toString();
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }
}

