/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.connectedtorepository;

import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.connectedtorepository.Messages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryConnectedToRepository
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private boolean isspecificrep;
    private String repname;
    private boolean isspecificuser;
    private String username;

    public JobEntryConnectedToRepository(String n, String scr) {
        super(n, "");
        this.isspecificrep = false;
        this.repname = null;
        this.isspecificuser = false;
        this.username = null;
        this.setJobEntryType(JobEntryType.CONNECTED_TO_REPOSITORY);
    }

    public JobEntryConnectedToRepository() {
        this("", "");
    }

    public void setSpecificRep(boolean isspecificrep) {
        this.isspecificrep = isspecificrep;
    }

    public String getRepName() {
        return this.repname;
    }

    public void setRepName(String repname) {
        this.repname = repname;
    }

    public String getUserName() {
        return this.username;
    }

    public void setUserName(String username) {
        this.username = username;
    }

    public boolean isSpecificRep() {
        return this.isspecificrep;
    }

    public boolean isSpecificUser() {
        return this.isspecificuser;
    }

    public void setSpecificUser(boolean isspecificuser) {
        this.isspecificuser = isspecificuser;
    }

    public JobEntryConnectedToRepository(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public Object clone() {
        JobEntryConnectedToRepository je = (JobEntryConnectedToRepository)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("      ").append(XMLHandler.addTagValue((String)"isspecificrep", (boolean)this.isspecificrep));
        retval.append("      ").append(XMLHandler.addTagValue((String)"repname", (String)this.repname));
        retval.append("      ").append(XMLHandler.addTagValue((String)"isspecificuser", (boolean)this.isspecificuser));
        retval.append("      ").append(XMLHandler.addTagValue((String)"username", (String)this.username));
        retval.append(super.getXML());
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.isspecificrep = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"isspecificrep"));
            this.repname = XMLHandler.getTagValue((Node)entrynode, (String)"repname");
            this.isspecificuser = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"isspecificuser"));
            this.username = XMLHandler.getTagValue((Node)entrynode, (String)"username");
        }
        catch (Exception e) {
            throw new KettleXMLException(Messages.getString("JobEntryConnectedToRepository.Meta.UnableToLoadFromXML"), (Throwable)e);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.isspecificrep = rep.getJobEntryAttributeBoolean(id_jobentry, "isspecificrep");
            this.repname = rep.getJobEntryAttributeString(id_jobentry, "repname");
            this.isspecificuser = rep.getJobEntryAttributeBoolean(id_jobentry, "isspecificuser");
            this.username = rep.getJobEntryAttributeString(id_jobentry, "username");
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("JobEntryConnectedToRepository.Meta.UnableToLoadFromRep") + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getID(), "isspecificrep", this.isspecificrep);
            rep.saveJobEntryAttribute(id_job, this.getID(), "repname", this.repname);
            rep.saveJobEntryAttribute(id_job, this.getID(), "isspecificuser", this.isspecificuser);
            rep.saveJobEntryAttribute(id_job, this.getID(), "username", this.username);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("JobEntryConnectedToRepository.Meta.UnableToSaveToRep") + id_job, (Throwable)dbe);
        }
    }

    @Override
    public Result execute(Result previousResult, int nr, Repository rep, Job parentJob) {
        Result result = previousResult;
        result.setNrErrors(1L);
        result.setResult(false);
        LogWriter log = LogWriter.getInstance();
        if (rep == null) {
            log.logError(this.toString(), Messages.getString("JobEntryConnectedToRepository.Log.NotConnected"), new Object[0]);
            return result;
        }
        if (this.isspecificrep) {
            if (Const.isEmpty((String)this.repname)) {
                log.logError(this.toString(), Messages.getString("JobEntryConnectedToRepository.Error.NoRep"), new Object[0]);
                return result;
            }
            String Reponame = this.environmentSubstitute(this.repname);
            if (!Reponame.equals(rep.getName())) {
                log.logError(this.toString(), Messages.getString("JobEntryConnectedToRepository.Error.DiffRep", rep.getName(), Reponame), new Object[0]);
                return result;
            }
        }
        if (this.isspecificuser) {
            if (Const.isEmpty((String)this.username)) {
                log.logError(this.toString(), Messages.getString("JobEntryConnectedToRepository.Error.NoUser"), new Object[0]);
                return result;
            }
            String Username = this.environmentSubstitute(this.username);
            if (!Username.equals(rep.getUserInfo().getLogin())) {
                log.logError(this.toString(), Messages.getString("JobEntryConnectedToRepository.Error.DiffUser", rep.getUserInfo().getLogin(), Username), new Object[0]);
                return result;
            }
        }
        if (log.isDetailed()) {
            log.logDetailed(this.toString(), Messages.getString("JobEntryConnectedToRepository.Log.Connected", rep.getName(), rep.getUserInfo().getLogin()), new Object[0]);
        }
        result.setResult(true);
        result.setNrErrors(0L);
        return result;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public boolean isUnconditional() {
        return false;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
    }
}

