/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.delay;

import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.delay.Messages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.Repository;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryDelay
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static String DEFAULT_MAXIMUM_TIMEOUT = "0";
    private String maximumTimeout;
    public int scaleTime;

    public JobEntryDelay(String n) {
        super(n, "");
        this.setID(-1L);
        this.setJobEntryType(JobEntryType.DELAY);
    }

    public JobEntryDelay() {
        this("");
    }

    public JobEntryDelay(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public Object clone() {
        JobEntryDelay je = (JobEntryDelay)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(200);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"maximumTimeout", (String)this.maximumTimeout));
        retval.append("      ").append(XMLHandler.addTagValue((String)"scaletime", (int)this.scaleTime));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.maximumTimeout = XMLHandler.getTagValue((Node)entrynode, (String)"maximumTimeout");
            this.scaleTime = Integer.parseInt(XMLHandler.getTagValue((Node)entrynode, (String)"scaletime"));
        }
        catch (Exception e) {
            throw new KettleXMLException(Messages.getString("JobEntryDelay.UnableToLoadFromXml.Label"), (Throwable)e);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.maximumTimeout = rep.getJobEntryAttributeString(id_jobentry, "maximumTimeout");
            this.scaleTime = (int)rep.getJobEntryAttributeInteger(id_jobentry, "scaletime");
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("JobEntryDelay.UnableToLoadFromRepo.Label") + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getID(), "maximumTimeout", this.maximumTimeout);
            rep.saveJobEntryAttribute(id_job, this.getID(), "scaletime", this.scaleTime);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("JobEntryDelay.UnableToSaveToRepo.Label") + id_job, (Throwable)dbe);
        }
    }

    @Override
    public Result execute(Result previousResult, int nr, Repository rep, Job parentJob) {
        String Waitscale;
        int Multiple;
        LogWriter log = LogWriter.getInstance();
        Result result = previousResult;
        result.setResult(false);
        if (this.scaleTime == 0) {
            Multiple = 1000;
            Waitscale = Messages.getString("JobEntryDelay.SScaleTime.Label");
        } else if (this.scaleTime == 1) {
            Multiple = 60000;
            Waitscale = Messages.getString("JobEntryDelay.MnScaleTime.Label");
        } else {
            Multiple = 3600000;
            Waitscale = Messages.getString("JobEntryDelay.HrScaleTime.Label");
        }
        try {
            long timeStart = System.currentTimeMillis() / (long)Multiple;
            long iMaximumTimeout = Const.toInt((String)this.getrealMaximumTimeout(), (int)Const.toInt((String)DEFAULT_MAXIMUM_TIMEOUT, (int)0));
            if (log.isDetailed()) {
                log.logDetailed(this.toString(), Messages.getString("JobEntryDelay.LetsWaitFor.Label", String.valueOf(iMaximumTimeout), String.valueOf(Waitscale)), new Object[0]);
            }
            boolean continueLoop = true;
            if (iMaximumTimeout < 0L) {
                iMaximumTimeout = Const.toInt((String)DEFAULT_MAXIMUM_TIMEOUT, (int)0);
                log.logBasic(this.toString(), Messages.getString("JobEntryDelay.MaximumTimeReset.Label", String.valueOf(iMaximumTimeout), String.valueOf(Waitscale)), new Object[0]);
            }
            while (continueLoop && !parentJob.isStopped()) {
                long now = System.currentTimeMillis() / (long)Multiple;
                if (iMaximumTimeout > 0L && now >= timeStart + iMaximumTimeout) {
                    if (log.isDetailed()) {
                        log.logDetailed(this.toString(), Messages.getString("JobEntryDelay.WaitTimeIsElapsed.Label"), new Object[0]);
                    }
                    continueLoop = false;
                    result.setResult(true);
                    continue;
                }
                Thread.sleep(100L);
            }
        }
        catch (Exception e) {
            result.setResult(false);
            log.logError(this.toString(), "Error  : " + e.getMessage(), new Object[0]);
        }
        return result;
    }

    @Override
    public boolean resetErrorsBeforeExecution() {
        return false;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public boolean isUnconditional() {
        return false;
    }

    public String getMaximumTimeout() {
        return this.maximumTimeout;
    }

    public String getrealMaximumTimeout() {
        return this.environmentSubstitute(this.getMaximumTimeout());
    }

    public void setMaximumTimeout(String s) {
        this.maximumTimeout = s;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        JobEntryValidatorUtils.andValidator().validate(this, "maximumTimeout", remarks, AndValidator.putValidators(JobEntryValidatorUtils.longValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "scaleTime", remarks, AndValidator.putValidators(JobEntryValidatorUtils.integerValidator()));
    }

    public int getScaleTime() {
        return this.scaleTime;
    }

    public void setScaleTime(int scaleTime) {
        this.scaleTime = scaleTime;
    }
}

