/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.movefiles;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs.AllFileSelector;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelectInfo;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileType;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.movefiles.Messages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.Repository;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryMoveFiles
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    public boolean move_empty_folders;
    public boolean arg_from_previous;
    public boolean include_subfolders;
    public boolean add_result_filesname;
    public boolean destination_is_a_file;
    public boolean create_destination_folder;
    public String[] source_filefolder;
    public String[] destination_filefolder;
    public String[] wildcard;
    private String nr_errors_less_than;
    private String success_condition;
    public String SUCCESS_IF_AT_LEAST_X_FILES_UN_ZIPPED = "success_when_at_least";
    public String SUCCESS_IF_ERRORS_LESS = "success_if_errors_less";
    public String SUCCESS_IF_NO_ERRORS = "success_if_no_errors";
    private boolean add_date;
    private boolean add_time;
    private boolean SpecifyFormat;
    private String date_time_format;
    private boolean AddDateBeforeExtension;
    private boolean DoNotKeepFolderStructure;
    private String iffileexists;
    private String destinationFolder;
    private String ifmovedfileexists;
    private String moved_date_time_format;
    private boolean AddMovedDateBeforeExtension;
    private boolean add_moved_date;
    private boolean add_moved_time;
    private boolean SpecifyMoveFormat;
    public boolean create_move_to_folder;
    public boolean simulate;
    int NrErrors = 0;
    int NrSuccess = 0;
    boolean successConditionBroken = false;
    boolean successConditionBrokenExit = false;
    int limitFiles = 0;

    public JobEntryMoveFiles(String n) {
        super(n, "");
        this.simulate = false;
        this.create_move_to_folder = false;
        this.SpecifyMoveFormat = false;
        this.add_moved_date = false;
        this.add_moved_time = false;
        this.AddMovedDateBeforeExtension = false;
        this.moved_date_time_format = null;
        this.ifmovedfileexists = "do_nothing";
        this.destinationFolder = null;
        this.DoNotKeepFolderStructure = false;
        this.move_empty_folders = true;
        this.arg_from_previous = false;
        this.source_filefolder = null;
        this.destination_filefolder = null;
        this.wildcard = null;
        this.include_subfolders = false;
        this.add_result_filesname = false;
        this.destination_is_a_file = false;
        this.create_destination_folder = false;
        this.nr_errors_less_than = "10";
        this.success_condition = this.SUCCESS_IF_NO_ERRORS;
        this.add_date = false;
        this.add_time = false;
        this.SpecifyFormat = false;
        this.date_time_format = null;
        this.AddDateBeforeExtension = false;
        this.iffileexists = "do_nothing";
        this.setID(-1L);
        this.setJobEntryType(JobEntryType.MOVE_FILES);
    }

    public JobEntryMoveFiles() {
        this("");
    }

    public JobEntryMoveFiles(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public Object clone() {
        JobEntryMoveFiles je = (JobEntryMoveFiles)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"move_empty_folders", (boolean)this.move_empty_folders));
        retval.append("      ").append(XMLHandler.addTagValue((String)"arg_from_previous", (boolean)this.arg_from_previous));
        retval.append("      ").append(XMLHandler.addTagValue((String)"include_subfolders", (boolean)this.include_subfolders));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_result_filesname", (boolean)this.add_result_filesname));
        retval.append("      ").append(XMLHandler.addTagValue((String)"destination_is_a_file", (boolean)this.destination_is_a_file));
        retval.append("      ").append(XMLHandler.addTagValue((String)"create_destination_folder", (boolean)this.create_destination_folder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_date", (boolean)this.add_date));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_time", (boolean)this.add_time));
        retval.append("      ").append(XMLHandler.addTagValue((String)"SpecifyFormat", (boolean)this.SpecifyFormat));
        retval.append("      ").append(XMLHandler.addTagValue((String)"date_time_format", (String)this.date_time_format));
        retval.append("      ").append(XMLHandler.addTagValue((String)"nr_errors_less_than", (String)this.nr_errors_less_than));
        retval.append("      ").append(XMLHandler.addTagValue((String)"success_condition", (String)this.success_condition));
        retval.append("      ").append(XMLHandler.addTagValue((String)"AddDateBeforeExtension", (boolean)this.AddDateBeforeExtension));
        retval.append("      ").append(XMLHandler.addTagValue((String)"DoNotKeepFolderStructure", (boolean)this.DoNotKeepFolderStructure));
        retval.append("      ").append(XMLHandler.addTagValue((String)"iffileexists", (String)this.iffileexists));
        retval.append("      ").append(XMLHandler.addTagValue((String)"destinationFolder", (String)this.destinationFolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"ifmovedfileexists", (String)this.ifmovedfileexists));
        retval.append("      ").append(XMLHandler.addTagValue((String)"moved_date_time_format", (String)this.moved_date_time_format));
        retval.append("      ").append(XMLHandler.addTagValue((String)"create_move_to_folder", (boolean)this.create_move_to_folder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_moved_date", (boolean)this.add_moved_date));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_moved_time", (boolean)this.add_moved_time));
        retval.append("      ").append(XMLHandler.addTagValue((String)"SpecifyMoveFormat", (boolean)this.SpecifyMoveFormat));
        retval.append("      ").append(XMLHandler.addTagValue((String)"AddMovedDateBeforeExtension", (boolean)this.AddMovedDateBeforeExtension));
        retval.append("      ").append(XMLHandler.addTagValue((String)"simulate", (boolean)this.simulate));
        retval.append("      <fields>").append(Const.CR);
        if (this.source_filefolder != null) {
            for (int i = 0; i < this.source_filefolder.length; ++i) {
                retval.append("        <field>").append(Const.CR);
                retval.append("          ").append(XMLHandler.addTagValue((String)"source_filefolder", (String)this.source_filefolder[i]));
                retval.append("          ").append(XMLHandler.addTagValue((String)"destination_filefolder", (String)this.destination_filefolder[i]));
                retval.append("          ").append(XMLHandler.addTagValue((String)"wildcard", (String)this.wildcard[i]));
                retval.append("        </field>").append(Const.CR);
            }
        }
        retval.append("      </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.move_empty_folders = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"move_empty_folders"));
            this.arg_from_previous = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"arg_from_previous"));
            this.include_subfolders = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"include_subfolders"));
            this.add_result_filesname = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_result_filesname"));
            this.destination_is_a_file = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"destination_is_a_file"));
            this.create_destination_folder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"create_destination_folder"));
            this.add_date = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_date"));
            this.add_time = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_time"));
            this.SpecifyFormat = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"SpecifyFormat"));
            this.AddDateBeforeExtension = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"AddDateBeforeExtension"));
            this.DoNotKeepFolderStructure = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"DoNotKeepFolderStructure"));
            this.date_time_format = XMLHandler.getTagValue((Node)entrynode, (String)"date_time_format");
            this.nr_errors_less_than = XMLHandler.getTagValue((Node)entrynode, (String)"nr_errors_less_than");
            this.success_condition = XMLHandler.getTagValue((Node)entrynode, (String)"success_condition");
            this.iffileexists = XMLHandler.getTagValue((Node)entrynode, (String)"iffileexists");
            this.destinationFolder = XMLHandler.getTagValue((Node)entrynode, (String)"destinationFolder");
            this.ifmovedfileexists = XMLHandler.getTagValue((Node)entrynode, (String)"ifmovedfileexists");
            this.moved_date_time_format = XMLHandler.getTagValue((Node)entrynode, (String)"moved_date_time_format");
            this.AddMovedDateBeforeExtension = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"AddMovedDateBeforeExtension"));
            this.create_move_to_folder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"create_move_to_folder"));
            this.add_moved_date = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_moved_date"));
            this.add_moved_time = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_moved_time"));
            this.SpecifyMoveFormat = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"SpecifyMoveFormat"));
            this.simulate = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"simulate"));
            Node fields = XMLHandler.getSubNode((Node)entrynode, (String)"fields");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.source_filefolder = new String[nrFields];
            this.destination_filefolder = new String[nrFields];
            this.wildcard = new String[nrFields];
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.source_filefolder[i] = XMLHandler.getTagValue((Node)fnode, (String)"source_filefolder");
                this.destination_filefolder[i] = XMLHandler.getTagValue((Node)fnode, (String)"destination_filefolder");
                this.wildcard[i] = XMLHandler.getTagValue((Node)fnode, (String)"wildcard");
            }
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(Messages.getString("JobMoveFiles.Error.Exception.UnableLoadXML"), (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.move_empty_folders = rep.getJobEntryAttributeBoolean(id_jobentry, "move_empty_folders");
            this.arg_from_previous = rep.getJobEntryAttributeBoolean(id_jobentry, "arg_from_previous");
            this.include_subfolders = rep.getJobEntryAttributeBoolean(id_jobentry, "include_subfolders");
            this.add_result_filesname = rep.getJobEntryAttributeBoolean(id_jobentry, "add_result_filesname");
            this.destination_is_a_file = rep.getJobEntryAttributeBoolean(id_jobentry, "destination_is_a_file");
            this.create_destination_folder = rep.getJobEntryAttributeBoolean(id_jobentry, "create_destination_folder");
            this.nr_errors_less_than = rep.getJobEntryAttributeString(id_jobentry, "nr_errors_less_than");
            this.success_condition = rep.getJobEntryAttributeString(id_jobentry, "success_condition");
            this.add_date = rep.getJobEntryAttributeBoolean(id_jobentry, "add_date");
            this.add_time = rep.getJobEntryAttributeBoolean(id_jobentry, "add_time");
            this.SpecifyFormat = rep.getJobEntryAttributeBoolean(id_jobentry, "SpecifyFormat");
            this.date_time_format = rep.getJobEntryAttributeString(id_jobentry, "date_time_format");
            this.AddDateBeforeExtension = rep.getJobEntryAttributeBoolean(id_jobentry, "AddDateBeforeExtension");
            this.DoNotKeepFolderStructure = rep.getJobEntryAttributeBoolean(id_jobentry, "DoNotKeepFolderStructure");
            this.iffileexists = rep.getJobEntryAttributeString(id_jobentry, "iffileexists");
            this.destinationFolder = rep.getJobEntryAttributeString(id_jobentry, "destinationFolder");
            this.ifmovedfileexists = rep.getJobEntryAttributeString(id_jobentry, "ifmovedfileexists");
            this.moved_date_time_format = rep.getJobEntryAttributeString(id_jobentry, "moved_date_time_format");
            this.AddMovedDateBeforeExtension = rep.getJobEntryAttributeBoolean(id_jobentry, "AddMovedDateBeforeExtension");
            this.create_move_to_folder = rep.getJobEntryAttributeBoolean(id_jobentry, "create_move_to_folder");
            this.add_moved_date = rep.getJobEntryAttributeBoolean(id_jobentry, "add_moved_date");
            this.add_moved_time = rep.getJobEntryAttributeBoolean(id_jobentry, "add_moved_time");
            this.SpecifyMoveFormat = rep.getJobEntryAttributeBoolean(id_jobentry, "SpecifyMoveFormat");
            this.simulate = rep.getJobEntryAttributeBoolean(id_jobentry, "simulate");
            int argnr = rep.countNrJobEntryAttributes(id_jobentry, "source_filefolder");
            this.source_filefolder = new String[argnr];
            this.destination_filefolder = new String[argnr];
            this.wildcard = new String[argnr];
            for (int a = 0; a < argnr; ++a) {
                this.source_filefolder[a] = rep.getJobEntryAttributeString(id_jobentry, a, "source_filefolder");
                this.destination_filefolder[a] = rep.getJobEntryAttributeString(id_jobentry, a, "destination_filefolder");
                this.wildcard[a] = rep.getJobEntryAttributeString(id_jobentry, a, "wildcard");
            }
        }
        catch (KettleException dbe) {
            throw new KettleException(Messages.getString("JobMoveFiles.Error.Exception.UnableLoadRep") + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getID(), "move_empty_folders", this.move_empty_folders);
            rep.saveJobEntryAttribute(id_job, this.getID(), "arg_from_previous", this.arg_from_previous);
            rep.saveJobEntryAttribute(id_job, this.getID(), "include_subfolders", this.include_subfolders);
            rep.saveJobEntryAttribute(id_job, this.getID(), "destination_is_a_file", this.destination_is_a_file);
            rep.saveJobEntryAttribute(id_job, this.getID(), "create_destination_folder", this.create_destination_folder);
            rep.saveJobEntryAttribute(id_job, this.getID(), "nr_errors_less_than", this.nr_errors_less_than);
            rep.saveJobEntryAttribute(id_job, this.getID(), "success_condition", this.success_condition);
            rep.saveJobEntryAttribute(id_job, this.getID(), "add_date", this.add_date);
            rep.saveJobEntryAttribute(id_job, this.getID(), "add_time", this.add_time);
            rep.saveJobEntryAttribute(id_job, this.getID(), "SpecifyFormat", this.SpecifyFormat);
            rep.saveJobEntryAttribute(id_job, this.getID(), "date_time_format", this.date_time_format);
            rep.saveJobEntryAttribute(id_job, this.getID(), "AddDateBeforeExtension", this.AddDateBeforeExtension);
            rep.saveJobEntryAttribute(id_job, this.getID(), "DoNotKeepFolderStructure", this.DoNotKeepFolderStructure);
            rep.saveJobEntryAttribute(id_job, this.getID(), "iffileexists", this.iffileexists);
            rep.saveJobEntryAttribute(id_job, this.getID(), "destinationFolder", this.destinationFolder);
            rep.saveJobEntryAttribute(id_job, this.getID(), "ifmovedfileexists", this.ifmovedfileexists);
            rep.saveJobEntryAttribute(id_job, this.getID(), "moved_date_time_format", this.moved_date_time_format);
            rep.saveJobEntryAttribute(id_job, this.getID(), "add_moved_date", this.add_moved_date);
            rep.saveJobEntryAttribute(id_job, this.getID(), "add_moved_time", this.add_moved_time);
            rep.saveJobEntryAttribute(id_job, this.getID(), "SpecifyMoveFormat", this.SpecifyMoveFormat);
            rep.saveJobEntryAttribute(id_job, this.getID(), "create_move_to_folder", this.create_move_to_folder);
            rep.saveJobEntryAttribute(id_job, this.getID(), "AddMovedDateBeforeExtension", this.AddMovedDateBeforeExtension);
            rep.saveJobEntryAttribute(id_job, this.getID(), "simulate", this.simulate);
            if (this.source_filefolder != null) {
                for (int i = 0; i < this.source_filefolder.length; ++i) {
                    rep.saveJobEntryAttribute(id_job, this.getID(), (long)i, "source_filefolder", this.source_filefolder[i]);
                    rep.saveJobEntryAttribute(id_job, this.getID(), (long)i, "destination_filefolder", this.destination_filefolder[i]);
                    rep.saveJobEntryAttribute(id_job, this.getID(), (long)i, "wildcard", this.wildcard[i]);
                }
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("JobMoveFiles.Error.Exception.UnableSaveRep") + id_job, (Throwable)dbe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Result execute(Result previousResult, int nr, Repository rep, Job parentJob) throws KettleException {
        log = LogWriter.getInstance();
        result = previousResult;
        rows = result.getRows();
        resultRow = null;
        result.setEntryNr(1L);
        result.setResult(false);
        this.NrErrors = 0;
        this.NrSuccess = 0;
        this.successConditionBroken = false;
        this.successConditionBrokenExit = false;
        this.limitFiles = Const.toInt((String)this.environmentSubstitute(this.getNrErrorsLessThan()), (int)10);
        if (this.simulate && log.isDetailed()) {
            log.logDetailed(this.toString(), Messages.getString("JobMoveFiles.Log.SimulationOn"), new Object[0]);
        }
        if (this.include_subfolders && log.isDetailed()) {
            log.logDetailed(this.toString(), Messages.getString("JobMoveFiles.Log.IncludeSubFoldersOn"), new Object[0]);
        }
        MoveToFolder = this.environmentSubstitute(this.destinationFolder);
        vsourcefilefolder = this.source_filefolder;
        vdestinationfilefolder = this.destination_filefolder;
        vwildcard = this.wildcard;
        if (this.iffileexists.equals("move_file")) {
            block35: {
                block36: {
                    block34: {
                        if (Const.isEmpty((String)MoveToFolder)) {
                            log.logError(this.toString(), Messages.getString("JobMoveFiles.Log.Error.MoveToFolderMissing"), new Object[0]);
                            return result;
                        }
                        folder = null;
                        try {
                            try {
                                folder = KettleVFS.getFileObject((String)MoveToFolder);
                                if (!folder.exists()) {
                                    if (log.isDetailed()) {
                                        log.logDetailed(this.toString(), Messages.getString("JobMoveFiles.Log.Error.FolderMissing", MoveToFolder), new Object[0]);
                                    }
                                    if (!this.create_move_to_folder) {
                                        log.logError(this.toString(), Messages.getString("JobMoveFiles.Log.Error.FolderMissing", MoveToFolder), new Object[0]);
                                        var14_16 = result;
                                        var17_20 = null;
                                        if (folder == null) return var14_16;
                                        break block34;
                                    }
                                    folder.createFolder();
                                }
                                if (folder.getType().equals(FileType.FOLDER)) break block35;
                                log.logError(this.toString(), Messages.getString("JobMoveFiles.Log.Error.NotFolder", MoveToFolder), new Object[0]);
                                var14_17 = result;
                                break block36;
                            }
                            catch (Exception e) {
                                log.logError(this.toString(), Messages.getString("JobMoveFiles.Log.Error.GettingMoveToFolder", MoveToFolder, e.getMessage()), new Object[0]);
                                var15_30 = result;
                                var17_23 = null;
                                if (folder == null) return var15_30;
                                try {
                                    folder.close();
                                    return var15_30;
                                }
                                catch (IOException ex) {
                                    // empty catch block
                                }
                                return var15_30;
                            }
                        }
                        catch (Throwable var16_32) {
                            var17_24 = null;
                            if (folder == null) throw var16_32;
                            ** try [egrp 2[TRYBLOCK] [7 : 401->411)] { 
lbl61:
                            // 1 sources

                            folder.close();
                            throw var16_32;
lbl63:
                            // 1 sources

                            catch (IOException ex) {
                                // empty catch block
                            }
                            throw var16_32;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [7 : 401->411)] { 
lbl68:
                    // 1 sources

                    folder.close();
                    return var14_16;
lbl70:
                    // 1 sources

                    catch (IOException ex) {
                        // empty catch block
                    }
                    return var14_16;
                }
                var17_21 = null;
                if (folder == null) return var14_17;
                try {}
                catch (IOException ex) {
                    // empty catch block
                    return var14_17;
                }
                folder.close();
                return var14_17;
            }
            var17_22 = null;
            if (folder != null) {
                try {}
                catch (IOException ex) {}
                folder.close();
            }
        }
        if (this.arg_from_previous && log.isDetailed()) {
            log.logDetailed(this.toString(), Messages.getString("JobMoveFiles.Log.ArgFromPrevious.Found", (rows != null ? rows.size() : 0) + ""), new Object[0]);
        }
        if (this.arg_from_previous && rows != null) {
            for (iteration = 0; iteration < rows.size() && !parentJob.isStopped(); ++iteration) {
                if (this.successConditionBroken) {
                    if (!this.successConditionBrokenExit) {
                        log.logError(this.toString(), Messages.getString("JobMoveFiles.Error.SuccessConditionbroken", "" + this.NrErrors), new Object[0]);
                        this.successConditionBrokenExit = true;
                    }
                    result.setNrErrors((long)this.NrErrors);
                    this.displayResults(log);
                    return result;
                }
                resultRow = (RowMetaAndData)rows.get(iteration);
                vsourcefilefolder_previous = resultRow.getString(0, null);
                vdestinationfilefolder_previous = resultRow.getString(1, null);
                vwildcard_previous = resultRow.getString(2, null);
                if (!Const.isEmpty((String)vsourcefilefolder_previous) && !Const.isEmpty((String)vdestinationfilefolder_previous)) {
                    if (log.isDetailed()) {
                        log.logDetailed(this.toString(), Messages.getString("JobMoveFiles.Log.ProcessingRow", vsourcefilefolder_previous, vdestinationfilefolder_previous, vwildcard_previous), new Object[0]);
                    }
                    if (this.ProcessFileFolder(vsourcefilefolder_previous, vdestinationfilefolder_previous, vwildcard_previous, parentJob, result, MoveToFolder, log)) continue;
                    this.updateErrors();
                    continue;
                }
                if (!log.isDetailed()) continue;
                log.logDetailed(this.toString(), Messages.getString("JobMoveFiles.Log.IgnoringRow", vsourcefilefolder[iteration], vdestinationfilefolder[iteration], vwildcard[iteration]), new Object[0]);
            }
        } else if (vsourcefilefolder != null && vdestinationfilefolder != null) {
            for (i = 0; i < vsourcefilefolder.length && !parentJob.isStopped(); ++i) {
                if (this.successConditionBroken) {
                    if (!this.successConditionBrokenExit) {
                        log.logError(this.toString(), Messages.getString("JobMoveFiles.Error.SuccessConditionbroken", "" + this.NrErrors), new Object[0]);
                        this.successConditionBrokenExit = true;
                    }
                    result.setEntryNr((long)this.NrErrors);
                    this.displayResults(log);
                    return result;
                }
                if (!Const.isEmpty((String)vsourcefilefolder[i]) && !Const.isEmpty((String)vdestinationfilefolder[i])) {
                    if (log.isDetailed()) {
                        log.logDetailed(this.toString(), Messages.getString("JobMoveFiles.Log.ProcessingRow", vsourcefilefolder[i], vdestinationfilefolder[i], vwildcard[i]), new Object[0]);
                    }
                    if (this.ProcessFileFolder(vsourcefilefolder[i], vdestinationfilefolder[i], vwildcard[i], parentJob, result, MoveToFolder, log)) continue;
                    this.updateErrors();
                    continue;
                }
                if (!log.isDetailed()) continue;
                log.logDetailed(this.toString(), Messages.getString("JobMoveFiles.Log.IgnoringRow", vsourcefilefolder[i], vdestinationfilefolder[i], vwildcard[i]), new Object[0]);
            }
        }
        result.setNrErrors((long)this.NrErrors);
        result.setNrLinesWritten((long)this.NrSuccess);
        if (this.getSuccessStatus()) {
            result.setResult(true);
        }
        this.displayResults(log);
        return result;
    }

    private void displayResults(LogWriter log) {
        if (log.isDetailed()) {
            log.logDetailed(this.toString(), "=======================================", new Object[0]);
            log.logDetailed(this.toString(), Messages.getString("JobMoveFiles.Log.Info.FilesInError", "" + this.NrErrors), new Object[0]);
            log.logDetailed(this.toString(), Messages.getString("JobMoveFiles.Log.Info.FilesInSuccess", "" + this.NrSuccess), new Object[0]);
            log.logDetailed(this.toString(), "=======================================", new Object[0]);
        }
    }

    private boolean getSuccessStatus() {
        boolean retval = false;
        if (this.NrErrors == 0 && this.getSuccessCondition().equals(this.SUCCESS_IF_NO_ERRORS) || this.NrSuccess >= this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_AT_LEAST_X_FILES_UN_ZIPPED) || this.NrErrors <= this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_ERRORS_LESS)) {
            retval = true;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean ProcessFileFolder(String sourcefilefoldername, String destinationfilefoldername, String wildcard, Job parentJob, Result result, String MoveToFolder, LogWriter log) {
        entrystatus = false;
        sourcefilefolder = null;
        destinationfilefolder = null;
        movetofolderfolder = null;
        Currentfile = null;
        realSourceFilefoldername = this.environmentSubstitute(sourcefilefoldername);
        realDestinationFilefoldername = this.environmentSubstitute(destinationfilefoldername);
        realWildcard = this.environmentSubstitute(wildcard);
        try {
            block80: {
                block79: {
                    block78: {
                        block77: {
                            try {
                                System.gc();
                                sourcefilefolder = KettleVFS.getFileObject((String)realSourceFilefoldername);
                                destinationfilefolder = KettleVFS.getFileObject((String)realDestinationFilefoldername);
                                if (!Const.isEmpty((String)MoveToFolder)) {
                                    movetofolderfolder = KettleVFS.getFileObject((String)MoveToFolder);
                                }
                                if (sourcefilefolder.exists()) {
                                    if (this.CreateDestinationFolder(destinationfilefolder)) {
                                        if (sourcefilefolder.getType().equals(FileType.FOLDER) && this.destination_is_a_file) {
                                            log.logError(Messages.getString("JobMoveFiles.Log.Forbidden"), Messages.getString("JobMoveFiles.Log.CanNotMoveFolderToFile", realSourceFilefoldername, realDestinationFilefoldername), new Object[0]);
                                            this.updateErrors();
                                        } else if (destinationfilefolder.getType().equals(FileType.FOLDER) && sourcefilefolder.getType().equals(FileType.FILE)) {
                                            shortfilename = sourcefilefolder.getName().getBaseName();
                                            try {
                                                shortfilename = this.getDestinationFilename(shortfilename);
                                            }
                                            catch (Exception e) {
                                                log.logError(this.toString(), Messages.getString(Messages.getString("JobMoveFiles.Error.GettingFilename", sourcefilefolder.getName().getBaseName(), e.toString())), new Object[0]);
                                                var18_24 = entrystatus;
                                                var21_29 = null;
                                                if (sourcefilefolder != null) {
                                                    try {
                                                        sourcefilefolder.close();
                                                    }
                                                    catch (IOException ex) {
                                                        // empty catch block
                                                    }
                                                }
                                                if (destinationfilefolder != null) {
                                                    try {
                                                        destinationfilefolder.close();
                                                    }
                                                    catch (IOException ex) {
                                                        // empty catch block
                                                    }
                                                }
                                                if (Currentfile != null) {
                                                    try {
                                                        Currentfile.close();
                                                    }
                                                    catch (IOException ex) {
                                                        // empty catch block
                                                    }
                                                }
                                                if (movetofolderfolder == null) return var18_24;
                                                try {
                                                    movetofolderfolder.close();
                                                    return var18_24;
                                                }
                                                catch (IOException ex) {
                                                    // empty catch block
                                                }
                                                return var18_24;
                                            }
                                            destinationfilenamefull = KettleVFS.getFilename((FileObject)destinationfilefolder) + Const.FILE_SEPARATOR + shortfilename;
                                            destinationfile = KettleVFS.getFileObject((String)destinationfilenamefull);
                                            entrystatus = this.MoveFile(shortfilename, sourcefilefolder, destinationfile, movetofolderfolder, log, parentJob, result);
                                        } else if (sourcefilefolder.getType().equals(FileType.FILE) && this.destination_is_a_file) {
                                            destinationfile = KettleVFS.getFileObject((String)realDestinationFilefoldername);
                                            shortfilename = destinationfile.getName().getBaseName();
                                            try {
                                                shortfilename = this.getDestinationFilename(shortfilename);
                                            }
                                            catch (Exception e) {
                                                block73: {
                                                    block72: {
                                                        block71: {
                                                            log.logError(this.toString(), Messages.getString(Messages.getString("JobMoveFiles.Error.GettingFilename", sourcefilefolder.getName().getBaseName(), e.toString())), new Object[0]);
                                                            var19_41 = entrystatus;
                                                            var21_30 = null;
                                                            if (sourcefilefolder != null) {
                                                                ** try [egrp 4[TRYBLOCK] [12 : 789->799)] { 
lbl77:
                                                                // 1 sources

                                                                sourcefilefolder.close();
                                                                break block71;
lbl79:
                                                                // 1 sources

                                                                catch (IOException ex) {
                                                                    // empty catch block
                                                                }
                                                            }
                                                        }
                                                        if (destinationfilefolder != null) {
                                                            ** try [egrp 5[TRYBLOCK] [13 : 806->816)] { 
lbl84:
                                                            // 1 sources

                                                            destinationfilefolder.close();
                                                            break block72;
lbl86:
                                                            // 1 sources

                                                            catch (IOException ex) {
                                                                // empty catch block
                                                            }
                                                        }
                                                    }
                                                    if (Currentfile != null) {
                                                        ** try [egrp 6[TRYBLOCK] [14 : 823->833)] { 
lbl91:
                                                        // 1 sources

                                                        Currentfile.close();
                                                        break block73;
lbl93:
                                                        // 1 sources

                                                        catch (IOException ex) {
                                                            // empty catch block
                                                        }
                                                    }
                                                }
                                                if (movetofolderfolder == null) return var19_41;
                                                ** try [egrp 7[TRYBLOCK] [15 : 840->850)] { 
lbl98:
                                                // 1 sources

                                                movetofolderfolder.close();
                                                return var19_41;
lbl100:
                                                // 1 sources

                                                catch (IOException ex) {
                                                    // empty catch block
                                                }
                                                return var19_41;
                                            }
                                            destinationfilenamefull = KettleVFS.getFilename((FileObject)destinationfile.getParent()) + Const.FILE_SEPARATOR + shortfilename;
                                            destinationfile = KettleVFS.getFileObject((String)destinationfilenamefull);
                                            entrystatus = this.MoveFile(shortfilename, sourcefilefolder, destinationfile, movetofolderfolder, log, parentJob, result);
                                        } else {
                                            if (log.isDetailed()) {
                                                log.logDetailed(this.toString(), "  ", new Object[0]);
                                                log.logDetailed(this.toString(), Messages.getString("JobMoveFiles.Log.FetchFolder", sourcefilefolder.toString()), new Object[0]);
                                            }
                                            if ((fileObjects = sourcefilefolder.findFiles((FileSelector)new AllFileSelector(){

                                                public boolean traverseDescendents(FileSelectInfo info) {
                                                    return true;
                                                }

                                                /*
                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                 * Unable to fully structure code
                                                 * Enabled aggressive block sorting
                                                 * Enabled unnecessary exception pruning
                                                 * Enabled aggressive exception aggregation
                                                 */
                                                public boolean includeFile(FileSelectInfo info) {
                                                    block11: {
                                                        fileObject = info.getFile();
                                                        try {
                                                            try {
                                                                if (fileObject != null) break block11;
                                                                var3_3 = false;
                                                                var6_5 = null;
                                                                if (fileObject == null) return var3_3;
                                                            }
                                                            catch (Exception ex) {
                                                                var4_13 = false;
                                                                var6_7 = null;
                                                                if (fileObject == null) return var4_13;
                                                                try {
                                                                    fileObject.close();
                                                                    return var4_13;
                                                                }
                                                                catch (IOException ex) {
                                                                    // empty catch block
                                                                }
                                                                return var4_13;
                                                            }
                                                        }
                                                        catch (Throwable var5_14) {
                                                            var6_8 = null;
                                                            if (fileObject == null) throw var5_14;
                                                            ** try [egrp 2[TRYBLOCK] [5 : 48->57)] { 
lbl26:
                                                            // 1 sources

                                                            fileObject.close();
                                                            throw var5_14;
lbl28:
                                                            // 1 sources

                                                            catch (IOException ex) {
                                                                // empty catch block
                                                            }
                                                            throw var5_14;
                                                        }
                                                        try {}
                                                        catch (IOException ex) {
                                                            // empty catch block
                                                            return var3_3;
                                                        }
                                                        fileObject.close();
                                                        return var3_3;
                                                    }
                                                    var6_6 = null;
                                                    if (fileObject == null) return true;
                                                    try {}
                                                    catch (IOException ex) {}
                                                    fileObject.close();
                                                    return true;
                                                    return true;
                                                }
                                            })) != null) {
                                                for (j = 0; j < fileObjects.length && !parentJob.isStopped(); ++j) {
                                                    if (this.successConditionBroken) {
                                                        block76: {
                                                            block75: {
                                                                block74: {
                                                                    if (!this.successConditionBrokenExit) {
                                                                        log.logError(this.toString(), Messages.getString("JobMoveFiles.Error.SuccessConditionbroken", "" + this.NrErrors), new Object[0]);
                                                                        this.successConditionBrokenExit = true;
                                                                    }
                                                                    var18_28 = false;
                                                                    var21_31 = null;
                                                                    if (sourcefilefolder != null) {
                                                                        ** try [egrp 4[TRYBLOCK] [12 : 789->799)] { 
lbl121:
                                                                        // 1 sources

                                                                        sourcefilefolder.close();
                                                                        break block74;
lbl123:
                                                                        // 1 sources

                                                                        catch (IOException ex) {
                                                                            // empty catch block
                                                                        }
                                                                    }
                                                                }
                                                                if (destinationfilefolder != null) {
                                                                    ** try [egrp 5[TRYBLOCK] [13 : 806->816)] { 
lbl128:
                                                                    // 1 sources

                                                                    destinationfilefolder.close();
                                                                    break block75;
lbl130:
                                                                    // 1 sources

                                                                    catch (IOException ex) {
                                                                        // empty catch block
                                                                    }
                                                                }
                                                            }
                                                            if (Currentfile != null) {
                                                                ** try [egrp 6[TRYBLOCK] [14 : 823->833)] { 
lbl135:
                                                                // 1 sources

                                                                Currentfile.close();
                                                                break block76;
lbl137:
                                                                // 1 sources

                                                                catch (IOException ex) {
                                                                    // empty catch block
                                                                }
                                                            }
                                                        }
                                                        if (movetofolderfolder == null) return var18_28;
                                                        ** try [egrp 7[TRYBLOCK] [15 : 840->850)] { 
lbl142:
                                                        // 1 sources

                                                        movetofolderfolder.close();
                                                        return var18_28;
lbl144:
                                                        // 1 sources

                                                        catch (IOException ex) {
                                                            // empty catch block
                                                        }
                                                        return var18_28;
                                                    }
                                                    Currentfile = fileObjects[j];
                                                    if (this.MoveOneFile(Currentfile, sourcefilefolder, realDestinationFilefoldername, realWildcard, log, parentJob, result, movetofolderfolder)) continue;
                                                    this.updateErrors();
                                                }
                                            }
                                        }
                                        entrystatus = true;
                                        break block77;
                                    }
                                    log.logError(this.toString(), Messages.getString("JobMoveFiles.Error.DestinationFolderNotFound", realDestinationFilefoldername), new Object[0]);
                                    break block77;
                                }
                                log.logError(this.toString(), Messages.getString("JobMoveFiles.Error.SourceFileNotExists", realSourceFilefoldername), new Object[0]);
                            }
                            catch (Exception e) {
                                block83: {
                                    block82: {
                                        block81: {
                                            log.logError(this.toString(), Messages.getString("JobMoveFiles.Error.Exception.MoveProcess", realSourceFilefoldername.toString(), destinationfilefolder.toString(), e.getMessage()), new Object[0]);
                                            this.updateErrors();
                                            var21_33 = null;
                                            if (sourcefilefolder != null) {
                                                ** try [egrp 4[TRYBLOCK] [12 : 789->799)] { 
lbl163:
                                                // 1 sources

                                                sourcefilefolder.close();
                                                break block81;
lbl165:
                                                // 1 sources

                                                catch (IOException ex) {
                                                    // empty catch block
                                                }
                                            }
                                        }
                                        if (destinationfilefolder != null) {
                                            ** try [egrp 5[TRYBLOCK] [13 : 806->816)] { 
lbl170:
                                            // 1 sources

                                            destinationfilefolder.close();
                                            break block82;
lbl172:
                                            // 1 sources

                                            catch (IOException ex) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    if (Currentfile != null) {
                                        ** try [egrp 6[TRYBLOCK] [14 : 823->833)] { 
lbl177:
                                        // 1 sources

                                        Currentfile.close();
                                        break block83;
lbl179:
                                        // 1 sources

                                        catch (IOException ex) {
                                            // empty catch block
                                        }
                                    }
                                }
                                if (movetofolderfolder == null) return entrystatus;
                                try {}
                                catch (IOException ex) {
                                    return entrystatus;
                                }
                                movetofolderfolder.close();
                                return entrystatus;
                            }
                        }
                        var21_32 = null;
                        if (sourcefilefolder != null) {
                            ** try [egrp 4[TRYBLOCK] [12 : 789->799)] { 
lbl192:
                            // 1 sources

                            sourcefilefolder.close();
                            break block78;
lbl194:
                            // 1 sources

                            catch (IOException ex) {
                                // empty catch block
                            }
                        }
                    }
                    if (destinationfilefolder != null) {
                        ** try [egrp 5[TRYBLOCK] [13 : 806->816)] { 
lbl199:
                        // 1 sources

                        destinationfilefolder.close();
                        break block79;
lbl201:
                        // 1 sources

                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                }
                if (Currentfile != null) {
                    ** try [egrp 6[TRYBLOCK] [14 : 823->833)] { 
lbl206:
                    // 1 sources

                    Currentfile.close();
                    break block80;
lbl208:
                    // 1 sources

                    catch (IOException ex) {
                        // empty catch block
                    }
                }
            }
            if (movetofolderfolder == null) return entrystatus;
            try {}
            catch (IOException ex) {
                return entrystatus;
            }
            movetofolderfolder.close();
            return entrystatus;
        }
        catch (Throwable var20_42) {
            block86: {
                block85: {
                    block84: {
                        var21_34 = null;
                        if (sourcefilefolder != null) {
                            ** try [egrp 4[TRYBLOCK] [12 : 789->799)] { 
lbl222:
                            // 1 sources

                            sourcefilefolder.close();
                            break block84;
lbl224:
                            // 1 sources

                            catch (IOException ex) {
                                // empty catch block
                            }
                        }
                    }
                    if (destinationfilefolder != null) {
                        ** try [egrp 5[TRYBLOCK] [13 : 806->816)] { 
lbl229:
                        // 1 sources

                        destinationfilefolder.close();
                        break block85;
lbl231:
                        // 1 sources

                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                }
                if (Currentfile != null) {
                    ** try [egrp 6[TRYBLOCK] [14 : 823->833)] { 
lbl236:
                    // 1 sources

                    Currentfile.close();
                    break block86;
lbl238:
                    // 1 sources

                    catch (IOException ex) {
                        // empty catch block
                    }
                }
            }
            if (movetofolderfolder == null) throw var20_42;
            ** try [egrp 7[TRYBLOCK] [15 : 840->850)] { 
lbl243:
            // 1 sources

            movetofolderfolder.close();
            throw var20_42;
lbl245:
            // 1 sources

            catch (IOException ex) {
                // empty catch block
            }
            throw var20_42;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean MoveFile(String shortfilename, FileObject sourcefilename, FileObject destinationfilename, FileObject movetofolderfolder, LogWriter log, Job parentJob, Result result) {
        block55: {
            block52: {
                destinationfile = null;
                retval = false;
                if (!destinationfilename.exists()) {
                    if (!this.simulate) {
                        sourcefilename.moveTo(destinationfilename);
                    }
                    if (log.isDetailed()) {
                        log.logDetailed(this.toString(), Messages.getString("JobMoveFiles.Log.FileMoved", sourcefilename.getName().toString(), destinationfilename.getName().toString()), new Object[0]);
                    }
                    if (this.add_result_filesname && !this.iffileexists.equals("fail") && !this.iffileexists.equals("do_nothing")) {
                        this.addFileToResultFilenames(destinationfilename.toString(), log, result, parentJob);
                    }
                    this.updateSuccess();
                    break block52;
                }
                if (log.isDetailed()) {
                    log.logDetailed(this.toString(), Messages.getString("JobMoveFiles.Log.FileExists", destinationfilename.toString()), new Object[0]);
                }
                if (this.iffileexists.equals("overwrite_file")) {
                    if (!this.simulate) {
                        sourcefilename.moveTo(destinationfilename);
                    }
                    if (log.isDetailed()) {
                        log.logDetailed(this.toString(), Messages.getString("JobMoveFiles.Log.FileOverwrite", destinationfilename.getName().toString()), new Object[0]);
                    }
                    if (this.add_result_filesname && !this.iffileexists.equals("fail") && !this.iffileexists.equals("do_nothing")) {
                        this.addFileToResultFilenames(destinationfilename.toString(), log, result, parentJob);
                    }
                    this.updateSuccess();
                    break block52;
                }
                if (!this.iffileexists.equals("unique_name")) ** GOTO lbl53
                short_filename = shortfilename;
                try {
                    short_filename = this.getMoveDestinationFilename(short_filename, "ddMMyyyy_HHmmssSSS");
                }
                catch (Exception e) {
                    log.logError(this.toString(), Messages.getString(Messages.getString("JobMoveFiles.Error.GettingFilename", short_filename)), new Object[0]);
                    var12_16 = retval;
                    var17_19 = null;
                    if (destinationfile != null) {
                        try {
                            destinationfile.close();
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                    return var12_16;
                }
                movetofilenamefull = destinationfilename.getParent().toString() + Const.FILE_SEPARATOR + short_filename;
                destinationfile = KettleVFS.getFileObject((String)movetofilenamefull);
                if (!this.simulate) {
                    sourcefilename.moveTo(destinationfile);
                }
                if (log.isDetailed()) {
                    log.logDetailed(this.toString(), Messages.getString("JobMoveFiles.Log.FileMoved", sourcefilename.getName().toString(), destinationfile.getName().toString()), new Object[0]);
                }
                if (this.add_result_filesname && !this.iffileexists.equals("fail") && !this.iffileexists.equals("do_nothing")) {
                    this.addFileToResultFilenames(destinationfile.toString(), log, result, parentJob);
                }
                this.updateSuccess();
                break block52;
lbl53:
                // 1 sources

                if (this.iffileexists.equals("delete_file")) {
                    if (!this.simulate) {
                        destinationfilename.delete();
                    }
                    if (log.isDetailed()) {
                        log.logDetailed(this.toString(), Messages.getString("JobMoveFiles.Log.FileDeleted", destinationfilename.getName().toString()), new Object[0]);
                    }
                    break block52;
                }
                if (!this.iffileexists.equals("move_file")) ** GOTO lbl118
                short_filename = shortfilename;
                try {
                    short_filename = this.getMoveDestinationFilename(short_filename, null);
                }
                catch (Exception e) {
                    log.logError(this.toString(), Messages.getString(Messages.getString("JobMoveFiles.Error.GettingFilename", short_filename)), new Object[0]);
                    var12_17 = retval;
                    var17_20 = null;
                    if (destinationfile != null) {
                        try {
                            destinationfile.close();
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                    return var12_17;
                }
                try {
                    movetofilenamefull = movetofolderfolder.toString() + Const.FILE_SEPARATOR + short_filename;
                    destinationfile = KettleVFS.getFileObject((String)movetofilenamefull);
                    if (!destinationfile.exists()) {
                        if (!this.simulate) {
                            sourcefilename.moveTo(destinationfile);
                        }
                        if (log.isDetailed()) {
                            log.logDetailed(this.toString(), Messages.getString("JobMoveFiles.Log.FileMoved", sourcefilename.getName().toString(), destinationfile.getName().toString()), new Object[0]);
                        }
                        if (this.add_result_filesname && !this.iffileexists.equals("fail") && !this.iffileexists.equals("do_nothing")) {
                            this.addFileToResultFilenames(destinationfile.toString(), log, result, parentJob);
                        }
                    } else if (this.ifmovedfileexists.equals("overwrite_file")) {
                        if (!this.simulate) {
                            sourcefilename.moveTo(destinationfile);
                        }
                        if (log.isDetailed()) {
                            log.logDetailed(this.toString(), Messages.getString("JobMoveFiles.Log.FileOverwrite", destinationfile.getName().toString()), new Object[0]);
                        }
                        if (this.add_result_filesname && !this.iffileexists.equals("fail") && !this.iffileexists.equals("do_nothing")) {
                            this.addFileToResultFilenames(destinationfile.toString(), log, result, parentJob);
                        }
                        this.updateSuccess();
                    } else if (this.ifmovedfileexists.equals("unique_name")) {
                        daf = new SimpleDateFormat();
                        now = new Date();
                        daf.applyPattern("ddMMyyyy_HHmmssSSS");
                        dt = daf.format(now);
                        short_filename = short_filename + "_" + dt;
                        destinationfilenamefull = movetofolderfolder.toString() + Const.FILE_SEPARATOR + short_filename;
                        destinationfile = KettleVFS.getFileObject((String)destinationfilenamefull);
                        if (!this.simulate) {
                            sourcefilename.moveTo(destinationfile);
                        }
                        if (log.isDetailed()) {
                            log.logDetailed(this.toString(), Messages.getString("JobMoveFiles.Log.FileMoved", destinationfile.getName().toString()), new Object[0]);
                        }
                        if (this.add_result_filesname && !this.iffileexists.equals("fail") && !this.iffileexists.equals("do_nothing")) {
                            this.addFileToResultFilenames(destinationfile.toString(), log, result, parentJob);
                        }
                        this.updateSuccess();
                    } else if (this.ifmovedfileexists.equals("fail")) {
                        this.updateErrors();
                    }
                    break block52;
lbl118:
                    // 1 sources

                    if (!this.iffileexists.equals("fail")) break block52;
                    this.updateErrors();
                }
                catch (Throwable var16_32) {
                    var17_23 = null;
                    if (destinationfile != null) {
                        try {
                            destinationfile.close();
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                    throw var16_32;
                }
            }
            var17_21 = null;
            if (destinationfile != null) {
                try {
                    destinationfile.close();
                }
                catch (IOException ex) {}
            }
            break block55;
            {
                catch (Exception e) {
                    log.logError(this.toString(), Messages.getString("JobMoveFiles.Error.Exception.MoveProcessError", sourcefilename.toString(), destinationfilename.toString(), e.getMessage()), new Object[0]);
                    var17_22 = null;
                    if (destinationfile != null) {
                        try {
                            destinationfile.close();
                        }
                        catch (IOException ex) {}
                    }
                }
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean MoveOneFile(FileObject Currentfile, FileObject sourcefilefolder, String realDestinationFilefoldername, String realWildcard, LogWriter log, Job parentJob, Result result, FileObject movetofolderfolder) {
        block29: {
            entrystatus = false;
            file_name = null;
            if (Currentfile.toString().equals(sourcefilefolder.toString())) ** GOTO lbl45
            shortfilename = sourceshortfilename = Currentfile.getName().getBaseName();
            try {
                shortfilename = this.getDestinationFilename(sourceshortfilename);
            }
            catch (Exception e) {
                log.logError(this.toString(), Messages.getString(Messages.getString("JobMoveFiles.Error.GettingFilename", Currentfile.getName().getBaseName(), e.toString())), new Object[0]);
                var14_16 = entrystatus;
                var16_18 = null;
                if (file_name != null) {
                    try {
                        file_name.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                return var14_16;
            }
            try {
                lenCurrent = sourceshortfilename.length();
                short_filename_from_basefolder = shortfilename;
                if (!this.isDoNotKeepFolderStructure()) {
                    short_filename_from_basefolder = Currentfile.toString().substring(sourcefilefolder.toString().length(), Currentfile.toString().length());
                }
                short_filename_from_basefolder = short_filename_from_basefolder.substring(0, short_filename_from_basefolder.length() - lenCurrent) + shortfilename;
                file_name = KettleVFS.getFileObject((String)(realDestinationFilefoldername + Const.FILE_SEPARATOR + short_filename_from_basefolder));
                if (!Currentfile.getParent().toString().equals(sourcefilefolder.toString())) {
                    if (this.include_subfolders) {
                        if (Currentfile.getType() == FileType.FOLDER) {
                            if (this.include_subfolders && this.move_empty_folders && Const.isEmpty((String[])this.wildcard)) {
                                entrystatus = this.MoveFile(shortfilename, Currentfile, file_name, movetofolderfolder, log, parentJob, result);
                            }
                        } else if (this.GetFileWildcard(sourceshortfilename, realWildcard)) {
                            entrystatus = this.MoveFile(shortfilename, Currentfile, file_name, movetofolderfolder, log, parentJob, result);
                        }
                    }
                } else if (Currentfile.getType() == FileType.FOLDER) {
                    if (this.include_subfolders && this.move_empty_folders && Const.isEmpty((String[])this.wildcard)) {
                        entrystatus = this.MoveFile(shortfilename, Currentfile, file_name, movetofolderfolder, log, parentJob, result);
                    }
                } else if (this.GetFileWildcard(sourceshortfilename, realWildcard)) {
                    entrystatus = this.MoveFile(shortfilename, Currentfile, file_name, movetofolderfolder, log, parentJob, result);
                }
lbl45:
                // 7 sources

                entrystatus = true;
                var16_19 = null;
                ** if (file_name == null) goto lbl-1000
            }
            catch (Throwable var15_26) {
                var16_21 = null;
                if (file_name != null) {
                    try {
                        file_name.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                throw var15_26;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    file_name.close();
                }
                catch (IOException ex) {}
            }
lbl-1000:
            // 2 sources

            {
                break block29;
                catch (Exception e) {
                    log.logError(this.toString(), Messages.getString("JobMoveFiles.Log.Error", e.toString()), new Object[0]);
                    var16_20 = null;
                    if (file_name != null) {
                        try {
                            file_name.close();
                        }
                        catch (IOException ex) {}
                    }
                }
            }
        }
        return entrystatus;
    }

    private void updateErrors() {
        ++this.NrErrors;
        if (this.checkIfSuccessConditionBroken()) {
            this.successConditionBroken = true;
        }
    }

    private boolean checkIfSuccessConditionBroken() {
        boolean retval = false;
        if (this.NrErrors > 0 && this.getSuccessCondition().equals(this.SUCCESS_IF_NO_ERRORS) || this.NrErrors >= this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_ERRORS_LESS)) {
            retval = true;
        }
        return retval;
    }

    private void updateSuccess() {
        ++this.NrSuccess;
    }

    private void addFileToResultFilenames(String fileaddentry, LogWriter log, Result result, Job parentJob) {
        try {
            ResultFile resultFile = new ResultFile(0, KettleVFS.getFileObject((String)fileaddentry), parentJob.getJobname(), this.toString());
            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
            if (log.isDebug()) {
                log.logDebug(this.toString(), " ------ ", new Object[0]);
                log.logDebug(this.toString(), Messages.getString("JobMoveFiles.Log.FileAddedToResultFilesName", fileaddentry), new Object[0]);
            }
        }
        catch (Exception e) {
            log.logError(Messages.getString("JobMoveFiles.Error.AddingToFilenameResult"), fileaddentry + "" + e.getMessage(), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean CreateDestinationFolder(FileObject filefolder) {
        FileObject folder;
        LogWriter log;
        block13: {
            log = LogWriter.getInstance();
            folder = null;
            folder = this.destination_is_a_file ? filefolder.getParent() : filefolder;
            if (folder.exists()) break block13;
            if (this.create_destination_folder) {
                if (log.isDetailed()) {
                    log.logDetailed(this.toString(), Messages.getString("JobMoveFiles.Log.FolderNotExist", folder.getName().toString()), new Object[0]);
                }
                folder.createFolder();
                if (log.isDetailed()) {
                    log.logDetailed(this.toString(), Messages.getString("JobMoveFiles.Log.FolderWasCreated", folder.getName().toString()), new Object[0]);
                }
                break block13;
            }
            log.logError(this.toString(), Messages.getString("JobMoveFiles.Log.FolderNotExist", folder.getName().toString()), new Object[0]);
            boolean bl = false;
            Object var6_7 = null;
            if (folder == null) return bl;
            try {
                folder.close();
                return bl;
            }
            catch (Exception ex) {
                // empty catch block
            }
            return bl;
        }
        boolean bl = true;
        Object var6_8 = null;
        if (folder == null) return bl;
        try {
            folder.close();
            return bl;
        }
        catch (Exception ex) {
            // empty catch block
        }
        return bl;
        catch (Exception e) {
            try {
                log.logError(this.toString(), Messages.getString("JobMoveFiles.Log.CanNotCreateParentFolder", folder.getName().toString()), new Object[0]);
                Object var6_9 = null;
                if (folder == null) return false;
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                if (folder == null) throw throwable;
                try {
                    folder.close();
                    throw throwable;
                }
                catch (Exception ex) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                folder.close();
                return false;
            }
            catch (Exception ex) {}
            return false;
        }
    }

    private boolean GetFileWildcard(String selectedfile, String wildcard) {
        Pattern pattern = null;
        boolean getIt = true;
        if (!Const.isEmpty((String)wildcard) && (pattern = Pattern.compile(wildcard)) != null) {
            Matcher matcher = pattern.matcher(selectedfile);
            getIt = matcher.matches();
        }
        return getIt;
    }

    private String getDestinationFilename(String shortsourcefilename) throws Exception {
        String shortfilename = shortsourcefilename;
        int lenstring = shortsourcefilename.length();
        int lastindexOfDot = shortfilename.lastIndexOf(46);
        if (lastindexOfDot == -1) {
            lastindexOfDot = lenstring;
        }
        if (this.isAddDateBeforeExtension()) {
            shortfilename = shortfilename.substring(0, lastindexOfDot);
        }
        SimpleDateFormat daf = new SimpleDateFormat();
        Date now = new Date();
        if (this.isSpecifyFormat() && !Const.isEmpty((String)this.getDateTimeFormat())) {
            daf.applyPattern(this.getDateTimeFormat());
            String dt = daf.format(now);
            shortfilename = shortfilename + dt;
        } else {
            if (this.isAddDate()) {
                daf.applyPattern("yyyyMMdd");
                String d = daf.format(now);
                shortfilename = shortfilename + "_" + d;
            }
            if (this.isAddTime()) {
                daf.applyPattern("HHmmssSSS");
                String t = daf.format(now);
                shortfilename = shortfilename + "_" + t;
            }
        }
        if (this.isAddDateBeforeExtension()) {
            shortfilename = shortfilename + shortsourcefilename.substring(lastindexOfDot, lenstring);
        }
        return shortfilename;
    }

    private String getMoveDestinationFilename(String shortsourcefilename, String DateFormat2) throws Exception {
        String shortfilename = shortsourcefilename;
        int lenstring = shortsourcefilename.length();
        int lastindexOfDot = shortfilename.lastIndexOf(46);
        if (lastindexOfDot == -1) {
            lastindexOfDot = lenstring;
        }
        if (this.isAddMovedDateBeforeExtension()) {
            shortfilename = shortfilename.substring(0, lastindexOfDot);
        }
        SimpleDateFormat daf = new SimpleDateFormat();
        Date now = new Date();
        if (DateFormat2 != null) {
            daf.applyPattern(DateFormat2);
            String dt = daf.format(now);
            shortfilename = shortfilename + dt;
        } else if (this.isSpecifyMoveFormat() && !Const.isEmpty((String)this.getMovedDateTimeFormat())) {
            daf.applyPattern(this.getMovedDateTimeFormat());
            String dt = daf.format(now);
            shortfilename = shortfilename + dt;
        } else {
            if (this.isAddMovedDate()) {
                daf.applyPattern("yyyyMMdd");
                String d = daf.format(now);
                shortfilename = shortfilename + "_" + d;
            }
            if (this.isAddMovedTime()) {
                daf.applyPattern("HHmmssSSS");
                String t = daf.format(now);
                shortfilename = shortfilename + "_" + t;
            }
        }
        if (this.isAddMovedDateBeforeExtension()) {
            shortfilename = shortfilename + shortsourcefilename.substring(lastindexOfDot, lenstring);
        }
        return shortfilename;
    }

    public void setAddDate(boolean adddate) {
        this.add_date = adddate;
    }

    public boolean isAddDate() {
        return this.add_date;
    }

    public boolean isAddMovedDate() {
        return this.add_moved_date;
    }

    public void setAddMovedDate(boolean add_moved_date) {
        this.add_moved_date = add_moved_date;
    }

    public boolean isAddMovedTime() {
        return this.add_moved_time;
    }

    public void setAddMovedTime(boolean add_moved_time) {
        this.add_moved_time = add_moved_time;
    }

    public void setIfFileExists(String iffileexists) {
        this.iffileexists = iffileexists;
    }

    public String getIfFileExists() {
        return this.iffileexists;
    }

    public void setIfMovedFileExists(String ifmovedfileexists) {
        this.ifmovedfileexists = ifmovedfileexists;
    }

    public String getIfMovedFileExists() {
        return this.ifmovedfileexists;
    }

    public void setAddTime(boolean addtime) {
        this.add_time = addtime;
    }

    public boolean isAddTime() {
        return this.add_time;
    }

    public void setAddDateBeforeExtension(boolean AddDateBeforeExtension) {
        this.AddDateBeforeExtension = AddDateBeforeExtension;
    }

    public void setAddMovedDateBeforeExtension(boolean AddMovedDateBeforeExtension) {
        this.AddMovedDateBeforeExtension = AddMovedDateBeforeExtension;
    }

    public boolean isSpecifyFormat() {
        return this.SpecifyFormat;
    }

    public void setSpecifyFormat(boolean SpecifyFormat) {
        this.SpecifyFormat = SpecifyFormat;
    }

    public void setSpecifyMoveFormat(boolean SpecifyMoveFormat) {
        this.SpecifyMoveFormat = SpecifyMoveFormat;
    }

    public boolean isSpecifyMoveFormat() {
        return this.SpecifyMoveFormat;
    }

    public String getDateTimeFormat() {
        return this.date_time_format;
    }

    public void setDateTimeFormat(String date_time_format) {
        this.date_time_format = date_time_format;
    }

    public String getMovedDateTimeFormat() {
        return this.moved_date_time_format;
    }

    public void setMovedDateTimeFormat(String moved_date_time_format) {
        this.moved_date_time_format = moved_date_time_format;
    }

    public boolean isAddDateBeforeExtension() {
        return this.AddDateBeforeExtension;
    }

    public boolean isAddMovedDateBeforeExtension() {
        return this.AddMovedDateBeforeExtension;
    }

    public boolean isDoNotKeepFolderStructure() {
        return this.DoNotKeepFolderStructure;
    }

    public void setDestinationFolder(String destinationFolder) {
        this.destinationFolder = destinationFolder;
    }

    public String getDestinationFolder() {
        return this.destinationFolder;
    }

    public void setDoNotKeepFolderStructure(boolean DoNotKeepFolderStructure) {
        this.DoNotKeepFolderStructure = DoNotKeepFolderStructure;
    }

    public void setMoveEmptyFolders(boolean move_empty_foldersin) {
        this.move_empty_folders = move_empty_foldersin;
    }

    public void setIncludeSubfolders(boolean include_subfoldersin) {
        this.include_subfolders = include_subfoldersin;
    }

    public void setAddresultfilesname(boolean add_result_filesnamein) {
        this.add_result_filesname = add_result_filesnamein;
    }

    public void setArgFromPrevious(boolean argfrompreviousin) {
        this.arg_from_previous = argfrompreviousin;
    }

    public void setDestinationIsAFile(boolean destination_is_a_file) {
        this.destination_is_a_file = destination_is_a_file;
    }

    public void setCreateDestinationFolder(boolean create_destination_folder) {
        this.create_destination_folder = create_destination_folder;
    }

    public void setCreateMoveToFolder(boolean create_move_to_folder) {
        this.create_move_to_folder = create_move_to_folder;
    }

    public void setNrErrorsLessThan(String nr_errors_less_than) {
        this.nr_errors_less_than = nr_errors_less_than;
    }

    public String getNrErrorsLessThan() {
        return this.nr_errors_less_than;
    }

    public void setSimulate(boolean simulate) {
        this.simulate = simulate;
    }

    public void setSuccessCondition(String success_condition) {
        this.success_condition = success_condition;
    }

    public String getSuccessCondition() {
        return this.success_condition;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        boolean res = JobEntryValidatorUtils.andValidator().validate(this, "arguments", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
        if (!res) {
            return;
        }
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notNullValidator(), JobEntryValidatorUtils.fileExistsValidator());
        for (int i = 0; i < this.source_filefolder.length; ++i) {
            JobEntryValidatorUtils.andValidator().validate(this, "arguments[" + i + "]", remarks, ctx);
        }
    }

    @Override
    public boolean evaluates() {
        return true;
    }
}

