/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.repository.Messages;
import org.pentaho.di.repository.PermissionMeta;
import org.pentaho.di.repository.Repository;

public class ProfileMeta {
    private long id;
    private String name;
    private String description;
    private List<PermissionMeta> permissions;

    public ProfileMeta(String name, String description) {
        this.name = name;
        this.description = description;
        this.permissions = new ArrayList<PermissionMeta>();
    }

    public ProfileMeta() {
        this.name = null;
        this.description = null;
        this.permissions = new ArrayList<PermissionMeta>();
    }

    public ProfileMeta(Repository rep, long id_profile) throws KettleException {
        block4: {
            try {
                RowMetaAndData r = rep.getProfile(id_profile);
                if (r != null) {
                    this.setID(id_profile);
                    this.name = r.getString("NAME", null);
                    this.description = r.getString("DESCRIPTION", null);
                    long[] pid = rep.getPermissionIDs(id_profile);
                    this.permissions = new ArrayList<PermissionMeta>();
                    for (int i = 0; i < pid.length; ++i) {
                        PermissionMeta pi = new PermissionMeta(rep, pid[i]);
                        if (pi.getID() <= 0L) continue;
                        this.addPermission(pi);
                    }
                    break block4;
                }
                throw new KettleException(Messages.getString("ProfileMeta.Error.NotFound", Long.toString(id_profile)));
            }
            catch (KettleDatabaseException dbe) {
                throw new KettleException(Messages.getString("ProfileMeta.Error.NotCreated", Long.toString(id_profile)), (Throwable)dbe);
            }
        }
    }

    public boolean saveRep(Repository rep) throws KettleException {
        try {
            if (this.getID() <= 0L) {
                this.setID(rep.getProfileID(this.getName()));
            }
            if (this.getID() <= 0L) {
                this.setID(rep.getNextProfileID());
                rep.insertTableRow("R_PROFILE", this.fillTableRow());
                this.saveProfilePermissions(rep);
            } else {
                rep.updateTableRow("R_PROFILE", "ID_PROFILE", this.fillTableRow());
                rep.delProfilePermissions(this.getID());
                this.saveProfilePermissions(rep);
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("ProfileMeta.Error.NotSaved", Long.toString(this.getID())), (Throwable)dbe);
        }
        return true;
    }

    public RowMetaAndData fillTableRow() {
        RowMetaAndData r = new RowMetaAndData();
        r.addValue(new ValueMeta("ID_PROFILE", 5), (Object)new Long(this.getID()));
        r.addValue(new ValueMeta("NAME", 2), (Object)this.name);
        r.addValue(new ValueMeta("DESCRIPTION", 2), (Object)this.description);
        return r;
    }

    private void saveProfilePermissions(Repository rep) throws KettleException {
        try {
            for (int i = 0; i < this.nrPermissions(); ++i) {
                PermissionMeta pi = this.getPermission(i);
                long id_permission = rep.getPermissionID(pi.getTypeDesc());
                RowMetaAndData pr = new RowMetaAndData();
                pr.addValue(new ValueMeta("ID_PROFILE", 5), (Object)new Long(this.getID()));
                pr.addValue(new ValueMeta("ID_PERMISSION", 5), (Object)new Long(id_permission));
                rep.insertTableRow("R_PROFILE_PERMISSION", pr);
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("ProfileMeta.Error.PermissionNotSaved", Long.toString(this.getID())), (Throwable)dbe);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void addPermission(PermissionMeta permission) {
        this.permissions.add(permission);
    }

    public void addPermission(int p, PermissionMeta permission) {
        this.permissions.add(p, permission);
    }

    public PermissionMeta getPermission(int i) {
        return this.permissions.get(i);
    }

    public int nrPermissions() {
        if (this.permissions == null) {
            return 0;
        }
        return this.permissions.size();
    }

    public void removePermission(int i) {
        this.permissions.remove(i);
    }

    public void removeAllPermissions() {
        this.permissions.clear();
    }

    public int indexOfPermission(PermissionMeta permission) {
        return this.permissions.indexOf(permission);
    }

    public long getID() {
        return this.id;
    }

    public void setID(long id) {
        this.id = id;
    }

    public boolean isReadonly() {
        for (int i = 0; i < this.nrPermissions(); ++i) {
            PermissionMeta pi = this.getPermission(i);
            if (!pi.isReadonly()) continue;
            return true;
        }
        return false;
    }

    public boolean isAdministrator() {
        for (int i = 0; i < this.nrPermissions(); ++i) {
            PermissionMeta pi = this.getPermission(i);
            if (!pi.isAdministrator()) continue;
            return true;
        }
        return false;
    }

    public boolean useTransformations() {
        for (int i = 0; i < this.nrPermissions(); ++i) {
            PermissionMeta pi = this.getPermission(i);
            if (!pi.useTransformations()) continue;
            return true;
        }
        return false;
    }

    public boolean useJobs() {
        for (int i = 0; i < this.nrPermissions(); ++i) {
            PermissionMeta pi = this.getPermission(i);
            if (!pi.useJobs()) continue;
            return true;
        }
        return false;
    }

    public boolean useSchemas() {
        for (int i = 0; i < this.nrPermissions(); ++i) {
            PermissionMeta pi = this.getPermission(i);
            if (!pi.useSchemas()) continue;
            return true;
        }
        return false;
    }
}

