/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.shared;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.cluster.ClusterSchema;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.partition.PartitionSchema;
import org.pentaho.di.shared.Messages;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedObjects {
    private static final String XML_TAG = "sharedobjects";
    private String filename;
    private Map<SharedEntry, SharedObjectInterface> objectsMap;

    public SharedObjects(String sharedObjectsFile) throws KettleXMLException {
        try {
            this.filename = SharedObjects.createFilename(sharedObjectsFile);
            this.objectsMap = new Hashtable<SharedEntry, SharedObjectInterface>();
            FileObject file = KettleVFS.getFileObject((String)this.filename);
            if (file.exists()) {
                LogWriter.getInstance().logDetailed(Messages.getString("SharedOjects.ReadingFile.Title"), Messages.getString("SharedOjects.ReadingFile.Message", "" + file), new Object[0]);
                Document document = XMLHandler.loadXMLFile((FileObject)file);
                Node sharedObjectsNode = XMLHandler.getSubNode((Node)document, (String)XML_TAG);
                if (sharedObjectsNode != null) {
                    Object isShared;
                    String nodeName;
                    Node node;
                    int i;
                    ArrayList<SlaveServer> privateSlaveServers = new ArrayList<SlaveServer>();
                    ArrayList<DatabaseMeta> privateDatabases = new ArrayList<DatabaseMeta>();
                    NodeList childNodes = sharedObjectsNode.getChildNodes();
                    for (i = 0; i < childNodes.getLength(); ++i) {
                        node = childNodes.item(i);
                        nodeName = node.getNodeName();
                        isShared = null;
                        if (nodeName.equals("connection")) {
                            DatabaseMeta sharedDatabaseMeta;
                            isShared = sharedDatabaseMeta = new DatabaseMeta(node);
                            privateDatabases.add(sharedDatabaseMeta);
                        } else if (nodeName.equals("slaveserver")) {
                            SlaveServer sharedSlaveServer = new SlaveServer(node);
                            isShared = sharedSlaveServer;
                            privateSlaveServers.add(sharedSlaveServer);
                        }
                        if (isShared == null) continue;
                        isShared.setShared(true);
                        this.storeObject((SharedObjectInterface)isShared);
                    }
                    for (i = 0; i < childNodes.getLength(); ++i) {
                        node = childNodes.item(i);
                        nodeName = node.getNodeName();
                        isShared = null;
                        if (nodeName.equals("step")) {
                            StepMeta stepMeta = new StepMeta(node, privateDatabases, null);
                            stepMeta.setDraw(false);
                            isShared = stepMeta;
                        } else if (nodeName.equals("partitionschema")) {
                            isShared = new PartitionSchema(node);
                        } else if (nodeName.equals("clusterschema")) {
                            isShared = new ClusterSchema(node, privateSlaveServers);
                        }
                        if (isShared == null) continue;
                        isShared.setShared(true);
                        this.storeObject((SharedObjectInterface)isShared);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(Messages.getString("SharedOjects.Readingfile.UnexpectedError", sharedObjectsFile), (Throwable)e);
        }
    }

    public static final String createFilename(String sharedObjectsFile) {
        String filename;
        if (Const.isEmpty((String)sharedObjectsFile)) {
            filename = Variables.getADefaultVariableSpace().getVariable("KETTLE_SHARED_OBJECTS");
            if (Const.isEmpty((String)filename)) {
                filename = Const.getSharedObjectsFile();
            }
        } else {
            filename = sharedObjectsFile;
        }
        return filename;
    }

    public SharedObjects() throws KettleXMLException {
        this(null);
    }

    public Map<SharedEntry, SharedObjectInterface> getObjectsMap() {
        return this.objectsMap;
    }

    public void setObjectsMap(Map<SharedEntry, SharedObjectInterface> objects) {
        this.objectsMap = objects;
    }

    public void storeObject(SharedObjectInterface sharedObject) {
        SharedEntry key = new SharedEntry(sharedObject.getClass().getName(), sharedObject.getName());
        this.objectsMap.put(key, sharedObject);
    }

    public void saveToFile() throws IOException, KettleException {
        OutputStream outputStream = KettleVFS.getOutputStream((String)this.filename, (boolean)false);
        PrintStream out = new PrintStream(outputStream);
        out.print(XMLHandler.getXMLHeader((String)"UTF-8"));
        out.println("<sharedobjects>");
        Collection<SharedObjectInterface> collection = this.objectsMap.values();
        for (SharedObjectInterface sharedObject : collection) {
            out.println(sharedObject.getXML());
        }
        out.println("</sharedobjects>");
        out.flush();
        out.close();
        outputStream.close();
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    private class SharedEntry {
        public String className;
        public String objectName;

        public SharedEntry(String className, String objectName) {
            this.className = className;
            this.objectName = objectName;
        }

        public boolean equals(Object obj) {
            SharedEntry sharedEntry = (SharedEntry)obj;
            return this.className.equals(sharedEntry.className) && this.objectName.equals(this.objectName);
        }

        public int hashCode() {
            return this.className.hashCode() ^ this.objectName.hashCode();
        }
    }
}

