/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import java.io.IOException;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.trans.TransExecutionConfiguration;
import org.pentaho.di.trans.TransMeta;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class TransConfiguration {
    public static final String XML_TAG = "transformation_configuration";
    private TransMeta transMeta;
    private TransExecutionConfiguration transExecutionConfiguration;

    public TransConfiguration(TransMeta transMeta, TransExecutionConfiguration transExecutionConfiguration) {
        this.transMeta = transMeta;
        this.transExecutionConfiguration = transExecutionConfiguration;
    }

    public String getXML() throws IOException, KettleException {
        StringBuilder xml = new StringBuilder(200);
        xml.append("<transformation_configuration>").append(Const.CR);
        xml.append(this.transMeta.getXML());
        xml.append(this.transExecutionConfiguration.getXML());
        xml.append("</transformation_configuration>").append(Const.CR);
        return xml.toString();
    }

    public TransConfiguration(Node configNode) throws KettleException {
        Node trecNode = XMLHandler.getSubNode((Node)configNode, (String)"transformation_execution_configuration");
        this.transExecutionConfiguration = new TransExecutionConfiguration(trecNode);
        Node transNode = XMLHandler.getSubNode((Node)configNode, (String)"transformation");
        this.transMeta = new TransMeta(transNode, this.transExecutionConfiguration.getRepository());
    }

    public static final TransConfiguration fromXML(String xml) throws KettleException {
        Document document = XMLHandler.loadXMLString((String)xml);
        Node configNode = XMLHandler.getSubNode((Node)document, (String)XML_TAG);
        return new TransConfiguration(configNode);
    }

    public TransExecutionConfiguration getTransExecutionConfiguration() {
        return this.transExecutionConfiguration;
    }

    public void setTransExecutionConfiguration(TransExecutionConfiguration transExecutionConfiguration) {
        this.transExecutionConfiguration = transExecutionConfiguration;
    }

    public TransMeta getTransMeta() {
        return this.transMeta;
    }

    public void setTransMeta(TransMeta transMeta) {
        this.transMeta = transMeta;
    }
}

