/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.cubeinput;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.zip.GZIPInputStream;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleEOFException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.cubeinput.CubeInputData;
import org.pentaho.di.trans.steps.cubeinput.CubeInputMeta;
import org.pentaho.di.trans.steps.cubeinput.Messages;

public class CubeInput
extends BaseStep
implements StepInterface {
    private CubeInputMeta meta;
    private CubeInputData data;

    public CubeInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (CubeInputMeta)smi;
        this.data = (CubeInputData)sdi;
        try {
            Object[] r = this.data.meta.readData(this.data.dis);
            this.putRow(this.data.meta, r);
            this.incrementLinesInput();
            if (this.meta.getRowLimit() > 0 && this.getLinesInput() >= (long)this.meta.getRowLimit()) {
                this.setOutputDone();
                return false;
            }
        }
        catch (KettleEOFException eof) {
            this.setOutputDone();
            return false;
        }
        catch (SocketTimeoutException e) {
            throw new KettleException((Throwable)e);
        }
        if (this.checkFeedback(this.getLinesInput()) && this.log.isBasic()) {
            this.logBasic(Messages.getString("CubeInput.Log.LineNumber") + this.getLinesInput());
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (CubeInputMeta)smi;
        this.data = (CubeInputData)sdi;
        if (super.init(smi, sdi)) {
            try {
                String filename = this.environmentSubstitute(this.meta.getFilename());
                if (this.meta.isAddResultFile()) {
                    ResultFile resultFile = new ResultFile(0, KettleVFS.getFileObject((String)filename), this.getTransMeta().getName(), this.toString());
                    resultFile.setComment("File was read by a Cube Input step");
                    this.addResultFile(resultFile);
                }
                this.data.fis = KettleVFS.getInputStream((String)filename);
                this.data.zip = new GZIPInputStream(this.data.fis);
                this.data.dis = new DataInputStream(this.data.zip);
                try {
                    this.data.meta = new RowMeta(this.data.dis);
                    return true;
                }
                catch (KettleFileException kfe) {
                    this.logError(Messages.getString("CubeInput.Log.UnableToReadMetadata") + kfe.getMessage());
                    return false;
                }
            }
            catch (IOException e) {
                this.logError(Messages.getString("CubeInput.Log.ErrorReadingFromDataCube") + e.toString());
            }
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (CubeInputMeta)smi;
        this.data = (CubeInputData)sdi;
        try {
            if (this.data.dis != null) {
                this.data.dis.close();
                this.data.dis = null;
            }
            if (this.data.zip != null) {
                this.data.zip.close();
                this.data.zip = null;
            }
            if (this.data.fis != null) {
                this.data.fis.close();
                this.data.fis = null;
            }
        }
        catch (IOException e) {
            this.logError(Messages.getString("CubeInput.Log.ErrorClosingCube") + e.toString());
            this.setErrors(1L);
            this.stopAll();
        }
        super.dispose(smi, sdi);
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

