/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.filestoresult;

import java.io.IOException;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.filestoresult.FilesToResultData;
import org.pentaho.di.trans.steps.filestoresult.FilesToResultMeta;
import org.pentaho.di.trans.steps.filestoresult.Messages;

public class FilesToResult
extends BaseStep
implements StepInterface {
    private FilesToResultMeta meta;
    private FilesToResultData data;

    public FilesToResult(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (FilesToResultMeta)smi;
        this.data = (FilesToResultData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            for (ResultFile resultFile : this.data.filenames) {
                this.addResultFile(resultFile);
            }
            this.logBasic(Messages.getString("FilesToResult.Log.AddedNrOfFiles", String.valueOf(this.data.filenames.size())));
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.filenameIndex = this.getInputRowMeta().indexOfValue(this.meta.getFilenameField());
            if (this.data.filenameIndex < 0) {
                this.logError(Messages.getString("FilesToResult.Log.CouldNotFindField", this.meta.getFilenameField()));
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
        }
        String filename = (String)r[this.data.filenameIndex];
        try {
            ResultFile resultFile = new ResultFile(this.meta.getFileType(), KettleVFS.getFileObject((String)filename), this.getTrans().getName(), this.getStepname());
            this.data.filenames.add(resultFile);
        }
        catch (IOException e) {
            throw new KettleException((Throwable)e);
        }
        this.data.outputRowMeta = this.getInputRowMeta().clone();
        this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
        this.putRow(this.data.outputRowMeta, r);
        if (this.checkFeedback(this.getLinesRead())) {
            this.logBasic(Messages.getString("FilesToResult.Log.LineNumber") + this.getLinesRead());
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (FilesToResultMeta)smi;
        this.data = (FilesToResultData)sdi;
        return super.init(smi, sdi);
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

