/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mapping;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaDataCombi;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mapping.MappingData;
import org.pentaho.di.trans.steps.mapping.MappingIODefinition;
import org.pentaho.di.trans.steps.mapping.MappingMeta;
import org.pentaho.di.trans.steps.mapping.MappingParameters;
import org.pentaho.di.trans.steps.mapping.MappingValueRename;
import org.pentaho.di.trans.steps.mapping.Messages;
import org.pentaho.di.trans.steps.mappinginput.MappingInput;
import org.pentaho.di.trans.steps.mappingoutput.MappingOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mapping
extends BaseStep
implements StepInterface {
    private MappingMeta meta;
    private MappingData data;

    public Mapping(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        try {
            this.meta = (MappingMeta)smi;
            this.data = (MappingData)sdi;
            if (!this.inputRowSets.isEmpty()) {
                MappingInput[] mappingInputs = this.data.mappingTrans.findMappingInput();
                for (RowSet rowSet : new ArrayList(this.inputRowSets)) {
                    if (mappingInputs.length == 1) {
                        this.inputRowSets.remove(rowSet);
                        mappingInputs[0].getInputRowSets().add(rowSet);
                        continue;
                    }
                    throw new KettleException("Unsupported situation detected.  To solve it, insert a dummy step.");
                }
            }
            this.data.mappingTrans.startThreads();
            this.data.mappingTrans.waitUntilFinished();
            Result result = this.data.mappingTrans.getResult();
            this.setErrors(result.getNrErrors());
            this.setLinesRead(result.getNrLinesRead());
            this.setLinesWritten(result.getNrLinesWritten());
            this.setLinesInput(result.getNrLinesInput());
            this.setLinesOutput(result.getNrLinesOutput());
            this.setLinesUpdated(result.getNrLinesUpdated());
            this.setLinesRejected(result.getNrLinesRejected());
            return false;
        }
        catch (Throwable t) {
            if (this.data.mappingTrans != null) {
                this.data.mappingTrans.stopAll();
            }
            throw new KettleException(t);
        }
    }

    private void setMappingParameters() throws KettleException {
        MappingParameters mappingParameters = this.meta.getMappingParameters();
        if (mappingParameters != null) {
            if (mappingParameters.isInheritingAllVariables()) {
                this.data.mappingTransMeta.copyVariablesFrom(this.getTransMeta());
            }
            for (int i = 0; i < mappingParameters.getVariable().length; ++i) {
                String name = mappingParameters.getVariable()[i];
                String value = this.environmentSubstitute(mappingParameters.getInputField()[i]);
                if (Const.isEmpty((String)name) || Const.isEmpty((String)value)) continue;
                this.data.mappingTransMeta.setVariable(name, value);
            }
        }
    }

    public void prepareMappingExecution() throws KettleException {
        this.data.mappingTrans = new Trans(this.data.mappingTransMeta);
        this.data.mappingTrans.setParentTrans(this.getTrans());
        this.data.mappingTrans.setSafeModeEnabled(this.getTrans().isSafeModeEnabled());
        this.data.mappingTrans.setMappingStepName(this.getStepname());
        try {
            this.data.mappingTrans.prepareExecution(this.getTransMeta().getArguments());
        }
        catch (KettleException e) {
            throw new KettleException(Messages.getString("Mapping.Exception.UnableToPrepareExecutionOfMapping"), (Throwable)e);
        }
        MappingInput[] mappingInputs = this.data.mappingTrans.findMappingInput();
        if (this.data.mappingTransMeta.getReadStep() == null && mappingInputs != null && mappingInputs.length >= 1) {
            this.data.mappingTransMeta.setReadStep(mappingInputs[0].getStepMeta());
        }
        MappingOutput[] mappingOutputs = this.data.mappingTrans.findMappingOutput();
        if (this.data.mappingTransMeta.getWriteStep() == null && mappingOutputs != null && mappingOutputs.length >= 1) {
            this.data.mappingTransMeta.setWriteStep(mappingOutputs[0].getStepMeta());
        }
        for (MappingIODefinition inputDefinition : this.meta.getInputMappings()) {
            StepInterface[] sourceSteps;
            if (!Const.isEmpty((String)inputDefinition.getInputStepname())) {
                BaseStep sourceStep = this.getTrans().findRunThread(inputDefinition.getInputStepname());
                if (sourceStep == null) {
                    throw new KettleException(Messages.getString("MappingDialog.Exception.StepNameNotFound", inputDefinition.getInputStepname()));
                }
                sourceSteps = new StepInterface[]{sourceStep};
            } else {
                List<StepMeta> prevSteps = this.getTransMeta().findPreviousSteps(this.getStepMeta());
                sourceSteps = new StepInterface[prevSteps.size()];
                for (int s = 0; s < sourceSteps.length; ++s) {
                    sourceSteps[s] = this.getTrans().findRunThread(prevSteps.get(s).getName());
                }
            }
            MappingInput mappingInputTarget = null;
            MappingInput[] mappingInputSteps = this.data.mappingTrans.findMappingInput();
            if (Const.isEmpty((String)inputDefinition.getOutputStepname())) {
                if (mappingInputSteps.length == 0) {
                    throw new KettleException(Messages.getString("MappingDialog.Exception.OneMappingInputStepRequired"));
                }
                if (mappingInputSteps.length > 1) {
                    throw new KettleException(Messages.getString("MappingDialog.Exception.OnlyOneMappingInputStepAllowed", "" + mappingInputSteps.length));
                }
                mappingInputTarget = mappingInputSteps[0];
            } else {
                for (int s = 0; s < mappingInputSteps.length && mappingInputTarget == null; ++s) {
                    if (!mappingInputSteps[s].getStepname().equals(inputDefinition.getOutputStepname())) continue;
                    mappingInputTarget = mappingInputSteps[s];
                }
                if (mappingInputTarget == null) {
                    throw new KettleException(Messages.getString("MappingDialog.Exception.StepNameNotFound", inputDefinition.getOutputStepname()));
                }
            }
            if (inputDefinition.isRenamingOnOutput()) {
                Mapping.addInputRenames(this.data.inputRenameList, inputDefinition.getValueRenames());
            }
            mappingInputTarget.setConnectorSteps(sourceSteps, inputDefinition.getValueRenames(), this.getStepname());
        }
        for (MappingIODefinition outputDefinition : this.meta.getOutputMappings()) {
            StepInterface[] targetSteps;
            MappingOutput mappingOutputSource = (MappingOutput)this.data.mappingTrans.findRunThread(outputDefinition.getInputStepname());
            if (mappingOutputSource == null) {
                MappingOutput[] mappingOutputSteps = this.data.mappingTrans.findMappingOutput();
                if (mappingOutputSteps.length == 0) {
                    throw new KettleException(Messages.getString("MappingDialog.Exception.OneMappingOutputStepRequired"));
                }
                if (mappingOutputSteps.length > 1) {
                    throw new KettleException(Messages.getString("MappingDialog.Exception.OnlyOneMappingOutputStepAllowed", "" + mappingOutputSteps.length));
                }
                mappingOutputSource = mappingOutputSteps[0];
            }
            if (!Const.isEmpty((String)outputDefinition.getOutputStepname())) {
                BaseStep target = this.getTrans().findRunThread(outputDefinition.getOutputStepname());
                if (target == null) {
                    throw new KettleException(Messages.getString("MappingDialog.Exception.StepNameNotFound", outputDefinition.getOutputStepname()));
                }
                targetSteps = new StepInterface[]{target};
            } else {
                List<StepMeta> nextSteps = this.getTransMeta().findNextSteps(this.getStepMeta());
                targetSteps = new StepInterface[nextSteps.size()];
                for (int s = 0; s < targetSteps.length; ++s) {
                    targetSteps[s] = this.getTrans().findRunThread(nextSteps.get(s).getName());
                }
            }
            mappingOutputSource.setConnectorSteps(targetSteps, this.data.inputRenameList, outputDefinition.getValueRenames());
            mappingOutputSource.setDistributed(this.isDistributed());
        }
    }

    public static void addInputRenames(List<MappingValueRename> renameList, List<MappingValueRename> addRenameList) {
        for (MappingValueRename rename : addRenameList) {
            if (renameList.indexOf(rename) >= 0) continue;
            renameList.add(rename);
        }
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (MappingMeta)smi;
        this.data = (MappingData)sdi;
        if (super.init(smi, sdi)) {
            try {
                this.meta.setRepository(this.getTransMeta().getRepository());
                this.data.mappingTransMeta = MappingMeta.loadMappingMeta(this.meta.getFileName(), this.meta.getTransName(), this.meta.getDirectoryPath(), this.meta.getRepository(), this);
                if (this.data.mappingTransMeta != null) {
                    this.setMappingParameters();
                    this.prepareMappingExecution();
                    this.lookupStatusStepNumbers();
                    return true;
                }
                this.logError("No valid mapping was specified!");
                return false;
            }
            catch (Exception e) {
                this.logError("Unable to load the mapping transformation because of an error : " + e.toString());
                this.logError(Const.getStackTracker((Throwable)e));
            }
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        if (this.data.wasStarted) {
            this.data.mappingTrans.waitUntilFinished();
            try {
                this.data.mappingTrans.endProcessing("end");
            }
            catch (KettleException e) {
                this.log.logError(this.toString(), Messages.getString("Mapping.Log.UnableToLogEndOfTransformation") + e.toString(), new Object[0]);
            }
            if (this.data.mappingTrans.getErrors() > 0) {
                this.logError(Messages.getString("Mapping.Log.ErrorOccurredInSubTransformation"));
                this.setErrors(1L);
            }
        }
        super.dispose(smi, sdi);
    }

    @Override
    public void stopRunning(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) throws KettleException {
        if (this.data.mappingTrans != null) {
            this.data.mappingTrans.stopAll();
        }
    }

    @Override
    public void stopAll() {
        if (this.data.mappingTrans != null) {
            this.data.mappingTrans.stopAll();
        }
        super.stopAll();
    }

    @Override
    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }

    private void lookupStatusStepNumbers() {
        if (this.data.mappingTrans != null) {
            List<StepMetaDataCombi> steps = this.data.mappingTrans.getSteps();
            for (int i = 0; i < steps.size(); ++i) {
                StepMetaDataCombi sid = steps.get(i);
                BaseStep rt = (BaseStep)sid.step;
                if (this.data.mappingTransMeta.getReadStep() != null && rt.getStepname().equals(this.data.mappingTransMeta.getReadStep().getName())) {
                    this.data.linesReadStepNr = i;
                }
                if (this.data.mappingTransMeta.getInputStep() != null && rt.getStepname().equals(this.data.mappingTransMeta.getInputStep().getName())) {
                    this.data.linesInputStepNr = i;
                }
                if (this.data.mappingTransMeta.getWriteStep() != null && rt.getStepname().equals(this.data.mappingTransMeta.getWriteStep().getName())) {
                    this.data.linesWrittenStepNr = i;
                }
                if (this.data.mappingTransMeta.getOutputStep() != null && rt.getStepname().equals(this.data.mappingTransMeta.getOutputStep().getName())) {
                    this.data.linesOutputStepNr = i;
                }
                if (this.data.mappingTransMeta.getUpdateStep() != null && rt.getStepname().equals(this.data.mappingTransMeta.getUpdateStep().getName())) {
                    this.data.linesUpdatedStepNr = i;
                }
                if (this.data.mappingTransMeta.getRejectedStep() == null || !rt.getStepname().equals(this.data.mappingTransMeta.getRejectedStep().getName())) continue;
                this.data.linesRejectedStepNr = i;
            }
        }
    }

    @Override
    public long getLinesInput() {
        if (this.data != null && this.data.linesInputStepNr != -1) {
            return this.data.mappingTrans.getSteps().get((int)this.data.linesInputStepNr).step.getLinesInput();
        }
        return 0L;
    }

    @Override
    public long getLinesOutput() {
        if (this.data != null && this.data.linesOutputStepNr != -1) {
            return this.data.mappingTrans.getSteps().get((int)this.data.linesOutputStepNr).step.getLinesOutput();
        }
        return 0L;
    }

    @Override
    public long getLinesRead() {
        if (this.data != null && this.data.linesReadStepNr != -1) {
            return this.data.mappingTrans.getSteps().get((int)this.data.linesReadStepNr).step.getLinesRead();
        }
        return 0L;
    }

    @Override
    public long getLinesRejected() {
        if (this.data != null && this.data.linesRejectedStepNr != -1) {
            return this.data.mappingTrans.getSteps().get((int)this.data.linesRejectedStepNr).step.getLinesRejected();
        }
        return 0L;
    }

    @Override
    public long getLinesUpdated() {
        if (this.data != null && this.data.linesUpdatedStepNr != -1) {
            return this.data.mappingTrans.getSteps().get((int)this.data.linesUpdatedStepNr).step.getLinesUpdated();
        }
        return 0L;
    }

    @Override
    public long getLinesWritten() {
        if (this.data != null && this.data.linesWrittenStepNr != -1) {
            return this.data.mappingTrans.getSteps().get((int)this.data.linesWrittenStepNr).step.getLinesWritten();
        }
        return 0L;
    }

    @Override
    public int rowsetInputSize() {
        int size = 0;
        for (MappingInput input : this.data.mappingTrans.findMappingInput()) {
            for (RowSet rowSet : input.getInputRowSets()) {
                size += rowSet.size();
            }
        }
        return size;
    }

    @Override
    public int rowsetOutputSize() {
        int size = 0;
        for (MappingOutput output : this.data.mappingTrans.findMappingOutput()) {
            for (RowSet rowSet : output.getOutputRowSets()) {
                size += rowSet.size();
            }
        }
        return size;
    }

    public Trans getMappingTrans() {
        return this.data.mappingTrans;
    }

    @Override
    public void addRowListener(RowListener rowListener) {
        MappingOutput[] mappingOutputs = this.data.mappingTrans.findMappingOutput();
        if (mappingOutputs == null || mappingOutputs.length == 0) {
            return;
        }
        for (MappingOutput mappingOutput : mappingOutputs) {
            mappingOutput.addRowListener(rowListener);
        }
    }
}

