/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.parallelgzipcsv;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.step.BaseStepData;
import org.pentaho.di.trans.step.StepDataInterface;

public class ParGzipCsvInputData
extends BaseStepData
implements StepDataInterface {
    public RowMetaInterface convertRowMeta;
    public RowMetaInterface outputRowMeta;
    public String[] filenames;
    public int filenr;
    public int startFilenr;
    public byte[] binaryFilename;
    public InputStream fis;
    public boolean isAddingRowNumber;
    public long rowNumber;
    public int stepNumber;
    public int totalNumberOfSteps;
    public boolean parallel;
    public int filenameFieldIndex;
    public int rownumFieldIndex;
    public GZIPInputStream gzis;
    public int bufferSize;
    public byte[] delimiter;
    public byte[] enclosure;
    public int startBuffer = 0;
    public int endBuffer = 0;
    public int maxBuffer = 0;
    public byte[] byteBuffer;
    public long totalBytesRead;
    public long blockSize;
    public boolean eofReached;
    public long fileReadPosition = 0L;
    public int blockNr;

    public byte[] removeEscapedEnclosures(byte[] field, int nrEnclosuresFound) {
        byte[] result = new byte[field.length - nrEnclosuresFound];
        int resultIndex = 0;
        for (int i = 0; i < field.length; ++i) {
            if (field[i] == this.enclosure[0]) {
                if (i + 1 < field.length && field[i + 1] == this.enclosure[0]) continue;
                result[resultIndex++] = field[i];
                continue;
            }
            result[resultIndex++] = field[i];
        }
        return result;
    }

    public boolean getMoreData() throws KettleException {
        if (this.startBuffer == 0 && this.endBuffer >= this.byteBuffer.length) {
            int newSize = this.byteBuffer.length == 0 ? this.bufferSize : this.byteBuffer.length * 3 / 2;
            byte[] newByteBuffer = new byte[newSize];
            this.maxBuffer = this.byteBuffer.length - this.startBuffer;
            System.arraycopy(this.byteBuffer, this.startBuffer, newByteBuffer, 0, this.maxBuffer);
            this.byteBuffer = newByteBuffer;
        } else if (this.startBuffer > 0) {
            this.maxBuffer = this.byteBuffer.length - this.startBuffer;
            System.arraycopy(this.byteBuffer, this.startBuffer, this.byteBuffer, 0, this.maxBuffer);
            this.endBuffer = this.maxBuffer;
            this.startBuffer = 0;
        }
        int size = this.byteBuffer.length - this.maxBuffer;
        int bytesRead = 0;
        int leftToRead = size;
        try {
            while (bytesRead < size) {
                int n = this.gzis.read(this.byteBuffer, this.maxBuffer, leftToRead);
                if (n < 0) {
                    this.eofReached = true;
                    this.fileReadPosition += (long)bytesRead;
                    return bytesRead == 0;
                }
                bytesRead += n;
                this.maxBuffer += n;
                leftToRead -= n;
            }
            this.fileReadPosition += (long)bytesRead;
            return false;
        }
        catch (IOException e) {
            throw new KettleException("Unable to read " + size + " bytes from the gzipped input file", (Throwable)e);
        }
    }
}

