/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.rowgenerator;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.rowgenerator.Messages;
import org.pentaho.di.trans.steps.rowgenerator.RowGeneratorData;
import org.pentaho.di.trans.steps.rowgenerator.RowGeneratorMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RowGenerator
extends BaseStep
implements StepInterface {
    private RowGeneratorMeta meta = (RowGeneratorMeta)this.getStepMeta().getStepMetaInterface();
    private RowGeneratorData data;

    public RowGenerator(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.data = (RowGeneratorData)stepDataInterface;
    }

    public static final RowMetaAndData buildRow(RowGeneratorMeta meta, List<CheckResultInterface> remarks, String origin) {
        RowMeta rowMeta = new RowMeta();
        Object[] rowData = RowDataUtil.allocateRowData((int)meta.getFieldName().length);
        for (int i = 0; i < meta.getFieldName().length; ++i) {
            int valtype = ValueMeta.getType((String)meta.getFieldType()[i]);
            if (meta.getFieldName()[i] == null) continue;
            ValueMeta valueMeta = new ValueMeta(meta.getFieldName()[i], valtype);
            valueMeta.setLength(meta.getFieldLength()[i]);
            valueMeta.setPrecision(meta.getFieldPrecision()[i]);
            valueMeta.setConversionMask(meta.getFieldFormat()[i]);
            valueMeta.setGroupingSymbol(meta.getGroup()[i]);
            valueMeta.setDecimalSymbol(meta.getDecimal()[i]);
            valueMeta.setOrigin(origin);
            ValueMetaInterface stringMeta = valueMeta.clone();
            stringMeta.setType(2);
            String stringValue = meta.getValue()[i];
            if (Const.isEmpty((String)stringValue)) {
                rowData[i] = null;
                if (valueMeta.getType() == 0) {
                    String message = Messages.getString("RowGenerator.CheckResult.SpecifyTypeError", valueMeta.getName(), stringValue);
                    remarks.add((CheckResultInterface)new CheckResult(4, message, null));
                }
            } else {
                try {
                    rowData[i] = valueMeta.convertData(stringMeta, (Object)stringValue);
                }
                catch (KettleValueException e) {
                    switch (valueMeta.getType()) {
                        case 1: {
                            String message = Messages.getString("RowGenerator.BuildRow.Error.Parsing.Number", valueMeta.getName(), stringValue, e.toString());
                            remarks.add((CheckResultInterface)new CheckResult(4, message, null));
                            break;
                        }
                        case 3: {
                            String message = Messages.getString("RowGenerator.BuildRow.Error.Parsing.Date", valueMeta.getName(), stringValue, e.toString());
                            remarks.add((CheckResultInterface)new CheckResult(4, message, null));
                            break;
                        }
                        case 5: {
                            String message = Messages.getString("RowGenerator.BuildRow.Error.Parsing.Integer", valueMeta.getName(), stringValue, e.toString());
                            remarks.add((CheckResultInterface)new CheckResult(4, message, null));
                            break;
                        }
                        case 6: {
                            String message = Messages.getString("RowGenerator.BuildRow.Error.Parsing.BigNumber", valueMeta.getName(), stringValue, e.toString());
                            remarks.add((CheckResultInterface)new CheckResult(4, message, null));
                            break;
                        }
                        default: {
                            String message = Messages.getString("RowGenerator.CheckResult.SpecifyTypeError", valueMeta.getName(), stringValue);
                            remarks.add((CheckResultInterface)new CheckResult(4, message, null));
                        }
                    }
                }
            }
            rowMeta.addValueMeta((ValueMetaInterface)valueMeta);
        }
        return new RowMetaAndData((RowMetaInterface)rowMeta, rowData);
    }

    @Override
    public synchronized boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (RowGeneratorMeta)smi;
        this.data = (RowGeneratorData)sdi;
        Object[] r = null;
        boolean retval = true;
        if (this.data.rowsWritten >= this.data.rowLimit) {
            this.setOutputDone();
            return false;
        }
        r = this.data.outputRowMeta.cloneRow(this.data.outputRowData);
        this.putRow(this.data.outputRowMeta, r);
        ++this.data.rowsWritten;
        if (this.log.isRowLevel()) {
            this.log.logRowlevel(this.toString(), Messages.getString("RowGenerator.Log.Wrote.Row", Long.toString(this.data.rowsWritten), this.data.outputRowMeta.getString(r)), new Object[0]);
        }
        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
            this.logBasic(Messages.getString("RowGenerator.Log.LineNr", Long.toString(this.data.rowsWritten)));
        }
        return retval;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (RowGeneratorMeta)smi;
        this.data = (RowGeneratorData)sdi;
        if (super.init(smi, sdi)) {
            this.data.rowLimit = Const.toLong((String)this.environmentSubstitute(this.meta.getRowLimit()), (long)-1L);
            this.data.rowsWritten = 0L;
            if (this.data.rowLimit < 0L) {
                this.logError(Messages.getString("RowGenerator.Wrong.RowLimit.Number"));
                return false;
            }
            ArrayList<CheckResultInterface> remarks = new ArrayList<CheckResultInterface>();
            RowMetaAndData outputRow = RowGenerator.buildRow(this.meta, remarks, this.getStepname());
            if (!remarks.isEmpty()) {
                for (int i = 0; i < remarks.size(); ++i) {
                    CheckResult cr = (CheckResult)remarks.get(i);
                    this.logError(cr.getText());
                }
                return false;
            }
            this.data.outputRowData = outputRow.getData();
            this.data.outputRowMeta = outputRow.getRowMeta();
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

