/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.switchcase;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.switchcase.Messages;
import org.pentaho.di.trans.steps.switchcase.SwitchCase;
import org.pentaho.di.trans.steps.switchcase.SwitchCaseData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwitchCaseMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static final String XML_TAG_CASE_VALUES = "cases";
    private static final String XML_TAG_CASE_VALUE = "case";
    private String fieldname;
    private int caseValueType;
    private String caseValueFormat;
    private String caseValueDecimal;
    private String caseValueGroup;
    private String[] caseValues;
    private String[] caseTargetStepnames;
    private StepMeta[] caseTargetSteps;
    private String defaultTargetStepname;
    private StepMeta defaultTargetStep;
    private boolean isContains;

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int nrCases) {
        this.caseValues = new String[nrCases];
        this.caseTargetStepnames = new String[nrCases];
        this.caseTargetSteps = new StepMeta[nrCases];
    }

    @Override
    public Object clone() {
        SwitchCaseMeta retval = (SwitchCaseMeta)super.clone();
        return retval;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(200);
        retval.append(XMLHandler.addTagValue((String)"fieldname", (String)this.fieldname));
        retval.append(XMLHandler.addTagValue((String)"use_contains", (boolean)this.isContains));
        retval.append(XMLHandler.addTagValue((String)"case_value_type", (String)ValueMeta.getTypeDesc((int)this.caseValueType)));
        retval.append(XMLHandler.addTagValue((String)"case_value_format", (String)this.caseValueFormat));
        retval.append(XMLHandler.addTagValue((String)"case_value_decimal", (String)this.caseValueDecimal));
        retval.append(XMLHandler.addTagValue((String)"case_value_group", (String)this.caseValueGroup));
        retval.append(XMLHandler.addTagValue((String)"default_target_step", this.defaultTargetStep == null ? null : this.defaultTargetStep.getName()));
        retval.append(XMLHandler.openTag((String)XML_TAG_CASE_VALUES));
        for (int i = 0; i < this.caseValues.length; ++i) {
            retval.append(XMLHandler.openTag((String)XML_TAG_CASE_VALUE));
            retval.append(XMLHandler.addTagValue((String)"value", (String)this.caseValues[i]));
            retval.append(XMLHandler.addTagValue((String)"target_step", this.caseTargetSteps[i] != null ? this.caseTargetSteps[i].getName() : null));
            retval.append(XMLHandler.closeTag((String)XML_TAG_CASE_VALUE));
        }
        retval.append(XMLHandler.closeTag((String)XML_TAG_CASE_VALUES));
        return retval.toString();
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.fieldname = XMLHandler.getTagValue((Node)stepnode, (String)"fieldname");
            this.isContains = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"use_contains"));
            this.caseValueType = ValueMeta.getType((String)XMLHandler.getTagValue((Node)stepnode, (String)"case_value_type"));
            this.caseValueFormat = XMLHandler.getTagValue((Node)stepnode, (String)"case_value_format");
            this.caseValueDecimal = XMLHandler.getTagValue((Node)stepnode, (String)"case_value_decimal");
            this.caseValueGroup = XMLHandler.getTagValue((Node)stepnode, (String)"case_value_group");
            this.defaultTargetStepname = XMLHandler.getTagValue((Node)stepnode, (String)"default_target_step");
            Node casesNode = XMLHandler.getSubNode((Node)stepnode, (String)XML_TAG_CASE_VALUES);
            int nrCases = XMLHandler.countNodes((Node)casesNode, (String)XML_TAG_CASE_VALUE);
            this.allocate(nrCases);
            for (int i = 0; i < nrCases; ++i) {
                Node caseNode = XMLHandler.getSubNodeByNr((Node)casesNode, (String)XML_TAG_CASE_VALUE, (int)i);
                this.caseValues[i] = XMLHandler.getTagValue((Node)caseNode, (String)"value");
                this.caseTargetStepnames[i] = XMLHandler.getTagValue((Node)caseNode, (String)"target_step");
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(Messages.getString("SwitchCaseMeta.Exception..UnableToLoadStepInfoFromXML"), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.allocate(0);
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.fieldname = rep.getStepAttributeString(id_step, "fieldname");
            this.isContains = rep.getStepAttributeBoolean(id_step, "use_contains");
            this.caseValueType = ValueMeta.getType((String)rep.getStepAttributeString(id_step, "case_value_type"));
            this.caseValueFormat = rep.getStepAttributeString(id_step, "case_value_format");
            this.caseValueDecimal = rep.getStepAttributeString(id_step, "case_value_decimal");
            this.caseValueGroup = rep.getStepAttributeString(id_step, "case_value_group");
            this.defaultTargetStepname = rep.getStepAttributeString(id_step, "default_target_step");
            int nrCases = rep.countNrStepAttributes(id_step, "case_value");
            this.allocate(nrCases);
            for (int i = 0; i < nrCases; ++i) {
                this.caseValues[i] = rep.getStepAttributeString(id_step, i, "case_value");
                this.caseTargetStepnames[i] = rep.getStepAttributeString(id_step, i, "case_target_step");
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("SwitchCaseMeta.Exception.UnexpectedErrorInReadingStepInfoFromRepository"), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "fieldname", this.fieldname);
            rep.saveStepAttribute(id_transformation, id_step, "use_contains", this.isContains);
            rep.saveStepAttribute(id_transformation, id_step, "case_value_type", ValueMeta.getTypeDesc((int)this.caseValueType));
            rep.saveStepAttribute(id_transformation, id_step, "case_value_format", this.caseValueFormat);
            rep.saveStepAttribute(id_transformation, id_step, "case_value_decimal", this.caseValueDecimal);
            rep.saveStepAttribute(id_transformation, id_step, "case_value_group", this.caseValueGroup);
            rep.saveStepAttribute(id_transformation, id_step, "default_target_step", this.defaultTargetStep == null ? null : this.defaultTargetStep.getName());
            for (int i = 0; i < this.caseValues.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "case_value", this.caseValues[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "case_target_step", this.caseTargetSteps[i] != null ? this.caseTargetSteps[i].getName() : null);
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("SwitchCaseMeta.Exception.UnableToSaveStepInfoToRepository") + id_step, (Throwable)e);
        }
    }

    @Override
    public void searchInfoAndTargetSteps(List<StepMeta> steps) {
        for (int i = 0; i < this.caseTargetStepnames.length; ++i) {
            this.caseTargetSteps[i] = StepMeta.findStep(steps, this.caseTargetStepnames[i]);
        }
        this.defaultTargetStep = StepMeta.findStep(steps, this.defaultTargetStepname);
    }

    @Override
    public boolean chosesTargetSteps() {
        return true;
    }

    @Override
    public String[] getTargetSteps() {
        ArrayList<String> names = new ArrayList<String>();
        for (StepMeta stepMeta : this.caseTargetSteps) {
            if (stepMeta == null) continue;
            names.add(stepMeta.getName());
        }
        if (this.defaultTargetStep != null) {
            names.add(this.defaultTargetStep.getName());
        }
        return names.toArray(new String[names.size()]);
    }

    @Override
    public void setTargetSteps(StepMeta[] targetSteps) {
        this.caseTargetSteps = targetSteps;
    }

    @Override
    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepinfo, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (this.caseTargetSteps != null) {
            for (String stepname : this.caseTargetStepnames) {
                int index = Const.indexOfString((String)stepname, (String[])output);
                if (index >= 0) continue;
                cr = new CheckResult(4, Messages.getString("SwitchCaseMeta.CheckResult.TargetStepInvalid", "false", stepname), (CheckResultSourceInterface)stepinfo);
                remarks.add((CheckResultInterface)cr);
            }
        }
        cr = Const.isEmpty((String)this.fieldname) ? new CheckResult(4, Messages.getString("SwitchCaseMeta.CheckResult.NoFieldSpecified"), (CheckResultSourceInterface)stepinfo) : new CheckResult(1, Messages.getString("SwitchCaseMeta.CheckResult.FieldSpecified"), (CheckResultSourceInterface)stepinfo);
        remarks.add((CheckResultInterface)cr);
        if (input.length > 0) {
            cr = new CheckResult(1, Messages.getString("SwitchCaseMeta.CheckResult.StepReceivingInfoFromOtherSteps"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, Messages.getString("SwitchCaseMeta.CheckResult.NoInputReceivedFromOtherSteps"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new SwitchCase(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new SwitchCaseData();
    }

    public String getFieldname() {
        return this.fieldname;
    }

    public void setFieldname(String fieldname) {
        this.fieldname = fieldname;
    }

    public String getCaseValueFormat() {
        return this.caseValueFormat;
    }

    public void setCaseValueFormat(String caseValueFormat) {
        this.caseValueFormat = caseValueFormat;
    }

    public String getCaseValueDecimal() {
        return this.caseValueDecimal;
    }

    public void setCaseValueDecimal(String caseValueDecimal) {
        this.caseValueDecimal = caseValueDecimal;
    }

    public String getCaseValueGroup() {
        return this.caseValueGroup;
    }

    public void setCaseValueGroup(String caseValueGroup) {
        this.caseValueGroup = caseValueGroup;
    }

    public String[] getCaseValues() {
        return this.caseValues;
    }

    public void setCaseValues(String[] caseValues) {
        this.caseValues = caseValues;
    }

    public String[] getCaseTargetStepnames() {
        return this.caseTargetStepnames;
    }

    public void setCaseTargetStepnames(String[] caseTargetStepnames) {
        this.caseTargetStepnames = caseTargetStepnames;
    }

    public StepMeta[] getCaseTargetSteps() {
        return this.caseTargetSteps;
    }

    public void setCaseTargetSteps(StepMeta[] caseTargetSteps) {
        this.caseTargetSteps = caseTargetSteps;
    }

    public int getCaseValueType() {
        return this.caseValueType;
    }

    public void setCaseValueType(int caseValueType) {
        this.caseValueType = caseValueType;
    }

    public String getDefaultTargetStepname() {
        return this.defaultTargetStepname;
    }

    public void setDefaultTargetStepname(String defaultTargetStepname) {
        this.defaultTargetStepname = defaultTargetStepname;
    }

    public StepMeta getDefaultTargetStep() {
        return this.defaultTargetStep;
    }

    public void setDefaultTargetStep(StepMeta defaultTargetStep) {
        this.defaultTargetStep = defaultTargetStep;
    }

    public boolean isContains() {
        return this.isContains;
    }

    public void setContains(boolean isContains) {
        this.isContains = isContains;
    }
}

