/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.writetolog;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.writetolog.Messages;
import org.pentaho.di.trans.steps.writetolog.WriteToLogData;
import org.pentaho.di.trans.steps.writetolog.WriteToLogMeta;

public class WriteToLog
extends BaseStep
implements StepInterface {
    private WriteToLogMeta meta;
    private WriteToLogData data;

    public WriteToLog(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (WriteToLogMeta)smi;
        this.data = (WriteToLogData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            int i;
            this.first = false;
            if (this.meta.getFieldName() != null && this.meta.getFieldName().length > 0) {
                this.data.fieldnrs = new int[this.meta.getFieldName().length];
                for (i = 0; i < this.data.fieldnrs.length; ++i) {
                    this.data.fieldnrs[i] = this.getInputRowMeta().indexOfValue(this.meta.getFieldName()[i]);
                    if (this.data.fieldnrs[i] >= 0) continue;
                    this.logError(Messages.getString("WriteToLog.Log.CanNotFindField", this.meta.getFieldName()[i]));
                    throw new KettleException(Messages.getString("WriteToLog.Log.CanNotFindField", this.meta.getFieldName()[i]));
                }
            } else {
                this.data.fieldnrs = new int[this.getInputRowMeta().size()];
                for (i = 0; i < this.data.fieldnrs.length; ++i) {
                    this.data.fieldnrs[i] = i;
                }
            }
            this.data.fieldnr = this.data.fieldnrs.length;
            this.data.loglevel = this.meta.getLogLevelByDesc();
        }
        StringBuffer out = new StringBuffer();
        out.append(Const.CR + "------------> " + Messages.getString("WriteToLog.Log.NLigne", "" + this.getLinesRead()) + "------------------------------" + Const.CR);
        for (int i = 0; i < this.data.fieldnr; ++i) {
            String fieldvalue = this.getInputRowMeta().getString(r, this.data.fieldnrs[i]);
            if (this.meta.isdisplayHeader()) {
                String fieldname = this.getInputRowMeta().getFieldNames()[this.data.fieldnrs[i]];
                out.append(fieldname + " = " + fieldvalue + Const.CR);
                continue;
            }
            out.append(fieldvalue + Const.CR);
        }
        out.append(Const.CR + "====================");
        this.setLog(this.log, this.data.loglevel, out);
        this.putRow(this.getInputRowMeta(), r);
        return true;
    }

    private void setLog(LogWriter log, int loglevel, StringBuffer msg) {
        switch (loglevel) {
            case 1: {
                log.logError(this.toString(), msg.toString(), new Object[0]);
                break;
            }
            case 2: {
                log.logMinimal(this.toString(), msg.toString(), new Object[0]);
                break;
            }
            case 3: {
                log.logBasic(this.toString(), msg.toString(), new Object[0]);
                break;
            }
            case 4: {
                log.logDetailed(this.toString(), msg.toString(), new Object[0]);
                break;
            }
            case 5: {
                log.logDebug(this.toString(), msg.toString(), new Object[0]);
                break;
            }
            case 6: {
                log.logRowlevel(this.toString(), msg.toString(), new Object[0]);
                break;
            }
            default: {
                log.logBasic(this.toString(), msg.toString(), new Object[0]);
            }
        }
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (WriteToLogMeta)smi;
        this.data = (WriteToLogData)sdi;
        return super.init(smi, sdi);
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

