/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.xmljoin;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.xmljoin.Messages;
import org.pentaho.di.trans.steps.xmljoin.XMLJoinData;
import org.pentaho.di.trans.steps.xmljoin.XMLJoinMeta;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XMLJoin
extends BaseStep
implements StepInterface {
    private XMLJoinMeta meta;
    private XMLJoinData data;
    private Transformer serializer;

    public XMLJoin(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        String[] source_field_names;
        Object[] rJoinSource;
        this.meta = (XMLJoinMeta)smi;
        this.data = (XMLJoinData)sdi;
        XPath xpath = XPathFactory.newInstance().newXPath();
        if (this.first) {
            this.first = false;
            int target_field_id = -1;
            XMLJoinMeta meta = (XMLJoinMeta)smi;
            this.data.TargetRowSet = this.findInputRowSet(meta.getTargetXMLstep());
            this.data.SourceRowSet = this.findInputRowSet(meta.getSourceXMLstep());
            Object[] rTarget = this.getRowFrom(this.data.TargetRowSet);
            meta.getTargetXMLstep();
            String[] target_field_names = this.data.TargetRowSet.getRowMeta().getFieldNames();
            for (int i = 0; i < target_field_names.length; ++i) {
                if (!meta.getTargetXMLfield().equals(target_field_names[i])) continue;
                target_field_id = i;
            }
            if (target_field_id == -1) {
                throw new KettleException(Messages.getString("XMLJoin.Exception.FieldNotFound", meta.getTargetXMLfield()));
            }
            this.data.outputRowMeta = this.data.TargetRowSet.getRowMeta().clone();
            meta.getFields(this.data.outputRowMeta, this.getStepname(), new RowMetaInterface[]{this.data.TargetRowSet.getRowMeta()}, null, this);
            this.data.outputRowData = (Object[])rTarget.clone();
            String strTarget = (String)rTarget[target_field_id];
            InputSource inputSource = new InputSource(new StringReader(strTarget));
            this.data.XPathStatement = meta.getTargetXPath();
            try {
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                this.data.targetDOM = builder.parse(inputSource);
                if (!meta.isComplexJoin()) {
                    this.data.targetNode = (Node)xpath.evaluate(this.data.XPathStatement, this.data.targetDOM, XPathConstants.NODE);
                    if (this.data.targetNode == null) {
                        throw new KettleXMLException("XPath statement returned no reuslt [" + this.data.XPathStatement + "]");
                    }
                }
            }
            catch (Exception e) {
                throw new KettleXMLException((Throwable)e);
            }
        }
        if ((rJoinSource = this.getRowFrom(this.data.SourceRowSet)) == null) {
            try {
                String strOmitXMLHeader = this.meta.isOmitXMLHeader() ? "yes" : "no";
                this.serializer.setOutputProperty("omit-xml-declaration", strOmitXMLHeader);
                this.serializer.setOutputProperty("indent", "no");
                StringWriter sw = new StringWriter();
                StreamResult resultXML = new StreamResult(sw);
                DOMSource source = new DOMSource(this.data.targetDOM);
                this.serializer.transform(source, resultXML);
                String output = sw.toString();
                int outputIndex = this.data.outputRowMeta.size() - 1;
                this.putRow(this.data.outputRowMeta, RowDataUtil.addValueData((Object[])this.data.outputRowData, (int)outputIndex, (Object)output));
                this.setOutputDone();
                return false;
            }
            catch (Exception e) {
                throw new KettleException((Throwable)e);
            }
        }
        if (this.data.iSourceXMLField == -1) {
            source_field_names = this.data.SourceRowSet.getRowMeta().getFieldNames();
            for (int i = 0; i < source_field_names.length; ++i) {
                if (!this.meta.getSourceXMLfield().equals(source_field_names[i])) continue;
                this.data.iSourceXMLField = i;
            }
            if (this.data.iSourceXMLField == -1) {
                throw new KettleException(Messages.getString("XMLJoin.Exception.FieldNotFound", this.meta.getSourceXMLfield()));
            }
        }
        if (this.meta.isComplexJoin() && this.data.iCompareFieldID == -1) {
            source_field_names = this.data.SourceRowSet.getRowMeta().getFieldNames();
            for (int i = 0; i < source_field_names.length; ++i) {
                if (!this.meta.getJoinCompareField().equals(source_field_names[i])) continue;
                this.data.iCompareFieldID = i;
            }
            if (this.data.iCompareFieldID == -1) {
                throw new KettleException(Messages.getString("XMLJoin.Exception.FieldNotFound", this.meta.getJoinCompareField()));
            }
        }
        if (rJoinSource != null) {
            Document joinDocument;
            String strJoinXML = (String)rJoinSource[this.data.iSourceXMLField];
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                joinDocument = builder.parse(new InputSource(new StringReader(strJoinXML)));
            }
            catch (Exception e) {
                throw new KettleException((Throwable)e);
            }
            Node node = this.data.targetDOM.importNode(joinDocument.getDocumentElement(), true);
            if (this.meta.isComplexJoin()) {
                String strCompareValue = rJoinSource[this.data.iCompareFieldID].toString();
                String strXPathStatement = this.data.XPathStatement.replace("?", strCompareValue);
                try {
                    this.data.targetNode = (Node)xpath.evaluate(strXPathStatement, this.data.targetDOM, XPathConstants.NODE);
                    if (this.data.targetNode == null) {
                        throw new KettleXMLException("XPath statement returned no reuslt [" + strXPathStatement + "]");
                    }
                    this.data.targetNode.appendChild(node);
                }
                catch (Exception e) {
                    throw new KettleException((Throwable)e);
                }
            } else {
                this.data.targetNode.appendChild(node);
            }
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (XMLJoinMeta)smi;
        this.data = (XMLJoinData)sdi;
        if (!super.init(smi, sdi)) {
            return false;
        }
        try {
            this.setSerializer(TransformerFactory.newInstance().newTransformer());
            if (this.meta.getEncoding() != null) {
                this.getSerializer().setOutputProperty("encoding", this.meta.getEncoding());
            }
            if (this.meta.isOmitXMLHeader()) {
                this.getSerializer().setOutputProperty("omit-xml-declaration", "yes");
            }
            this.setSafeModeEnabled(false);
            for (int i = 0; i < this.inputRowSets.size(); ++i) {
                RowSet rs = (RowSet)this.inputRowSets.get(i);
                if (!rs.getOriginStepName().equalsIgnoreCase(this.meta.getTargetXMLstep())) continue;
                RowSet zero = (RowSet)this.inputRowSets.get(0);
                this.inputRowSets.set(0, rs);
                this.inputRowSets.set(i, zero);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (XMLJoinMeta)smi;
        this.data = (XMLJoinData)sdi;
        super.dispose(smi, sdi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                this.logBasic("Starting to run...");
                while (this.processRow(this.meta, this.data) && !this.isStopped()) {
                }
                Object var3_1 = null;
                this.dispose(this.meta, this.data);
            }
            catch (Exception e) {
                this.logError("Unexpected error : ");
                this.logError(Const.getStackTracker((Throwable)e));
                this.setErrors(1L);
                this.stopAll();
                Object var3_2 = null;
                this.dispose(this.meta, this.data);
                this.logSummary();
                this.markStop();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.dispose(this.meta, this.data);
            this.logSummary();
            this.markStop();
            throw throwable;
        }
        this.logSummary();
        this.markStop();
    }

    private void setSerializer(Transformer serializer) {
        this.serializer = serializer;
    }

    private Transformer getSerializer() {
        return this.serializer;
    }
}

