/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.www.Messages;
import org.pentaho.di.www.TransformationMap;
import org.pentaho.di.www.WebResult;

public class StartExecutionTransServlet
extends HttpServlet {
    private static final long serialVersionUID = 3634806745372015720L;
    public static final String CONTEXT_PATH = "/kettle/startExec";
    private static LogWriter log = LogWriter.getInstance();
    private TransformationMap transformationMap;

    public StartExecutionTransServlet(TransformationMap transformationMap) {
        this.transformationMap = transformationMap;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (log.isDebug()) {
            log.logDebug(this.toString(), "Start execution of transformation requested", new Object[0]);
        }
        response.setStatus(200);
        String transName = request.getParameter("name");
        boolean useXML = "Y".equalsIgnoreCase(request.getParameter("xml"));
        PrintWriter out = response.getWriter();
        if (useXML) {
            response.setContentType("text/xml");
            out.print(XMLHandler.getXMLHeader((String)"UTF-8"));
        } else {
            response.setContentType("text/html");
            out.println("<HTML>");
            out.println("<HEAD>");
            out.println("<TITLE>" + Messages.getString("PrepareExecutionTransServlet.TransPrepareExecution") + "</TITLE>");
            out.println("<META http-equiv=\"Refresh\" content=\"2;url=/kettle/transStatus?name=" + URLEncoder.encode(transName, "UTF-8") + "\">");
            out.println("</HEAD>");
            out.println("<BODY>");
        }
        try {
            Trans trans = this.transformationMap.getTransformation(transName);
            if (trans != null) {
                if (trans.isReadyToStart()) {
                    trans.startThreads();
                    if (useXML) {
                        out.println(WebResult.OK.getXML());
                    } else {
                        out.println("<H1>Transformation '" + transName + "' has been executed.</H1>");
                        out.println("<a href=\"/kettle/transStatus?name=" + URLEncoder.encode(transName, "UTF-8") + "\">Back to the transformation status page</a><p>");
                    }
                } else {
                    String message = "The specified transformation [" + transName + "] is not ready to be started. (Was not prepared for execution)";
                    if (useXML) {
                        out.println(new WebResult("ERROR", message));
                    } else {
                        out.println("<H1>" + message + "</H1>");
                        out.println("<a href=\"/kettle/status\">" + Messages.getString("TransStatusServlet.BackToStatusPage") + "</a><p>");
                    }
                }
            } else if (useXML) {
                out.println(new WebResult("ERROR", Messages.getString("TransStatusServlet.Log.CoundNotFindSpecTrans", transName)));
            } else {
                out.println("<H1>" + Messages.getString("TransStatusServlet.Log.CoundNotFindTrans", transName) + "</H1>");
                out.println("<a href=\"/kettle/status\">" + Messages.getString("TransStatusServlet.BackToStatusPage") + "</a><p>");
            }
        }
        catch (Exception ex) {
            if (useXML) {
                out.println(new WebResult("ERROR", "Unexpected error during transformation execution preparation:" + Const.CR + Const.getStackTracker((Throwable)ex)));
            }
            out.println("<p>");
            out.println("<pre>");
            ex.printStackTrace(out);
            out.println("</pre>");
        }
        if (!useXML) {
            out.println("<p>");
            out.println("</BODY>");
            out.println("</HTML>");
        }
    }

    public String toString() {
        return "Start transformation";
    }
}

