/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.swt;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PComponent;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PRoot;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.event.PPanEventHandler;
import edu.umd.cs.piccolo.event.PZoomEventHandler;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDebug;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolo.util.PStack;
import edu.umd.cs.piccolox.swt.PSWTKeyEvent;
import edu.umd.cs.piccolox.swt.PSWTMouseEvent;
import edu.umd.cs.piccolox.swt.PSWTRoot;
import edu.umd.cs.piccolox.swt.SWTGraphics2D;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.InputEvent;
import java.awt.geom.Rectangle2D;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class PSWTCanvas
extends Composite
implements PComponent {
    public static PSWTCanvas CURRENT_CANVAS = null;
    private Image backBuffer;
    private boolean doubleBuffered = true;
    private PCamera camera;
    private PStack cursorStack;
    private org.eclipse.swt.graphics.Cursor curCursor;
    private int interacting;
    private int defaultRenderQuality;
    private int animatingRenderQuality;
    private int interactingRenderQuality;
    private PPanEventHandler panEventHandler;
    private PZoomEventHandler zoomEventHandler;
    private boolean paintingImmediately;
    private boolean animatingOnLastPaint;
    private boolean isButton1Pressed;
    private boolean isButton2Pressed;
    private boolean isButton3Pressed;

    public PSWTCanvas(Composite composite, int n) {
        super(composite, n | 0x40000 | 0x100000);
        CURRENT_CANVAS = this;
        this.cursorStack = new PStack();
        this.setCamera(this.createBasicSceneGraph());
        this.installInputSources();
        this.setDefaultRenderQuality(1);
        this.setAnimatingRenderQuality(0);
        this.setInteractingRenderQuality(0);
        this.panEventHandler = new PPanEventHandler();
        this.zoomEventHandler = new PZoomEventHandler();
        this.addInputEventListener(this.panEventHandler);
        this.addInputEventListener(this.zoomEventHandler);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                PSWTCanvas.this.paintComponent(paintEvent.gc, paintEvent.x, paintEvent.y, paintEvent.width, paintEvent.height);
            }
        });
        SWTGraphics2D.incrementGCCount();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                PSWTCanvas.this.getRoot().getActivityScheduler().removeAllActivities();
                SWTGraphics2D.decrementGCCount();
            }
        });
    }

    public PPanEventHandler getPanEventHandler() {
        return this.panEventHandler;
    }

    public PZoomEventHandler getZoomEventHandler() {
        return this.zoomEventHandler;
    }

    public PCamera getCamera() {
        return this.camera;
    }

    public void setCamera(PCamera pCamera) {
        if (this.camera != null) {
            this.camera.setComponent(null);
        }
        this.camera = pCamera;
        if (this.camera != null) {
            this.camera.setComponent(this);
            Rectangle rectangle = this.getBounds();
            this.camera.setBounds(new Rectangle2D.Double(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
        }
    }

    public PRoot getRoot() {
        return this.camera.getRoot();
    }

    public PLayer getLayer() {
        return this.camera.getLayer(0);
    }

    public void addInputEventListener(PInputEventListener pInputEventListener) {
        this.getCamera().addInputEventListener(pInputEventListener);
    }

    public void removeInputEventListener(PInputEventListener pInputEventListener) {
        this.getCamera().removeInputEventListener(pInputEventListener);
    }

    public PCamera createBasicSceneGraph() {
        PSWTRoot pSWTRoot = new PSWTRoot(this);
        PLayer pLayer = new PLayer();
        PCamera pCamera = new PCamera();
        pSWTRoot.addChild(pCamera);
        pSWTRoot.addChild(pLayer);
        pCamera.addLayer(pLayer);
        return pCamera;
    }

    public boolean getInteracting() {
        return this.interacting > 0;
    }

    public boolean getAnimating() {
        return this.getRoot().getActivityScheduler().getAnimating();
    }

    public void setInteracting(boolean bl) {
        this.interacting = bl ? ++this.interacting : --this.interacting;
        if (!this.getInteracting()) {
            this.repaint();
        }
    }

    public boolean getDoubleBuffered() {
        return this.doubleBuffered;
    }

    public void setDoubleBuffered(boolean bl) {
        this.doubleBuffered = bl;
    }

    public void setDefaultRenderQuality(int n) {
        this.defaultRenderQuality = n;
        this.repaint();
    }

    public void setAnimatingRenderQuality(int n) {
        this.animatingRenderQuality = n;
        this.repaint();
    }

    public void setInteractingRenderQuality(int n) {
        this.interactingRenderQuality = n;
        this.repaint();
    }

    public void pushCursor(Cursor cursor) {
        org.eclipse.swt.graphics.Cursor cursor2 = null;
        if (cursor.getType() == 8) {
            cursor2 = new org.eclipse.swt.graphics.Cursor((Device)this.getDisplay(), 10);
        } else if (cursor.getType() == 7) {
            cursor2 = new org.eclipse.swt.graphics.Cursor((Device)this.getDisplay(), 14);
        } else if (cursor.getType() == 6) {
            cursor2 = new org.eclipse.swt.graphics.Cursor((Device)this.getDisplay(), 17);
        } else if (cursor.getType() == 9) {
            cursor2 = new org.eclipse.swt.graphics.Cursor((Device)this.getDisplay(), 11);
        } else if (cursor.getType() == 5) {
            cursor2 = new org.eclipse.swt.graphics.Cursor((Device)this.getDisplay(), 15);
        } else if (cursor.getType() == 4) {
            cursor2 = new org.eclipse.swt.graphics.Cursor((Device)this.getDisplay(), 16);
        } else if (cursor.getType() == 11) {
            cursor2 = new org.eclipse.swt.graphics.Cursor((Device)this.getDisplay(), 12);
        } else if (cursor.getType() == 10) {
            cursor2 = new org.eclipse.swt.graphics.Cursor((Device)this.getDisplay(), 13);
        } else if (cursor.getType() == 2) {
            cursor2 = new org.eclipse.swt.graphics.Cursor((Device)this.getDisplay(), 19);
        } else if (cursor.getType() == 12) {
            cursor2 = new org.eclipse.swt.graphics.Cursor((Device)this.getDisplay(), 21);
        } else if (cursor.getType() == 13) {
            cursor2 = new org.eclipse.swt.graphics.Cursor((Device)this.getDisplay(), 5);
        } else if (cursor.getType() == 1) {
            cursor2 = new org.eclipse.swt.graphics.Cursor((Device)this.getDisplay(), 2);
        } else if (cursor.getType() == 3) {
            cursor2 = new org.eclipse.swt.graphics.Cursor((Device)this.getDisplay(), 1);
        }
        if (cursor2 != null) {
            if (this.curCursor != null) {
                this.cursorStack.push(this.curCursor);
            }
            this.curCursor = cursor2;
            this.setCursor(cursor2);
        }
    }

    public void popCursor() {
        if (this.curCursor != null) {
            this.curCursor.dispose();
        }
        this.curCursor = !this.cursorStack.isEmpty() ? (org.eclipse.swt.graphics.Cursor)this.cursorStack.pop() : null;
        this.setCursor(this.curCursor);
    }

    protected void installInputSources() {
        this.addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent mouseEvent) {
                PSWTMouseEvent pSWTMouseEvent;
                boolean bl = false;
                switch (mouseEvent.button) {
                    case 1: {
                        if (PSWTCanvas.this.isButton1Pressed) {
                            bl = true;
                        }
                        PSWTCanvas.this.isButton1Pressed = true;
                        break;
                    }
                    case 2: {
                        if (PSWTCanvas.this.isButton2Pressed) {
                            bl = true;
                        }
                        PSWTCanvas.this.isButton2Pressed = true;
                        break;
                    }
                    case 3: {
                        if (PSWTCanvas.this.isButton3Pressed) {
                            bl = true;
                        }
                        PSWTCanvas.this.isButton3Pressed = true;
                    }
                }
                if (bl) {
                    pSWTMouseEvent = new PSWTMouseEvent(mouseEvent, 502, 1);
                    PSWTCanvas.this.sendInputEventToInputManager(pSWTMouseEvent, 502);
                }
                pSWTMouseEvent = new PSWTMouseEvent(mouseEvent, 501, 1);
                PSWTCanvas.this.sendInputEventToInputManager(pSWTMouseEvent, 501);
            }

            public void mouseUp(MouseEvent mouseEvent) {
                PSWTMouseEvent pSWTMouseEvent;
                boolean bl = false;
                switch (mouseEvent.button) {
                    case 1: {
                        if (!PSWTCanvas.this.isButton1Pressed) {
                            bl = true;
                        }
                        PSWTCanvas.this.isButton1Pressed = false;
                        break;
                    }
                    case 2: {
                        if (!PSWTCanvas.this.isButton2Pressed) {
                            bl = true;
                        }
                        PSWTCanvas.this.isButton2Pressed = false;
                        break;
                    }
                    case 3: {
                        if (!PSWTCanvas.this.isButton3Pressed) {
                            bl = true;
                        }
                        PSWTCanvas.this.isButton3Pressed = false;
                    }
                }
                if (bl) {
                    pSWTMouseEvent = new PSWTMouseEvent(mouseEvent, 501, 1);
                    PSWTCanvas.this.sendInputEventToInputManager(pSWTMouseEvent, 501);
                }
                pSWTMouseEvent = new PSWTMouseEvent(mouseEvent, 502, 1);
                PSWTCanvas.this.sendInputEventToInputManager(pSWTMouseEvent, 502);
            }

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                PSWTMouseEvent pSWTMouseEvent = new PSWTMouseEvent(mouseEvent, 501, 2);
                PSWTCanvas.this.sendInputEventToInputManager(pSWTMouseEvent, 501);
                pSWTMouseEvent = new PSWTMouseEvent(mouseEvent, 502, 2);
                PSWTCanvas.this.sendInputEventToInputManager(pSWTMouseEvent, 502);
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent mouseEvent) {
                if (PSWTCanvas.this.isButton1Pressed || PSWTCanvas.this.isButton2Pressed || PSWTCanvas.this.isButton3Pressed) {
                    PSWTMouseEvent pSWTMouseEvent = new PSWTMouseEvent(mouseEvent, 506, 1);
                    PSWTCanvas.this.sendInputEventToInputManager(pSWTMouseEvent, 506);
                } else {
                    PSWTMouseEvent pSWTMouseEvent = new PSWTMouseEvent(mouseEvent, 503, 1);
                    PSWTCanvas.this.sendInputEventToInputManager(pSWTMouseEvent, 503);
                }
            }
        });
        this.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                PSWTKeyEvent pSWTKeyEvent = new PSWTKeyEvent(keyEvent, 401);
                PSWTCanvas.this.sendInputEventToInputManager(pSWTKeyEvent, 401);
            }

            public void keyReleased(KeyEvent keyEvent) {
                PSWTKeyEvent pSWTKeyEvent = new PSWTKeyEvent(keyEvent, 402);
                PSWTCanvas.this.sendInputEventToInputManager(pSWTKeyEvent, 402);
            }
        });
    }

    protected void sendInputEventToInputManager(InputEvent inputEvent, int n) {
        this.getRoot().getDefaultInputManager().processEventFromCamera(inputEvent, n, this.getCamera());
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.camera.setBounds(this.camera.getX(), this.camera.getY(), n3, n4);
        if (this.backBuffer == null || this.backBuffer.getBounds().width < n3 || this.backBuffer.getBounds().height < n4) {
            this.backBuffer = new Image((Device)this.getDisplay(), n3, n4);
        }
        super.setBounds(n, n2, n3, n4);
    }

    public void repaint() {
        super.redraw();
    }

    public void repaint(PBounds pBounds) {
        pBounds.expandNearestIntegerDimensions();
        pBounds.inset(-1.0, -1.0);
        this.redraw((int)pBounds.x, (int)pBounds.y, (int)pBounds.width, (int)pBounds.height, true);
    }

    public void paintComponent(GC gC, int n, int n2, int n3, int n4) {
        Object object;
        PDebug.startProcessingOutput();
        GC gC2 = null;
        SWTGraphics2D sWTGraphics2D = null;
        if (this.doubleBuffered) {
            gC2 = new GC((Drawable)this.backBuffer);
            sWTGraphics2D = new SWTGraphics2D(gC2, (Device)this.getDisplay());
        } else {
            sWTGraphics2D = new SWTGraphics2D(gC, (Device)this.getDisplay());
        }
        ((Graphics)sWTGraphics2D).setColor(Color.white);
        ((Graphics2D)sWTGraphics2D).setBackground(Color.white);
        Rectangle rectangle = this.getBounds();
        ((Graphics)sWTGraphics2D).fillRect(0, 0, rectangle.width, rectangle.height);
        if (PDebug.debugRegionManagement) {
            object = gC.getClipping();
            Rectangle2D.Double double_ = new Rectangle2D.Double(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
            ((Graphics2D)sWTGraphics2D).setBackground(PDebug.getDebugPaintColor());
            ((Graphics2D)sWTGraphics2D).fill(double_);
        }
        object = new PPaintContext(sWTGraphics2D);
        if (this.getInteracting() || this.getAnimating()) {
            if (this.interactingRenderQuality > this.animatingRenderQuality) {
                ((PPaintContext)object).setRenderQuality(this.interactingRenderQuality);
            } else {
                ((PPaintContext)object).setRenderQuality(this.animatingRenderQuality);
            }
        } else {
            ((PPaintContext)object).setRenderQuality(this.defaultRenderQuality);
        }
        this.camera.fullPaint((PPaintContext)object);
        if (!this.getAnimating() && this.animatingOnLastPaint) {
            this.repaint();
        }
        this.animatingOnLastPaint = this.getAnimating();
        boolean bl = PDebug.debugRegionManagement;
        PDebug.debugRegionManagement = false;
        PDebug.endProcessingOutput(sWTGraphics2D);
        PDebug.debugRegionManagement = bl;
        if (this.doubleBuffered) {
            gC.drawImage(this.backBuffer, 0, 0);
            gC2.dispose();
        }
    }

    public void paintImmediately() {
        if (this.paintingImmediately) {
            return;
        }
        this.paintingImmediately = true;
        this.redraw();
        this.update();
        this.paintingImmediately = false;
    }
}

