/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.str.StringTool;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.value.StringValue;

public class StringLiteral
extends Literal {
    public StringLiteral(StringValue value) {
        super(value);
    }

    public StringLiteral(UnicodeString value) {
        this(new StringValue(value));
    }

    public StringLiteral(String value) {
        this(new StringValue(StringTool.fromCharSequence(value)));
    }

    @Override
    public StringValue getGroundedValue() {
        return (StringValue)super.getGroundedValue();
    }

    public UnicodeString getString() {
        return this.getGroundedValue().getUnicodeStringValue();
    }

    public String stringify() {
        return this.getGroundedValue().getStringValue();
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        StringLiteral stringLiteral = new StringLiteral(this.getGroundedValue());
        ExpressionTool.copyLocationInfo(this, stringLiteral);
        return stringLiteral;
    }
}

