/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.xml.handlers;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class DelegateDefaultHandler
extends DefaultHandler {
    private final EntityResolver entityResolver;
    private final List<DTDHandler> dtdHandlers;
    private final List<ContentHandler> contentHandlers;
    private final List<ErrorHandler> errorHandlers;

    private DelegateDefaultHandler(Builder builder) {
        this.entityResolver = builder.entityResolver;
        this.dtdHandlers = ImmutableList.copyOf((Collection)builder.dtdHandlers);
        this.contentHandlers = ImmutableList.copyOf((Collection)builder.contentHandlers);
        this.errorHandlers = ImmutableList.copyOf((Collection)builder.errorHandlers);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (this.entityResolver != null) {
            return this.entityResolver.resolveEntity(publicId, systemId);
        }
        return null;
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        for (DTDHandler delegate : this.dtdHandlers) {
            delegate.notationDecl(name, publicId, systemId);
        }
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        for (DTDHandler delegate : this.dtdHandlers) {
            delegate.unparsedEntityDecl(name, publicId, systemId, notationName);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        for (ContentHandler delegate : this.contentHandlers) {
            delegate.setDocumentLocator(locator);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        for (ContentHandler delegate : this.contentHandlers) {
            delegate.startDocument();
        }
    }

    @Override
    public void endDocument() throws SAXException {
        for (ContentHandler delegate : this.contentHandlers) {
            delegate.endDocument();
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        for (ContentHandler delegate : this.contentHandlers) {
            delegate.startPrefixMapping(prefix, uri);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        for (ContentHandler delegate : this.contentHandlers) {
            delegate.endPrefixMapping(prefix);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        for (ContentHandler delegate : this.contentHandlers) {
            delegate.startElement(uri, localName, qName, atts);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        for (ContentHandler delegate : this.contentHandlers) {
            delegate.endElement(uri, localName, qName);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        for (ContentHandler delegate : this.contentHandlers) {
            delegate.characters(ch, start, length);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        for (ContentHandler delegate : this.contentHandlers) {
            delegate.ignorableWhitespace(ch, start, length);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        for (ContentHandler delegate : this.contentHandlers) {
            delegate.processingInstruction(target, data);
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        for (ContentHandler delegate : this.contentHandlers) {
            delegate.skippedEntity(name);
        }
    }

    @Override
    public void warning(SAXParseException ex) throws SAXException {
        for (ErrorHandler delegate : this.errorHandlers) {
            delegate.warning(ex);
        }
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        for (ErrorHandler delegate : this.errorHandlers) {
            delegate.error(ex);
        }
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        for (ErrorHandler delegate : this.errorHandlers) {
            delegate.fatalError(ex);
        }
    }

    public static final class Builder {
        private EntityResolver entityResolver = null;
        private final List<DTDHandler> dtdHandlers = new LinkedList<DTDHandler>();
        private final List<ContentHandler> contentHandlers = new LinkedList<ContentHandler>();
        private final List<ErrorHandler> errorHandlers = new LinkedList<ErrorHandler>();

        public void setEntityResolver(EntityResolver entityResolver) {
            this.entityResolver = entityResolver;
        }

        public void addDTDHandler(DTDHandler handler) {
            if (handler != null) {
                this.dtdHandlers.add(handler);
            }
        }

        public void addContentHandler(ContentHandler handler) {
            if (handler != null) {
                this.contentHandlers.add(handler);
            }
        }

        public void addErrorHandler(ErrorHandler handler) {
            if (handler != null) {
                this.errorHandlers.add(handler);
            }
        }

        public DelegateDefaultHandler build() {
            return new DelegateDefaultHandler(this);
        }
    }
}

