/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model.production;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.ProductionType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.production.ProductionUtils;
import net.sf.freecol.common.model.production.WorkerAssignment;
import net.sf.freecol.common.util.CollectionUtils;

public class BuildingProductionCalculator {
    private static final double EPSILON = 1.0E-4;
    private Player owner;
    private FeatureContainer colonyFeatureContainer;
    private int colonyProductionBonus;

    public BuildingProductionCalculator(Player owner, FeatureContainer colonyFeatureContainer, int colonyProductionBonus) {
        this.owner = owner;
        this.colonyFeatureContainer = colonyFeatureContainer;
        this.colonyProductionBonus = colonyProductionBonus;
    }

    public ProductionInfo getAdjustedProductionInfo(BuildingType buildingType, Turn turn, List<WorkerAssignment> workerAssignments, List<AbstractGoods> inputs, List<AbstractGoods> outputs, int warehouseCapacity) {
        GoodsType goodsType;
        ProductionInfo result = new ProductionInfo();
        List<AbstractGoods> buildingOutputs = this.getOutputs(buildingType, workerAssignments);
        if (buildingOutputs.isEmpty()) {
            return result;
        }
        List<AbstractGoods> buildingInputs = this.getInputs(buildingType, workerAssignments);
        Specification spec = buildingType.getSpecification();
        boolean avoidOverflow = buildingType.hasAbility("model.ability.avoidExcessProduction");
        double maximumRatio = 0.0;
        double minimumRatio = Double.MAX_VALUE;
        if (buildingType.hasAbility("model.ability.autoProduction")) {
            for (AbstractGoods output : CollectionUtils.transform(buildingOutputs.stream(), AbstractGoods::isPositive)) {
                goodsType = output.getType();
                int available = outputs.stream().filter(gt -> gt.getType().equals(goodsType)).findAny().map(AbstractGoods::getAmount).orElse(0);
                if (available >= warehouseCapacity) {
                    maximumRatio = 0.0;
                    minimumRatio = 0.0;
                    continue;
                }
                int divisor = (int)buildingType.apply(0.0f, turn, "model.modifier.breedingDivisor");
                int factor = (int)buildingType.apply(0.0f, turn, "model.modifier.breedingFactor");
                int production = available < goodsType.getBreedingNumber() || divisor <= 0 ? 0 : ((available - 1) / divisor + 1) * factor;
                double newRatio = (double)production / (double)output.getAmount();
                minimumRatio = Math.min(minimumRatio, newRatio);
                maximumRatio = Math.max(maximumRatio, newRatio);
            }
        } else {
            for (AbstractGoods output : buildingOutputs) {
                goodsType = output.getType();
                float production = this.determineProduction(buildingType, workerAssignments, turn, goodsType);
                double newRatio = production / (float)output.getAmount();
                minimumRatio = Math.min(minimumRatio, newRatio);
                maximumRatio = Math.max(maximumRatio, newRatio);
            }
        }
        for (AbstractGoods input : buildingInputs) {
            long minimumGoodsInput;
            long required = (long)Math.floor((double)input.getAmount() * minimumRatio);
            long available = this.getAvailable(input.getType(), inputs);
            if (buildingType.hasAbility("model.ability.autoProduction")) {
                available = Math.max(0L, available);
            }
            if (available < required && buildingType.hasAbility("model.ability.expertsUseConnections") && spec.getBoolean("model.option.expertsHaveConnections") && (minimumGoodsInput = (long)(buildingType.getExpertConnectionProduction() * CollectionUtils.count(workerAssignments.stream().map(WorkerAssignment::getUnitType), CollectionUtils.matchKey(this.getExpertUnitType(buildingType))))) > available) {
                available = minimumGoodsInput;
            }
            if (available >= required) continue;
            minimumRatio *= (double)available / (double)required;
        }
        if (avoidOverflow) {
            for (AbstractGoods output : buildingOutputs) {
                double production = (double)output.getAmount() * minimumRatio;
                if (production <= 0.0) continue;
                double headroom = (double)warehouseCapacity - (double)this.getAvailable(output.getType(), outputs);
                if (production > headroom) {
                    minimumRatio = Math.min(minimumRatio, headroom / (double)output.getAmount());
                }
                if (!((production = (double)output.getAmount() * maximumRatio) > headroom)) continue;
                maximumRatio = Math.min(maximumRatio, headroom / (double)output.getAmount());
            }
        }
        for (AbstractGoods input : buildingInputs) {
            GoodsType type = input.getType();
            int consumption = (int)Math.floor((double)input.getAmount() * minimumRatio + 1.0E-4);
            int maximumConsumption = (int)Math.floor((double)input.getAmount() * maximumRatio);
            result.addConsumption(new AbstractGoods(type, consumption));
            if (consumption >= maximumConsumption) continue;
            result.addMaximumConsumption(new AbstractGoods(type, maximumConsumption));
        }
        for (AbstractGoods output : buildingOutputs) {
            GoodsType type = output.getType();
            int production = (int)Math.floor((double)output.getAmount() * minimumRatio + 1.0E-4);
            int maximumProduction = (int)Math.floor((double)output.getAmount() * maximumRatio);
            result.addProduction(new AbstractGoods(type, production));
            if (production >= maximumProduction) continue;
            result.addMaximumProduction(new AbstractGoods(type, maximumProduction));
        }
        return result;
    }

    public UnitType getExpertUnitType(BuildingType buildingType) {
        Specification spec = buildingType.getSpecification();
        ProductionType pt = this.getBestProductionType(buildingType);
        return pt == null ? null : CollectionUtils.find(CollectionUtils.map(pt.getOutputs(), ag -> spec.getExpertForProducing(ag.getType())), CollectionUtils.isNotNull());
    }

    private ProductionType getBestProductionType(BuildingType buildingType) {
        return ProductionType.getBestProductionType(null, buildingType.getAvailableProductionTypes(false));
    }

    private List<AbstractGoods> getOutputs(BuildingType buildingType, List<WorkerAssignment> workerAssignments) {
        List unattendedOutputs = buildingType.getAvailableProductionTypes(true).stream().map(pt -> pt.getOutputList()).flatMap(Collection::stream).collect(Collectors.toList());
        List workerOutputs = workerAssignments.stream().map(WorkerAssignment::getProductionType).filter(Objects::nonNull).map(pt -> pt.getOutputList()).flatMap(Collection::stream).collect(Collectors.toList());
        ArrayList allOutputs = new ArrayList(unattendedOutputs);
        allOutputs.addAll(workerOutputs);
        HashMap<GoodsType, Integer> amounts = new HashMap<GoodsType, Integer>();
        for (AbstractGoods ag : allOutputs) {
            if (amounts.get(ag.getType()) == null) {
                amounts.put(ag.getType(), 0);
            }
            amounts.put(ag.getType(), (Integer)amounts.get(ag.getType()) + ag.getAmount());
        }
        return amounts.entrySet().stream().map(e -> new AbstractGoods((GoodsType)e.getKey(), (Integer)e.getValue())).collect(Collectors.toList());
    }

    private List<AbstractGoods> getInputs(BuildingType buildingType, List<WorkerAssignment> workerAssignments) {
        List unattendedInputs = buildingType.getAvailableProductionTypes(true).stream().map(pt -> pt.getInputList()).flatMap(Collection::stream).collect(Collectors.toList());
        List workerInputs = workerAssignments.stream().map(WorkerAssignment::getProductionType).filter(Objects::nonNull).map(pt -> pt.getInputList()).flatMap(Collection::stream).collect(Collectors.toList());
        ArrayList allInputs = new ArrayList(unattendedInputs);
        allInputs.addAll(workerInputs);
        HashMap<GoodsType, Integer> amounts = new HashMap<GoodsType, Integer>();
        for (AbstractGoods ag : allInputs) {
            if (amounts.get(ag.getType()) == null) {
                amounts.put(ag.getType(), 0);
            }
            amounts.put(ag.getType(), (Integer)amounts.get(ag.getType()) + ag.getAmount());
        }
        return amounts.entrySet().stream().map(e -> new AbstractGoods((GoodsType)e.getKey(), (Integer)e.getValue())).collect(Collectors.toList());
    }

    private int determineProduction(BuildingType buildingType, List<WorkerAssignment> workerAssignments, Turn turn, GoodsType goodsType) {
        float production = CollectionUtils.sum(workerAssignments, wa -> this.getUnitProduction(turn, buildingType, (WorkerAssignment)wa, goodsType));
        production += (float)this.getBaseProduction(buildingType, null, goodsType, null);
        production = FeatureContainer.applyModifiers(production, turn, this.getProductionModifiers(turn, buildingType, goodsType, null));
        return (int)Math.floor(production);
    }

    private int getAvailable(GoodsType type, List<AbstractGoods> available) {
        return AbstractGoods.getCount(type, available);
    }

    private int getUnitProduction(Turn turn, BuildingType buildingType, WorkerAssignment workerAssignment, GoodsType goodsType) {
        if (workerAssignment == null || workerAssignment.getProductionType().getOutputs().noneMatch(g -> goodsType.equals(g.getType()))) {
            return 0;
        }
        return Math.max(0, (int)FeatureContainer.applyModifiers((float)this.getBaseProduction(buildingType, workerAssignment.getProductionType(), goodsType, workerAssignment.getUnitType()), turn, this.getProductionModifiers(turn, buildingType, goodsType, workerAssignment.getUnitType())));
    }

    private int getBaseProduction(BuildingType buildingType, ProductionType productionType, GoodsType goodsType, UnitType unitType) {
        return buildingType == null ? 0 : buildingType.getBaseProduction(productionType, goodsType, unitType);
    }

    private Stream<Modifier> getProductionModifiers(Turn turn, BuildingType buildingType, GoodsType goodsType, UnitType unitType) {
        String id;
        String string = id = goodsType == null ? null : goodsType.getId();
        return unitType != null ? CollectionUtils.concat(buildingType.getModifiers(id, unitType, turn), ProductionUtils.getRebelProductionModifiersForBuilding(buildingType, this.colonyProductionBonus, goodsType, unitType), buildingType.getCompetenceModifiers(id, unitType, turn), this.owner == null ? null : this.owner.getModifiers(id, unitType, turn)) : CollectionUtils.concat(this.colonyFeatureContainer.getModifiers(id, buildingType, turn), this.owner == null ? null : this.owner.getModifiers(id, buildingType, turn));
    }
}

