"""Generated client library for bigquerydatatransfer version v1."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.generated_clients.apis.bigquerydatatransfer.v1 import bigquerydatatransfer_v1_messages as messages


class BigquerydatatransferV1(base_api.BaseApiClient):
  """Generated client library for service bigquerydatatransfer version v1."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://bigquerydatatransfer.googleapis.com/'
  MTLS_BASE_URL = 'https://bigquerydatatransfer.mtls.googleapis.com/'

  _PACKAGE = 'bigquerydatatransfer'
  _SCOPES = ['https://www.googleapis.com/auth/bigquery', 'https://www.googleapis.com/auth/cloud-platform', 'https://www.googleapis.com/auth/cloud-platform.read-only']
  _VERSION = 'v1'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'BigquerydatatransferV1'
  _URL_VERSION = 'v1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new bigquerydatatransfer handle."""
    url = url or self.BASE_URL
    super(BigquerydatatransferV1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_dataSources = self.ProjectsDataSourcesService(self)
    self.projects_locations_dataSources = self.ProjectsLocationsDataSourcesService(self)
    self.projects_locations_transferConfigs_runs_transferLogs = self.ProjectsLocationsTransferConfigsRunsTransferLogsService(self)
    self.projects_locations_transferConfigs_runs = self.ProjectsLocationsTransferConfigsRunsService(self)
    self.projects_locations_transferConfigs = self.ProjectsLocationsTransferConfigsService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects_transferConfigs_runs_transferLogs = self.ProjectsTransferConfigsRunsTransferLogsService(self)
    self.projects_transferConfigs_runs = self.ProjectsTransferConfigsRunsService(self)
    self.projects_transferConfigs = self.ProjectsTransferConfigsService(self)
    self.projects = self.ProjectsService(self)

  class ProjectsDataSourcesService(base_api.BaseApiService):
    """Service class for the projects_dataSources resource."""

    _NAME = 'projects_dataSources'

    def __init__(self, client):
      super(BigquerydatatransferV1.ProjectsDataSourcesService, self).__init__(client)
      self._upload_configs = {
          }

    def CheckValidCreds(self, request, global_params=None):
      r"""Returns true if valid credentials exist for the given data source and requesting user.

      Args:
        request: (BigquerydatatransferProjectsDataSourcesCheckValidCredsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CheckValidCredsResponse) The response message.
      """
      config = self.GetMethodConfig('CheckValidCreds')
      return self._RunMethod(
          config, request, global_params=global_params)

    CheckValidCreds.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/dataSources/{dataSourcesId}:checkValidCreds',
        http_method='POST',
        method_id='bigquerydatatransfer.projects.dataSources.checkValidCreds',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:checkValidCreds',
        request_field='checkValidCredsRequest',
        request_type_name='BigquerydatatransferProjectsDataSourcesCheckValidCredsRequest',
        response_type_name='CheckValidCredsResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves a supported data source and returns its settings.

      Args:
        request: (BigquerydatatransferProjectsDataSourcesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DataSource) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/dataSources/{dataSourcesId}',
        http_method='GET',
        method_id='bigquerydatatransfer.projects.dataSources.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='BigquerydatatransferProjectsDataSourcesGetRequest',
        response_type_name='DataSource',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists supported data sources and returns their settings.

      Args:
        request: (BigquerydatatransferProjectsDataSourcesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListDataSourcesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/dataSources',
        http_method='GET',
        method_id='bigquerydatatransfer.projects.dataSources.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1/{+parent}/dataSources',
        request_field='',
        request_type_name='BigquerydatatransferProjectsDataSourcesListRequest',
        response_type_name='ListDataSourcesResponse',
        supports_download=False,
    )

  class ProjectsLocationsDataSourcesService(base_api.BaseApiService):
    """Service class for the projects_locations_dataSources resource."""

    _NAME = 'projects_locations_dataSources'

    def __init__(self, client):
      super(BigquerydatatransferV1.ProjectsLocationsDataSourcesService, self).__init__(client)
      self._upload_configs = {
          }

    def CheckValidCreds(self, request, global_params=None):
      r"""Returns true if valid credentials exist for the given data source and requesting user.

      Args:
        request: (BigquerydatatransferProjectsLocationsDataSourcesCheckValidCredsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CheckValidCredsResponse) The response message.
      """
      config = self.GetMethodConfig('CheckValidCreds')
      return self._RunMethod(
          config, request, global_params=global_params)

    CheckValidCreds.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/dataSources/{dataSourcesId}:checkValidCreds',
        http_method='POST',
        method_id='bigquerydatatransfer.projects.locations.dataSources.checkValidCreds',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:checkValidCreds',
        request_field='checkValidCredsRequest',
        request_type_name='BigquerydatatransferProjectsLocationsDataSourcesCheckValidCredsRequest',
        response_type_name='CheckValidCredsResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves a supported data source and returns its settings.

      Args:
        request: (BigquerydatatransferProjectsLocationsDataSourcesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DataSource) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/dataSources/{dataSourcesId}',
        http_method='GET',
        method_id='bigquerydatatransfer.projects.locations.dataSources.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='BigquerydatatransferProjectsLocationsDataSourcesGetRequest',
        response_type_name='DataSource',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists supported data sources and returns their settings.

      Args:
        request: (BigquerydatatransferProjectsLocationsDataSourcesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListDataSourcesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/dataSources',
        http_method='GET',
        method_id='bigquerydatatransfer.projects.locations.dataSources.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1/{+parent}/dataSources',
        request_field='',
        request_type_name='BigquerydatatransferProjectsLocationsDataSourcesListRequest',
        response_type_name='ListDataSourcesResponse',
        supports_download=False,
    )

  class ProjectsLocationsTransferConfigsRunsTransferLogsService(base_api.BaseApiService):
    """Service class for the projects_locations_transferConfigs_runs_transferLogs resource."""

    _NAME = 'projects_locations_transferConfigs_runs_transferLogs'

    def __init__(self, client):
      super(BigquerydatatransferV1.ProjectsLocationsTransferConfigsRunsTransferLogsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Returns log messages for the transfer run.

      Args:
        request: (BigquerydatatransferProjectsLocationsTransferConfigsRunsTransferLogsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListTransferLogsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/transferConfigs/{transferConfigsId}/runs/{runsId}/transferLogs',
        http_method='GET',
        method_id='bigquerydatatransfer.projects.locations.transferConfigs.runs.transferLogs.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['messageTypes', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/transferLogs',
        request_field='',
        request_type_name='BigquerydatatransferProjectsLocationsTransferConfigsRunsTransferLogsListRequest',
        response_type_name='ListTransferLogsResponse',
        supports_download=False,
    )

  class ProjectsLocationsTransferConfigsRunsService(base_api.BaseApiService):
    """Service class for the projects_locations_transferConfigs_runs resource."""

    _NAME = 'projects_locations_transferConfigs_runs'

    def __init__(self, client):
      super(BigquerydatatransferV1.ProjectsLocationsTransferConfigsRunsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified transfer run.

      Args:
        request: (BigquerydatatransferProjectsLocationsTransferConfigsRunsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/transferConfigs/{transferConfigsId}/runs/{runsId}',
        http_method='DELETE',
        method_id='bigquerydatatransfer.projects.locations.transferConfigs.runs.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='BigquerydatatransferProjectsLocationsTransferConfigsRunsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns information about the particular transfer run.

      Args:
        request: (BigquerydatatransferProjectsLocationsTransferConfigsRunsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TransferRun) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/transferConfigs/{transferConfigsId}/runs/{runsId}',
        http_method='GET',
        method_id='bigquerydatatransfer.projects.locations.transferConfigs.runs.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='BigquerydatatransferProjectsLocationsTransferConfigsRunsGetRequest',
        response_type_name='TransferRun',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Returns information about running and completed transfer runs.

      Args:
        request: (BigquerydatatransferProjectsLocationsTransferConfigsRunsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListTransferRunsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/transferConfigs/{transferConfigsId}/runs',
        http_method='GET',
        method_id='bigquerydatatransfer.projects.locations.transferConfigs.runs.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken', 'runAttempt', 'states'],
        relative_path='v1/{+parent}/runs',
        request_field='',
        request_type_name='BigquerydatatransferProjectsLocationsTransferConfigsRunsListRequest',
        response_type_name='ListTransferRunsResponse',
        supports_download=False,
    )

  class ProjectsLocationsTransferConfigsService(base_api.BaseApiService):
    """Service class for the projects_locations_transferConfigs resource."""

    _NAME = 'projects_locations_transferConfigs'

    def __init__(self, client):
      super(BigquerydatatransferV1.ProjectsLocationsTransferConfigsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new data transfer configuration.

      Args:
        request: (BigquerydatatransferProjectsLocationsTransferConfigsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TransferConfig) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/transferConfigs',
        http_method='POST',
        method_id='bigquerydatatransfer.projects.locations.transferConfigs.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['authorizationCode', 'serviceAccountName', 'versionInfo'],
        relative_path='v1/{+parent}/transferConfigs',
        request_field='transferConfig',
        request_type_name='BigquerydatatransferProjectsLocationsTransferConfigsCreateRequest',
        response_type_name='TransferConfig',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a data transfer configuration, including any associated transfer runs and logs.

      Args:
        request: (BigquerydatatransferProjectsLocationsTransferConfigsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/transferConfigs/{transferConfigsId}',
        http_method='DELETE',
        method_id='bigquerydatatransfer.projects.locations.transferConfigs.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='BigquerydatatransferProjectsLocationsTransferConfigsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns information about a data transfer config.

      Args:
        request: (BigquerydatatransferProjectsLocationsTransferConfigsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TransferConfig) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/transferConfigs/{transferConfigsId}',
        http_method='GET',
        method_id='bigquerydatatransfer.projects.locations.transferConfigs.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='BigquerydatatransferProjectsLocationsTransferConfigsGetRequest',
        response_type_name='TransferConfig',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Returns information about all transfer configs owned by a project in the specified location.

      Args:
        request: (BigquerydatatransferProjectsLocationsTransferConfigsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListTransferConfigsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/transferConfigs',
        http_method='GET',
        method_id='bigquerydatatransfer.projects.locations.transferConfigs.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['dataSourceIds', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/transferConfigs',
        request_field='',
        request_type_name='BigquerydatatransferProjectsLocationsTransferConfigsListRequest',
        response_type_name='ListTransferConfigsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a data transfer configuration. All fields must be set, even if they are not updated.

      Args:
        request: (BigquerydatatransferProjectsLocationsTransferConfigsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TransferConfig) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/transferConfigs/{transferConfigsId}',
        http_method='PATCH',
        method_id='bigquerydatatransfer.projects.locations.transferConfigs.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['authorizationCode', 'serviceAccountName', 'updateMask', 'versionInfo'],
        relative_path='v1/{+name}',
        request_field='transferConfig',
        request_type_name='BigquerydatatransferProjectsLocationsTransferConfigsPatchRequest',
        response_type_name='TransferConfig',
        supports_download=False,
    )

    def ScheduleRuns(self, request, global_params=None):
      r"""Creates transfer runs for a time range [start_time, end_time]. For each date - or whatever granularity the data source supports - in the range, one transfer run is created. Note that runs are created per UTC time in the time range. DEPRECATED: use StartManualTransferRuns instead.

      Args:
        request: (BigquerydatatransferProjectsLocationsTransferConfigsScheduleRunsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ScheduleTransferRunsResponse) The response message.
      """
      config = self.GetMethodConfig('ScheduleRuns')
      return self._RunMethod(
          config, request, global_params=global_params)

    ScheduleRuns.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/transferConfigs/{transferConfigsId}:scheduleRuns',
        http_method='POST',
        method_id='bigquerydatatransfer.projects.locations.transferConfigs.scheduleRuns',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}:scheduleRuns',
        request_field='scheduleTransferRunsRequest',
        request_type_name='BigquerydatatransferProjectsLocationsTransferConfigsScheduleRunsRequest',
        response_type_name='ScheduleTransferRunsResponse',
        supports_download=False,
    )

    def StartManualRuns(self, request, global_params=None):
      r"""Start manual transfer runs to be executed now with schedule_time equal to current time. The transfer runs can be created for a time range where the run_time is between start_time (inclusive) and end_time (exclusive), or for a specific run_time.

      Args:
        request: (BigquerydatatransferProjectsLocationsTransferConfigsStartManualRunsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (StartManualTransferRunsResponse) The response message.
      """
      config = self.GetMethodConfig('StartManualRuns')
      return self._RunMethod(
          config, request, global_params=global_params)

    StartManualRuns.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/transferConfigs/{transferConfigsId}:startManualRuns',
        http_method='POST',
        method_id='bigquerydatatransfer.projects.locations.transferConfigs.startManualRuns',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}:startManualRuns',
        request_field='startManualTransferRunsRequest',
        request_type_name='BigquerydatatransferProjectsLocationsTransferConfigsStartManualRunsRequest',
        response_type_name='StartManualTransferRunsResponse',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = 'projects_locations'

    def __init__(self, client):
      super(BigquerydatatransferV1.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def EnrollDataSources(self, request, global_params=None):
      r"""Enroll data sources in a user project. This allows users to create transfer configurations for these data sources. They will also appear in the ListDataSources RPC and as such, will appear in the [BigQuery UI](https://console.cloud.google.com/bigquery), and the documents can be found in the public guide for [BigQuery Web UI](https://cloud.google.com/bigquery/bigquery-web-ui) and [Data Transfer Service](https://cloud.google.com/bigquery/docs/working-with-transfers).

      Args:
        request: (BigquerydatatransferProjectsLocationsEnrollDataSourcesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('EnrollDataSources')
      return self._RunMethod(
          config, request, global_params=global_params)

    EnrollDataSources.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}:enrollDataSources',
        http_method='POST',
        method_id='bigquerydatatransfer.projects.locations.enrollDataSources',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:enrollDataSources',
        request_field='enrollDataSourcesRequest',
        request_type_name='BigquerydatatransferProjectsLocationsEnrollDataSourcesRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets information about a location.

      Args:
        request: (BigquerydatatransferProjectsLocationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Location) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}',
        http_method='GET',
        method_id='bigquerydatatransfer.projects.locations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='BigquerydatatransferProjectsLocationsGetRequest',
        response_type_name='Location',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists information about the supported locations for this service.

      Args:
        request: (BigquerydatatransferProjectsLocationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLocationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations',
        http_method='GET',
        method_id='bigquerydatatransfer.projects.locations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1/{+name}/locations',
        request_field='',
        request_type_name='BigquerydatatransferProjectsLocationsListRequest',
        response_type_name='ListLocationsResponse',
        supports_download=False,
    )

    def UnenrollDataSources(self, request, global_params=None):
      r"""Unenroll data sources in a user project. This allows users to remove transfer configurations for these data sources. They will no longer appear in the ListDataSources RPC and will also no longer appear in the [BigQuery UI](https://console.cloud.google.com/bigquery). Data transfers configurations of unenrolled data sources will not be scheduled.

      Args:
        request: (BigquerydatatransferProjectsLocationsUnenrollDataSourcesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('UnenrollDataSources')
      return self._RunMethod(
          config, request, global_params=global_params)

    UnenrollDataSources.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}:unenrollDataSources',
        http_method='POST',
        method_id='bigquerydatatransfer.projects.locations.unenrollDataSources',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:unenrollDataSources',
        request_field='unenrollDataSourcesRequest',
        request_type_name='BigquerydatatransferProjectsLocationsUnenrollDataSourcesRequest',
        response_type_name='Empty',
        supports_download=False,
    )

  class ProjectsTransferConfigsRunsTransferLogsService(base_api.BaseApiService):
    """Service class for the projects_transferConfigs_runs_transferLogs resource."""

    _NAME = 'projects_transferConfigs_runs_transferLogs'

    def __init__(self, client):
      super(BigquerydatatransferV1.ProjectsTransferConfigsRunsTransferLogsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Returns log messages for the transfer run.

      Args:
        request: (BigquerydatatransferProjectsTransferConfigsRunsTransferLogsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListTransferLogsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/transferConfigs/{transferConfigsId}/runs/{runsId}/transferLogs',
        http_method='GET',
        method_id='bigquerydatatransfer.projects.transferConfigs.runs.transferLogs.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['messageTypes', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/transferLogs',
        request_field='',
        request_type_name='BigquerydatatransferProjectsTransferConfigsRunsTransferLogsListRequest',
        response_type_name='ListTransferLogsResponse',
        supports_download=False,
    )

  class ProjectsTransferConfigsRunsService(base_api.BaseApiService):
    """Service class for the projects_transferConfigs_runs resource."""

    _NAME = 'projects_transferConfigs_runs'

    def __init__(self, client):
      super(BigquerydatatransferV1.ProjectsTransferConfigsRunsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified transfer run.

      Args:
        request: (BigquerydatatransferProjectsTransferConfigsRunsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/transferConfigs/{transferConfigsId}/runs/{runsId}',
        http_method='DELETE',
        method_id='bigquerydatatransfer.projects.transferConfigs.runs.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='BigquerydatatransferProjectsTransferConfigsRunsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns information about the particular transfer run.

      Args:
        request: (BigquerydatatransferProjectsTransferConfigsRunsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TransferRun) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/transferConfigs/{transferConfigsId}/runs/{runsId}',
        http_method='GET',
        method_id='bigquerydatatransfer.projects.transferConfigs.runs.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='BigquerydatatransferProjectsTransferConfigsRunsGetRequest',
        response_type_name='TransferRun',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Returns information about running and completed transfer runs.

      Args:
        request: (BigquerydatatransferProjectsTransferConfigsRunsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListTransferRunsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/transferConfigs/{transferConfigsId}/runs',
        http_method='GET',
        method_id='bigquerydatatransfer.projects.transferConfigs.runs.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken', 'runAttempt', 'states'],
        relative_path='v1/{+parent}/runs',
        request_field='',
        request_type_name='BigquerydatatransferProjectsTransferConfigsRunsListRequest',
        response_type_name='ListTransferRunsResponse',
        supports_download=False,
    )

  class ProjectsTransferConfigsService(base_api.BaseApiService):
    """Service class for the projects_transferConfigs resource."""

    _NAME = 'projects_transferConfigs'

    def __init__(self, client):
      super(BigquerydatatransferV1.ProjectsTransferConfigsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new data transfer configuration.

      Args:
        request: (BigquerydatatransferProjectsTransferConfigsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TransferConfig) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/transferConfigs',
        http_method='POST',
        method_id='bigquerydatatransfer.projects.transferConfigs.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['authorizationCode', 'serviceAccountName', 'versionInfo'],
        relative_path='v1/{+parent}/transferConfigs',
        request_field='transferConfig',
        request_type_name='BigquerydatatransferProjectsTransferConfigsCreateRequest',
        response_type_name='TransferConfig',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a data transfer configuration, including any associated transfer runs and logs.

      Args:
        request: (BigquerydatatransferProjectsTransferConfigsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/transferConfigs/{transferConfigsId}',
        http_method='DELETE',
        method_id='bigquerydatatransfer.projects.transferConfigs.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='BigquerydatatransferProjectsTransferConfigsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns information about a data transfer config.

      Args:
        request: (BigquerydatatransferProjectsTransferConfigsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TransferConfig) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/transferConfigs/{transferConfigsId}',
        http_method='GET',
        method_id='bigquerydatatransfer.projects.transferConfigs.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='BigquerydatatransferProjectsTransferConfigsGetRequest',
        response_type_name='TransferConfig',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Returns information about all transfer configs owned by a project in the specified location.

      Args:
        request: (BigquerydatatransferProjectsTransferConfigsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListTransferConfigsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/transferConfigs',
        http_method='GET',
        method_id='bigquerydatatransfer.projects.transferConfigs.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['dataSourceIds', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/transferConfigs',
        request_field='',
        request_type_name='BigquerydatatransferProjectsTransferConfigsListRequest',
        response_type_name='ListTransferConfigsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a data transfer configuration. All fields must be set, even if they are not updated.

      Args:
        request: (BigquerydatatransferProjectsTransferConfigsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TransferConfig) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/transferConfigs/{transferConfigsId}',
        http_method='PATCH',
        method_id='bigquerydatatransfer.projects.transferConfigs.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['authorizationCode', 'serviceAccountName', 'updateMask', 'versionInfo'],
        relative_path='v1/{+name}',
        request_field='transferConfig',
        request_type_name='BigquerydatatransferProjectsTransferConfigsPatchRequest',
        response_type_name='TransferConfig',
        supports_download=False,
    )

    def ScheduleRuns(self, request, global_params=None):
      r"""Creates transfer runs for a time range [start_time, end_time]. For each date - or whatever granularity the data source supports - in the range, one transfer run is created. Note that runs are created per UTC time in the time range. DEPRECATED: use StartManualTransferRuns instead.

      Args:
        request: (BigquerydatatransferProjectsTransferConfigsScheduleRunsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ScheduleTransferRunsResponse) The response message.
      """
      config = self.GetMethodConfig('ScheduleRuns')
      return self._RunMethod(
          config, request, global_params=global_params)

    ScheduleRuns.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/transferConfigs/{transferConfigsId}:scheduleRuns',
        http_method='POST',
        method_id='bigquerydatatransfer.projects.transferConfigs.scheduleRuns',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}:scheduleRuns',
        request_field='scheduleTransferRunsRequest',
        request_type_name='BigquerydatatransferProjectsTransferConfigsScheduleRunsRequest',
        response_type_name='ScheduleTransferRunsResponse',
        supports_download=False,
    )

    def StartManualRuns(self, request, global_params=None):
      r"""Start manual transfer runs to be executed now with schedule_time equal to current time. The transfer runs can be created for a time range where the run_time is between start_time (inclusive) and end_time (exclusive), or for a specific run_time.

      Args:
        request: (BigquerydatatransferProjectsTransferConfigsStartManualRunsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (StartManualTransferRunsResponse) The response message.
      """
      config = self.GetMethodConfig('StartManualRuns')
      return self._RunMethod(
          config, request, global_params=global_params)

    StartManualRuns.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/transferConfigs/{transferConfigsId}:startManualRuns',
        http_method='POST',
        method_id='bigquerydatatransfer.projects.transferConfigs.startManualRuns',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}:startManualRuns',
        request_field='startManualTransferRunsRequest',
        request_type_name='BigquerydatatransferProjectsTransferConfigsStartManualRunsRequest',
        response_type_name='StartManualTransferRunsResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(BigquerydatatransferV1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }

    def EnrollDataSources(self, request, global_params=None):
      r"""Enroll data sources in a user project. This allows users to create transfer configurations for these data sources. They will also appear in the ListDataSources RPC and as such, will appear in the [BigQuery UI](https://console.cloud.google.com/bigquery), and the documents can be found in the public guide for [BigQuery Web UI](https://cloud.google.com/bigquery/bigquery-web-ui) and [Data Transfer Service](https://cloud.google.com/bigquery/docs/working-with-transfers).

      Args:
        request: (BigquerydatatransferProjectsEnrollDataSourcesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('EnrollDataSources')
      return self._RunMethod(
          config, request, global_params=global_params)

    EnrollDataSources.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}:enrollDataSources',
        http_method='POST',
        method_id='bigquerydatatransfer.projects.enrollDataSources',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:enrollDataSources',
        request_field='enrollDataSourcesRequest',
        request_type_name='BigquerydatatransferProjectsEnrollDataSourcesRequest',
        response_type_name='Empty',
        supports_download=False,
    )
