/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.AbstractProperty;
import org.gradle.api.internal.provider.ManagedFactories;
import org.gradle.api.internal.provider.MapCollector;
import org.gradle.api.internal.provider.MapCollectors;
import org.gradle.api.internal.provider.MapEntryCollector;
import org.gradle.api.internal.provider.MapProviderInternal;
import org.gradle.api.internal.provider.MapSupplier;
import org.gradle.api.internal.provider.PropertyHost;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.provider.ValidatingMapEntryCollector;
import org.gradle.api.internal.provider.ValidatingValueCollector;
import org.gradle.api.internal.provider.ValueCollector;
import org.gradle.api.internal.provider.ValueSanitizers;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Cast;

public class DefaultMapProperty<K, V>
extends AbstractProperty<Map<K, V>, MapSupplier<K, V>>
implements MapProperty<K, V>,
MapProviderInternal<K, V> {
    private static final String NULL_KEY_FORBIDDEN_MESSAGE = String.format("Cannot add an entry with a null key to a property of type %s.", Map.class.getSimpleName());
    private static final String NULL_VALUE_FORBIDDEN_MESSAGE = String.format("Cannot add an entry with a null value to a property of type %s.", Map.class.getSimpleName());
    private static final MapSupplier<Object, Object> NO_VALUE = new NoValueSupplier<Object, Object>(ValueSupplier.Value.missing());
    private final Class<K> keyType;
    private final Class<V> valueType;
    private final ValueCollector<K> keyCollector;
    private final MapEntryCollector<K, V> entryCollector;
    private MapSupplier<K, V> defaultValue = this.emptySupplier();

    public DefaultMapProperty(PropertyHost propertyHost, Class<K> keyType, Class<V> valueType) {
        super(propertyHost);
        this.keyType = keyType;
        this.valueType = valueType;
        this.keyCollector = new ValidatingValueCollector<K>(Set.class, keyType, ValueSanitizers.forType(keyType));
        this.entryCollector = new ValidatingMapEntryCollector<K, V>(keyType, valueType, ValueSanitizers.forType(keyType), ValueSanitizers.forType(valueType));
        this.init(this.defaultValue, this.noValueSupplier());
    }

    private MapSupplier<K, V> emptySupplier() {
        return new EmptySupplier();
    }

    private MapSupplier<K, V> noValueSupplier() {
        return (MapSupplier)Cast.uncheckedCast(NO_VALUE);
    }

    @Override
    @Nullable
    public Class<Map<K, V>> getType() {
        return Map.class;
    }

    @Override
    public Class<K> getKeyType() {
        return this.keyType;
    }

    @Override
    public Class<V> getValueType() {
        return this.valueType;
    }

    @Override
    public Class<?> publicType() {
        return MapProperty.class;
    }

    @Override
    public int getFactoryId() {
        return ManagedFactories.MapPropertyManagedFactory.FACTORY_ID;
    }

    public Provider<V> getting(K key) {
        return new EntryProvider(key);
    }

    public MapProperty<K, V> empty() {
        this.setSupplier(this.emptySupplier());
        return this;
    }

    @Override
    public void setFromAnyValue(@Nullable Object object) {
        if (object == null || object instanceof Map) {
            this.set((Map)object);
        } else if (object instanceof Provider) {
            this.set((Provider)object);
        } else {
            throw new IllegalArgumentException(String.format("Cannot set the value of a property of type %s using an instance of type %s.", Map.class.getName(), object.getClass().getName()));
        }
    }

    public void set(@Nullable Map<? extends K, ? extends V> entries) {
        if (entries == null) {
            this.discardValue();
            this.defaultValue = this.noValueSupplier();
        } else {
            this.setSupplier(new CollectingSupplier(new MapCollectors.EntriesFromMap<K, V>(entries)));
        }
    }

    public void set(Provider<? extends Map<? extends K, ? extends V>> provider) {
        ProviderInternal<Map<K, V>> p = this.checkMapProvider(provider);
        this.setSupplier(new CollectingSupplier(new MapCollectors.EntriesFromMapProvider<K, V>(p)));
    }

    public MapProperty<K, V> value(@Nullable Map<? extends K, ? extends V> entries) {
        this.set(entries);
        return this;
    }

    public MapProperty<K, V> value(Provider<? extends Map<? extends K, ? extends V>> provider) {
        this.set(provider);
        return this;
    }

    public void put(K key, V value) {
        Preconditions.checkNotNull(key, (Object)NULL_KEY_FORBIDDEN_MESSAGE);
        Preconditions.checkNotNull(value, (Object)NULL_VALUE_FORBIDDEN_MESSAGE);
        this.addCollector(new MapCollectors.SingleEntry<K, V>(key, value));
    }

    public void put(K key, Provider<? extends V> providerOfValue) {
        Preconditions.checkNotNull(key, (Object)NULL_KEY_FORBIDDEN_MESSAGE);
        Preconditions.checkNotNull(providerOfValue, (Object)NULL_VALUE_FORBIDDEN_MESSAGE);
        ProviderInternal<V> p = Providers.internal(providerOfValue);
        if (p.getType() != null && !this.valueType.isAssignableFrom(p.getType())) {
            throw new IllegalArgumentException(String.format("Cannot add an entry to a property of type %s with values of type %s using a provider of type %s.", Map.class.getName(), this.valueType.getName(), p.getType().getName()));
        }
        this.addCollector(new MapCollectors.EntryWithValueFromProvider<K, V>(key, p));
    }

    public void putAll(Map<? extends K, ? extends V> entries) {
        this.addCollector(new MapCollectors.EntriesFromMap<K, V>(entries));
    }

    public void putAll(Provider<? extends Map<? extends K, ? extends V>> provider) {
        ProviderInternal<Map<K, V>> p = this.checkMapProvider(provider);
        this.addCollector(new MapCollectors.EntriesFromMapProvider<K, V>(p));
    }

    private void addCollector(MapCollector<K, V> collector) {
        this.assertCanMutate();
        this.setSupplier(this.getExplicitValue(this.defaultValue).plus(collector));
    }

    private ProviderInternal<? extends Map<? extends K, ? extends V>> checkMapProvider(@Nullable Provider<? extends Map<? extends K, ? extends V>> provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Cannot set the value of a property using a null provider.");
        }
        ProviderInternal<Map<K, V>> p = Providers.internal(provider);
        if (p.getType() != null && !Map.class.isAssignableFrom(p.getType())) {
            throw new IllegalArgumentException(String.format("Cannot set the value of a property of type %s using a provider of type %s.", Map.class.getName(), p.getType().getName()));
        }
        if (p instanceof MapProviderInternal) {
            Class providerKeyType = ((MapProviderInternal)p).getKeyType();
            Class providerValueType = ((MapProviderInternal)p).getValueType();
            if (!this.keyType.isAssignableFrom(providerKeyType) || !this.valueType.isAssignableFrom(providerValueType)) {
                throw new IllegalArgumentException(String.format("Cannot set the value of a property of type %s with key type %s and value type %s using a provider with key type %s and value type %s.", Map.class.getName(), this.keyType.getName(), this.valueType.getName(), providerKeyType.getName(), providerValueType.getName()));
            }
        }
        return p;
    }

    public MapProperty<K, V> convention(@Nullable Map<? extends K, ? extends V> value) {
        if (value == null) {
            this.setConvention(this.noValueSupplier());
        } else {
            this.setConvention(new CollectingSupplier(new MapCollectors.EntriesFromMap<K, V>(value)));
        }
        return this;
    }

    public MapProperty<K, V> convention(Provider<? extends Map<? extends K, ? extends V>> valueProvider) {
        this.setConvention(new CollectingSupplier(new MapCollectors.EntriesFromMapProvider(Providers.internal(valueProvider))));
        return this;
    }

    public void fromState(ValueSupplier.ExecutionTimeValue<? extends Map<? extends K, ? extends V>> value) {
        if (value.isMissing()) {
            this.setSupplier(this.noValueSupplier());
        } else if (value.hasFixedValue()) {
            this.setSupplier(new FixedSupplier((Map)Cast.uncheckedNonnullCast(value.getFixedValue()), (ValueSupplier.SideEffect)Cast.uncheckedCast(value.getSideEffect())));
        } else {
            this.setSupplier(new CollectingSupplier(new MapCollectors.EntriesFromMapProvider(value.getChangingValue())));
        }
    }

    public Provider<Set<K>> keySet() {
        return new KeySetProvider();
    }

    @Override
    protected String describeContents() {
        return String.format("Map(%s->%s, %s)", this.keyType.getSimpleName().toLowerCase(), this.valueType.getSimpleName(), ((MapSupplier)this.getSupplier()).toString());
    }

    @Override
    protected ValueSupplier.Value<? extends Map<K, V>> calculateValueFrom(MapSupplier<K, V> value, ValueSupplier.ValueConsumer consumer) {
        return value.calculateValue(consumer);
    }

    @Override
    protected MapSupplier<K, V> finalValue(MapSupplier<K, V> value, ValueSupplier.ValueConsumer consumer) {
        ValueSupplier.Value<Map<K, V>> result = value.calculateValue(consumer);
        if (!result.isMissing()) {
            return new FixedSupplier<K, V>(result.getWithoutSideEffect(), (ValueSupplier.SideEffect)Cast.uncheckedCast(result.getSideEffect()));
        }
        if (result.getPathToOrigin().isEmpty()) {
            return this.noValueSupplier();
        }
        return new NoValueSupplier<K, V>(result);
    }

    @Override
    protected ValueSupplier.ExecutionTimeValue<? extends Map<K, V>> calculateOwnExecutionTimeValue(MapSupplier<K, V> value) {
        return value.calculateOwnExecutionTimeValue();
    }

    private static class PlusCollector<K, V>
    implements MapCollector<K, V> {
        private final MapCollector<K, V> left;
        private final MapCollector<K, V> right;

        public PlusCollector(MapCollector<K, V> left, MapCollector<K, V> right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return this.left.calculatePresence(consumer) && this.right.calculatePresence(consumer);
        }

        @Override
        public ValueSupplier.Value<Void> collectEntries(ValueSupplier.ValueConsumer consumer, MapEntryCollector<K, V> collector, Map<K, V> dest) {
            ValueSupplier.Value<Void> leftValue = this.left.collectEntries(consumer, collector, dest);
            if (leftValue.isMissing()) {
                return leftValue;
            }
            ValueSupplier.Value<Void> rightValue = this.right.collectEntries(consumer, collector, dest);
            if (rightValue.isMissing()) {
                return rightValue;
            }
            return ValueSupplier.Value.present().withSideEffect(ValueSupplier.SideEffect.fixedFrom(leftValue)).withSideEffect(ValueSupplier.SideEffect.fixedFrom(rightValue));
        }

        @Override
        public ValueSupplier.Value<Void> collectKeys(ValueSupplier.ValueConsumer consumer, ValueCollector<K> collector, ImmutableCollection.Builder<K> dest) {
            ValueSupplier.Value<Void> result = this.left.collectKeys(consumer, collector, dest);
            if (result.isMissing()) {
                return result;
            }
            return this.right.collectKeys(consumer, collector, dest);
        }

        @Override
        public void calculateExecutionTimeValue(Action<ValueSupplier.ExecutionTimeValue<? extends Map<? extends K, ? extends V>>> visitor) {
            this.left.calculateExecutionTimeValue(visitor);
            this.right.calculateExecutionTimeValue(visitor);
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return this.left.getProducer().plus(this.right.getProducer());
        }
    }

    private static class CollectingProvider<K, V>
    extends AbstractMinimalProvider<Map<K, V>> {
        private final List<ProviderInternal<? extends Map<? extends K, ? extends V>>> providers;

        public CollectingProvider(List<ProviderInternal<? extends Map<? extends K, ? extends V>>> providers) {
            this.providers = providers;
        }

        @Override
        @Nullable
        public Class<Map<K, V>> getType() {
            return (Class)Cast.uncheckedCast(Map.class);
        }

        @Override
        protected ValueSupplier.Value<? extends Map<K, V>> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
            LinkedHashMap<? extends K, ? extends V> entries = new LinkedHashMap<K, V>();
            ValueSupplier.SideEffectBuilder sideEffectBuilder = ValueSupplier.SideEffect.builder();
            for (ProviderInternal<Map<K, V>> provider : this.providers) {
                ValueSupplier.Value<Map<K, V>> value = provider.calculateValue(consumer);
                if (value.isMissing()) {
                    return ValueSupplier.Value.missing();
                }
                entries.putAll(value.getWithoutSideEffect());
                sideEffectBuilder.add(ValueSupplier.SideEffect.fixedFrom(value));
            }
            return ValueSupplier.Value.of(ImmutableMap.copyOf(entries)).withSideEffect(sideEffectBuilder.build());
        }
    }

    private class CollectingSupplier
    implements MapSupplier<K, V> {
        private final MapCollector<K, V> collector;

        public CollectingSupplier(MapCollector<K, V> collector) {
            this.collector = collector;
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return this.collector.calculatePresence(consumer);
        }

        @Override
        public ValueSupplier.Value<? extends Set<K>> calculateKeys(ValueSupplier.ValueConsumer consumer) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            ValueSupplier.Value<Void> result = this.collector.collectKeys(consumer, DefaultMapProperty.this.keyCollector, (ImmutableCollection.Builder)builder);
            if (result.isMissing()) {
                return result.asType();
            }
            return ValueSupplier.Value.of(ImmutableSet.copyOf((Collection)builder.build())).withSideEffect(ValueSupplier.SideEffect.fixedFrom(result));
        }

        @Override
        public ValueSupplier.Value<? extends Map<K, V>> calculateValue(ValueSupplier.ValueConsumer consumer) {
            LinkedHashMap entries = new LinkedHashMap();
            ValueSupplier.Value<Void> result = this.collector.collectEntries(consumer, DefaultMapProperty.this.entryCollector, entries);
            if (result.isMissing()) {
                return result.asType();
            }
            return ValueSupplier.Value.of(ImmutableMap.copyOf(entries)).withSideEffect(ValueSupplier.SideEffect.fixedFrom(result));
        }

        @Override
        public MapSupplier<K, V> plus(MapCollector<K, V> collector) {
            return new CollectingSupplier(new PlusCollector(this.collector, collector));
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<? extends Map<K, V>> calculateOwnExecutionTimeValue() {
            ArrayList values = new ArrayList();
            this.collector.calculateExecutionTimeValue(values::add);
            boolean fixed = true;
            boolean changingContent = false;
            for (ValueSupplier.ExecutionTimeValue value : values) {
                if (value.isMissing()) {
                    return ValueSupplier.ExecutionTimeValue.missing();
                }
                if (value.isChangingValue()) {
                    fixed = false;
                    continue;
                }
                if (!value.hasChangingContent()) continue;
                changingContent = true;
            }
            if (fixed) {
                LinkedHashMap entries = new LinkedHashMap();
                ValueSupplier.SideEffectBuilder sideEffectBuilder = ValueSupplier.SideEffect.builder();
                for (ValueSupplier.ExecutionTimeValue value : values) {
                    DefaultMapProperty.this.entryCollector.addAll(((Map)value.getFixedValue()).entrySet(), entries);
                    sideEffectBuilder.add(ValueSupplier.SideEffect.fixedFrom(value));
                }
                ValueSupplier.ExecutionTimeValue<ImmutableMap> value = ValueSupplier.ExecutionTimeValue.fixedValue(ImmutableMap.copyOf(entries));
                if (changingContent) {
                    value = value.withChangingContent();
                }
                return value.withSideEffect(sideEffectBuilder.build());
            }
            ArrayList providers = new ArrayList();
            for (ValueSupplier.ExecutionTimeValue value : values) {
                providers.add(value.toProvider());
            }
            return ValueSupplier.ExecutionTimeValue.changingValue(new CollectingProvider(providers));
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return this.collector.getProducer();
        }
    }

    private static class FixedSupplier<K, V>
    implements MapSupplier<K, V> {
        private final Map<K, V> entries;
        private final ValueSupplier.SideEffect<? super Map<K, V>> sideEffect;

        public FixedSupplier(Map<K, V> entries, @Nullable ValueSupplier.SideEffect<? super Map<K, V>> sideEffect) {
            this.entries = entries;
            this.sideEffect = sideEffect;
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return true;
        }

        @Override
        public ValueSupplier.Value<? extends Map<K, V>> calculateValue(ValueSupplier.ValueConsumer consumer) {
            return ValueSupplier.Value.of(this.entries).withSideEffect(this.sideEffect);
        }

        @Override
        public ValueSupplier.Value<? extends Set<K>> calculateKeys(ValueSupplier.ValueConsumer consumer) {
            return ValueSupplier.Value.of(this.entries.keySet());
        }

        @Override
        public MapSupplier<K, V> plus(MapCollector<K, V> collector) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<? extends Map<K, V>> calculateOwnExecutionTimeValue() {
            return ValueSupplier.ExecutionTimeValue.fixedValue(this.entries).withSideEffect(this.sideEffect);
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return ValueSupplier.ValueProducer.unknown();
        }
    }

    private class EmptySupplier
    implements MapSupplier<K, V> {
        private EmptySupplier() {
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return true;
        }

        @Override
        public ValueSupplier.Value<? extends Map<K, V>> calculateValue(ValueSupplier.ValueConsumer consumer) {
            return ValueSupplier.Value.of(ImmutableMap.of());
        }

        @Override
        public ValueSupplier.Value<? extends Set<K>> calculateKeys(ValueSupplier.ValueConsumer consumer) {
            return ValueSupplier.Value.of(ImmutableSet.of());
        }

        @Override
        public MapSupplier<K, V> plus(MapCollector<K, V> collector) {
            return new CollectingSupplier(collector);
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<? extends Map<K, V>> calculateOwnExecutionTimeValue() {
            return ValueSupplier.ExecutionTimeValue.fixedValue(ImmutableMap.of());
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return ValueSupplier.ValueProducer.noProducer();
        }
    }

    private static class NoValueSupplier<K, V>
    implements MapSupplier<K, V> {
        private final ValueSupplier.Value<? extends Map<K, V>> value;

        public NoValueSupplier(ValueSupplier.Value<? extends Map<K, V>> value) {
            this.value = value.asType();
            assert (value.isMissing());
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return false;
        }

        @Override
        public ValueSupplier.Value<? extends Map<K, V>> calculateValue(ValueSupplier.ValueConsumer consumer) {
            return this.value;
        }

        @Override
        public ValueSupplier.Value<? extends Set<K>> calculateKeys(ValueSupplier.ValueConsumer consumer) {
            return this.value.asType();
        }

        @Override
        public MapSupplier<K, V> plus(MapCollector<K, V> collector) {
            return this;
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<? extends Map<K, V>> calculateOwnExecutionTimeValue() {
            return ValueSupplier.ExecutionTimeValue.missing();
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return ValueSupplier.ValueProducer.unknown();
        }
    }

    private class KeySetProvider
    extends AbstractMinimalProvider<Set<K>> {
        private KeySetProvider() {
        }

        @Override
        @Nullable
        public Class<Set<K>> getType() {
            return Set.class;
        }

        @Override
        protected ValueSupplier.Value<? extends Set<K>> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
            DefaultMapProperty.this.beforeRead(consumer);
            return ((MapSupplier)DefaultMapProperty.this.getSupplier()).calculateKeys(consumer);
        }
    }

    private class EntryProvider
    extends AbstractMinimalProvider<V> {
        private final K key;

        public EntryProvider(K key) {
            this.key = key;
        }

        @Override
        @Nullable
        public Class<V> getType() {
            return DefaultMapProperty.this.valueType;
        }

        @Override
        protected ValueSupplier.Value<? extends V> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
            ValueSupplier.Value result = DefaultMapProperty.this.calculateOwnValue(consumer);
            if (result.isMissing()) {
                return result.asType();
            }
            ValueSupplier.Value resultValue = ValueSupplier.Value.ofNullable(((Map)result.getWithoutSideEffect()).get(this.key));
            return resultValue.withSideEffect(ValueSupplier.SideEffect.fixedFrom(result));
        }
    }
}

