/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.serialization;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.gradle.internal.classloader.ClassLoaderSpec;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.tooling.internal.provider.serialization.ClassLoaderDetails;
import org.gradle.tooling.internal.provider.serialization.DeserializeMap;
import org.gradle.tooling.internal.provider.serialization.PayloadClassLoaderRegistry;
import org.gradle.tooling.internal.provider.serialization.SerializeMap;

public class WellKnownClassLoaderRegistry
implements PayloadClassLoaderRegistry {
    private static final Set<ClassLoader> PLATFORM_CLASS_LOADERS;
    private static final ClassLoader PLATFORM_CLASS_LOADER;
    private static final short PLATFORM_CLASS_LOADER_ID = -1;
    private static final ClassLoaderDetails PLATFORM_CLASS_LOADER_DETAILS;
    private final PayloadClassLoaderRegistry delegate;

    public WellKnownClassLoaderRegistry(PayloadClassLoaderRegistry delegate) {
        this.delegate = delegate;
    }

    @Override
    public SerializeMap newSerializeSession() {
        final SerializeMap delegateSession = this.delegate.newSerializeSession();
        return new SerializeMap(){
            final Map<Short, ClassLoaderDetails> knownLoaders = new HashMap<Short, ClassLoaderDetails>();

            @Override
            public short visitClass(Class<?> target) {
                ClassLoader classLoader = target.getClassLoader();
                if (classLoader == null || PLATFORM_CLASS_LOADERS.contains(classLoader)) {
                    this.knownLoaders.put((short)-1, PLATFORM_CLASS_LOADER_DETAILS);
                    return -1;
                }
                return delegateSession.visitClass(target);
            }

            @Override
            public void collectClassLoaderDefinitions(Map<Short, ClassLoaderDetails> details) {
                delegateSession.collectClassLoaderDefinitions(details);
                details.putAll(this.knownLoaders);
            }
        };
    }

    @Override
    public DeserializeMap newDeserializeSession() {
        final DeserializeMap delegateSession = this.delegate.newDeserializeSession();
        return new DeserializeMap(){

            @Override
            public Class<?> resolveClass(ClassLoaderDetails classLoaderDetails, String className) throws ClassNotFoundException {
                if (classLoaderDetails.spec instanceof KnownClassLoaderSpec) {
                    KnownClassLoaderSpec knownClassLoaderSpec = (KnownClassLoaderSpec)classLoaderDetails.spec;
                    switch (knownClassLoaderSpec.id) {
                        case -1: {
                            return Class.forName(className, false, PLATFORM_CLASS_LOADER);
                        }
                    }
                    throw new IllegalArgumentException("Unknown ClassLoader id specified.");
                }
                return delegateSession.resolveClass(classLoaderDetails, className);
            }
        };
    }

    static {
        PLATFORM_CLASS_LOADER = ClassLoaderUtils.getPlatformClassLoader();
        PLATFORM_CLASS_LOADER_DETAILS = new ClassLoaderDetails(UUID.randomUUID(), new KnownClassLoaderSpec(-1));
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ClassLoader cl = PLATFORM_CLASS_LOADER; cl != null; cl = cl.getParent()) {
            builder.add((Object)cl);
        }
        PLATFORM_CLASS_LOADERS = builder.build();
    }

    private static class KnownClassLoaderSpec
    extends ClassLoaderSpec {
        private final short id;

        KnownClassLoaderSpec(short id) {
            this.id = id;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            KnownClassLoaderSpec other = (KnownClassLoaderSpec)obj;
            return this.id == other.id;
        }

        public int hashCode() {
            return this.id;
        }

        public String toString() {
            return "{known-class-loader id: " + this.id + "}";
        }
    }
}

