/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.util.Arrays;
import java.util.List;
import org.jruby.anno.MethodDescriptor;

public class DescriptorInfo {
    private int min = Integer.MAX_VALUE;
    private int max = 0;
    private boolean keywords = false;
    private boolean frame = false;
    private boolean rest = false;
    private boolean block = false;
    private String parameterDesc;
    public static final char ANONREQ_CHAR = 'n';
    public static final char ANONOPT_CHAR = 'O';
    public static final char ANONREST_CHAR = 'R';
    private static final boolean RICH_NATIVE_METHOD_PARAMETERS = false;

    public DescriptorInfo(MethodDescriptor ... descs) {
        this(Arrays.asList(descs));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DescriptorInfo(List<? extends MethodDescriptor> descs) {
        boolean first2 = true;
        boolean lastBlock = false;
        for (MethodDescriptor methodDescriptor : descs) {
            if (first2) {
                first2 = false;
            } else if (lastBlock != methodDescriptor.hasBlock) {
                throw new RuntimeException("Mismatched block parameters for method " + methodDescriptor.declaringClassName + "." + methodDescriptor.name);
            }
            lastBlock = methodDescriptor.hasBlock;
            int specificArity = -1;
            if (methodDescriptor.hasVarArgs) {
                if (methodDescriptor.optional == 0 && !methodDescriptor.rest && methodDescriptor.required == 0) {
                    throw new RuntimeException("IRubyObject[] args but neither of optional or rest specified for method " + methodDescriptor.declaringClassName + "." + methodDescriptor.name);
                }
                this.rest = true;
                if (descs.size() == 1) {
                    this.min = -1;
                }
            } else {
                if (methodDescriptor.optional == 0 && !methodDescriptor.rest) {
                    if (methodDescriptor.required == 0) {
                        if (methodDescriptor.actualRequired > 3) throw new RuntimeException("Invalid specific-arity number of arguments (" + methodDescriptor.actualRequired + ") on method " + methodDescriptor.declaringClassName + "." + methodDescriptor.name);
                        specificArity = methodDescriptor.actualRequired;
                    } else if (methodDescriptor.required >= 0 && methodDescriptor.required <= 3) {
                        if (methodDescriptor.actualRequired != methodDescriptor.required) {
                            throw new RuntimeException("Specified required args does not match actual on method " + methodDescriptor.declaringClassName + "." + methodDescriptor.name);
                        }
                        specificArity = methodDescriptor.required;
                    }
                }
                if (specificArity < this.min) {
                    this.min = specificArity;
                }
                if (specificArity > this.max) {
                    this.max = specificArity;
                }
            }
            if (this.frame && !methodDescriptor.anno.frame()) {
                throw new RuntimeException("Unbalanced frame property on method " + methodDescriptor.declaringClassName + '.' + methodDescriptor.name);
            }
            this.keywords |= methodDescriptor.anno.keywords();
            this.frame |= methodDescriptor.anno.frame();
            this.block |= methodDescriptor.hasBlock;
        }
        StringBuilder descBuilder = new StringBuilder();
        if (this.rest || this.min != this.max) {
            descBuilder.append('R');
        } else {
            void var5_7;
            boolean bl = false;
            while (var5_7 < this.min) {
                if (var5_7 > 0) {
                    descBuilder.append(';');
                }
                descBuilder.append('n');
                ++var5_7;
            }
        }
        this.parameterDesc = descBuilder.toString();
    }

    @Deprecated
    public boolean isBacktrace() {
        return false;
    }

    public boolean acceptsKeywords() {
        return this.keywords;
    }

    public boolean isFrame() {
        return this.frame;
    }

    public int getMax() {
        return this.max;
    }

    public int getMin() {
        return this.min;
    }

    public boolean isRest() {
        return this.rest;
    }

    public boolean isBlock() {
        return this.block;
    }

    public String getParameterDesc() {
        return this.parameterDesc;
    }
}

