/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.loader.zip;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.loader.AbstractResourceData;
import org.pentaho.reporting.libraries.resourceloader.loader.LoaderUtils;

public class ZipResourceData
extends AbstractResourceData {
    private ResourceKey key;
    private static final long serialVersionUID = -7432641415119820243L;

    public ZipResourceData(ResourceKey key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.key = key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream getResourceAsStream(ResourceManager caller) throws ResourceLoadingException {
        ResourceKey parentKey = this.key.getParent();
        ResourceData data = caller.load(parentKey);
        ZipInputStream zin = new ZipInputStream(data.getResourceAsStream(caller));
        try {
            try {
                block7: {
                    ZipEntry zipEntry = zin.getNextEntry();
                    while (zipEntry != null) {
                        if (!zipEntry.getName().equals(this.key.getIdentifier())) {
                            zipEntry = zin.getNextEntry();
                            continue;
                        }
                        break block7;
                    }
                    throw new ResourceLoadingException("The zip-file did not contain the specified entry");
                }
                ZipInputStream zipInputStream = zin;
                return zipInputStream;
            }
            finally {
                zin.close();
            }
        }
        catch (IOException e) {
            throw new ResourceLoadingException("Reading the zip-file failed.", e);
        }
    }

    @Override
    public Object getAttribute(String key) {
        if (key.equals("filename")) {
            return LoaderUtils.getFileName((String)this.key.getIdentifier());
        }
        return null;
    }

    @Override
    public ResourceKey getKey() {
        return this.key;
    }

    @Override
    public long getVersion(ResourceManager caller) throws ResourceLoadingException {
        ResourceKey parentKey = this.key.getParent();
        ResourceData data = caller.load(parentKey);
        return data.getVersion(caller);
    }
}

