/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkQueryPoolCreateInfoINTEL;
import org.lwjgl.vulkan.VkQueryPoolPerformanceCreateInfoKHR;
import org.lwjgl.vulkan.VkQueryPoolPerformanceQueryCreateInfoINTEL;
import org.lwjgl.vulkan.VkVideoDecodeH264ProfileEXT;
import org.lwjgl.vulkan.VkVideoDecodeH265ProfileEXT;
import org.lwjgl.vulkan.VkVideoEncodeH264ProfileEXT;
import org.lwjgl.vulkan.VkVideoEncodeH265ProfileEXT;
import org.lwjgl.vulkan.VkVideoProfileKHR;

public class VkQueryPoolCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int QUERYTYPE;
    public static final int QUERYCOUNT;
    public static final int PIPELINESTATISTICS;

    public VkQueryPoolCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkQueryPoolCreateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkQueryPoolCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkQueryPoolCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkQueryPoolCreateFlags")
    public int flags() {
        return VkQueryPoolCreateInfo.nflags(this.address());
    }

    @NativeType(value="VkQueryType")
    public int queryType() {
        return VkQueryPoolCreateInfo.nqueryType(this.address());
    }

    @NativeType(value="uint32_t")
    public int queryCount() {
        return VkQueryPoolCreateInfo.nqueryCount(this.address());
    }

    @NativeType(value="VkQueryPipelineStatisticFlags")
    public int pipelineStatistics() {
        return VkQueryPoolCreateInfo.npipelineStatistics(this.address());
    }

    public VkQueryPoolCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkQueryPoolCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkQueryPoolCreateInfo sType$Default() {
        return this.sType(11);
    }

    public VkQueryPoolCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkQueryPoolCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkQueryPoolCreateInfo pNext(VkQueryPoolCreateInfoINTEL value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkQueryPoolCreateInfo pNext(VkQueryPoolPerformanceCreateInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkQueryPoolCreateInfo pNext(VkQueryPoolPerformanceQueryCreateInfoINTEL value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkQueryPoolCreateInfo pNext(VkVideoDecodeH264ProfileEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkQueryPoolCreateInfo pNext(VkVideoDecodeH265ProfileEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkQueryPoolCreateInfo pNext(VkVideoEncodeH264ProfileEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkQueryPoolCreateInfo pNext(VkVideoEncodeH265ProfileEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkQueryPoolCreateInfo pNext(VkVideoProfileKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkQueryPoolCreateInfo flags(@NativeType(value="VkQueryPoolCreateFlags") int value) {
        VkQueryPoolCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkQueryPoolCreateInfo queryType(@NativeType(value="VkQueryType") int value) {
        VkQueryPoolCreateInfo.nqueryType(this.address(), value);
        return this;
    }

    public VkQueryPoolCreateInfo queryCount(@NativeType(value="uint32_t") int value) {
        VkQueryPoolCreateInfo.nqueryCount(this.address(), value);
        return this;
    }

    public VkQueryPoolCreateInfo pipelineStatistics(@NativeType(value="VkQueryPipelineStatisticFlags") int value) {
        VkQueryPoolCreateInfo.npipelineStatistics(this.address(), value);
        return this;
    }

    public VkQueryPoolCreateInfo set(int sType, long pNext, int flags, int queryType, int queryCount, int pipelineStatistics) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.queryType(queryType);
        this.queryCount(queryCount);
        this.pipelineStatistics(pipelineStatistics);
        return this;
    }

    public VkQueryPoolCreateInfo set(VkQueryPoolCreateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkQueryPoolCreateInfo malloc() {
        return (VkQueryPoolCreateInfo)VkQueryPoolCreateInfo.wrap(VkQueryPoolCreateInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkQueryPoolCreateInfo calloc() {
        return (VkQueryPoolCreateInfo)VkQueryPoolCreateInfo.wrap(VkQueryPoolCreateInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkQueryPoolCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkQueryPoolCreateInfo)VkQueryPoolCreateInfo.wrap(VkQueryPoolCreateInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkQueryPoolCreateInfo create(long address) {
        return (VkQueryPoolCreateInfo)VkQueryPoolCreateInfo.wrap(VkQueryPoolCreateInfo.class, (long)address);
    }

    @Nullable
    public static VkQueryPoolCreateInfo createSafe(long address) {
        return address == 0L ? null : (VkQueryPoolCreateInfo)VkQueryPoolCreateInfo.wrap(VkQueryPoolCreateInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkQueryPoolCreateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkQueryPoolCreateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkQueryPoolCreateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkQueryPoolCreateInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkQueryPoolCreateInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkQueryPoolCreateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkQueryPoolCreateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static VkQueryPoolCreateInfo mallocStack() {
        return VkQueryPoolCreateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkQueryPoolCreateInfo callocStack() {
        return VkQueryPoolCreateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkQueryPoolCreateInfo mallocStack(MemoryStack stack) {
        return VkQueryPoolCreateInfo.malloc(stack);
    }

    @Deprecated
    public static VkQueryPoolCreateInfo callocStack(MemoryStack stack) {
        return VkQueryPoolCreateInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkQueryPoolCreateInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkQueryPoolCreateInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkQueryPoolCreateInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkQueryPoolCreateInfo.calloc(capacity, stack);
    }

    public static VkQueryPoolCreateInfo malloc(MemoryStack stack) {
        return (VkQueryPoolCreateInfo)VkQueryPoolCreateInfo.wrap(VkQueryPoolCreateInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkQueryPoolCreateInfo calloc(MemoryStack stack) {
        return (VkQueryPoolCreateInfo)VkQueryPoolCreateInfo.wrap(VkQueryPoolCreateInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkQueryPoolCreateInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkQueryPoolCreateInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int nqueryType(long struct) {
        return UNSAFE.getInt(null, struct + (long)QUERYTYPE);
    }

    public static int nqueryCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)QUERYCOUNT);
    }

    public static int npipelineStatistics(long struct) {
        return UNSAFE.getInt(null, struct + (long)PIPELINESTATISTICS);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nqueryType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)QUERYTYPE, value);
    }

    public static void nqueryCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)QUERYCOUNT, value);
    }

    public static void npipelineStatistics(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PIPELINESTATISTICS, value);
    }

    static {
        Struct.Layout layout = VkQueryPoolCreateInfo.__struct((Struct.Member[])new Struct.Member[]{VkQueryPoolCreateInfo.__member((int)4), VkQueryPoolCreateInfo.__member((int)POINTER_SIZE), VkQueryPoolCreateInfo.__member((int)4), VkQueryPoolCreateInfo.__member((int)4), VkQueryPoolCreateInfo.__member((int)4), VkQueryPoolCreateInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        QUERYTYPE = layout.offsetof(3);
        QUERYCOUNT = layout.offsetof(4);
        PIPELINESTATISTICS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkQueryPoolCreateInfo, Buffer>
    implements NativeResource {
        private static final VkQueryPoolCreateInfo ELEMENT_FACTORY = VkQueryPoolCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkQueryPoolCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkQueryPoolCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkQueryPoolCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkQueryPoolCreateFlags")
        public int flags() {
            return VkQueryPoolCreateInfo.nflags(this.address());
        }

        @NativeType(value="VkQueryType")
        public int queryType() {
            return VkQueryPoolCreateInfo.nqueryType(this.address());
        }

        @NativeType(value="uint32_t")
        public int queryCount() {
            return VkQueryPoolCreateInfo.nqueryCount(this.address());
        }

        @NativeType(value="VkQueryPipelineStatisticFlags")
        public int pipelineStatistics() {
            return VkQueryPoolCreateInfo.npipelineStatistics(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkQueryPoolCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(11);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkQueryPoolCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkQueryPoolCreateInfoINTEL value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkQueryPoolPerformanceCreateInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkQueryPoolPerformanceQueryCreateInfoINTEL value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoDecodeH264ProfileEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoDecodeH265ProfileEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoEncodeH264ProfileEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoEncodeH265ProfileEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoProfileKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkQueryPoolCreateFlags") int value) {
            VkQueryPoolCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer queryType(@NativeType(value="VkQueryType") int value) {
            VkQueryPoolCreateInfo.nqueryType(this.address(), value);
            return this;
        }

        public Buffer queryCount(@NativeType(value="uint32_t") int value) {
            VkQueryPoolCreateInfo.nqueryCount(this.address(), value);
            return this;
        }

        public Buffer pipelineStatistics(@NativeType(value="VkQueryPipelineStatisticFlags") int value) {
            VkQueryPoolCreateInfo.npipelineStatistics(this.address(), value);
            return this;
        }
    }
}

