/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class EXTBufferStorage {
    public static final int GL_MAP_PERSISTENT_BIT_EXT = 64;
    public static final int GL_MAP_COHERENT_BIT_EXT = 128;
    public static final int GL_DYNAMIC_STORAGE_BIT_EXT = 256;
    public static final int GL_CLIENT_STORAGE_BIT_EXT = 512;
    public static final int GL_BUFFER_IMMUTABLE_STORAGE_EXT = 33311;
    public static final int GL_BUFFER_STORAGE_FLAGS_EXT = 33312;
    public static final int GL_CLIENT_MAPPED_BUFFER_BARRIER_BIT_EXT = 16384;

    protected EXTBufferStorage() {
        throw new UnsupportedOperationException();
    }

    public static native void nglBufferStorageEXT(int var0, long var1, long var3, int var5);

    public static void glBufferStorageEXT(@NativeType(value="GLenum") int target, @NativeType(value="GLsizeiptr") long size, @NativeType(value="GLbitfield") int flags) {
        EXTBufferStorage.nglBufferStorageEXT(target, size, 0L, flags);
    }

    public static void glBufferStorageEXT(@NativeType(value="GLenum") int target, @NativeType(value="void const *") ByteBuffer data, @NativeType(value="GLbitfield") int flags) {
        EXTBufferStorage.nglBufferStorageEXT(target, data.remaining(), MemoryUtil.memAddress((ByteBuffer)data), flags);
    }

    public static void glBufferStorageEXT(@NativeType(value="GLenum") int target, @NativeType(value="void const *") ShortBuffer data, @NativeType(value="GLbitfield") int flags) {
        EXTBufferStorage.nglBufferStorageEXT(target, Integer.toUnsignedLong(data.remaining()) << 1, MemoryUtil.memAddress((ShortBuffer)data), flags);
    }

    public static void glBufferStorageEXT(@NativeType(value="GLenum") int target, @NativeType(value="void const *") IntBuffer data, @NativeType(value="GLbitfield") int flags) {
        EXTBufferStorage.nglBufferStorageEXT(target, Integer.toUnsignedLong(data.remaining()) << 2, MemoryUtil.memAddress((IntBuffer)data), flags);
    }

    public static void glBufferStorageEXT(@NativeType(value="GLenum") int target, @NativeType(value="void const *") FloatBuffer data, @NativeType(value="GLbitfield") int flags) {
        EXTBufferStorage.nglBufferStorageEXT(target, Integer.toUnsignedLong(data.remaining()) << 2, MemoryUtil.memAddress((FloatBuffer)data), flags);
    }

    public static native void nglNamedBufferStorageEXT(int var0, long var1, long var3, int var5);

    public static void glNamedBufferStorageEXT(@NativeType(value="GLuint") int buffer, @NativeType(value="GLsizeiptr") long size, @NativeType(value="GLbitfield") int flags) {
        EXTBufferStorage.nglNamedBufferStorageEXT(buffer, size, 0L, flags);
    }

    public static void glNamedBufferStorageEXT(@NativeType(value="GLuint") int buffer, @NativeType(value="void const *") ByteBuffer data, @NativeType(value="GLbitfield") int flags) {
        EXTBufferStorage.nglNamedBufferStorageEXT(buffer, data.remaining(), MemoryUtil.memAddress((ByteBuffer)data), flags);
    }

    public static void glNamedBufferStorageEXT(@NativeType(value="GLuint") int buffer, @NativeType(value="void const *") ShortBuffer data, @NativeType(value="GLbitfield") int flags) {
        EXTBufferStorage.nglNamedBufferStorageEXT(buffer, Integer.toUnsignedLong(data.remaining()) << 1, MemoryUtil.memAddress((ShortBuffer)data), flags);
    }

    public static void glNamedBufferStorageEXT(@NativeType(value="GLuint") int buffer, @NativeType(value="void const *") IntBuffer data, @NativeType(value="GLbitfield") int flags) {
        EXTBufferStorage.nglNamedBufferStorageEXT(buffer, Integer.toUnsignedLong(data.remaining()) << 2, MemoryUtil.memAddress((IntBuffer)data), flags);
    }

    public static void glNamedBufferStorageEXT(@NativeType(value="GLuint") int buffer, @NativeType(value="void const *") FloatBuffer data, @NativeType(value="GLbitfield") int flags) {
        EXTBufferStorage.nglNamedBufferStorageEXT(buffer, Integer.toUnsignedLong(data.remaining()) << 2, MemoryUtil.memAddress((FloatBuffer)data), flags);
    }

    public static void glBufferStorageEXT(@NativeType(value="GLenum") int target, @NativeType(value="void const *") short[] data, @NativeType(value="GLbitfield") int flags) {
        long __functionAddress = GLES.getICD().glBufferStorageEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPV((int)target, (long)(Integer.toUnsignedLong(data.length) << 1), (short[])data, (int)flags, (long)__functionAddress);
    }

    public static void glBufferStorageEXT(@NativeType(value="GLenum") int target, @NativeType(value="void const *") int[] data, @NativeType(value="GLbitfield") int flags) {
        long __functionAddress = GLES.getICD().glBufferStorageEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPV((int)target, (long)(Integer.toUnsignedLong(data.length) << 2), (int[])data, (int)flags, (long)__functionAddress);
    }

    public static void glBufferStorageEXT(@NativeType(value="GLenum") int target, @NativeType(value="void const *") float[] data, @NativeType(value="GLbitfield") int flags) {
        long __functionAddress = GLES.getICD().glBufferStorageEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPV((int)target, (long)(Integer.toUnsignedLong(data.length) << 2), (float[])data, (int)flags, (long)__functionAddress);
    }

    public static void glNamedBufferStorageEXT(@NativeType(value="GLuint") int buffer, @NativeType(value="void const *") short[] data, @NativeType(value="GLbitfield") int flags) {
        long __functionAddress = GLES.getICD().glNamedBufferStorageEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPV((int)buffer, (long)(Integer.toUnsignedLong(data.length) << 1), (short[])data, (int)flags, (long)__functionAddress);
    }

    public static void glNamedBufferStorageEXT(@NativeType(value="GLuint") int buffer, @NativeType(value="void const *") int[] data, @NativeType(value="GLbitfield") int flags) {
        long __functionAddress = GLES.getICD().glNamedBufferStorageEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPV((int)buffer, (long)(Integer.toUnsignedLong(data.length) << 2), (int[])data, (int)flags, (long)__functionAddress);
    }

    public static void glNamedBufferStorageEXT(@NativeType(value="GLuint") int buffer, @NativeType(value="void const *") float[] data, @NativeType(value="GLbitfield") int flags) {
        long __functionAddress = GLES.getICD().glNamedBufferStorageEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPV((int)buffer, (long)(Integer.toUnsignedLong(data.length) << 2), (float[])data, (int)flags, (long)__functionAddress);
    }

    static {
        GLES.initialize();
    }
}

