/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct HmdVector4_t")
public class HmdVector4
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int V;

    public HmdVector4(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), HmdVector4.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="float[4]")
    public FloatBuffer v() {
        return HmdVector4.nv(this.address());
    }

    public float v(int index) {
        return HmdVector4.nv(this.address(), index);
    }

    public HmdVector4 v(@NativeType(value="float[4]") FloatBuffer value) {
        HmdVector4.nv(this.address(), value);
        return this;
    }

    public HmdVector4 v(int index, float value) {
        HmdVector4.nv(this.address(), index, value);
        return this;
    }

    public HmdVector4 set(HmdVector4 src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static HmdVector4 malloc() {
        return (HmdVector4)HmdVector4.wrap(HmdVector4.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static HmdVector4 calloc() {
        return (HmdVector4)HmdVector4.wrap(HmdVector4.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static HmdVector4 create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (HmdVector4)HmdVector4.wrap(HmdVector4.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static HmdVector4 create(long address) {
        return (HmdVector4)HmdVector4.wrap(HmdVector4.class, (long)address);
    }

    @Nullable
    public static HmdVector4 createSafe(long address) {
        return address == 0L ? null : (HmdVector4)HmdVector4.wrap(HmdVector4.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)HmdVector4.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)HmdVector4.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)HmdVector4.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = HmdVector4.__create((int)capacity, (int)SIZEOF);
        return (Buffer)HmdVector4.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)HmdVector4.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)HmdVector4.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static HmdVector4 mallocStack() {
        return HmdVector4.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static HmdVector4 callocStack() {
        return HmdVector4.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static HmdVector4 mallocStack(MemoryStack stack) {
        return HmdVector4.malloc(stack);
    }

    @Deprecated
    public static HmdVector4 callocStack(MemoryStack stack) {
        return HmdVector4.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return HmdVector4.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return HmdVector4.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return HmdVector4.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return HmdVector4.calloc(capacity, stack);
    }

    public static HmdVector4 malloc(MemoryStack stack) {
        return (HmdVector4)HmdVector4.wrap(HmdVector4.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static HmdVector4 calloc(MemoryStack stack) {
        return (HmdVector4)HmdVector4.wrap(HmdVector4.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)HmdVector4.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)HmdVector4.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static FloatBuffer nv(long struct) {
        return MemoryUtil.memFloatBuffer((long)(struct + (long)V), (int)4);
    }

    public static float nv(long struct, int index) {
        return UNSAFE.getFloat(null, struct + (long)V + Checks.check((int)index, (int)4) * 4L);
    }

    public static void nv(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)4);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((FloatBuffer)value), (long)(struct + (long)V), (long)(value.remaining() * 4));
    }

    public static void nv(long struct, int index, float value) {
        UNSAFE.putFloat(null, struct + (long)V + Checks.check((int)index, (int)4) * 4L, value);
    }

    static {
        Struct.Layout layout = HmdVector4.__struct((Struct.Member[])new Struct.Member[]{HmdVector4.__array((int)4, (int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        V = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<HmdVector4, Buffer>
    implements NativeResource {
        private static final HmdVector4 ELEMENT_FACTORY = HmdVector4.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected HmdVector4 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="float[4]")
        public FloatBuffer v() {
            return HmdVector4.nv(this.address());
        }

        public float v(int index) {
            return HmdVector4.nv(this.address(), index);
        }

        public Buffer v(@NativeType(value="float[4]") FloatBuffer value) {
            HmdVector4.nv(this.address(), value);
            return this;
        }

        public Buffer v(int index, float value) {
            HmdVector4.nv(this.address(), index, value);
            return this;
        }
    }
}

