/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct InputOriginInfo_t")
public class InputOriginInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DEVICEPATH;
    public static final int TRACKEDDEVICEINDEX;
    public static final int RCHRENDERMODELCOMPONENTNAME;

    public InputOriginInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), InputOriginInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VRInputValueHandle_t")
    public long devicePath() {
        return InputOriginInfo.ndevicePath(this.address());
    }

    @NativeType(value="TrackedDeviceIndex_t")
    public int trackedDeviceIndex() {
        return InputOriginInfo.ntrackedDeviceIndex(this.address());
    }

    @NativeType(value="char[128]")
    public ByteBuffer rchRenderModelComponentName() {
        return InputOriginInfo.nrchRenderModelComponentName(this.address());
    }

    @NativeType(value="char[128]")
    public String rchRenderModelComponentNameString() {
        return InputOriginInfo.nrchRenderModelComponentNameString(this.address());
    }

    public static InputOriginInfo malloc() {
        return (InputOriginInfo)InputOriginInfo.wrap(InputOriginInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static InputOriginInfo calloc() {
        return (InputOriginInfo)InputOriginInfo.wrap(InputOriginInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static InputOriginInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (InputOriginInfo)InputOriginInfo.wrap(InputOriginInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static InputOriginInfo create(long address) {
        return (InputOriginInfo)InputOriginInfo.wrap(InputOriginInfo.class, (long)address);
    }

    @Nullable
    public static InputOriginInfo createSafe(long address) {
        return address == 0L ? null : (InputOriginInfo)InputOriginInfo.wrap(InputOriginInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)InputOriginInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)InputOriginInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)InputOriginInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = InputOriginInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)InputOriginInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)InputOriginInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)InputOriginInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static InputOriginInfo mallocStack() {
        return InputOriginInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static InputOriginInfo callocStack() {
        return InputOriginInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static InputOriginInfo mallocStack(MemoryStack stack) {
        return InputOriginInfo.malloc(stack);
    }

    @Deprecated
    public static InputOriginInfo callocStack(MemoryStack stack) {
        return InputOriginInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return InputOriginInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return InputOriginInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return InputOriginInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return InputOriginInfo.calloc(capacity, stack);
    }

    public static InputOriginInfo malloc(MemoryStack stack) {
        return (InputOriginInfo)InputOriginInfo.wrap(InputOriginInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static InputOriginInfo calloc(MemoryStack stack) {
        return (InputOriginInfo)InputOriginInfo.wrap(InputOriginInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)InputOriginInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)InputOriginInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long ndevicePath(long struct) {
        return UNSAFE.getLong(null, struct + (long)DEVICEPATH);
    }

    public static int ntrackedDeviceIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)TRACKEDDEVICEINDEX);
    }

    public static ByteBuffer nrchRenderModelComponentName(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)RCHRENDERMODELCOMPONENTNAME), (int)128);
    }

    public static String nrchRenderModelComponentNameString(long struct) {
        return MemoryUtil.memUTF8((long)(struct + (long)RCHRENDERMODELCOMPONENTNAME));
    }

    static {
        Struct.Layout layout = InputOriginInfo.__struct((Struct.Member[])new Struct.Member[]{InputOriginInfo.__member((int)8), InputOriginInfo.__member((int)4), InputOriginInfo.__array((int)1, (int)128)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DEVICEPATH = layout.offsetof(0);
        TRACKEDDEVICEINDEX = layout.offsetof(1);
        RCHRENDERMODELCOMPONENTNAME = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<InputOriginInfo, Buffer>
    implements NativeResource {
        private static final InputOriginInfo ELEMENT_FACTORY = InputOriginInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected InputOriginInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VRInputValueHandle_t")
        public long devicePath() {
            return InputOriginInfo.ndevicePath(this.address());
        }

        @NativeType(value="TrackedDeviceIndex_t")
        public int trackedDeviceIndex() {
            return InputOriginInfo.ntrackedDeviceIndex(this.address());
        }

        @NativeType(value="char[128]")
        public ByteBuffer rchRenderModelComponentName() {
            return InputOriginInfo.nrchRenderModelComponentName(this.address());
        }

        @NativeType(value="char[128]")
        public String rchRenderModelComponentNameString() {
            return InputOriginInfo.nrchRenderModelComponentNameString(this.address());
        }
    }
}

