<?php

/**
 * ⚠️ Editing not allowed except for 'en' language.
 *
 * @see https://github.com/monicahq/monica/blob/main/docs/contribute/translate.md for translations.
 */

return [
    'sidebar_settings' => 'Kontoinnstillinger',
    'sidebar_personalization' => 'Tilpass',
    'sidebar_settings_storage' => 'Lagring',
    'sidebar_settings_export' => 'Eksporter data',
    'sidebar_settings_users' => 'Brukere',
    'sidebar_settings_subscriptions' => 'Abonnementer',
    'sidebar_settings_import' => 'Importer data',
    'sidebar_settings_tags' => 'Tag-administrasjon',
    'sidebar_settings_api' => 'API',
    'sidebar_settings_dav' => 'DAV-ressurser',
    'sidebar_settings_security' => 'Sikkerhet',
    'sidebar_settings_auditlogs' => 'Overvåkningslogg',

    'title_general' => 'Generell informasjon',
    'title_i18n' => 'Internasjonale innstillinger',
    'title_layout' => 'Visningsoppsett',

    'me_title' => 'Meg som kontakt',
    'me_help' => 'Dette er den kontakten som representerer <em>deg</em> i Monica',
    'me_select' => 'Velg en kontakt',
    'me_no_contact' => 'Ingen kontakt valgt.',
    'me_select_click' => 'Klikk her for å velge en kontakt.',
    'me_remove_contact' => 'Fjern tilknytning',
    'me_choose' => 'Velg deg selv',
    'me_choose_placeholder' => 'Velg deg selv',

    'export_title' => 'Eksporter dine kontodata',
    'export_be_patient' => 'Click the button to start the export. It might take several minutes to process the export – please be patient and do not spam the button.',
    'export_title_sql' => 'Export to SQL',
    'export_sql_explanation' => 'Exporting your data in SQL format allows you to take your data and import it to your own Monica instance. This is only valuable if you do have your own server.',
    'export_sql_cta' => 'Export to SQL',
    'export_sql_link_instructions' => 'Note: <a href=":url">read the instructions</a> to learn more about importing this file to your instance.',
    'export_title_json' => 'Export to Json',
    'export_submitted' => 'Your export has been submitted, it will be available in a few moment…',
    'export_json_explanation' => 'Exporting your data in Json format for backup.',
    'export_json_beta' => 'Json export is in preview mode. Tell us what you think about it:',
    'export_json_cta' => 'Export to Json',
    'export_header_type' => 'Type',
    'export_header_timestamp' => 'Creation date',
    'export_header_status' => 'Status',
    'export_header_actions' => 'Actions',
    'export_last_title' => 'Last exports',
    'export_empty_title' => 'No exports yet',
    'export_type_json' => 'Json export',
    'export_type_sql' => 'SQL export',
    'export_status_todo' => 'Submitted',
    'export_status_doing' => 'Doing',
    'export_status_done' => 'Done',
    'export_status_failed' => 'Failed',
    'export_not_done' => 'Download impossible, this export is not done yet.',

    'firstname' => 'Fornavn',
    'lastname' => 'Etternavn',
    'name_order' => 'Rekkefølge på navn',
    'name_order_firstname_lastname' => '<First name> <Last name> – Jon Smith',
    'name_order_lastname_firstname' => '<Last name> <First name>– Smith Jon',
    'name_order_firstname_lastname_nickname' => '<First name> <Last name> (<Nickname>) - Jon Smith (Rambo)',
    'name_order_firstname_nickname_lastname' => '<First name> (<Nickname>) <Last name> – Jon (Rambo) Smith',
    'name_order_lastname_firstname_nickname' => '<Last name> <First name> (<Nickname>) – Smith Jon (Rambo)',
    'name_order_lastname_nickname_firstname' => '<Last name> (<Nickname>) <First name> - Smith (Rambo) Jon',
    'name_order_nickname_firstname_lastname' => '<Nickname> (<First name> <Last name>) – Rambo (Jon Smith)',
    'name_order_nickname_lastname_firstname' => '<Nickname> (<Last name> <First name>) – Rambo (Doe John)',
    'name_order_nickname' => '<Nickname> – Rambo',
    'currency' => 'Valuta',
    'name' => 'Ditt navn: :name',
    'email' => 'E-postadresse',
    'email_placeholder' => 'Skriv e-postadresse',
    'email_help' => 'Dette er e-postadressen som brukes til å logge inn, og det er hit Monica sender deg påminnelser.',
    'timezone' => 'Tidssone',
    'temperature_scale' => 'Temperaturskala',
    'temperature_scale_fahrenheit' => 'Fahrenheit (°F)',
    'temperature_scale_celsius' => 'Celsius (°C)',
    'layout' => 'Visningsoppsett',
    'layout_small' => 'Maksimalt 1200 piksler bredt',
    'layout_big' => 'Full nettleserbredde',
    'save' => 'Oppdater innstillinger',
    'delete_title' => 'Slett kontoen din',
    'delete_desc' => 'Ønsker du å slette din konto? Sletting er permanent og alle dine data vil bli slettet permanent. Hvis du har et abonnement, blir det kansellert umiddelbart.',
    'delete_other_desc' => 'Your data in the main database will be deleted immediately. As described in our privacy policy, we carry out securely encrypted backups of the database every day.  These backups are kept for 30 days after which they are completely deleted. We cannot delete specific data from the backups we hold any earlier than this.  All of your data will be completely deleted no later than 31 days after your account’s deletion.',
    'reset_desc' => 'Ønsker du å tilbakestille kontoen din? Dette vil fjerne alle dine kontakter og alle dataene knyttet til dem. Kontoen din vil ikke bli slettet.',
    'reset_title' => 'Tilbakestill konto',
    'reset_cta' => 'Tilbakestill konto',
    'reset_notice' => 'Er du sikker på at du vil tilbakestille kontoen din? Dette er permanent og kan ikke angres.',
    'reset_success' => 'Din konto har blitt tilbakestilt.',
    'delete_notice' => 'Er du sikker på at du vil slette kontoen? Dette er permanent og kan ikke angres. Alle dataene dine vil bli slettet og vil ikke kunne gjenopprettes.',
    'delete_cta' => 'Slett konto',
    'settings_success' => 'Innstillinger oppdatert!',
    'locale' => 'Språk brukt i appen',
    'locale_help' => 'Vil du hjelpe med å oversette Monica eller legge til et nytt språk? Følg <a href=":url" target="_blank" lang="en">denne linken for mer informasjon</a>.',
    'locale_ar' => 'Arabisk',
    'locale_cs' => 'Tsjekkisk',
    'locale_de' => 'Tysk',
    'locale_el' => 'Gresk',
    'locale_en' => 'Engelsk',
    'locale_en-GB' => 'English (United Kingdom)',
    'locale_es' => 'Spansk',
    'locale_fr' => 'Fransk',
    'locale_he' => 'Hebraisk',
    'locale_hr' => 'Kroatisk',
    'locale_id' => 'Indonesisk',
    'locale_it' => 'Italiensk',
    'locale_ja' => 'Japanese',
    'locale_nl' => 'Dutch',
    'locale_pt' => 'Portuguese',
    'locale_pt-BR' => 'Brasiliansk portugisisk',
    'locale_ru' => 'Russian',
    'locale_sv' => 'Swedish',
    'locale_vi' => 'Vietnamesisk',
    'locale_zh' => 'Chinese Simplified',
    'locale_zh-TW' => 'Chinese Traditional',
    'locale_tr' => 'Turkish',

    'security_title' => 'Sikkerhet',
    'security_help' => 'Endre sikkerhetsinnstillinger for din konto.',
    'password_change' => 'Endre passord',
    'password_current' => 'Gjeldende passord',
    'password_current_placeholder' => 'Skriv inn ditt nåværende passord',
    'password_new1' => 'Nytt passord',
    'password_new1_placeholder' => 'Skriv inn det nye passordet ditt',
    'password_new2' => 'Bekreft nytt passord',
    'password_new2_placeholder' => 'Gjenta nytt passord',
    'password_btn' => 'Endre passord',
    '2fa_title' => 'To-faktor-autentisering',
    '2fa_otp_title' => 'To-faktor autentiserings mobilapp',
    '2fa_enable_title' => 'Sett opp to-faktor-autentisering',
    '2fa_enable_description' => 'Aktiver to-faktor autentisering for å øke sikkerheten på kontoen din.',
    '2fa_enable_otp' => 'Åpne opp din To-faktor autentiserings mobilapp og skann følgende QR-strekkode:',
    '2fa_enable_otp_help' => 'Hvis din to-faktor autentiseringsmobilapp ikke støtter QR-strekkoder, angi følgende kode:',
    '2fa_enable_otp_validate' => 'Vennligst bekreft den nye enheten du akkurat har konfigurert:',
    '2fa_enable_success' => 'To-faktor autentisering aktivert',
    '2fa_enable_error' => 'Feil ved forsøk på å aktivere To-faktor autentisering',
    '2fa_enable_error_already_set' => 'To-faktor autentisering er allerede aktivert',
    '2fa_disable_title' => 'Deaktiver to-faktor autentisering',
    '2fa_disable_description' => 'Deaktiver to-faktor autentisering for kontoen. Vær forsiktig, kontoen din blir mye mindre sikker!',
    '2fa_disable_success' => 'To-faktor autentisering deaktivert',
    '2fa_disable_error' => 'Feil ved forsøk på å deaktivere To-faktor autentisering',

    'webauthn_title' => 'Sikkerhetsnøkkel – WebAuthn protokoll',
    'webauthn_enable_description' => 'Legg til en ny sikkerhetsnøkkel',
    'webauthn_key_name_help' => 'Gi nøkkelen din et navn.',
    'webauthn_key_name' => 'Nøkkelens navn:',
    'webauthn_success' => 'Nøkkelen din ble oppdaget og validert.',
    'webauthn_last_use' => 'Sist bruk: {timestamp}',
    'webauthn_delete_confirmation' => 'Er du sikker på at du vil slette denne nøkkelen?',
    'webauthn_delete_success' => 'Nøkkelen ble slettet',
    'webauthn_insertKey' => 'Sett inn sikkerhetsnøkkelen.',
    'webauthn_buttonAdvise' => 'Hvis sikkerhetsnøkkelen har en knapp, trykk på den.',
    'webauthn_noButtonAdvise' => 'Hvis den ikke fjernes, slett den og sett den inn igjen.',
    'webauthn_not_supported' => 'Nettleseren din støtter for øyeblikket ikke WebAuthn.',
    'webauthn_not_secured' => 'WebAuthn støtter kun sikre tilkoblinger. Last inn denne siden med https plan.',
    'webauthn_error_already_used' => 'Nøkkelen er allerede registrert. Det er ikke nødvendig å registrere den på nytt.',
    'webauthn_error_not_allowed' => 'Operasjonen ble enten tidsavbrutt eller ikke tillatt.',

    'recovery_title' => 'Gjenopprettingskode',
    'recovery_show' => 'Få gjenopprettingskoder',
    'recovery_copy_help' => 'Kopier koder i din utklippstavle',
    'recovery_help_intro' => 'Dette er dine gjenopprettings koder:',
    'recovery_help_information' => 'Du kan bruke hver gjenopprettingskode en gang.',
    'recovery_clipboard' => 'Koder kopiert til utklippstavlen.',
    'recovery_generate' => 'Generer nye koder…',
    'recovery_generate_help' => 'Generering av nye koder vil ugyldiggjøre tidligere genererte koder.',
    'recovery_already_used_help' => 'Denne koden er allerede brukt.',

    'users_list_title' => 'Brukere med tilgang til kontoen din',
    'users_list_add_user' => 'Inviter en ny bruker',
    'users_list_you' => 'Dette er deg',
    'users_list_invitations_title' => 'Ventende invitasjoner',
    'users_list_invitations_explanation' => 'Nedenfor er de du har invitert til å bli med i Monica som samarbeidspartner.',
    'users_list_invitations_invited_by' => 'invitert av :name',
    'users_list_invitations_sent_date' => 'sendt :date',
    'users_blank_title' => 'Du er den eneste som har tilgang til denne kontoen.',
    'users_blank_add_title' => 'Vil du invitere noen andre?',
    'users_blank_description' => 'Denne personen vil ha samme tilgang som du har, og vil kunne legge til, redigere eller slette kontaktinformasjon.',
    'users_blank_cta' => 'Inviter noen',
    'users_add_title' => 'Inviter en ny bruker til kontoen din via e-post',
    'users_add_description' => 'Denne personen vil ha samme tilgang som du gjør, inkludert å invitere eller slette andre brukere, inkludert deg. Vær sikker på at du stoler på denne personen før du gir dem tilgang.',
    'users_add_email_field' => 'Angi e-post til personen du ønsker å invitere',
    'users_add_confirmation' => 'Jeg bekrefter at jeg vil invitere denne brukeren til kontoen min. Jeg forstår at denne personen vil ha tilgang til ALLE data og se nøyaktig hva jeg ser.',
    'users_add_cta' => 'Inviter brukeren via e-post',
    'users_accept_title' => 'Godta invitasjon og opprett en ny konto',
    'users_error_please_confirm' => 'Vennligst bekreft at du vil invitere denne brukeren før du fortsetter med invitasjonen',
    'users_error_email_already_taken' => 'Denne e-post adressen er allerede registrert. Velg en annen',
    'users_error_already_invited' => 'Du har allerede invitert brukeren. Velg en annen e-postadresse.',
    'users_error_email_not_similar' => 'Dette er ikke e-posten til personen som har invitert deg.',
    'users_invitation_deleted_confirmation_message' => 'Invitasjonen er slettet',
    'users_invitations_delete_confirmation' => 'Er du sikker på at du vil slette denne invitasjonen?',
    'users_list_delete_confirmation' => 'Er du sikker på at du vil slette denne brukeren fra kontoen din?',
    'users_invitation_need_subscription' => 'For å legge til flere brukere må du ha et abonnement.',

    'subscriptions_account_current_plan' => 'Din nåværende abonnementsplan',
    'subscriptions_account_current_legacy' => 'Nåværende plan, ikke valgbar lenger:',
    'subscriptions_account_current_paid_plan' => 'Du er på planen :name. Tusen takk for at du er abonnent.',

    'subscriptions_account_next_billing_title' => 'Neste regning',
    'subscriptions_account_next_billing' => 'Abonnementet ditt blir automatisk fornyet <strong>:date</strong>.',
    'subscriptions_account_bill_monthly' => 'Vi fakturerer deg <strong>:price</strong> i <strong>måned</strong>.',
    'subscriptions_account_bill_annual' => 'Vi fakturerer deg <strong>:price</strong> for ytterligere <strong>år</strong>.',
    'subscriptions_account_change' => 'Endre plan',

    'subscriptions_account_cancel_title' => 'Avslutt abonnement',
    'subscriptions_account_cancel_action' => 'Avslutt abonnement',
    'subscriptions_account_cancel' => 'Du kan avslutte abonnementet når som helst.',
    'subscriptions_account_free_plan' => 'Du er på en gratis abonnementsplan.',
    'subscriptions_account_free_plan_upgrade' => 'Du kan oppgradere kontoen din til planen :name, som koster $:price per måned. Her er fordelene:',
    'subscriptions_account_free_plan_benefits_users' => 'Ubegrenset antall brukere',
    'subscriptions_account_free_plan_benefits_reminders' => 'Påminnelser via e-post',
    'subscriptions_account_free_plan_benefits_import_data_vcard' => 'Importer kontaktene dine med vCard',
    'subscriptions_account_free_plan_benefits_support' => 'Støtt prosjektet på lang sikt, slik at vi kan introdusere mer flotte egenskaper.',
    'subscriptions_account_upgrade' => 'Oppgrader din konto',
    'subscriptions_account_upgrade_title' => 'Oppgrader Monica i dag og få mer meningsfylte forhold.',
    'subscriptions_account_upgrade_choice' => 'Velg en plan nedenfor og bli med :customers personer som har oppgradert sin Monica.',
    'subscriptions_account_update_title' => 'Oppdater Monica-abonnement',
    'subscriptions_account_update_description' => 'Du kan endre abonnementets frekvens her.',
    'subscriptions_account_update_information' => 'Du vil bli fakturert umiddelbart for det nye beløpet. Ditt abonnement vil forlenges til den nye perioden, avhengig av ditt valg.',
    'subscriptions_account_invoices' => 'Fakturaer',
    'subscriptions_account_invoices_download' => 'Nedlasting',
    'subscriptions_account_invoices_subscription' => 'Abonnement fra :startDate til :endDate',
    'subscriptions_account_payment' => 'Hvilket betalingsalternativ passer deg best?',
    'subscriptions_account_confirm_payment' => 'Betalingen er for øyeblikket ufullført, <a href=":url">bekreft betalingen</a>.',
    'subscriptions_downgrade_title' => 'Nedgrader din konto til gratisabonnementet',
    'subscriptions_downgrade_limitations' => 'Den frie planen har begrensninger. For å kunne nedgradere, må du bestå sjekklisten nedenfor:',
    'subscriptions_downgrade_rule_users' => 'Du må bare ha én bruker i kontoen din',
    'subscriptions_downgrade_rule_users_constraint' => 'Du har for tiden <a href=":url">1 bruker</a> i din konto.εDu har for tiden <a href=":url">:count brukere</a> på kontoen din.',
    'subscriptions_downgrade_rule_invitations' => 'Du kan ikke ha noen ventende invitasjoner',
    'subscriptions_downgrade_rule_invitations_constraint' => 'Du har for tiden <a href=":url">1 ventende invitasjon</a>.|Du har fortiden <a href=":url">:count Ventende invitasjoner</a>.',
    'subscriptions_downgrade_rule_contacts' => 'Du må ikke ha mer enn :number aktive kontakter',
    'subscriptions_downgrade_rule_contacts_constraint' => 'Du har <a href=":url">1 kontakt</a>. You have for øyeblikket <a href=":url">:count contacts</a>.',
    'subscriptions_downgrade_rule_contacts_archive' => 'Vi kan også <a href=":url">arkivere alle kontaktene dine for deg</a> - det vil tømme denne regelen, og la deg gå videre med nedgraderingsprosessen til din konto.',
    'subscriptions_downgrade_cta' => 'Nedgrader',
    'subscriptions_downgrade_success' => 'Du er tilbake til gratisplanen!',
    'subscriptions_downgrade_thanks' => 'Takk så mye for å prøve den betalte planen. Vi har lagt til nye funksjoner på Monica hele tiden, slik at du kanskje vil komme tilbake i fremtiden for å se om du kanskje er interessert i å melde deg på igjen.',
    'subscriptions_back' => 'Tilbake til innstillinger',
    'subscriptions_upgrade_title' => 'Oppgrader din konto',
    'subscriptions_upgrade_choose' => 'Du valgte :plan planen.',
    'subscriptions_upgrade_infos' => 'Vi kunne ikke være lykkelige. Skriv inn din betalingsinformasjon under.',
    'subscriptions_upgrade_name' => 'Navn på kortet',
    'subscriptions_upgrade_zip' => 'Postnummer',
    'subscriptions_upgrade_credit' => 'Kreditt- eller debet kort',
    'subscriptions_upgrade_submit' => 'Betal {amount}',
    'subscriptions_upgrade_charge' => 'Vi tar betalt for kortet ditt :price nå. Neste trekk vil være den :date. Hvis du noen gang ombestemmer deg, kan du avbryte når som helst, ingen spørsmål blir stilt.',
    'subscriptions_upgrade_charge_handled' => 'Betalingen håndteres av <a href=":url">Stripe</a>. Ingen kortinformasjon berører vår server.',
    'subscriptions_upgrade_success' => 'Takk! Du er nå abonnent.',
    'subscriptions_upgrade_thanks' => 'Velkommen til samfunnet av mennesker som prøver å gjøre verden til et bedre sted.',

    'subscriptions_payment_confirm_title' => 'Bekreft din :amount betaling',
    'subscriptions_payment_confirm_information' => 'Ekstra bekreftelse er nødvendig for å behandle betalingen. Vennligst bekreft betalingen din ved å fylle ut betalingdetaljene dine nedenfor.',
    'subscriptions_payment_succeeded_title' => 'Betaling vellykket',
    'subscriptions_payment_succeeded' => 'Denne betalingen var allerede bekreftet.',
    'subscriptions_payment_cancelled_title' => 'Betalingen ble avbrutt',
    'subscriptions_payment_cancelled' => 'Denne betalingen ble kansellert.',
    'subscriptions_payment_error_name' => 'Skriv inn navnet ditt.',
    'subscriptions_payment_success' => 'Betalingen var vellykket.',

    'subscriptions_pdf_title' => 'Ditt :name månedlige abonnement',
    'subscriptions_plan_frequency_year' => ':amount / år',
    'subscriptions_plan_frequency_month' => ':amount / måned',
    'subscriptions_plan_choose' => 'Velg denne planen',
    'subscriptions_plan_year_title' => 'Betal årlig',
    'subscriptions_plan_year_bonus' => 'Bli med i ett år',
    'subscriptions_plan_month_title' => 'Betal månedlig',
    'subscriptions_plan_month_bonus' => 'Avbryt når som helst',
    'subscriptions_plan_include1' => 'Inkludert med oppgradering:',
    'subscriptions_plan_include2' => 'Ubegrenset antall kontakter • Ubegrenset antall brukere • Påminnelser via e-post • Importer med vCard • Personalisering av kontaktskjemaet',
    'subscriptions_plan_include3' => '100 % av gevinstene går til utviklingen av dette åpne kildekode-prosjektet.',
    'subscriptions_help_title' => 'Ytterligere opplysninger du kan være nysgjerrig på',
    'subscriptions_help_opensource_title' => 'Hva er et åpen kildekode-prosjekt?',
    'subscriptions_help_opensource_desc' => 'Monica er et åpen kildekode-prosjekt. Det betyr at det blir bygget av et samfunn som ønsker å bygge et flott verktøy for mer godt. Å være åpen kildekode betyr at koden er offentlig tilgjengelig på GitHub, og alle kan inspisere den, endre koden eller forbedre den. Alle pengene vi skaffer oss er opptatt av å bygge bedre funksjoner, betale for mer kraftfulle servere og betale andre kostnader. Takk for din hjelp. Vi kunne ikke gjøre det uten deg.',
    'subscriptions_help_limits_title' => 'Er det begrenset hvor mange kontakter vi har på "free plan"?',
    'subscriptions_help_limits_plan' => 'Ja. "free plans" lar deg administrere :number kontakter.',
    'subscriptions_help_discounts_title' => 'Har du rabatter til veldedighet og utdanning?',
    'subscriptions_help_discounts_desc' => 'Vi gjør! Monica er gratis for studenter, og gratis for ikke-fortjeneste og veldedighet. Bare kontakt <a href=":support">brukerstøtte</a> med bevis på din status, og vi bruker denne spesielle statusen i kontoen din.',
    'subscriptions_help_change_title' => 'Hva hvis jeg ombestemmer meg?',
    'subscriptions_help_change_desc' => 'Du kan kansellere når som helst, ingen spørsmål spurt– ingen grunn til å kontakte kundestøtte. Men du vil ikke bli refundert for denne perioden.',

    'stripe_error_card' => 'Kortet ditt ble avslått. Meldingen er: :message',
    'stripe_error_api_connection' => 'Nettverkskommunikasjon med Stripe mislyktes. Prøv igjen senere.',
    'stripe_error_rate_limit' => 'For mange forespørsler med Stripe akkurat nå. Prøv igjen senere.',
    'stripe_error_invalid_request' => 'Ugyldige parametere. Prøv igjen senere.',
    'stripe_error_authentication' => 'Feil godkjenning med Stripe',

    'import_title' => 'Importer kontakter til din konto',
    'import_cta' => 'Last opp kontakter',
    'import_stat' => 'Du har importert :number filer så langt.',
    'import_result_stat' => 'Opplastet vCard med 1 kontakt (:total_imported importen, :total_skippet hoppet over)） Opplastet vCard med :total_contacts (:total_imported importen, :total_skipped skipped)',
    'import_view_report' => 'Vis rapport',
    'import_in_progress' => 'Importen pågår. Oppdater siden om et minutt.',
    'import_upload_title' => 'Importer kontaktene dine fra en vCard-fil',
    'import_upload_rules_desc' => 'Vi har imidlertid noen regler:',
    'import_upload_rule_format' => 'Vi støtter <code>.vcard</code> og <code>.vcf</code> filer.',
    'import_upload_rule_vcard' => 'Vi støtter vCard 3.0 formatet, som er standardformat for macOSs Kontakter.app og Google Kontakter.',
    'import_upload_rule_instructions' => 'Eksporter instruksjonene for <a href=":url1" target="_blank" rel="noopener noreferrer">macOS Contacts.app</a> og <a href=":url2" target="_blank" rel="noopener noreferrer">Google Kontakter</a>.',
    'import_upload_rule_multiple' => 'Hvis kontaktene har flere e-postadresser eller telefonnummer, lagres bare den første oppføringen.',
    'import_upload_rule_limit' => 'Filene er begrenset til 10 MB.',
    'import_upload_rule_time' => 'Det kan ta opptil ett minutt å laste opp kontaktene og behandle dem. Vær tålmodig.',
    'import_upload_rule_cant_revert' => 'Kontroller at dataene er nøyaktige før opplasting, da du ikke kan angre opplastingen.',
    'import_upload_form_file' => 'Din <code>.vcf</code> eller <code>.vCard</code> fil:',
    'import_upload_behaviour' => 'Import oppførsel:',
    'import_upload_behaviour_add' => 'Legg til nye kontakter og hopp over eksisterende',
    'import_upload_behaviour_replace' => 'Erstatt eksisterende kontakter',
    'import_upload_behaviour_help' => 'Erstatning erstatter alle data funnet i vCard, men vil beholde eksisterende kontaktfelt.',
    'import_report_title' => 'Importerer rapport',
    'import_report_date' => 'Dato for import',
    'import_report_type' => 'Import type',
    'import_report_number_contacts' => 'Antall kontakter i filen',
    'import_report_number_contacts_imported' => 'Antall importerte kontakter',
    'import_report_number_contacts_skipped' => 'Antall kontakter hoppet over',
    'import_report_status_imported' => 'Importert',
    'import_report_status_skipped' => 'Utelatt',
    'import_vcard_parse_error' => 'Feil ved analyse av vCard-oppføringen',
    'import_vcard_contact_exist' => 'Kontakten finnes allerede',
    'import_vcard_contact_no_firstname' => 'Har ikke fornavn (obligatorisk)',
    'import_vcard_file_not_found' => 'Finner ikke filen',
    'import_vcard_unknown_entry' => 'Ukjent navn på kontakt',
    'import_vcard_file_no_entries' => 'Filen inneholder ingen oppføringer',
    'import_blank_title' => 'Du har ikke importert noen kontakter enda.',
    'import_blank_question' => 'Vil du importere kontakter nå?',
    'import_blank_description' => 'Vi kan importere vCard-filer som du kan få fra Google Kontakter eller kontakt-behandleren din.',
    'import_blank_cta' => 'Importer vCard',
    'import_need_subscription' => 'Importering av data krever et abonnement.',

    'tags_list_title' => 'Tagger',
    'tags_list_description' => 'Du kan organisere kontaktene dine ved å sette opp tagger. Tagger fungerer som mapper, men du kan legge til flere enn ett tag til en kontakt. For å legge til en ny tag, legg den til selve kontakten.',
    'tags_list_contact_number' => '1 kontakt|:count kontakter',
    'tags_list_delete_success' => 'Taggen har blitt slettet',
    'tags_list_edit_success' => 'The tag has been successfully updated',
    'tags_list_delete_confirmation' => 'Er du sikker på at du vil slette taggen? Ingen kontakter vil bli slettet, bare taggen.',
    'tags_blank_title' => 'Tagger er en flott måte å kategorisere kontaktene på.',
    'tags_blank_description' => 'Merker fungerer som mapper, men du kan legge til flere enn en tag til en kontakt. Gå til kontakt og tagg en venn rett under navnet. Når en kontakt er tagget, kom tilbake hit for å administrere alle taggene på kontoen din.',

    'api_title' => 'API tilgang',
    'api_description' => 'API-et kan brukes til å manipulere Monicas data fra en ekstern applikasjon, for eksempel en mobilapplikasjon.',
    'api_help' => 'For å bruke API er et token obligatorisk. Du kan enten opprette en personlig tilgangstoken (sikker autentisering), eller autorisere en OAuth-klient til å opprette den for deg. Se <a href=":url">API dokumentasjon</a>.',
    'api_endpoint' => 'API-endepunktet for dette Monica-eksempelet er:',

    'api_personal_access_tokens' => 'Personlige tilgangsnøkler',
    'api_pao_description' => 'Sørg for at du gir denne tilgangsnøkkelen til en resurs du stoler på - da de gir deg tilgang til alle dine data.',
    'api_token_title' => 'Personlige tilgangsnøkler',
    'api_token_create_new' => 'Opprett Nytt Token',
    'api_token_not_created' => 'Du har ikke opprettet noen personlig tilgangsnøkkel.',
    'api_token_name' => 'Tokennavn',
    'api_token_expire' => 'Utløper den {date}',
    'api_token_delete' => 'Slett',
    'api_token_create' => 'Opprett Token',
    'api_token_scopes' => 'Omfang',
    'api_token_help' => 'Her er din nye personlige tilgangstoken. Dette er den eneste gangen den blir vist, ikke mist den! Nå kan du bruke dette tokenet til å lage API-forespørsler.',

    'api_oauth_clients' => 'Dine OAuth-klienter',
    'api_oauth_clients_desc' => 'Denne lar deg registrere dine egne OAuth-klienter.',
    'api_oauth_clients_desc2' => 'Bruk denne klient-id til å be om en ny token, og konvertere autorisasjonskoder til å få tilgang til token. Se <a href="{url}">Laravel Passport-dokumentasjon</a> for mer informasjon.',
    'api_oauth_title' => 'OAuth klienter',
    'api_oauth_create_new' => 'Opprett ny klient',
    'api_oauth_edit' => 'Rediger kunde',
    'api_oauth_not_created' => 'Du har ikke opprettet noen OAuth klienter.',
    'api_oauth_clientid' => 'Klient ID',
    'api_oauth_name' => 'Navn',
    'api_oauth_name_help' => 'Noe brukerne dine vil gjenkjenne og stole på.',
    'api_oauth_secret' => 'Hemmelig',
    'api_oauth_create' => 'Opprett kunde',
    'api_oauth_redirecturl' => 'Omdirigere URL',
    'api_oauth_redirecturl_help' => 'Appens autorisasjon tilbakeringing URL.',

    'api_authorized_clients' => 'Liste over autoriserte klienter',
    'api_authorized_clients_desc' => 'Denne delen viser alle klientene du har autorisert til å få tilgang til dine programdata. Du kan når som helst tilbakekalle denne autorisasjonen.',
    'api_authorized_clients_title' => 'Autoriserte applikasjoner',
    'api_authorized_clients_none' => 'Det finnes ingen autoriserte klienter ennå.',
    'api_authorized_clients_name' => 'Navn',
    'api_authorized_clients_scopes' => 'Omfang',

    'personalization_tab_title' => 'Tilpass din konto',

    'personalization_title' => 'Her finner du forskjellige innstillinger for å konfigurere kontoen din. Disse funksjonene er ment for "avanserte brukere" som vil ha maksimal kontroll over Monica.',
    'personalization_contact_field_type_title' => 'Kontaktfelt typer',
    'personalization_contact_field_type_add' => 'Legg til ny felttype',
    'personalization_contact_field_type_description' => 'Du kan konfigurere alle de ulike typene kontaktfeltene som du kan knytte til alle kontaktene dine. For eksempel, hvis et nytt sosialt nettverk vises i fremtiden, du vil kunne legge til denne nye måten å kommunisere med kontaktene dine på her.',
    'personalization_contact_field_type_table_name' => 'Navn',
    'personalization_contact_field_type_table_protocol' => 'Protokoll',
    'personalization_contact_field_type_table_actions' => 'Handlinger',
    'personalization_contact_field_type_modal_title' => 'Legg til en ny kontaktfelttype',
    'personalization_contact_field_type_modal_edit_title' => 'Rediger en eksisterende kontaktfelttype',
    'personalization_contact_field_type_modal_delete_title' => 'Slette en eksisterende kontaktfelttype',
    'personalization_contact_field_type_modal_delete_description' => 'Er du sikker på at du vil slette denne kontakt felttypen? Slette denne typen kontaktfelt vil slette ALLE data med denne typen for alle kontaktene dine.',
    'personalization_contact_field_type_modal_name' => 'Navn',
    'personalization_contact_field_type_modal_protocol' => 'Protokoll (valgfritt)',
    'personalization_contact_field_type_modal_protocol_help' => 'Hver nye kontaktfelttype kan være klikkbare. Hvis en protokoll er satt vil vi bruke den til å utløse handlingen som er satt.',
    'personalization_contact_field_type_modal_icon' => 'Ikon (valgfritt)',
    'personalization_contact_field_type_modal_icon_help' => 'Du kan tilknytte et ikon med denne kontaktfelttypen. Du må legge til en referanse til skrifttype Awesome icon.',
    'personalization_contact_field_type_delete_success' => 'Kontaktfelt type har blitt slettet.',
    'personalization_contact_field_type_add_success' => 'Kontaktfelt typen har blitt opprettet.',
    'personalization_contact_field_type_edit_success' => 'Kontaktfelt type har nå blitt oppdatert.',

    'personalization_genders_title' => 'Kjønn typer',
    'personalization_genders_add' => 'Legg til ny kjønnstype',
    'personalization_genders_desc' => 'Du kan definere så mange kjønn som du trenger det. Du trenger minst én kjønn type på kontoen din.',
    'personalization_genders_modal_add' => 'Legg til kjønn type',
    'personalization_genders_modal_edit' => 'Oppdater kjønnstype',
    'personalization_genders_modal_name' => 'Navn',
    'personalization_genders_modal_name_help' => 'Navnet som brukes til å vise kjønnet på en kontaktside.',
    'personalization_genders_modal_sex' => 'Kjønn',
    'personalization_genders_modal_sex_help' => 'Brukes til å definere forholdet og under VCard-import/eksport-prosessen.',
    'personalization_genders_modal_default' => 'Velg standard kjønn for en ny kontakt',
    'personalization_genders_modal_delete' => 'Slett kjønnstype',
    'personalization_genders_modal_delete_desc' => 'Er du sikker på at du vil slette kjønnet "{name}”?',
    'personalization_genders_modal_delete_question' => 'Du har for øyeblikket {count} kontakt med dette kjønnet Hvis du sletter denne kjønn, hvilket kjønn skal du ta bort denne kontakten? Du har for tiden {count} kontakter med dette kjønnet. Hvis du sletter denne kjønn, hvilket kjønn skal disse kontaktene ha?',
    'personalization_genders_modal_delete_question_default' => 'Dette kjønn er standard. Hvis du sletter denne kjønn som vil være den nye standarden?',
    'personalization_genders_modal_error' => 'Velg et kjønn fra listen.',
    'personalization_genders_list_contact_number' => '{count} kontakt|{count} kontakter',
    'personalization_genders_table_name' => 'Navn',
    'personalization_genders_table_sex' => 'Kjønn',
    'personalization_genders_table_default' => 'Standard',
    'personalization_genders_default' => 'Standard kjønn',
    'personalization_genders_make_default' => 'Endre standard kjønn',
    'personalization_genders_select_default' => 'Velg standard kjønn',
    'personalization_genders_m' => 'Mann',
    'personalization_genders_f' => 'Kvinne',
    'personalization_genders_o' => 'Annet',
    'personalization_genders_u' => 'Ukjent',
    'personalization_genders_n' => 'Ingen eller ikke relevant',

    'personalization_reminder_rule_save' => 'Endringen er lagret',
    'personalization_reminder_rule_title' => 'Regler for påminnelse',
    'personalization_reminder_rule_line' => '{count} dag før{count} dager før',
    'personalization_reminder_rule_desc' => 'For hver påminnelse du angir, kan Monica sende deg en e-post med en rekke dager før arrangementet skjer. Du kan justere disse varslingsinnstillingene her. Disse varslene gjelder bare for månedlige og årlige påminnelser.',

    'personalization_module_save' => 'Endringen er lagret',
    'personalization_module_title' => 'Funksjoner',
    'personalization_module_desc' => 'Det er mulig at du ikke trenger alle funksjonene til Monica. Nedenfor kan du endre bestemte funksjoner som brukes på et kontaktark. Denne endringen vil påvirke ALLE kontaktene dine. Ved å skru av en funksjon sletter du ikke data, vil den bare skjules funksjonen.',

    'personalisation_paid_upgrade' => 'Dette er en premium-funksjon som krever at et betalt abonnement er aktiv. Oppgrader kontoen din ved å gå til <a href=":url">Innstillinger > Abonnement</a>.',
    'personalisation_paid_upgrade_vue' => 'Dette er en premium-funksjon som krever at et betalt abonnement er aktiv. Oppgrader kontoen din ved å gå til <a href="{url}">Innstillinger > Abonnement</a>.',

    'reminder_time_to_send' => 'Tidspunkt på dagen du ønsker påminnelser skal bli sendt',
    'reminder_time_to_send_help' => 'Din neste påminnelse er planlagt å bli sendt den <span title="{dateTimeUtc}" class="reminder-info">{dateTime}</span>.',

    'personalization_activity_type_category_title' => 'Kategorier av aktivitetstype',
    'personalization_activity_type_category_add' => 'Legg til en ny aktivitetstype kategori',
    'personalization_activity_type_category_table_name' => 'Navn',
    'personalization_activity_type_category_description' => 'En aktivitet med en av kontaktene dine kan ha en type og kategori type. Kontoen din kommer med et sett med forhåndsdefinerte kategorityper som standard, men du kan tilpasse disse her.',
    'personalization_activity_type_category_table_actions' => 'Handlinger',
    'personalization_activity_type_category_modal_add' => 'Legg til en ny aktivitetstype kategori',
    'personalization_activity_type_category_modal_edit' => 'Endre en aktivitetstype kategori',
    'personalization_activity_type_category_modal_question' => 'Hva bør vi kalle denne nye kategorien?',
    'personalization_activity_type_add_button' => 'Legg til en ny aktivitetstype',
    'personalization_activity_type_modal_add' => 'Legg til en ny aktivitetstype',
    'personalization_activity_type_modal_question' => 'Hva bør vi kalle denne nye aktivitetstypen?',
    'personalization_activity_type_modal_edit' => 'Endre en aktivitetstype',
    'personalization_activity_type_category_modal_delete' => 'Slett aktivitetstype kategori',
    'personalization_activity_type_category_modal_delete_desc' => 'Er du sikker på at du vil slette denne kategorien? Sletting vil slette alle tilknyttede aktivitetstyper. Aktiviteter som tilhører denne kategorien vil ikke bli påvirket av denne slettingen.',
    'personalization_activity_type_modal_delete' => 'Slett en aktivitetstype',
    'personalization_activity_type_modal_delete_desc' => 'Er du sikker på at du vil slette denne aktivitetstypen? Aktiviteter som tilhører denne kategorien påvirkes ikke av denne slettingen.',
    'personalization_activity_type_modal_delete_error' => 'Vi finner ikke denne aktivitetstypen.',
    'personalization_activity_type_category_modal_delete_error' => 'Vi finner ikke denne aktivitetstype kategorien.',

    'personalization_life_event_category_title' => 'Kategorier for livets hendelser',
    'personalization_live_event_category_table_name' => 'Navn',
    'personalization_life_event_category_description' => 'En livshendelse kan ha en type og en kategori. Kontoen din kommer med et sett av forhåndsdefinerte kategorier og typer som standard, men du kan tilpasse livstyper her.',
    'personalization_live_event_category_table_actions' => 'Handlinger',
    'personalization_life_event_type_add_button' => 'Legg til en ny hendelsestype',
    'personalization_life_event_type_modal_add' => 'Legg til en ny livs hendelsetype',
    'personalization_life_event_type_modal_question' => 'Hva skal vi kalle denne nye livshendelsestypen?',
    'personalization_life_event_type_modal_edit' => 'Rediger en livshendelsetype',
    'personalization_life_event_type_modal_delete' => 'Slette en livshendelse',
    'personalization_life_event_type_modal_delete_desc' => 'Er du sikker på at du vil slette denne livshendelsen? Livshendelser som tilhører denne typen vil bli slettet ved å utføre denne handlingen.',
    'personalization_life_event_type_modal_delete_error' => 'Vi kan ikke finne denne typen livshendelse.',

    'personalization_life_event_category_work_education' => 'Arbeid og utdanning',
    'personalization_life_event_category_family_relationships' => 'Familier og relasjoner',
    'personalization_life_event_category_home_living' => 'Hjem og hendelser',
    'personalization_life_event_category_travel_experiences' => 'Reiser og opplevelser',
    'personalization_life_event_category_health_wellness' => 'Helse og velvære',

    'personalization_life_event_type_new_job' => 'Ny jobb',
    'personalization_life_event_type_retirement' => 'Pensjonert',
    'personalization_life_event_type_new_school' => 'Ny skole',
    'personalization_life_event_type_study_abroad' => 'Studie i utlandet',
    'personalization_life_event_type_volunteer_work' => 'Frivillig arbeid',
    'personalization_life_event_type_published_book_or_paper' => 'Publiserte bok eller avisartikkel',
    'personalization_life_event_type_military_service' => 'Militær tjeneste',
    'personalization_life_event_type_first_met' => 'Første møte',
    'personalization_life_event_type_new_relationship' => 'Nytt forhold',
    'personalization_life_event_type_engagement' => 'Engasjement',
    'personalization_life_event_type_marriage' => 'Ekteskap',
    'personalization_life_event_type_anniversary' => 'Jubileum',
    'personalization_life_event_type_expecting_a_baby' => 'Forventer en baby',
    'personalization_life_event_type_new_child' => 'Nytt barn',
    'personalization_life_event_type_new_family_member' => 'Nytt familiemedlem',
    'personalization_life_event_type_new_pet' => 'Nytt kjæledyr',
    'personalization_life_event_type_end_of_relationship' => 'Avsluttet forholdet',
    'personalization_life_event_type_loss_of_a_loved_one' => 'Mistet et familiemedlem',
    'personalization_life_event_type_moved' => 'Flyttet',
    'personalization_life_event_type_bought_a_home' => 'Kjøpt et hjem',
    'personalization_life_event_type_home_improvement' => 'Oppussing',
    'personalization_life_event_type_holidays' => 'Ferier',
    'personalization_life_event_type_new_vehicle' => 'Nytt kjøretøy',
    'personalization_life_event_type_new_roommate' => 'Ny samboer',
    'personalization_life_event_type_overcame_an_illness' => 'Overkom en sykdom',
    'personalization_life_event_type_quit_a_habit' => 'Avslutt en vane',
    'personalization_life_event_type_new_eating_habits' => 'Nye spisevaner',
    'personalization_life_event_type_weight_loss' => 'Vekttap',
    'personalization_life_event_type_wear_glass_or_contact' => 'Startet å bruke briller eller kontaktlinser',
    'personalization_life_event_type_broken_bone' => 'Knakk et bein',
    'personalization_life_event_type_removed_braces' => 'Fikk fjernet regulering',
    'personalization_life_event_type_surgery' => 'Fikk kirurgi',
    'personalization_life_event_type_dentist' => 'Hadde tannbehandling',
    'personalization_life_event_type_new_sport' => 'Startet med en ny sport',
    'personalization_life_event_type_new_hobby' => 'Begynte med en ny hobby',
    'personalization_life_event_type_new_instrument' => 'Begynte å lære et nytt instrument',
    'personalization_life_event_type_new_language' => 'Startet å lære et nytt språk',
    'personalization_life_event_type_tattoo_or_piercing' => 'Tatovering eller piercing',
    'personalization_life_event_type_new_license' => 'Nytt sertifikat',
    'personalization_life_event_type_travel' => 'Reise',
    'personalization_life_event_type_achievement_or_award' => 'Prestasjon eller pris',
    'personalization_life_event_type_changed_beliefs' => 'Endret livs tro',
    'personalization_life_event_type_first_word' => 'Første ord',
    'personalization_life_event_type_first_kiss' => 'Første kyss',

    'storage_title' => 'Lagring',
    'storage_account_info' => 'Begrensningen på kontoen din er :accountLimit MB. Din gjeldende bruk er :currentAccountSize MB (ca :percentUsage%).',
    'storage_upgrade_notice' => 'Oppgrader kontoen din for å kunne laste opp dokumenter og bilder.',
    'storage_description' => 'Her kan du se alle dokumenter og bilder som er lastet opp under kontaktene dine.',

    'dav_title' => 'WebDAV',
    'dav_description' => 'Her finner du alle innstillingene til å bruke med WebDAV-ressurser til CardDAV-og CalDAV-eksport.',
    'dav_copy_help' => 'Kopier til utklippstavle',
    'dav_clipboard_copied' => 'Verdi kopiert til utklippstavle',
    'dav_url_base' => 'Basis url for alle CardDAV-og CalDAV-ressurser:',
    'dav_connect_help' => 'Du kan koble kontakter og/eller kalendere med denne base-url på din telefon eller datamaskin.',
    'dav_connect_help2' => 'Bruk innloggingen din (e-post) og opprett et API-token som passord for å godkjenne.',
    'dav_url_carddav' => 'CardDAV url for kontakt-ressurs:',
    'dav_url_caldav_birthdays' => 'CalDAV url for bursdags ressurser:',
    'dav_url_caldav_tasks' => 'CalDAV-url for oppgave-ressurser:',
    'dav_title_carddav' => 'CardDAV',
    'dav_title_caldav' => 'CalDAV',
    'dav_carddav_export' => 'Eksporter alle kontakter i en fil',
    'dav_caldav_birthdays_export' => 'Eksporter alle bursdager i en fil',
    'dav_caldav_tasks_export' => 'Eksporter alle oppgaver til en fil',

    'archive_title' => 'Arkiver alle kontaktene i kontoen din',
    'archive_desc' => 'Dette vil arkivere alle kontaktene i kontoen din.',
    'archive_cta' => 'Arkiver alle kontaktene dine',

    'logs_title' => 'Alt som har skjedd med denne kontoen',
    'logs_actor' => 'Aktør',
    'logs_timestamp' => 'Tidsstempel',
    'logs_description' => 'Beskrivelse',
    'logs_subject' => 'Emne',
    'logs_size' => 'Størrelse (Kb)',
    'logs_object' => 'Objekt',
];
