"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiBadgeGroup", {
  enumerable: true,
  get: function get() {
    return _badge_group.EuiBadgeGroup;
  }
});
exports.OuiBadgeGroup = exports.GUTTER_SIZES = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _common = require("../../common");

var _badge_group = require("../../../eui_components/badge/badge_group/badge_group");

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var gutterSizeToClassNameMap = {
  none: null,
  xs: 'ouiBadgeGroup--gutterExtraSmall',
  s: 'ouiBadgeGroup--gutterSmall'
};
var GUTTER_SIZES = (0, _common.keysOf)(gutterSizeToClassNameMap);
exports.GUTTER_SIZES = GUTTER_SIZES;
var OuiBadgeGroup = /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var children = _ref.children,
      className = _ref.className,
      _ref$gutterSize = _ref.gutterSize,
      gutterSize = _ref$gutterSize === void 0 ? 'xs' : _ref$gutterSize,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["children", "className", "gutterSize"]);
  var classes = (0, _classnames.default)('ouiBadgeGroup', gutterSizeToClassNameMap[gutterSize], className);
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    className: classes,
    ref: ref
  }, rest), _react.default.Children.map(children, function (child) {
    return /*#__PURE__*/_react.default.createElement("span", {
      className: "ouiBadgeGroup__item"
    }, child);
  }));
});
exports.OuiBadgeGroup = OuiBadgeGroup;
OuiBadgeGroup.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,

  /**
     * Space between badges
     */
  gutterSize: _propTypes.default.oneOf(["none", "xs", "s"]),

  /**
     * Should be a list of OuiBadge's but can also be any other element
     * Will apply an extra class to add spacing
     */
  children: _propTypes.default.node
};
OuiBadgeGroup.displayName = 'OuiBadgeGroup';
/* OUI -> EUI Aliases: Build-Time */

/* OUI -> EUI Aliases: Build-Time */