"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiComboBoxInput = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _reactInputAutosize = _interopRequireDefault(require("react-input-autosize"));

var _accessibility = require("../../accessibility");

var _form_control_layout = require("../../form/form_control_layout");

var _icon = require("../../icon");

var _combo_box_pill = require("./combo_box_pill");

var _services = require("../../../services");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } } /*
                                                                                                                                                                                                                                                                                                                                      * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                                      *
                                                                                                                                                                                                                                                                                                                                      * The OpenSearch Contributors require contributions made to
                                                                                                                                                                                                                                                                                                                                      * this file be licensed under the Apache-2.0 license or a
                                                                                                                                                                                                                                                                                                                                      * compatible open source license.
                                                                                                                                                                                                                                                                                                                                      *
                                                                                                                                                                                                                                                                                                                                      * Modifications Copyright OpenSearch Contributors. See
                                                                                                                                                                                                                                                                                                                                      * GitHub history for details.
                                                                                                                                                                                                                                                                                                                                      */ /*
                                                                                                                                                                                                                                                                                                                                          * Licensed to Elasticsearch B.V. under one or more contributor
                                                                                                                                                                                                                                                                                                                                          * license agreements. See the NOTICE file distributed with
                                                                                                                                                                                                                                                                                                                                          * this work for additional information regarding copyright
                                                                                                                                                                                                                                                                                                                                          * ownership. Elasticsearch B.V. licenses this file to you under
                                                                                                                                                                                                                                                                                                                                          * the Apache License, Version 2.0 (the "License"); you may
                                                                                                                                                                                                                                                                                                                                          * not use this file except in compliance with the License.
                                                                                                                                                                                                                                                                                                                                          * You may obtain a copy of the License at
                                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                                          *    http://www.apache.org/licenses/LICENSE-2.0
                                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                                          * Unless required by applicable law or agreed to in writing,
                                                                                                                                                                                                                                                                                                                                          * software distributed under the License is distributed on an
                                                                                                                                                                                                                                                                                                                                          * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
                                                                                                                                                                                                                                                                                                                                          * KIND, either express or implied.  See the License for the
                                                                                                                                                                                                                                                                                                                                          * specific language governing permissions and limitations
                                                                                                                                                                                                                                                                                                                                          * under the License.
                                                                                                                                                                                                                                                                                                                                          */

var EuiComboBoxInput = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(EuiComboBoxInput, _Component);

  var _super = _createSuper(EuiComboBoxInput);

  function EuiComboBoxInput() {
    var _this;

    (0, _classCallCheck2.default)(this, EuiComboBoxInput);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", {
      hasFocus: false
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "updatePosition", function () {
      // Wait a beat for the DOM to update, since we depend on DOM elements' bounds.
      requestAnimationFrame(function () {
        _this.props.updatePosition();
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onFocus", function (event) {
      _this.props.onFocus(event);

      _this.setState({
        hasFocus: true
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onBlur", function (event) {
      if (_this.props.onBlur) {
        _this.props.onBlur(event);
      }

      _this.setState({
        hasFocus: false
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "inputOnChange", function (event) {
      var _this$props = _this.props,
          onChange = _this$props.onChange,
          searchValue = _this$props.searchValue;

      if (onChange) {
        onChange(event.target.value);
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "inputRefCallback", function (ref) {
      var autoSizeInputRef = _this.props.autoSizeInputRef;

      if (autoSizeInputRef) {
        autoSizeInputRef(ref);
      }
    });
    return _this;
  }

  (0, _createClass2.default)(EuiComboBoxInput, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      var searchValue = prevProps.searchValue; // We need to update the position of everything if the user enters enough input to change
      // the size of the input.

      if (searchValue !== this.props.searchValue) {
        this.updatePosition();
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          compressed = _this$props2.compressed,
          focusedOptionId = _this$props2.focusedOptionId,
          fullWidth = _this$props2.fullWidth,
          hasSelectedOptions = _this$props2.hasSelectedOptions,
          iconProp = _this$props2.icon,
          id = _this$props2.id,
          inputRef = _this$props2.inputRef,
          isDisabled = _this$props2.isDisabled,
          isListOpen = _this$props2.isListOpen,
          noIcon = _this$props2.noIcon,
          onClear = _this$props2.onClear,
          onClick = _this$props2.onClick,
          onCloseListClick = _this$props2.onCloseListClick,
          onOpenListClick = _this$props2.onOpenListClick,
          onRemoveOption = _this$props2.onRemoveOption,
          placeholder = _this$props2.placeholder,
          rootId = _this$props2.rootId,
          searchValue = _this$props2.searchValue,
          selectedOptions = _this$props2.selectedOptions,
          singleSelectionProp = _this$props2.singleSelection,
          toggleButtonRef = _this$props2.toggleButtonRef,
          value = _this$props2.value,
          prepend = _this$props2.prepend,
          append = _this$props2.append,
          isLoading = _this$props2.isLoading,
          autoFocus = _this$props2.autoFocus;
      var singleSelection = Boolean(singleSelectionProp);
      var asPlainText = singleSelectionProp && (0, _typeof2.default)(singleSelectionProp) === 'object' && singleSelectionProp.asPlainText || false;
      var pills = selectedOptions ? selectedOptions.map(function (option) {
        var key = option.key,
            label = option.label,
            color = option.color,
            onClick = option.onClick,
            rest = (0, _objectWithoutProperties2.default)(option, ["key", "label", "color", "onClick"]);
        var pillOnClose = isDisabled || singleSelection || onClick ? undefined : onRemoveOption;
        return /*#__PURE__*/_react.default.createElement(_combo_box_pill.EuiComboBoxPill, (0, _extends2.default)({
          option: option,
          onClose: pillOnClose,
          key: key !== null && key !== void 0 ? key : label.toLowerCase(),
          color: color,
          onClick: onClick,
          onClickAriaLabel: onClick ? 'Change' : undefined,
          asPlainText: asPlainText
        }, rest), label);
      }) : null;
      var removeOptionMessage;
      var removeOptionMessageId;

      if (this.state.hasFocus) {
        var readPlaceholder = placeholder ? "".concat(placeholder, ".") : '';
        var removeOptionMessageContent = "Combo box. Selected. ".concat(searchValue ? "".concat(searchValue, ". Selected. ") : '').concat(selectedOptions && selectedOptions.length > 0 ? "".concat(value, ". Press Backspace to delete ").concat(selectedOptions[selectedOptions.length - 1].label, ". ") : '', "Combo box input. ").concat(readPlaceholder, " Type some text or, to display a list of choices, press Down Arrow. ") + 'To exit the list of choices, press Escape.';
        removeOptionMessageId = (0, _services.htmlIdGenerator)()(); // aria-live="assertive" will read this message aloud immediately once it enters the DOM.
        // We'll render to the DOM when the input gains focus and remove it when the input loses focus.
        // We'll use aria-hidden to prevent default aria information from being read by the screen
        // reader.

        removeOptionMessage = /*#__PURE__*/_react.default.createElement(_accessibility.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("span", {
          "aria-live": "assertive",
          id: removeOptionMessageId
        }, removeOptionMessageContent));
      }

      var placeholderMessage;

      if (placeholder && selectedOptions && !selectedOptions.length && !searchValue) {
        placeholderMessage = /*#__PURE__*/_react.default.createElement("p", {
          className: "euiComboBoxPlaceholder"
        }, placeholder);
      }

      var clickProps = {};

      if (!isDisabled && onClear && hasSelectedOptions) {
        clickProps.clear = {
          'data-test-subj': 'comboBoxClearButton',
          onClick: onClear
        };
      }

      var formControlIcon;

      if (!noIcon) {
        formControlIcon = {
          'aria-label': isListOpen ? 'Close list of options' : 'Open list of options',
          'data-test-subj': 'comboBoxToggleListButton',
          disabled: isDisabled,
          onClick: isListOpen && !isDisabled ? onCloseListClick : onOpenListClick,
          ref: toggleButtonRef,
          side: 'right',
          type: 'arrowDown'
        };
      }

      var icon;

      if (!!iconProp) {
        var iconClasses = (0, _classnames.default)('euiComboBoxPill', 'euiComboBoxIcon');
        icon = /*#__PURE__*/_react.default.createElement(_icon.EuiIcon, {
          type: typeof iconProp === 'string' ? iconProp : 'search',
          size: compressed ? 's' : 'm',
          className: iconClasses,
          "data-test-subj": "comboBoxIcon"
        });
      }

      var wrapClasses = (0, _classnames.default)('euiComboBox__inputWrap', {
        'euiComboBox__inputWrap--compressed': compressed,
        'euiComboBox__inputWrap--fullWidth': fullWidth,
        'euiComboBox__inputWrap--noWrap': singleSelection,
        'euiComboBox__inputWrap-isLoading': isLoading,
        'euiComboBox__inputWrap-isClearable': onClear,
        'euiComboBox__inputWrap--inGroup': prepend || append
      });
      return /*#__PURE__*/_react.default.createElement(_form_control_layout.EuiFormControlLayout, (0, _extends2.default)({
        icon: formControlIcon
      }, clickProps, {
        isLoading: isLoading,
        compressed: compressed,
        fullWidth: fullWidth,
        prepend: prepend,
        append: append
      }), /*#__PURE__*/_react.default.createElement("div", {
        className: wrapClasses,
        "data-test-subj": "comboBoxInput",
        onClick: onClick,
        tabIndex: -1 // becomes onBlur event's relatedTarget, otherwise relatedTarget is null when clicking on this div

      }, icon, !singleSelection || !searchValue ? pills : null, placeholderMessage, /*#__PURE__*/_react.default.createElement(_reactInputAutosize.default, {
        "aria-activedescendant": focusedOptionId,
        "aria-controls": isListOpen ? rootId('listbox') : '',
        className: "euiComboBox__input",
        "data-test-subj": "comboBoxSearchInput",
        disabled: isDisabled,
        id: id,
        inputRef: inputRef,
        onBlur: this.onBlur,
        onChange: this.inputOnChange,
        onFocus: this.onFocus,
        ref: this.inputRefCallback,
        role: "textbox",
        style: {
          fontSize: 14
        },
        value: searchValue,
        autoFocus: autoFocus
      }), removeOptionMessage));
    }
  }]);
  return EuiComboBoxInput;
}(_react.Component);

exports.EuiComboBoxInput = EuiComboBoxInput;
EuiComboBoxInput.propTypes = {
  autoSizeInputRef: _propTypes.default.any,
  compressed: _propTypes.default.bool.isRequired,
  focusedOptionId: _propTypes.default.string,
  fullWidth: _propTypes.default.bool,
  hasSelectedOptions: _propTypes.default.bool.isRequired,
  icon: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "aggregate", "alert", "analyzeEvent", "annotation", "anomalyDetection", "apmApp", "apmTrace", "apps", "appSearchApp", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "asterisk", "auditbeatApp", "beaker", "bell", "bellSlash", "bolt", "bookOpen", "boxesHorizontal", "boxesVertical", "branch", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "codeApp", "chatLeft", "chatRight", "check", "checkInCircleEmpty", "checkInCircleFilled", "cheer", "classificationJob", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "color", "compass", "compute", "console", "consoleApp", "continuityAbove", "continuityAboveBelow", "continuityBelow", "continuityWithin", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crosshairs", "crossInACircleFilled", "crossInCircleEmpty", "crossInCircleFilled", "currency", "cut", "dashboard", "dashboardApp", "database", "dataVisualizer", "devToolsApp", "discoverApp", "document", "documentation", "documentEdit", "documents", "dot", "download", "dockedBottom", "dockedDetached", "dockedLeft", "dockedRight", "dockedTakeover", "dockedTop", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignLeft", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "eql", "eraser", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "flag", "fold", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "frameNext", "framePrevious", "fullScreen", "fullScreenExit", "function", "functionAdd", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "history", "home", "iInCircle", "image", "importAction", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexRuntime", "indexSettings", "inputOutput", "inspect", "integrationGeneral", "integrationObservability", "integrationSearch", "integrationSecurity", "invert", "ip", "keyboardShortcut", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "layers", "lensApp", "lineChart", "link", "list", "listAdd", "lock", "lockOpen", "logsApp", "logoAerospike", "logoApache", "logoAppSearch", "logoAWS", "logoAWSMono", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticsearch", "logoElasticStack", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOpenSearch", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuDown", "menuLeft", "menuRight", "menuUp", "merge", "metricbeatApp", "metricsApp", "minimize", "minus", "minusInCircle", "minusInCircleFilled", "mobile", "monitoringApp", "moon", "nested", "node", "notebookApp", "number", "offline", "online", "outlierDetectionJob", "package", "packetbeatApp", "pageSelect", "pagesSelect", "partial", "paperClip", "pause", "pencil", "percent", "pin", "pinFilled", "pipelineApp", "play", "playFilled", "plus", "plusInCircle", "plusInCircleFilled", "polygon", "popout", "power", "pulse", "push", "questionInCircle", "quote", "radar", "radius", "recent", "recentlyViewedApp", "redeploy", "refresh", "regressionJob", "reporter", "reportingApp", "returnKey", "rocket", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "shard", "share", "snowflake", "sortable", "sortDown", "sortLeft", "sortRight", "sortUp", "spacesApp", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "swatchInput", "symlink", "tableOfContents", "tableDensityExpanded", "tableDensityCompact", "tableDensityNormal", "tag", "tear", "temperature", "thumbsDown", "thumbsUp", "timeline", "timelionApp", "timeslider", "training", "trash", "upgradeAssistantApp", "uptimeApp", "undeploy", "unfold", "unlink", "user", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visBuilder", "visBuilderSavedObject", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visQueryDQL", "visQueryPPL", "visQueryPromQL", "visQuerySQL", "visTable", "visTagCloud", "visText", "visTimelion", "visualizeApp", "visVega", "visVisualBuilder", "watchesApp", "wordWrap", "wordWrapDisabled", "workplaceSearchApp", "wrench", "tokenClass", "tokenProperty", "tokenEnum", "tokenVariable", "tokenMethod", "tokenAnnotation", "tokenException", "tokenInterface", "tokenParameter", "tokenField", "tokenElement", "tokenFunction", "tokenBoolean", "tokenString", "tokenArray", "tokenNumber", "tokenConstant", "tokenObject", "tokenEvent", "tokenKey", "tokenNull", "tokenStruct", "tokenPackage", "tokenOperator", "tokenEnumMember", "tokenRepo", "tokenSymbol", "tokenFile", "tokenModule", "tokenNamespace", "tokenDate", "tokenIP", "tokenNested", "tokenAlias", "tokenShape", "tokenGeo", "tokenRange", "tokenBinary", "tokenJoin", "tokenPercolator", "tokenFlattened", "tokenRankFeature", "tokenRankFeatures", "tokenKeyword", "tokenCompletionSuggester", "tokenDenseVector", "tokenText", "tokenTokenCount", "tokenSearchType", "tokenHistogram", "wsAnalytics", "wsEssentials", "wsObservability", "wsSearch", "wsSecurityAnalytics", "wsSelector"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired]).isRequired, _propTypes.default.bool.isRequired]),
  id: _propTypes.default.string,
  inputRef: _propTypes.default.any,
  isDisabled: _propTypes.default.bool,
  isListOpen: _propTypes.default.bool.isRequired,
  noIcon: _propTypes.default.bool.isRequired,
  onBlur: _propTypes.default.any,
  onChange: _propTypes.default.func,
  onClear: _propTypes.default.func,
  onClick: _propTypes.default.func,
  onCloseListClick: _propTypes.default.func.isRequired,
  onFocus: _propTypes.default.any.isRequired,
  onOpenListClick: _propTypes.default.func.isRequired,
  onRemoveOption: _propTypes.default.func,
  placeholder: _propTypes.default.string,
  rootId: _propTypes.default.any.isRequired,
  searchValue: _propTypes.default.string.isRequired,
  selectedOptions: _propTypes.default.arrayOf(_propTypes.default.shape({
    isGroupLabelOption: _propTypes.default.bool,
    label: _propTypes.default.string.isRequired,
    key: _propTypes.default.string,
    options: _propTypes.default.arrayOf(_propTypes.default.shape({
      isGroupLabelOption: _propTypes.default.bool,
      label: _propTypes.default.string.isRequired,
      key: _propTypes.default.string,
      options: _propTypes.default.arrayOf(_propTypes.default.any.isRequired),
      value: _propTypes.default.any,
      className: _propTypes.default.string,
      "aria-label": _propTypes.default.string,
      "data-test-subj": _propTypes.default.string
    }).isRequired),
    value: _propTypes.default.any,
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string
  }).isRequired),
  singleSelection: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.shape({
    asPlainText: _propTypes.default.bool
  }).isRequired]),
  toggleButtonRef: _propTypes.default.any,
  updatePosition: _propTypes.default.func.isRequired,
  value: _propTypes.default.string,
  prepend: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired, _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired).isRequired]),
  append: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired, _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired).isRequired]),
  isLoading: _propTypes.default.bool,
  autoFocus: _propTypes.default.bool,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string
};