"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TEXT2VIZ_API = exports.TEXT2VEGA_WITH_INSTRUCTIONS_AGENT_CONFIG_ID = exports.TEXT2VEGA_RULE_BASED_AGENT_CONFIG_ID = exports.TEXT2VEGA_INPUT_SIZE_LIMIT = exports.TEXT2PPL_AGENT_CONFIG_ID = exports.SUMMARY_ASSISTANT_API = exports.NOTEBOOK_PREFIX = exports.NOTEBOOK_API = exports.DSL_SEARCH = exports.DSL_BASE = exports.DEFAULT_USER_NAME = exports.ASSISTANT_API = exports.API_BASE = exports.AGENT_API = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const API_BASE = exports.API_BASE = '/api/assistant';
const DSL_BASE = exports.DSL_BASE = '/api/dsl';
const DSL_SEARCH = exports.DSL_SEARCH = '/search';
const NOTEBOOK_PREFIX = exports.NOTEBOOK_PREFIX = '/api/observability/notebooks';
const ASSISTANT_API = exports.ASSISTANT_API = {
  SEND_MESSAGE: `${API_BASE}/send_message`,
  CONVERSATION: `${API_BASE}/conversation`,
  CONVERSATIONS: `${API_BASE}/conversations`,
  FEEDBACK: `${API_BASE}/feedback`,
  ABORT_AGENT_EXECUTION: `${API_BASE}/abort`,
  REGENERATE: `${API_BASE}/regenerate`,
  TRACE: `${API_BASE}/trace`,
  ACCOUNT: `${API_BASE}/account`
};
const TEXT2VIZ_API = exports.TEXT2VIZ_API = {
  TEXT2PPL: `${API_BASE}/text2ppl`,
  TEXT2VEGA: `${API_BASE}/text2vega`
};
const AGENT_API = exports.AGENT_API = {
  EXECUTE: `${API_BASE}/agent/_execute`,
  CONFIG_EXISTS: `${API_BASE}/agent_config/_exists`
};
const SUMMARY_ASSISTANT_API = exports.SUMMARY_ASSISTANT_API = {
  SUMMARIZE: `${API_BASE}/summary`,
  INSIGHT: `${API_BASE}/insight`,
  DATA2SUMMARY: `${API_BASE}/data2summary`
};
const NOTEBOOK_API = exports.NOTEBOOK_API = {
  CREATE_NOTEBOOK: `${NOTEBOOK_PREFIX}/note`,
  SET_PARAGRAPH: `${NOTEBOOK_PREFIX}/set_paragraphs/`
};
const DEFAULT_USER_NAME = exports.DEFAULT_USER_NAME = 'User';
const TEXT2VEGA_INPUT_SIZE_LIMIT = exports.TEXT2VEGA_INPUT_SIZE_LIMIT = 400;
const TEXT2VEGA_RULE_BASED_AGENT_CONFIG_ID = exports.TEXT2VEGA_RULE_BASED_AGENT_CONFIG_ID = 'os_text2vega';
const TEXT2VEGA_WITH_INSTRUCTIONS_AGENT_CONFIG_ID = exports.TEXT2VEGA_WITH_INSTRUCTIONS_AGENT_CONFIG_ID = 'os_text2vega_with_instructions';
const TEXT2PPL_AGENT_CONFIG_ID = exports.TEXT2PPL_AGENT_CONFIG_ID = 'os_query_assist_ppl';
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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