"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerAgentRoutes = registerAgentRoutes;
var _configSchema = require("@osd/config-schema");
var _llm = require("../../common/constants/llm");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function registerAgentRoutes(router, assistantService) {
  router.post({
    path: _llm.AGENT_API.EXECUTE,
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.oneOf([_configSchema.schema.object({
        dataSourceId: _configSchema.schema.maybe(_configSchema.schema.string()),
        agentId: _configSchema.schema.string()
      }), _configSchema.schema.object({
        dataSourceId: _configSchema.schema.maybe(_configSchema.schema.string()),
        agentConfigName: _configSchema.schema.string()
      })])
    }
  }, router.handleLegacyErrors(async (context, req, res) => {
    try {
      const assistantClient = assistantService.getScopedClient(req, context);
      if ('agentId' in req.query) {
        const response = await assistantClient.executeAgent(req.query.agentId, req.body);
        return res.ok({
          body: response
        });
      }
      const response = await assistantClient.executeAgentByConfigName(req.query.agentConfigName, req.body);
      return res.ok({
        body: response
      });
    } catch (e) {
      return res.badRequest();
    }
  }));
  router.get({
    path: _llm.AGENT_API.CONFIG_EXISTS,
    validate: {
      query: _configSchema.schema.oneOf([_configSchema.schema.object({
        dataSourceId: _configSchema.schema.maybe(_configSchema.schema.string()),
        agentConfigName: _configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.arrayOf(_configSchema.schema.string())])
      })])
    }
  }, router.handleLegacyErrors(async (context, req, res) => {
    try {
      const assistantClient = assistantService.getScopedClient(req, context);
      const promises = Array().concat(req.query.agentConfigName).map(configName => assistantClient.getAgentIdByConfigName(configName));
      const results = await Promise.all(promises);
      const exists = results.every(r => Boolean(r));
      return res.ok({
        body: {
          exists
        }
      });
    } catch (e) {
      return res.ok({
        body: {
          exists: false
        }
      });
    }
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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