"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MDSEnabledClientService = void 0;
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
class MDSEnabledClientService {
  constructor(osDriver, dataSourceEnabled = false) {
    _defineProperty(this, "osDriver", void 0);
    _defineProperty(this, "dataSourceEnabled", void 0);
    this.osDriver = osDriver;
    this.dataSourceEnabled = dataSourceEnabled;
  }
  getClientBasedOnDataSource(context, request) {
    const {
      dataSourceId = ""
    } = request.query || {};
    if (this.dataSourceEnabled && dataSourceId && dataSourceId.trim().length != 0) {
      // non-zero data source id
      return context.dataSource.opensearch.legacy.getClient(dataSourceId).callAPI;
    } else {
      // fall back to default local cluster
      return this.osDriver.asScoped(request).callAsCurrentUser;
    }
  }
}
exports.MDSEnabledClientService = MDSEnabledClientService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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