/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.dxf;

import de.escape.quincunx.dxf.LineStyle;
import de.escape.quincunx.dxf.reader.DxfFile;
import de.escape.quincunx.dxf.reader.DxfLAYER;
import de.escape.quincunx.dxf.reader.DxfLTYPE;
import de.escape.quincunx.gimmicks.Utility;
import java.util.Hashtable;

public class LineStyleManager {
    public static final int DEFAULT_MAX_NUMBER_REPETITIONS = 500;
    public static final boolean DEFAULT_USE_LTYPE = true;
    public static final int MAX_NUMBER_REPETITIONS = Utility.getIntProperty("ltype.maxrepetitions", 500);
    public static final boolean USE_LTYPE = Utility.getBooleanProperty("ltype.use", true);
    private Hashtable lineStyleHash;

    public LineStyleManager(DxfFile dxf) {
        DxfLTYPE[] ltypes = dxf.getLtypes();
        float ltscale = dxf.getHeader().getLTSCALE();
        if (ltypes == null) {
            this.lineStyleHash = new Hashtable(11);
            this.lineStyleHash.put("CONTINUOUS", null);
        } else {
            this.lineStyleHash = new Hashtable(ltypes.length);
            int l = 0;
            while (l < ltypes.length) {
                this.lineStyleHash.put(ltypes[l].getName(), new LineStyle(ltypes[l], ltscale));
                ++l;
            }
        }
    }

    public LineStyle getLineStyle(String name, LineStyle insertLineStyle, DxfLAYER layer) {
        if (USE_LTYPE) {
            if (name == null || "BYBLOCK".equals(name)) {
                return insertLineStyle == null ? this.getLineStyle("CONTINUOUS") : insertLineStyle;
            }
            if ("BYLAYER".equals(name)) {
                return this.getLineStyle(layer.getLineTypeName());
            }
            return this.getLineStyle(name);
        }
        return this.getLineStyle("CONTINUOUS");
    }

    private LineStyle getLineStyle(String name) {
        LineStyle ret;
        if (!USE_LTYPE) {
            name = "CONTINUOUS";
        }
        if ((ret = (LineStyle)this.lineStyleHash.get(name)) == null) {
            ret = (LineStyle)this.lineStyleHash.get("CONTINUOUS");
        }
        return ret;
    }

    public boolean isVariableLineStyle(String name) {
        if (USE_LTYPE) {
            return "BYBLOCK".equals(name) || "BYLAYER".equals(name);
        }
        return false;
    }
}

