# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("rasapi32.dll")
prototypes = \
    {
        #
        'RasDialA': SimTypeFunction([SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwfOptions": SimTypeInt(signed=False, label="UInt32"), "hwndParent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "reserved": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "reserved1": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "RasEapInfo": SimStruct({"dwSizeofEapInfo": SimTypeInt(signed=False, label="UInt32"), "pbEapInfo": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="RASEAPINFO", pack=False, align=None), "fSkipPppAuth": SimTypeInt(signed=True, label="Int32"), "RasDevSpecificInfo": SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "pbDevSpecificInfo": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="RASDEVSPECIFICINFO", pack=False, align=None)}, name="RASDIALEXTENSIONS", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "szEntryName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 257), "szPhoneNumber": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 129), "szCallbackNumber": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 129), "szUserName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 257), "szPassword": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 257), "szDomain": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 16), "dwSubEntry": SimTypeInt(signed=False, label="UInt32"), "dwCallbackId": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwIfIndex": SimTypeInt(signed=False, label="UInt32"), "szEncPassword": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="RASDIALPARAMSA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2", "param3", "param4", "param5"]),
        #
        'RasDialW': SimTypeFunction([SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwfOptions": SimTypeInt(signed=False, label="UInt32"), "hwndParent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "reserved": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "reserved1": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "RasEapInfo": SimStruct({"dwSizeofEapInfo": SimTypeInt(signed=False, label="UInt32"), "pbEapInfo": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="RASEAPINFO", pack=False, align=None), "fSkipPppAuth": SimTypeInt(signed=True, label="Int32"), "RasDevSpecificInfo": SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "pbDevSpecificInfo": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="RASDEVSPECIFICINFO", pack=False, align=None)}, name="RASDIALEXTENSIONS", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "szEntryName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 257), "szPhoneNumber": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 129), "szCallbackNumber": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 129), "szUserName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 257), "szPassword": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 257), "szDomain": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 16), "dwSubEntry": SimTypeInt(signed=False, label="UInt32"), "dwCallbackId": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwIfIndex": SimTypeInt(signed=False, label="UInt32"), "szEncPassword": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="RASDIALPARAMSW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2", "param3", "param4", "param5"]),
        #
        'RasEnumConnectionsA': SimTypeFunction([SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "hrasconn": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "szEntryName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 257), "szDeviceType": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 17), "szDeviceName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 129), "szPhonebook": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 260), "dwSubEntry": SimTypeInt(signed=False, label="UInt32"), "guidEntry": SimTypeBottom(label="Guid"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "luid": SimTypeBottom(label="LUID"), "guidCorrelationId": SimTypeBottom(label="Guid")}, name="RASCONNA", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2"]),
        #
        'RasEnumConnectionsW': SimTypeFunction([SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "hrasconn": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "szEntryName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 257), "szDeviceType": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 17), "szDeviceName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 129), "szPhonebook": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 260), "dwSubEntry": SimTypeInt(signed=False, label="UInt32"), "guidEntry": SimTypeBottom(label="Guid"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "luid": SimTypeBottom(label="LUID"), "guidCorrelationId": SimTypeBottom(label="Guid")}, name="RASCONNW", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2"]),
        #
        'RasEnumEntriesA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "szEntryName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 257), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "szPhonebookPath": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 261)}, name="RASENTRYNAMEA", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2", "param3", "param4"]),
        #
        'RasEnumEntriesW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "szEntryName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 257), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "szPhonebookPath": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 261)}, name="RASENTRYNAMEW", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2", "param3", "param4"]),
        #
        'RasGetConnectStatusA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "rasconnstate": SimTypeInt(signed=False, label="RASCONNSTATE"), "dwError": SimTypeInt(signed=False, label="UInt32"), "szDeviceType": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 17), "szDeviceName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 129), "szPhoneNumber": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 129), "localEndPoint": SimStruct({"dwType": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"ipv4": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "ipv6": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None)}, name="<anon>", label="None")}, name="RASTUNNELENDPOINT", pack=False, align=None), "remoteEndPoint": SimStruct({"dwType": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"ipv4": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "ipv6": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None)}, name="<anon>", label="None")}, name="RASTUNNELENDPOINT", pack=False, align=None), "rasconnsubstate": SimTypeInt(signed=False, label="RASCONNSUBSTATE")}, name="RASCONNSTATUSA", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1"]),
        #
        'RasGetConnectStatusW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "rasconnstate": SimTypeInt(signed=False, label="RASCONNSTATE"), "dwError": SimTypeInt(signed=False, label="UInt32"), "szDeviceType": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 17), "szDeviceName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 129), "szPhoneNumber": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 129), "localEndPoint": SimStruct({"dwType": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"ipv4": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "ipv6": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None)}, name="<anon>", label="None")}, name="RASTUNNELENDPOINT", pack=False, align=None), "remoteEndPoint": SimStruct({"dwType": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"ipv4": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "ipv6": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None)}, name="<anon>", label="None")}, name="RASTUNNELENDPOINT", pack=False, align=None), "rasconnsubstate": SimTypeInt(signed=False, label="RASCONNSUBSTATE")}, name="RASCONNSTATUSW", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1"]),
        #
        'RasGetErrorStringA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["ResourceId", "lpszString", "InBufSize"]),
        #
        'RasGetErrorStringW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["ResourceId", "lpszString", "InBufSize"]),
        #
        'RasHangUpA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0"]),
        #
        'RasHangUpW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0"]),
        #
        'RasGetProjectionInfoA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="RASPROJECTION"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2", "param3"]),
        #
        'RasGetProjectionInfoW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="RASPROJECTION"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2", "param3"]),
        #
        'RasCreatePhonebookEntryA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1"]),
        #
        'RasCreatePhonebookEntryW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1"]),
        #
        'RasEditPhonebookEntryA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2"]),
        #
        'RasEditPhonebookEntryW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2"]),
        #
        'RasSetEntryDialParamsA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "szEntryName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 257), "szPhoneNumber": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 129), "szCallbackNumber": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 129), "szUserName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 257), "szPassword": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 257), "szDomain": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 16), "dwSubEntry": SimTypeInt(signed=False, label="UInt32"), "dwCallbackId": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwIfIndex": SimTypeInt(signed=False, label="UInt32"), "szEncPassword": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="RASDIALPARAMSA", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2"]),
        #
        'RasSetEntryDialParamsW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "szEntryName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 257), "szPhoneNumber": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 129), "szCallbackNumber": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 129), "szUserName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 257), "szPassword": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 257), "szDomain": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 16), "dwSubEntry": SimTypeInt(signed=False, label="UInt32"), "dwCallbackId": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwIfIndex": SimTypeInt(signed=False, label="UInt32"), "szEncPassword": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="RASDIALPARAMSW", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2"]),
        #
        'RasGetEntryDialParamsA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "szEntryName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 257), "szPhoneNumber": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 129), "szCallbackNumber": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 129), "szUserName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 257), "szPassword": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 257), "szDomain": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 16), "dwSubEntry": SimTypeInt(signed=False, label="UInt32"), "dwCallbackId": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwIfIndex": SimTypeInt(signed=False, label="UInt32"), "szEncPassword": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="RASDIALPARAMSA", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2"]),
        #
        'RasGetEntryDialParamsW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "szEntryName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 257), "szPhoneNumber": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 129), "szCallbackNumber": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 129), "szUserName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 257), "szPassword": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 257), "szDomain": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 16), "dwSubEntry": SimTypeInt(signed=False, label="UInt32"), "dwCallbackId": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwIfIndex": SimTypeInt(signed=False, label="UInt32"), "szEncPassword": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="RASDIALPARAMSW", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2"]),
        #
        'RasEnumDevicesA': SimTypeFunction([SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "szDeviceType": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 17), "szDeviceName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 129)}, name="RASDEVINFOA", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2"]),
        #
        'RasEnumDevicesW': SimTypeFunction([SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "szDeviceType": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 17), "szDeviceName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 129)}, name="RASDEVINFOW", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2"]),
        #
        'RasGetCountryInfoA': SimTypeFunction([SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwCountryID": SimTypeInt(signed=False, label="UInt32"), "dwNextCountryID": SimTypeInt(signed=False, label="UInt32"), "dwCountryCode": SimTypeInt(signed=False, label="UInt32"), "dwCountryNameOffset": SimTypeInt(signed=False, label="UInt32")}, name="RASCTRYINFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1"]),
        #
        'RasGetCountryInfoW': SimTypeFunction([SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwCountryID": SimTypeInt(signed=False, label="UInt32"), "dwNextCountryID": SimTypeInt(signed=False, label="UInt32"), "dwCountryCode": SimTypeInt(signed=False, label="UInt32"), "dwCountryNameOffset": SimTypeInt(signed=False, label="UInt32")}, name="RASCTRYINFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1"]),
        #
        'RasGetEntryPropertiesA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwfOptions": SimTypeInt(signed=False, label="UInt32"), "dwCountryID": SimTypeInt(signed=False, label="UInt32"), "dwCountryCode": SimTypeInt(signed=False, label="UInt32"), "szAreaCode": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 11), "szLocalPhoneNumber": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 129), "dwAlternateOffset": SimTypeInt(signed=False, label="UInt32"), "ipaddr": SimStruct({"a": SimTypeChar(label="Byte"), "b": SimTypeChar(label="Byte"), "c": SimTypeChar(label="Byte"), "d": SimTypeChar(label="Byte")}, name="RASIPADDR", pack=False, align=None), "ipaddrDns": SimStruct({"a": SimTypeChar(label="Byte"), "b": SimTypeChar(label="Byte"), "c": SimTypeChar(label="Byte"), "d": SimTypeChar(label="Byte")}, name="RASIPADDR", pack=False, align=None), "ipaddrDnsAlt": SimStruct({"a": SimTypeChar(label="Byte"), "b": SimTypeChar(label="Byte"), "c": SimTypeChar(label="Byte"), "d": SimTypeChar(label="Byte")}, name="RASIPADDR", pack=False, align=None), "ipaddrWins": SimStruct({"a": SimTypeChar(label="Byte"), "b": SimTypeChar(label="Byte"), "c": SimTypeChar(label="Byte"), "d": SimTypeChar(label="Byte")}, name="RASIPADDR", pack=False, align=None), "ipaddrWinsAlt": SimStruct({"a": SimTypeChar(label="Byte"), "b": SimTypeChar(label="Byte"), "c": SimTypeChar(label="Byte"), "d": SimTypeChar(label="Byte")}, name="RASIPADDR", pack=False, align=None), "dwFrameSize": SimTypeInt(signed=False, label="UInt32"), "dwfNetProtocols": SimTypeInt(signed=False, label="UInt32"), "dwFramingProtocol": SimTypeInt(signed=False, label="UInt32"), "szScript": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 260), "szAutodialDll": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 260), "szAutodialFunc": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 260), "szDeviceType": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 17), "szDeviceName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 129), "szX25PadType": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 33), "szX25Address": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 201), "szX25Facilities": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 201), "szX25UserData": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 201), "dwChannels": SimTypeInt(signed=False, label="UInt32"), "dwReserved1": SimTypeInt(signed=False, label="UInt32"), "dwReserved2": SimTypeInt(signed=False, label="UInt32"), "dwSubEntries": SimTypeInt(signed=False, label="UInt32"), "dwDialMode": SimTypeInt(signed=False, label="RASENTRY_DIAL_MODE"), "dwDialExtraPercent": SimTypeInt(signed=False, label="UInt32"), "dwDialExtraSampleSeconds": SimTypeInt(signed=False, label="UInt32"), "dwHangUpExtraPercent": SimTypeInt(signed=False, label="UInt32"), "dwHangUpExtraSampleSeconds": SimTypeInt(signed=False, label="UInt32"), "dwIdleDisconnectSeconds": SimTypeInt(signed=False, label="UInt32"), "dwType": SimTypeInt(signed=False, label="UInt32"), "dwEncryptionType": SimTypeInt(signed=False, label="UInt32"), "dwCustomAuthKey": SimTypeInt(signed=False, label="UInt32"), "guidId": SimTypeBottom(label="Guid"), "szCustomDialDll": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 260), "dwVpnStrategy": SimTypeInt(signed=False, label="UInt32"), "dwfOptions2": SimTypeInt(signed=False, label="UInt32"), "dwfOptions3": SimTypeInt(signed=False, label="UInt32"), "szDnsSuffix": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "dwTcpWindowSize": SimTypeInt(signed=False, label="UInt32"), "szPrerequisitePbk": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 260), "szPrerequisiteEntry": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 257), "dwRedialCount": SimTypeInt(signed=False, label="UInt32"), "dwRedialPause": SimTypeInt(signed=False, label="UInt32"), "ipv6addrDns": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "ipv6addrDnsAlt": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "dwIPv4InterfaceMetric": SimTypeInt(signed=False, label="UInt32"), "dwIPv6InterfaceMetric": SimTypeInt(signed=False, label="UInt32"), "ipv6addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "dwIPv6PrefixLength": SimTypeInt(signed=False, label="UInt32"), "dwNetworkOutageTime": SimTypeInt(signed=False, label="UInt32"), "szIDi": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 257), "szIDr": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 257), "fIsImsConfig": SimTypeInt(signed=True, label="Int32"), "IdiType": SimTypeInt(signed=False, label="IKEV2_ID_PAYLOAD_TYPE"), "IdrType": SimTypeInt(signed=False, label="IKEV2_ID_PAYLOAD_TYPE"), "fDisableIKEv2Fragmentation": SimTypeInt(signed=True, label="Int32")}, name="RASENTRYA", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2", "param3", "param4", "param5"]),
        #
        'RasGetEntryPropertiesW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwfOptions": SimTypeInt(signed=False, label="UInt32"), "dwCountryID": SimTypeInt(signed=False, label="UInt32"), "dwCountryCode": SimTypeInt(signed=False, label="UInt32"), "szAreaCode": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 11), "szLocalPhoneNumber": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 129), "dwAlternateOffset": SimTypeInt(signed=False, label="UInt32"), "ipaddr": SimStruct({"a": SimTypeChar(label="Byte"), "b": SimTypeChar(label="Byte"), "c": SimTypeChar(label="Byte"), "d": SimTypeChar(label="Byte")}, name="RASIPADDR", pack=False, align=None), "ipaddrDns": SimStruct({"a": SimTypeChar(label="Byte"), "b": SimTypeChar(label="Byte"), "c": SimTypeChar(label="Byte"), "d": SimTypeChar(label="Byte")}, name="RASIPADDR", pack=False, align=None), "ipaddrDnsAlt": SimStruct({"a": SimTypeChar(label="Byte"), "b": SimTypeChar(label="Byte"), "c": SimTypeChar(label="Byte"), "d": SimTypeChar(label="Byte")}, name="RASIPADDR", pack=False, align=None), "ipaddrWins": SimStruct({"a": SimTypeChar(label="Byte"), "b": SimTypeChar(label="Byte"), "c": SimTypeChar(label="Byte"), "d": SimTypeChar(label="Byte")}, name="RASIPADDR", pack=False, align=None), "ipaddrWinsAlt": SimStruct({"a": SimTypeChar(label="Byte"), "b": SimTypeChar(label="Byte"), "c": SimTypeChar(label="Byte"), "d": SimTypeChar(label="Byte")}, name="RASIPADDR", pack=False, align=None), "dwFrameSize": SimTypeInt(signed=False, label="UInt32"), "dwfNetProtocols": SimTypeInt(signed=False, label="UInt32"), "dwFramingProtocol": SimTypeInt(signed=False, label="UInt32"), "szScript": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 260), "szAutodialDll": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 260), "szAutodialFunc": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 260), "szDeviceType": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 17), "szDeviceName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 129), "szX25PadType": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 33), "szX25Address": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 201), "szX25Facilities": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 201), "szX25UserData": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 201), "dwChannels": SimTypeInt(signed=False, label="UInt32"), "dwReserved1": SimTypeInt(signed=False, label="UInt32"), "dwReserved2": SimTypeInt(signed=False, label="UInt32"), "dwSubEntries": SimTypeInt(signed=False, label="UInt32"), "dwDialMode": SimTypeInt(signed=False, label="RASENTRY_DIAL_MODE"), "dwDialExtraPercent": SimTypeInt(signed=False, label="UInt32"), "dwDialExtraSampleSeconds": SimTypeInt(signed=False, label="UInt32"), "dwHangUpExtraPercent": SimTypeInt(signed=False, label="UInt32"), "dwHangUpExtraSampleSeconds": SimTypeInt(signed=False, label="UInt32"), "dwIdleDisconnectSeconds": SimTypeInt(signed=False, label="UInt32"), "dwType": SimTypeInt(signed=False, label="UInt32"), "dwEncryptionType": SimTypeInt(signed=False, label="UInt32"), "dwCustomAuthKey": SimTypeInt(signed=False, label="UInt32"), "guidId": SimTypeBottom(label="Guid"), "szCustomDialDll": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 260), "dwVpnStrategy": SimTypeInt(signed=False, label="UInt32"), "dwfOptions2": SimTypeInt(signed=False, label="UInt32"), "dwfOptions3": SimTypeInt(signed=False, label="UInt32"), "szDnsSuffix": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "dwTcpWindowSize": SimTypeInt(signed=False, label="UInt32"), "szPrerequisitePbk": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 260), "szPrerequisiteEntry": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 257), "dwRedialCount": SimTypeInt(signed=False, label="UInt32"), "dwRedialPause": SimTypeInt(signed=False, label="UInt32"), "ipv6addrDns": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "ipv6addrDnsAlt": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "dwIPv4InterfaceMetric": SimTypeInt(signed=False, label="UInt32"), "dwIPv6InterfaceMetric": SimTypeInt(signed=False, label="UInt32"), "ipv6addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "dwIPv6PrefixLength": SimTypeInt(signed=False, label="UInt32"), "dwNetworkOutageTime": SimTypeInt(signed=False, label="UInt32"), "szIDi": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 257), "szIDr": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 257), "fIsImsConfig": SimTypeInt(signed=True, label="Int32"), "IdiType": SimTypeInt(signed=False, label="IKEV2_ID_PAYLOAD_TYPE"), "IdrType": SimTypeInt(signed=False, label="IKEV2_ID_PAYLOAD_TYPE"), "fDisableIKEv2Fragmentation": SimTypeInt(signed=True, label="Int32")}, name="RASENTRYW", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2", "param3", "param4", "param5"]),
        #
        'RasSetEntryPropertiesA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwfOptions": SimTypeInt(signed=False, label="UInt32"), "dwCountryID": SimTypeInt(signed=False, label="UInt32"), "dwCountryCode": SimTypeInt(signed=False, label="UInt32"), "szAreaCode": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 11), "szLocalPhoneNumber": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 129), "dwAlternateOffset": SimTypeInt(signed=False, label="UInt32"), "ipaddr": SimStruct({"a": SimTypeChar(label="Byte"), "b": SimTypeChar(label="Byte"), "c": SimTypeChar(label="Byte"), "d": SimTypeChar(label="Byte")}, name="RASIPADDR", pack=False, align=None), "ipaddrDns": SimStruct({"a": SimTypeChar(label="Byte"), "b": SimTypeChar(label="Byte"), "c": SimTypeChar(label="Byte"), "d": SimTypeChar(label="Byte")}, name="RASIPADDR", pack=False, align=None), "ipaddrDnsAlt": SimStruct({"a": SimTypeChar(label="Byte"), "b": SimTypeChar(label="Byte"), "c": SimTypeChar(label="Byte"), "d": SimTypeChar(label="Byte")}, name="RASIPADDR", pack=False, align=None), "ipaddrWins": SimStruct({"a": SimTypeChar(label="Byte"), "b": SimTypeChar(label="Byte"), "c": SimTypeChar(label="Byte"), "d": SimTypeChar(label="Byte")}, name="RASIPADDR", pack=False, align=None), "ipaddrWinsAlt": SimStruct({"a": SimTypeChar(label="Byte"), "b": SimTypeChar(label="Byte"), "c": SimTypeChar(label="Byte"), "d": SimTypeChar(label="Byte")}, name="RASIPADDR", pack=False, align=None), "dwFrameSize": SimTypeInt(signed=False, label="UInt32"), "dwfNetProtocols": SimTypeInt(signed=False, label="UInt32"), "dwFramingProtocol": SimTypeInt(signed=False, label="UInt32"), "szScript": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 260), "szAutodialDll": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 260), "szAutodialFunc": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 260), "szDeviceType": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 17), "szDeviceName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 129), "szX25PadType": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 33), "szX25Address": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 201), "szX25Facilities": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 201), "szX25UserData": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 201), "dwChannels": SimTypeInt(signed=False, label="UInt32"), "dwReserved1": SimTypeInt(signed=False, label="UInt32"), "dwReserved2": SimTypeInt(signed=False, label="UInt32"), "dwSubEntries": SimTypeInt(signed=False, label="UInt32"), "dwDialMode": SimTypeInt(signed=False, label="RASENTRY_DIAL_MODE"), "dwDialExtraPercent": SimTypeInt(signed=False, label="UInt32"), "dwDialExtraSampleSeconds": SimTypeInt(signed=False, label="UInt32"), "dwHangUpExtraPercent": SimTypeInt(signed=False, label="UInt32"), "dwHangUpExtraSampleSeconds": SimTypeInt(signed=False, label="UInt32"), "dwIdleDisconnectSeconds": SimTypeInt(signed=False, label="UInt32"), "dwType": SimTypeInt(signed=False, label="UInt32"), "dwEncryptionType": SimTypeInt(signed=False, label="UInt32"), "dwCustomAuthKey": SimTypeInt(signed=False, label="UInt32"), "guidId": SimTypeBottom(label="Guid"), "szCustomDialDll": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 260), "dwVpnStrategy": SimTypeInt(signed=False, label="UInt32"), "dwfOptions2": SimTypeInt(signed=False, label="UInt32"), "dwfOptions3": SimTypeInt(signed=False, label="UInt32"), "szDnsSuffix": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "dwTcpWindowSize": SimTypeInt(signed=False, label="UInt32"), "szPrerequisitePbk": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 260), "szPrerequisiteEntry": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 257), "dwRedialCount": SimTypeInt(signed=False, label="UInt32"), "dwRedialPause": SimTypeInt(signed=False, label="UInt32"), "ipv6addrDns": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "ipv6addrDnsAlt": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "dwIPv4InterfaceMetric": SimTypeInt(signed=False, label="UInt32"), "dwIPv6InterfaceMetric": SimTypeInt(signed=False, label="UInt32"), "ipv6addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "dwIPv6PrefixLength": SimTypeInt(signed=False, label="UInt32"), "dwNetworkOutageTime": SimTypeInt(signed=False, label="UInt32"), "szIDi": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 257), "szIDr": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 257), "fIsImsConfig": SimTypeInt(signed=True, label="Int32"), "IdiType": SimTypeInt(signed=False, label="IKEV2_ID_PAYLOAD_TYPE"), "IdrType": SimTypeInt(signed=False, label="IKEV2_ID_PAYLOAD_TYPE"), "fDisableIKEv2Fragmentation": SimTypeInt(signed=True, label="Int32")}, name="RASENTRYA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2", "param3", "param4", "param5"]),
        #
        'RasSetEntryPropertiesW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwfOptions": SimTypeInt(signed=False, label="UInt32"), "dwCountryID": SimTypeInt(signed=False, label="UInt32"), "dwCountryCode": SimTypeInt(signed=False, label="UInt32"), "szAreaCode": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 11), "szLocalPhoneNumber": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 129), "dwAlternateOffset": SimTypeInt(signed=False, label="UInt32"), "ipaddr": SimStruct({"a": SimTypeChar(label="Byte"), "b": SimTypeChar(label="Byte"), "c": SimTypeChar(label="Byte"), "d": SimTypeChar(label="Byte")}, name="RASIPADDR", pack=False, align=None), "ipaddrDns": SimStruct({"a": SimTypeChar(label="Byte"), "b": SimTypeChar(label="Byte"), "c": SimTypeChar(label="Byte"), "d": SimTypeChar(label="Byte")}, name="RASIPADDR", pack=False, align=None), "ipaddrDnsAlt": SimStruct({"a": SimTypeChar(label="Byte"), "b": SimTypeChar(label="Byte"), "c": SimTypeChar(label="Byte"), "d": SimTypeChar(label="Byte")}, name="RASIPADDR", pack=False, align=None), "ipaddrWins": SimStruct({"a": SimTypeChar(label="Byte"), "b": SimTypeChar(label="Byte"), "c": SimTypeChar(label="Byte"), "d": SimTypeChar(label="Byte")}, name="RASIPADDR", pack=False, align=None), "ipaddrWinsAlt": SimStruct({"a": SimTypeChar(label="Byte"), "b": SimTypeChar(label="Byte"), "c": SimTypeChar(label="Byte"), "d": SimTypeChar(label="Byte")}, name="RASIPADDR", pack=False, align=None), "dwFrameSize": SimTypeInt(signed=False, label="UInt32"), "dwfNetProtocols": SimTypeInt(signed=False, label="UInt32"), "dwFramingProtocol": SimTypeInt(signed=False, label="UInt32"), "szScript": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 260), "szAutodialDll": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 260), "szAutodialFunc": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 260), "szDeviceType": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 17), "szDeviceName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 129), "szX25PadType": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 33), "szX25Address": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 201), "szX25Facilities": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 201), "szX25UserData": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 201), "dwChannels": SimTypeInt(signed=False, label="UInt32"), "dwReserved1": SimTypeInt(signed=False, label="UInt32"), "dwReserved2": SimTypeInt(signed=False, label="UInt32"), "dwSubEntries": SimTypeInt(signed=False, label="UInt32"), "dwDialMode": SimTypeInt(signed=False, label="RASENTRY_DIAL_MODE"), "dwDialExtraPercent": SimTypeInt(signed=False, label="UInt32"), "dwDialExtraSampleSeconds": SimTypeInt(signed=False, label="UInt32"), "dwHangUpExtraPercent": SimTypeInt(signed=False, label="UInt32"), "dwHangUpExtraSampleSeconds": SimTypeInt(signed=False, label="UInt32"), "dwIdleDisconnectSeconds": SimTypeInt(signed=False, label="UInt32"), "dwType": SimTypeInt(signed=False, label="UInt32"), "dwEncryptionType": SimTypeInt(signed=False, label="UInt32"), "dwCustomAuthKey": SimTypeInt(signed=False, label="UInt32"), "guidId": SimTypeBottom(label="Guid"), "szCustomDialDll": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 260), "dwVpnStrategy": SimTypeInt(signed=False, label="UInt32"), "dwfOptions2": SimTypeInt(signed=False, label="UInt32"), "dwfOptions3": SimTypeInt(signed=False, label="UInt32"), "szDnsSuffix": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "dwTcpWindowSize": SimTypeInt(signed=False, label="UInt32"), "szPrerequisitePbk": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 260), "szPrerequisiteEntry": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 257), "dwRedialCount": SimTypeInt(signed=False, label="UInt32"), "dwRedialPause": SimTypeInt(signed=False, label="UInt32"), "ipv6addrDns": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "ipv6addrDnsAlt": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "dwIPv4InterfaceMetric": SimTypeInt(signed=False, label="UInt32"), "dwIPv6InterfaceMetric": SimTypeInt(signed=False, label="UInt32"), "ipv6addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "dwIPv6PrefixLength": SimTypeInt(signed=False, label="UInt32"), "dwNetworkOutageTime": SimTypeInt(signed=False, label="UInt32"), "szIDi": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 257), "szIDr": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 257), "fIsImsConfig": SimTypeInt(signed=True, label="Int32"), "IdiType": SimTypeInt(signed=False, label="IKEV2_ID_PAYLOAD_TYPE"), "IdrType": SimTypeInt(signed=False, label="IKEV2_ID_PAYLOAD_TYPE"), "fDisableIKEv2Fragmentation": SimTypeInt(signed=True, label="Int32")}, name="RASENTRYW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2", "param3", "param4", "param5"]),
        #
        'RasRenameEntryA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2"]),
        #
        'RasRenameEntryW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2"]),
        #
        'RasDeleteEntryA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1"]),
        #
        'RasDeleteEntryW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1"]),
        #
        'RasValidateEntryNameA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1"]),
        #
        'RasValidateEntryNameW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1"]),
        #
        'RasConnectionNotificationA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2"]),
        #
        'RasConnectionNotificationW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2"]),
        #
        'RasGetSubEntryHandleA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2"]),
        #
        'RasGetSubEntryHandleW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2"]),
        #
        'RasGetCredentialsA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwMask": SimTypeInt(signed=False, label="UInt32"), "szUserName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 257), "szPassword": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 257), "szDomain": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 16)}, name="RASCREDENTIALSA", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2"]),
        #
        'RasGetCredentialsW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwMask": SimTypeInt(signed=False, label="UInt32"), "szUserName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 257), "szPassword": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 257), "szDomain": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 16)}, name="RASCREDENTIALSW", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2"]),
        #
        'RasSetCredentialsA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwMask": SimTypeInt(signed=False, label="UInt32"), "szUserName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 257), "szPassword": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 257), "szDomain": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 16)}, name="RASCREDENTIALSA", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2", "param3"]),
        #
        'RasSetCredentialsW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwMask": SimTypeInt(signed=False, label="UInt32"), "szUserName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 257), "szPassword": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 257), "szDomain": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 16)}, name="RASCREDENTIALSW", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2", "param3"]),
        #
        'RasGetSubEntryPropertiesA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwfFlags": SimTypeInt(signed=False, label="UInt32"), "szDeviceType": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 17), "szDeviceName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 129), "szLocalPhoneNumber": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 129), "dwAlternateOffset": SimTypeInt(signed=False, label="UInt32")}, name="RASSUBENTRYA", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2", "param3", "param4", "param5", "param6"]),
        #
        'RasGetSubEntryPropertiesW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwfFlags": SimTypeInt(signed=False, label="UInt32"), "szDeviceType": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 17), "szDeviceName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 129), "szLocalPhoneNumber": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 129), "dwAlternateOffset": SimTypeInt(signed=False, label="UInt32")}, name="RASSUBENTRYW", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2", "param3", "param4", "param5", "param6"]),
        #
        'RasSetSubEntryPropertiesA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwfFlags": SimTypeInt(signed=False, label="UInt32"), "szDeviceType": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 17), "szDeviceName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 129), "szLocalPhoneNumber": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 129), "dwAlternateOffset": SimTypeInt(signed=False, label="UInt32")}, name="RASSUBENTRYA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2", "param3", "param4", "param5", "param6"]),
        #
        'RasSetSubEntryPropertiesW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwfFlags": SimTypeInt(signed=False, label="UInt32"), "szDeviceType": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 17), "szDeviceName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 129), "szLocalPhoneNumber": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 129), "dwAlternateOffset": SimTypeInt(signed=False, label="UInt32")}, name="RASSUBENTRYW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2", "param3", "param4", "param5", "param6"]),
        #
        'RasGetAutodialAddressA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "dwDialingLocation": SimTypeInt(signed=False, label="UInt32"), "szEntry": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 257)}, name="RASAUTODIALENTRYA", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2", "param3", "param4"]),
        #
        'RasGetAutodialAddressW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "dwDialingLocation": SimTypeInt(signed=False, label="UInt32"), "szEntry": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 257)}, name="RASAUTODIALENTRYW", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2", "param3", "param4"]),
        #
        'RasSetAutodialAddressA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "dwDialingLocation": SimTypeInt(signed=False, label="UInt32"), "szEntry": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 257)}, name="RASAUTODIALENTRYA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2", "param3", "param4"]),
        #
        'RasSetAutodialAddressW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "dwDialingLocation": SimTypeInt(signed=False, label="UInt32"), "szEntry": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 257)}, name="RASAUTODIALENTRYW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2", "param3", "param4"]),
        #
        'RasEnumAutodialAddressesA': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lppRasAutodialAddresses", "lpdwcbRasAutodialAddresses", "lpdwcRasAutodialAddresses"]),
        #
        'RasEnumAutodialAddressesW': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lppRasAutodialAddresses", "lpdwcbRasAutodialAddresses", "lpdwcRasAutodialAddresses"]),
        #
        'RasGetAutodialEnableA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1"]),
        #
        'RasGetAutodialEnableW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1"]),
        #
        'RasSetAutodialEnableA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1"]),
        #
        'RasSetAutodialEnableW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1"]),
        #
        'RasGetAutodialParamA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2"]),
        #
        'RasGetAutodialParamW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2"]),
        #
        'RasSetAutodialParamA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2"]),
        #
        'RasSetAutodialParamW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2"]),
        #
        'RasGetPCscf': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpszPCscf"]),
        #
        'RasInvokeEapUI': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwfOptions": SimTypeInt(signed=False, label="UInt32"), "hwndParent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "reserved": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "reserved1": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "RasEapInfo": SimStruct({"dwSizeofEapInfo": SimTypeInt(signed=False, label="UInt32"), "pbEapInfo": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="RASEAPINFO", pack=False, align=None), "fSkipPppAuth": SimTypeInt(signed=True, label="Int32"), "RasDevSpecificInfo": SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "pbDevSpecificInfo": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="RASDEVSPECIFICINFO", pack=False, align=None)}, name="RASDIALEXTENSIONS", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2", "param3"]),
        #
        'RasGetLinkStatistics': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwBytesXmited": SimTypeInt(signed=False, label="UInt32"), "dwBytesRcved": SimTypeInt(signed=False, label="UInt32"), "dwFramesXmited": SimTypeInt(signed=False, label="UInt32"), "dwFramesRcved": SimTypeInt(signed=False, label="UInt32"), "dwCrcErr": SimTypeInt(signed=False, label="UInt32"), "dwTimeoutErr": SimTypeInt(signed=False, label="UInt32"), "dwAlignmentErr": SimTypeInt(signed=False, label="UInt32"), "dwHardwareOverrunErr": SimTypeInt(signed=False, label="UInt32"), "dwFramingErr": SimTypeInt(signed=False, label="UInt32"), "dwBufferOverrunErr": SimTypeInt(signed=False, label="UInt32"), "dwCompressionRatioIn": SimTypeInt(signed=False, label="UInt32"), "dwCompressionRatioOut": SimTypeInt(signed=False, label="UInt32"), "dwBps": SimTypeInt(signed=False, label="UInt32"), "dwConnectDuration": SimTypeInt(signed=False, label="UInt32")}, name="RAS_STATS", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hRasConn", "dwSubEntry", "lpStatistics"]),
        #
        'RasGetConnectionStatistics': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwBytesXmited": SimTypeInt(signed=False, label="UInt32"), "dwBytesRcved": SimTypeInt(signed=False, label="UInt32"), "dwFramesXmited": SimTypeInt(signed=False, label="UInt32"), "dwFramesRcved": SimTypeInt(signed=False, label="UInt32"), "dwCrcErr": SimTypeInt(signed=False, label="UInt32"), "dwTimeoutErr": SimTypeInt(signed=False, label="UInt32"), "dwAlignmentErr": SimTypeInt(signed=False, label="UInt32"), "dwHardwareOverrunErr": SimTypeInt(signed=False, label="UInt32"), "dwFramingErr": SimTypeInt(signed=False, label="UInt32"), "dwBufferOverrunErr": SimTypeInt(signed=False, label="UInt32"), "dwCompressionRatioIn": SimTypeInt(signed=False, label="UInt32"), "dwCompressionRatioOut": SimTypeInt(signed=False, label="UInt32"), "dwBps": SimTypeInt(signed=False, label="UInt32"), "dwConnectDuration": SimTypeInt(signed=False, label="UInt32")}, name="RAS_STATS", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hRasConn", "lpStatistics"]),
        #
        'RasClearLinkStatistics': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hRasConn", "dwSubEntry"]),
        #
        'RasClearConnectionStatistics': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hRasConn"]),
        #
        'RasGetEapUserDataA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hToken", "pszPhonebook", "pszEntry", "pbEapData", "pdwSizeofEapData"]),
        #
        'RasGetEapUserDataW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hToken", "pszPhonebook", "pszEntry", "pbEapData", "pdwSizeofEapData"]),
        #
        'RasSetEapUserDataA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hToken", "pszPhonebook", "pszEntry", "pbEapData", "dwSizeofEapData"]),
        #
        'RasSetEapUserDataW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hToken", "pszPhonebook", "pszEntry", "pbEapData", "dwSizeofEapData"]),
        #
        'RasGetCustomAuthDataA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pszPhonebook", "pszEntry", "pbCustomAuthData", "pdwSizeofCustomAuthData"]),
        #
        'RasGetCustomAuthDataW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pszPhonebook", "pszEntry", "pbCustomAuthData", "pdwSizeofCustomAuthData"]),
        #
        'RasSetCustomAuthDataA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["pszPhonebook", "pszEntry", "pbCustomAuthData", "dwSizeofCustomAuthData"]),
        #
        'RasSetCustomAuthDataW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["pszPhonebook", "pszEntry", "pbCustomAuthData", "dwSizeofCustomAuthData"]),
        #
        'RasGetEapUserIdentityW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimStruct({"szUserName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 257), "dwSizeofEapInfo": SimTypeInt(signed=False, label="UInt32"), "pbEapInfo": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="RASEAPUSERIDENTITYW", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pszPhonebook", "pszEntry", "dwFlags", "hwnd", "ppRasEapUserIdentity"]),
        #
        'RasGetEapUserIdentityA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimStruct({"szUserName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 257), "dwSizeofEapInfo": SimTypeInt(signed=False, label="UInt32"), "pbEapInfo": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="RASEAPUSERIDENTITYA", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pszPhonebook", "pszEntry", "dwFlags", "hwnd", "ppRasEapUserIdentity"]),
        #
        'RasFreeEapUserIdentityW': SimTypeFunction([SimTypePointer(SimStruct({"szUserName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 257), "dwSizeofEapInfo": SimTypeInt(signed=False, label="UInt32"), "pbEapInfo": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="RASEAPUSERIDENTITYW", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["pRasEapUserIdentity"]),
        #
        'RasFreeEapUserIdentityA': SimTypeFunction([SimTypePointer(SimStruct({"szUserName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 257), "dwSizeofEapInfo": SimTypeInt(signed=False, label="UInt32"), "pbEapInfo": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="RASEAPUSERIDENTITYA", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["pRasEapUserIdentity"]),
        #
        'RasDeleteSubEntryA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["pszPhonebook", "pszEntry", "dwSubentryId"]),
        #
        'RasDeleteSubEntryW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["pszPhonebook", "pszEntry", "dwSubEntryId"]),
        #
        'RasUpdateConnection': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"version": SimTypeInt(signed=False, label="RASAPIVERSION"), "dwSize": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "dwIfIndex": SimTypeInt(signed=False, label="UInt32"), "localEndPoint": SimStruct({"dwType": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"ipv4": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "ipv6": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None)}, name="<anon>", label="None")}, name="RASTUNNELENDPOINT", pack=False, align=None), "remoteEndPoint": SimStruct({"dwType": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"ipv4": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "ipv6": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None)}, name="<anon>", label="None")}, name="RASTUNNELENDPOINT", pack=False, align=None)}, name="RASUPDATECONN", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hrasconn", "lprasupdateconn"]),
        #
        'RasGetProjectionInfoEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"version": SimTypeInt(signed=False, label="RASAPIVERSION"), "type": SimTypeInt(signed=False, label="RASPROJECTION_INFO_TYPE"), "Anonymous": SimUnion({"ppp": SimStruct({"dwIPv4NegotiationError": SimTypeInt(signed=False, label="UInt32"), "ipv4Address": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "ipv4ServerAddress": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "dwIPv4Options": SimTypeInt(signed=False, label="UInt32"), "dwIPv4ServerOptions": SimTypeInt(signed=False, label="UInt32"), "dwIPv6NegotiationError": SimTypeInt(signed=False, label="UInt32"), "bInterfaceIdentifier": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 8), "bServerInterfaceIdentifier": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 8), "fBundled": SimTypeInt(signed=True, label="Int32"), "fMultilink": SimTypeInt(signed=True, label="Int32"), "dwAuthenticationProtocol": SimTypeInt(signed=False, label="RASPPP_PROJECTION_INFO_SERVER_AUTH_PROTOCOL"), "dwAuthenticationData": SimTypeInt(signed=False, label="RASPPP_PROJECTION_INFO_SERVER_AUTH_DATA"), "dwServerAuthenticationProtocol": SimTypeInt(signed=False, label="RASPPP_PROJECTION_INFO_SERVER_AUTH_PROTOCOL"), "dwServerAuthenticationData": SimTypeInt(signed=False, label="RASPPP_PROJECTION_INFO_SERVER_AUTH_DATA"), "dwEapTypeId": SimTypeInt(signed=False, label="UInt32"), "dwServerEapTypeId": SimTypeInt(signed=False, label="UInt32"), "dwLcpOptions": SimTypeInt(signed=False, label="UInt32"), "dwLcpServerOptions": SimTypeInt(signed=False, label="UInt32"), "dwCcpError": SimTypeInt(signed=False, label="UInt32"), "dwCcpCompressionAlgorithm": SimTypeInt(signed=False, label="UInt32"), "dwCcpServerCompressionAlgorithm": SimTypeInt(signed=False, label="UInt32"), "dwCcpOptions": SimTypeInt(signed=False, label="UInt32"), "dwCcpServerOptions": SimTypeInt(signed=False, label="UInt32")}, name="RASPPP_PROJECTION_INFO", pack=False, align=None), "ikev2": SimStruct({"dwIPv4NegotiationError": SimTypeInt(signed=False, label="UInt32"), "ipv4Address": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "ipv4ServerAddress": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "dwIPv6NegotiationError": SimTypeInt(signed=False, label="UInt32"), "ipv6Address": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "ipv6ServerAddress": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "dwPrefixLength": SimTypeInt(signed=False, label="UInt32"), "dwAuthenticationProtocol": SimTypeInt(signed=False, label="UInt32"), "dwEapTypeId": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="RASIKEV_PROJECTION_INFO_FLAGS"), "dwEncryptionMethod": SimTypeInt(signed=False, label="UInt32"), "numIPv4ServerAddresses": SimTypeInt(signed=False, label="UInt32"), "ipv4ServerAddresses": SimTypePointer(SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), offset=0), "numIPv6ServerAddresses": SimTypeInt(signed=False, label="UInt32"), "ipv6ServerAddresses": SimTypePointer(SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), offset=0)}, name="RASIKEV2_PROJECTION_INFO", pack=False, align=None)}, name="<anon>", label="None")}, name="RAS_PROJECTION_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hrasconn", "pRasProjection", "lpdwSize"]),
    }

lib.set_prototypes(prototypes)
