"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const fromZigbee_1 = __importDefault(require("../converters/fromZigbee"));
const exposes = __importStar(require("../lib/exposes"));
const legacy = __importStar(require("../lib/legacy"));
const tuya = __importStar(require("../lib/tuya"));
const e = exposes.presets;
const ea = exposes.access;
const definitions = [
    {
        zigbeeModel: ['ivfvd7h', 'eaxp72v\u0000', 'kfvq6avy\u0000', 'fvq6avy\u0000', 'fvq6avy', 'zk78ptr\u0000', '4yfvweb\u0000'],
        fingerprint: tuya.fingerprint('TS0601', [
            '_TZE200_zivfvd7h',
            '_TZE200_kfvq6avy',
            '_TZE200_hhrtiq0x',
            '_TZE200_ps5v5jor',
            '_TZE200_jeaxp72v',
            '_TZE200_owwdxjbx',
            '_TZE200_2cs6g9i7',
            '_TZE200_04yfvweb',
            '_TZE200_lrznf59v',
        ]),
        model: 'GS361A-H04',
        vendor: 'Siterwell',
        description: 'Radiator valve with thermostat',
        fromZigbee: [legacy.fz.tuya_thermostat, fromZigbee_1.default.ignore_basic_report],
        meta: {
            tuyaThermostatSystemMode: legacy.thermostatSystemModes4,
            tuyaThermostatPreset: legacy.thermostatPresets,
            tuyaThermostatPresetToSystemMode: legacy.thermostatSystemModes4,
        },
        toZigbee: [
            legacy.tz.tuya_thermostat_child_lock,
            legacy.tz.siterwell_thermostat_window_detection,
            legacy.tz.tuya_thermostat_valve_detection,
            legacy.tz.tuya_thermostat_current_heating_setpoint,
            legacy.tz.tuya_thermostat_system_mode,
            legacy.tz.tuya_thermostat_auto_lock,
            legacy.tz.tuya_thermostat_calibration,
            legacy.tz.tuya_thermostat_min_temp,
            legacy.tz.tuya_thermostat_max_temp,
            legacy.tz.tuya_thermostat_comfort_temp,
            legacy.tz.tuya_thermostat_eco_temp,
            legacy.tz.tuya_thermostat_force,
            legacy.tz.tuya_thermostat_preset,
            legacy.tz.tuya_thermostat_boost_time,
        ],
        whiteLabel: [
            { vendor: 'Essentials', description: 'Smart home heizkörperthermostat premium', model: '120112' },
            { vendor: 'Tuya', description: 'Głowica termostatyczna', model: 'GTZ02' },
            { vendor: 'Revolt', description: 'Thermostatic Radiator Valve Controller', model: 'NX-4911' },
            { vendor: 'Unitec', description: 'Thermostatic Radiator Valve Controller', model: '30946' },
            { vendor: 'Tesla Smart', description: 'Thermostatic Radiator Valve Controller', model: 'TSL-TRV-GS361A' },
            { vendor: 'Nedis', description: 'Thermostatic Radiator Valve Controller', model: 'ZBHTR10WT' },
            { vendor: 'TCP Smart', description: 'Smart Thermostatic Radiator Valve', model: 'TBUWTRV' },
            tuya.whitelabel('Brennenstuhl', 'HT CZ 01', 'Radiator thermostat', ['_TZE200_lrznf59v']),
            { vendor: 'Appartme', description: 'Głowica termostatyczna', model: 'APRM-04-001' },
        ],
        exposes: [
            e.child_lock(),
            e.window_detection(),
            e.battery(),
            e.valve_detection(),
            e
                .climate()
                .withSetpoint('current_heating_setpoint', 5, 30, 0.5, ea.STATE_SET)
                .withLocalTemperature(ea.STATE)
                .withSystemMode(['off', 'auto', 'heat'], ea.STATE_SET)
                .withRunningState(['idle', 'heat'], ea.STATE),
        ],
    },
];
exports.default = definitions;
module.exports = definitions;
//# sourceMappingURL=siterwell.js.map