import { Zcl } from 'zigbee-herdsman';
import * as m from '../lib/modernExtend';
import { KeyValue, ModernExtend, Range } from '../lib/types';
export declare const manufacturerOptions: {
    manufacturerCode: Zcl.ManufacturerCode;
};
export declare function ikeaLight(args?: Omit<m.LightArgs, 'colorTemp'> & {
    colorTemp?: true | {
        range: Range;
        viaColor: true;
    };
}): ModernExtend;
export declare function ikeaBattery(): ModernExtend;
export declare function ikeaConfigureStyrbar(): ModernExtend;
export declare function ikeaConfigureRemote(): ModernExtend;
export declare function ikeaAirPurifier(): ModernExtend;
export declare function ikeaVoc(args?: Partial<m.NumericArgs>): ModernExtend;
export declare function ikeaConfigureGenPollCtrl(args?: {
    endpointId: number;
}): ModernExtend;
export declare function tradfriOccupancy(): ModernExtend;
export declare function tradfriRequestedBrightness(): ModernExtend;
export declare function tradfriCommandsOnOff(): ModernExtend;
export declare function tradfriCommandsLevelCtrl(): ModernExtend;
export declare function styrbarCommandOn(): ModernExtend;
export declare function ikeaDotsClick(args: {
    actionLookup?: KeyValue;
    dotsPrefix?: boolean;
    endpointNames: string[];
}): ModernExtend;
export declare function ikeaArrowClick(args?: {
    styrbar?: boolean;
    bind?: boolean;
}): ModernExtend;
export declare function ikeaMediaCommands(): ModernExtend;
export declare function addCustomClusterManuSpecificIkeaAirPurifier(): ModernExtend;
export declare function addCustomClusterManuSpecificIkeaVocIndexMeasurement(): ModernExtend;
export declare function addCustomClusterManuSpecificIkeaUnknown(): ModernExtend;
//# sourceMappingURL=ikea.d.ts.map