/*
 * Decompiled with CFR 0.152.
 */
package org.apache.html.dom;

import org.apache.html.dom.HTMLDocumentImpl;
import org.apache.html.dom.HTMLElementImpl;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLTableCellElement;
import org.w3c.dom.html.HTMLTableRowElement;

public class HTMLTableCellElementImpl
extends HTMLElementImpl
implements HTMLTableCellElement {
    public HTMLTableCellElementImpl(HTMLDocumentImpl hTMLDocumentImpl, String string) {
        super(hTMLDocumentImpl, string);
    }

    public String getAbbr() {
        return this.getAttribute("abbr");
    }

    public String getAlign() {
        return this.capitalize(this.getAttribute("align"));
    }

    public String getAxis() {
        return this.getAttribute("axis");
    }

    public String getBgColor() {
        return this.getAttribute("bgcolor");
    }

    public int getCellIndex() {
        Node node = this.getParentNode();
        int n = 0;
        if (node instanceof HTMLTableRowElement) {
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                if (node2 instanceof HTMLTableCellElement) {
                    if (node2 == this) {
                        return n;
                    }
                    ++n;
                }
                node2 = node2.getNextSibling();
            }
        }
        return -1;
    }

    public String getCh() {
        String string = this.getAttribute("char");
        if (string != null && string.length() > 1) {
            string = string.substring(0, 1);
        }
        return string;
    }

    public String getChOff() {
        return this.getAttribute("charoff");
    }

    public int getColSpan() {
        return this.getInteger(this.getAttribute("colspan"));
    }

    public String getHeaders() {
        return this.getAttribute("headers");
    }

    public String getHeight() {
        return this.getAttribute("height");
    }

    public boolean getNoWrap() {
        return this.getBinary("nowrap");
    }

    public int getRowSpan() {
        return this.getInteger(this.getAttribute("rowspan"));
    }

    public String getScope() {
        return this.getAttribute("scope");
    }

    public String getVAlign() {
        return this.capitalize(this.getAttribute("valign"));
    }

    public String getWidth() {
        return this.getAttribute("width");
    }

    public void setAbbr(String string) {
        this.setAttribute("abbr", string);
    }

    public void setAlign(String string) {
        this.setAttribute("align", string);
    }

    public void setAxis(String string) {
        this.setAttribute("axis", string);
    }

    public void setBgColor(String string) {
        this.setAttribute("bgcolor", string);
    }

    public void setCellIndex(int n) {
        Node node = this.getParentNode();
        if (node instanceof HTMLTableRowElement) {
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                if (node2 instanceof HTMLTableCellElement) {
                    if (n == 0) {
                        if (this != node2) {
                            node.insertBefore(this, node2);
                        }
                        return;
                    }
                    --n;
                }
                node2 = node2.getNextSibling();
            }
        }
        node.appendChild(this);
    }

    public void setCh(String string) {
        if (string != null && string.length() > 1) {
            string = string.substring(0, 1);
        }
        this.setAttribute("char", string);
    }

    public void setChOff(String string) {
        this.setAttribute("charoff", string);
    }

    public void setColSpan(int n) {
        this.setAttribute("colspan", String.valueOf(n));
    }

    public void setHeaders(String string) {
        this.setAttribute("headers", string);
    }

    public void setHeight(String string) {
        this.setAttribute("height", string);
    }

    public void setNoWrap(boolean bl) {
        this.setAttribute("nowrap", bl);
    }

    public void setRowSpan(int n) {
        this.setAttribute("rowspan", String.valueOf(n));
    }

    public void setScope(String string) {
        this.setAttribute("scope", string);
    }

    public void setVAlign(String string) {
        this.setAttribute("valign", string);
    }

    public void setWidth(String string) {
        this.setAttribute("width", string);
    }
}

